/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.joram.shell.mom.commands;

import fr.dyade.aaa.agent.AgentMBean;
import fr.dyade.aaa.agent.AgentServer;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import org.objectweb.joram.mom.dest.AdminTopicMBean;
import org.objectweb.joram.mom.dest.DestinationMBean;
import org.objectweb.joram.mom.dest.Queue;
import org.objectweb.joram.mom.dest.QueueMBean;
import org.objectweb.joram.mom.dest.Topic;
import org.objectweb.joram.mom.dest.TopicMBean;
import org.objectweb.joram.mom.messages.MessageView;
import org.objectweb.joram.mom.proxies.ClientSubscription;
import org.objectweb.joram.mom.proxies.ClientSubscriptionMBean;
import org.objectweb.joram.mom.proxies.UserAgentMBean;
import org.objectweb.joram.mom.util.JoramHelper;
import org.objectweb.joram.mom.util.SynchronousAgent;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;
import org.ow2.joram.shell.ShellDisplay;
import org.ow2.joram.shell.mom.commands.MOMCommands;

public class MOMCommandsImpl
implements MOMCommands {
    private static MOMCommandsImpl INSTANCE = null;
    public static final String NAMESPACE = "joram:mom";
    private static final int TIMEOUT = 1000;
    private static BundleContext bundleContext;
    private static ServiceTracker destinationTracker;
    private static ServiceTracker queueTracker;
    private static ServiceTracker topicTracker;
    private static ServiceTracker userTracker;
    private static ServiceTracker adminTracker;
    private static ServiceTracker clientSubTracker;
    public static String[] COMMANDS;

    public static void init(BundleContext context) {
        bundleContext = context;
        destinationTracker = new ServiceTracker(bundleContext, DestinationMBean.class.getCanonicalName(), null);
        queueTracker = new ServiceTracker(bundleContext, QueueMBean.class.getCanonicalName(), null);
        topicTracker = new ServiceTracker(bundleContext, TopicMBean.class.getCanonicalName(), null);
        userTracker = new ServiceTracker(bundleContext, UserAgentMBean.class.getCanonicalName(), null);
        adminTracker = new ServiceTracker(bundleContext, AdminTopicMBean.class.getCanonicalName(), null);
        clientSubTracker = new ServiceTracker(bundleContext, ClientSubscriptionMBean.class.getCanonicalName(), null);
        destinationTracker.open();
        queueTracker.open();
        topicTracker.open();
        userTracker.open();
        adminTracker.open();
        clientSubTracker.open();
    }

    public static MOMCommandsImpl getInstance() throws Exception {
        if (INSTANCE == null && bundleContext != null) {
            INSTANCE = new MOMCommandsImpl();
        }
        if (INSTANCE == null) {
            throw new Exception("MOM commands have not been initialized.");
        }
        return INSTANCE;
    }

    public static void help() {
        System.out.println("Usage: help <cmd>");
        Arrays.sort(COMMANDS);
        System.out.println("Commands: " + COMMANDS[0]);
        for (int i = 1; i < COMMANDS.length; ++i) {
            System.out.println("          " + COMMANDS[i]);
        }
    }

    public static void help(String command) {
        if (command.length() > NAMESPACE.length() && command.substring(0, NAMESPACE.length()).equalsIgnoreCase(NAMESPACE)) {
            command = command.substring(NAMESPACE.length() + 1, command.length());
        }
        String fullCommand = "[joram:mom:]" + command;
        StringBuffer buf = new StringBuffer();
        buf.append("Usage: ").append(fullCommand).append(" ");
        if (command.equalsIgnoreCase("list")) {
            buf.append("<category> [username]");
            buf.append("\n\tPossible categories: destination, topic, queue, user, subscription");
            buf.append("\n\tNB: For the subscription category, you must provide the user name.");
        } else if (command.equalsIgnoreCase("help")) {
            buf.append("<command>");
            buf.append("\nShows this help.");
        } else if (command.equalsIgnoreCase("create")) {
            buf.append("<topic|queue> <name> [option...]");
            buf.append("\n       ").append(fullCommand).append(" ");
            buf.append("user [<name>]\n");
            buf.append("Options: -sid <server id>\tSpecifies on which server the destination is to be created\n");
            buf.append("                         \tDefault: This server\n");
            buf.append("         -ext <extension>\tSpecifies which extension class to instanciate\n");
            buf.append("                         \tDefault: None");
        } else if (command.equalsIgnoreCase("queueLoad")) {
            buf.append("<queueName>");
        } else if (command.equalsIgnoreCase("subscriptionLoad")) {
            buf.append("<userName> <subscriptionName>");
        } else if (command.equalsIgnoreCase("delete")) {
            buf.append("(topic|queue|dest[ination]|user) <name>");
        } else if (command.equalsIgnoreCase("info")) {
            buf.append("(queue|topic) <name>");
            buf.append("\n       ").append(fullCommand).append(" ");
            buf.append("subscription <user name> <subscription name>");
        } else if (command.equalsIgnoreCase("lsMsg")) {
            buf.append("queue <queue name> [[first msg idx]:[last msg idx]]");
            buf.append("\n       ").append(fullCommand).append(" ");
            buf.append("subscription <username> <subscription name> [[first msg idx]:[last msg idx]]");
        } else if (command.equalsIgnoreCase("deleteMsg")) {
            buf.append("queue <queue name> <msg id>");
            buf.append("\n       ").append(fullCommand).append(" ");
            buf.append("subscription <username> <subscription name> <msg id>");
        } else if (command.equalsIgnoreCase("receiveMsg")) {
            buf.append("<queue name> [options]");
            buf.append("Options: -n <x>\tReceive only <x> messages");
            buf.append("         -t <x>\tTimes out after <x> seconds");
        } else if (command.equalsIgnoreCase("sendMsg")) {
            buf.append("(queue|topic) <destination name> <text>");
        } else if (command.equalsIgnoreCase("ping")) {
            buf.append("\nChecks whether a JoramAdminTopic exists.");
        } else if (command.equalsIgnoreCase("clear")) {
            buf.append("queue <name>");
            buf.append("\n       ").append(fullCommand).append(" ");
            buf.append("subscription <username> <subscription name>");
            buf.append("\nDeletes all pending messages.");
        } else if (command.equalsIgnoreCase("setFreeRead")) {
            buf.append("(topic|queue) <destination name> <value>");
            buf.append("\nChange destination's reading permission.");
        } else if (command.equalsIgnoreCase("setFreeWrite")) {
            buf.append("(topic|queue) <destination name> <value>");
            buf.append("\nChange destination's writing permission.");
        } else {
            System.err.println("Unknown command: " + command);
            return;
        }
        System.out.println(buf.toString());
    }

    @Override
    public void list(String[] args) {
        if (args.length == 0) {
            MOMCommandsImpl.help("list");
            return;
        }
        String category = args[0].toLowerCase();
        if (category.equals("destination")) {
            this.listDestination();
        } else if (category.equals("topic")) {
            this.listTopic();
        } else if (category.equals("queue")) {
            this.listQueue();
        } else if (category.equals("user")) {
            this.listUser();
        } else if (category.equals("subscription") && args.length == 2) {
            this.listSubscription(args[1]);
        } else {
            MOMCommandsImpl.help("list");
        }
    }

    private void listDestination() {
        Object[] obj = destinationTracker.getServices();
        if (obj == null || obj.length == 0) {
            System.out.println("There is no destination.");
            return;
        }
        HashMap<String, DestinationMBean> dests = new HashMap<String, DestinationMBean>();
        for (Object o : obj) {
            DestinationMBean d = (DestinationMBean)o;
            dests.put(d.getDestinationId(), d);
        }
        String[][] table = new String[dests.size() + 1][];
        table[0] = new String[]{"Id", "Name", "Type", "Creation Date", "Perm."};
        int i = 1;
        for (DestinationMBean d : dests.values()) {
            String type = "NA";
            type = d instanceof TopicMBean ? "Topic" : (d instanceof QueueMBean ? "Queue" : "(Unknown)");
            table[i++] = new String[]{d.getDestinationId(), d.getName(), type, d.getCreationDate(), (d.isFreeReading() ? "r" : "-") + '/' + (d.isFreeWriting() ? "w" : "-")};
        }
        int n = dests.size();
        if (n < 2) {
            System.out.println("There is " + dests.size() + " destination.");
        } else {
            System.out.println("There are " + dests.size() + " destinations.");
        }
        ShellDisplay.displayTable(table, true);
    }

    private void listQueue() {
        Object[] obj = queueTracker.getServices();
        if (obj == null || obj.length == 0) {
            System.out.println("There is no queue.");
            return;
        }
        HashMap<String, QueueMBean> dests = new HashMap<String, QueueMBean>();
        for (Object o : obj) {
            QueueMBean d = (QueueMBean)o;
            dests.put(d.getDestinationId(), d);
        }
        String[][] table = new String[dests.size() + 1][];
        table[0] = new String[]{"Id", "Name", "Pending msg", "Rcvd Msg", "Dlvd Msg", "Perm."};
        int i = 1;
        for (QueueMBean d : dests.values()) {
            table[i++] = new String[]{d.getDestinationId(), d.getName(), Integer.toString(d.getPendingMessageCount()), Long.toString(d.getNbMsgsReceiveSinceCreation()), Long.toString(d.getNbMsgsDeliverSinceCreation()), (d.isFreeReading() ? "r" : "-") + '/' + (d.isFreeWriting() ? "w" : "-")};
        }
        int n = dests.size();
        if (n < 2) {
            System.out.println("There is " + dests.size() + " queue.");
        } else {
            System.out.println("There are " + dests.size() + " queues.");
        }
        ShellDisplay.displayTable(table, true);
    }

    private void listTopic() {
        Object[] obj = topicTracker.getServices();
        if (obj == null || obj.length == 0) {
            System.out.println("There is no topic.");
            return;
        }
        HashMap<String, TopicMBean> dests = new HashMap<String, TopicMBean>();
        for (Object o : obj) {
            TopicMBean d = (TopicMBean)o;
            dests.put(d.getDestinationId(), d);
        }
        String[][] table = new String[dests.size() + 1][];
        table[0] = new String[]{"Id", "Name", "Subscriber", "Rcvd Msg", "Dlvd Msg", "Perm."};
        int i = 1;
        for (TopicMBean d : dests.values()) {
            table[i++] = new String[]{d.getDestinationId(), d.getName(), Integer.toString(d.getNumberOfSubscribers()), Long.toString(d.getNbMsgsReceiveSinceCreation()), Long.toString(d.getNbMsgsDeliverSinceCreation()), (d.isFreeReading() ? "r" : "-") + '/' + (d.isFreeWriting() ? "w" : "-")};
        }
        int n = dests.size();
        if (n < 2) {
            System.out.println("There is " + dests.size() + " topic.");
        } else {
            System.out.println("There are " + dests.size() + " topics.");
        }
        ShellDisplay.displayTable(table, true);
    }

    private void listUser() {
        Object[] objs = userTracker.getServices();
        if (objs == null || objs.length == 0) {
            System.err.println("Error: There is no user.");
            return;
        }
        HashMap<String, UserAgentMBean> users = new HashMap<String, UserAgentMBean>();
        for (int i = 0; i < objs.length; ++i) {
            UserAgentMBean u = (UserAgentMBean)objs[i];
            users.put(u.getAgentId(), u);
        }
        String[][] table = new String[users.size() + 1][];
        table[0] = new String[]{"User Id", "Name"};
        int i = 1;
        for (UserAgentMBean u : users.values()) {
            table[i++] = new String[]{u.getAgentId(), u.getName()};
        }
        ShellDisplay.displayTable(table, true);
    }

    private void listSubscription(String userName) {
        try {
            UserAgentMBean user = null;
            Object[] objs = userTracker.getServices();
            if (objs == null) {
                System.err.println("Error: No user found.");
                return;
            }
            for (Object object : objs) {
                UserAgentMBean u = (UserAgentMBean)object;
                if (!u.getName().equals(userName)) continue;
                user = u;
                break;
            }
            if (user == null) {
                System.err.println("Error: The user " + userName + " does not exist.");
                return;
            }
            String[] names = user.getSubscriptionNames();
            HashSet<ClientSubscriptionMBean> subs = new HashSet<ClientSubscriptionMBean>();
            Object[] clients = clientSubTracker.getServices();
            if (clients == null) {
                System.err.println("Error: No subscription found.");
                return;
            }
            block3: for (Object o : clients) {
                ClientSubscriptionMBean s = (ClientSubscriptionMBean)o;
                for (String n : names) {
                    if (!n.equals(s.getName())) continue;
                    subs.add(s);
                    continue block3;
                }
            }
            if (subs.size() == 0) {
                System.err.println("Error: The user " + userName + " has no subscription.");
                return;
            }
            String[][] stringArray = new String[subs.size() + 1][8];
            stringArray[0] = new String[]{"Name", "Topic Id", "Pndng msgs", "Wtng for ack.", "Dlvd msg", "Nb msg max", "Sent to DMQ"};
            int i = 1;
            for (ClientSubscriptionMBean sub : subs) {
                stringArray[i] = new String[]{sub.getName().length() > 9 ? sub.getName().subSequence(0, 9).toString() : sub.getName(), sub.getTopicIdAsString(), String.valueOf(sub.getPendingMessageCount()), String.valueOf(sub.getDeliveredMessageCount()), String.valueOf(sub.getNbMsgsDeliveredSinceCreation()), String.valueOf(sub.getNbMaxMsg()), String.valueOf(sub.getNbMsgsSentToDMQSinceCreation())};
            }
            ShellDisplay.displayTable(stringArray, true);
        }
        catch (StringIndexOutOfBoundsException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void create(String[] args) {
        if (args == null || args.length < 2) {
            MOMCommandsImpl.help("create");
            return;
        }
        if (!args[0].equals("topic") && !args[0].equals("queue")) {
            if (args[0].equals("user")) {
                String[] newArgs = new String[args.length - 1];
                for (int i = 1; i < args.length; ++i) {
                    newArgs[i - 1] = args[i];
                }
                this.createUser(newArgs);
                return;
            }
            MOMCommandsImpl.help("create");
            return;
        }
        this.createDestination(args);
    }

    private void createDestination(String[] args) {
        byte type = args[0].equalsIgnoreCase("queue") ? (byte)2 : 1;
        String name = null;
        short sid = AgentServer.getServerId();
        String ext = null;
        name = args[1];
        for (int i = 2; i < args.length; ++i) {
            if (args[i].equals("-sid") && args.length > i + 1) {
                sid = Short.parseShort(args[++i]);
                continue;
            }
            if (args[i].equals("-ext") && args.length > i + 1) {
                ext = args[++i];
                continue;
            }
            MOMCommandsImpl.help("create");
            return;
        }
        try {
            SynchronousAgent syncAgent = SynchronousAgent.getSynchronousAgent();
            if (ext == null) {
                String string = ext = type == 2 ? Queue.class.getName() : Topic.class.getName();
            }
            if (syncAgent.createDestination(sid, name, ext, null, type)) {
                if (type == 2) {
                    System.out.println("Queue " + name + " created on server " + sid + (ext == null ? "." : " with the class " + ext + "."));
                } else {
                    System.out.println("Topic " + name + " created on server " + sid + (ext == null ? "." : " with the class " + ext + "."));
                }
            } else {
                System.err.println("Error: The creation request failed.");
            }
        }
        catch (IOException e) {
            System.err.println("Error: Couldn't retrieve the synchronous agent.");
        }
        catch (InterruptedException e) {
            System.err.println("Error: Interrupted while waiting for the reply.");
        }
    }

    private void createUser(String[] args) {
        String userName = null;
        Scanner s = new Scanner(System.in);
        if (args.length == 0) {
            System.out.print("User name: ");
            System.out.flush();
            userName = s.nextLine();
        } else if (args.length == 1) {
            userName = args[0];
        } else {
            MOMCommandsImpl.help("addUser");
            return;
        }
        if (!userName.matches("[A-Za-z][A-Za-z0-9]{2,}?")) {
            System.out.println("The user name must begin with a letter and contain at least 3 alhpa-numeric caracters.");
            return;
        }
        System.out.print("Password: ");
        System.out.flush();
        String pwd = s.nextLine();
        if (userName.length() < 5) {
            System.out.println("The password must be at least 6 caracters long.");
            return;
        }
        try {
            SynchronousAgent syncAgent = SynchronousAgent.getSynchronousAgent();
            boolean res = syncAgent.createUser(AgentServer.getServerId(), userName, pwd, null, null);
            if (res) {
                System.out.println("User " + userName + " succesfully created.");
            } else {
                System.out.println("User creation failed.");
            }
        }
        catch (ClassNotFoundException e) {
            System.err.println("Error: Identity class not found.");
        }
        catch (IOException e) {
            System.err.println("Error: Couldn't retrieve the synchronous agent.");
        }
        catch (InterruptedException e) {
            System.err.println("Error: Interrupted while waiting for the reply.");
        }
        catch (Exception e) {
            System.err.println("Error: " + e.getClass().getName() + " received.");
            e.printStackTrace(System.err);
        }
    }

    @Override
    public void delete(String[] args) {
        ServiceTracker tracker;
        if (args.length != 2) {
            MOMCommandsImpl.help("delete");
            return;
        }
        String category = args[0];
        if (category.equalsIgnoreCase("queue") || category.equalsIgnoreCase("topic") || category.equalsIgnoreCase("destination") || category.equalsIgnoreCase("dest")) {
            tracker = destinationTracker;
        } else if (category.equalsIgnoreCase("user")) {
            tracker = userTracker;
        } else {
            System.err.println("Error: Unknwon category.");
            return;
        }
        Object[] objs = tracker.getServices();
        if (objs == null) {
            System.err.println("Error: " + category.toLowerCase() + " not found.");
            return;
        }
        for (int i = 0; i < objs.length; ++i) {
            block18: {
                AgentMBean a = (AgentMBean)objs[i];
                if (!a.getName().equals(args[1])) continue;
                if (category.equalsIgnoreCase("user")) {
                    try {
                        if (SynchronousAgent.getSynchronousAgent().deleteUser(a.getName(), a.getAgentId())) {
                            System.out.println("User successfully deleted.");
                            break block18;
                        }
                        System.err.println("User suppression failed.");
                    }
                    catch (InterruptedException e) {
                        System.err.println("Error: Interrupted");
                    }
                    catch (Exception e) {
                        System.err.println("Error: Exception raised");
                        e.printStackTrace();
                    }
                } else {
                    try {
                        if (SynchronousAgent.getSynchronousAgent().deleteDest(a.getAgentId())) {
                            System.out.println("Destination successfully deleted.");
                        } else {
                            System.err.println("Destination suppression failed.");
                        }
                    }
                    catch (InterruptedException e) {
                        System.err.println("Error: Interrupted");
                    }
                    catch (Exception e) {
                        System.err.println("Error: Exception raised");
                        e.printStackTrace();
                    }
                }
            }
            return;
        }
        System.err.println("Error: " + category.toLowerCase() + " not found.");
    }

    public void setFreeRead(String[] args) {
        if (args.length != 3) {
            MOMCommandsImpl.help("setFreeRead");
            return;
        }
        String category = args[0];
        String destName = args[1];
        boolean freeReading = Boolean.parseBoolean(args[2]);
        String destId = null;
        if (category.equalsIgnoreCase("queue")) {
            try {
                destId = this.findQueue(destName).getAgentId();
            }
            catch (QueueNotFoundException e) {
                System.err.println("Error: " + e.getMessage());
                return;
            }
        }
        if (category.equalsIgnoreCase("topic")) {
            try {
                destId = this.findTopic(destName).getAgentId();
            }
            catch (TopicNotFoundException e) {
                System.err.println("Error: " + e.getMessage());
                return;
            }
        }
        try {
            if (SynchronousAgent.getSynchronousAgent().setFreeReading(freeReading, destId)) {
                if (freeReading) {
                    System.out.println("Destination is now freely readable.");
                } else {
                    System.out.println("Destination is no longer freely readable.");
                }
            } else {
                System.out.println("Destination's rights' modification failed.");
            }
        }
        catch (Exception e) {
            System.err.println("Error: " + e.getMessage());
        }
    }

    public void setFreeWrite(String[] args) {
        if (args.length != 3) {
            MOMCommandsImpl.help("setFreeWrite");
            return;
        }
        String category = args[0];
        String destName = args[1];
        boolean freeWriting = Boolean.parseBoolean(args[2]);
        String destId = null;
        if (category.equalsIgnoreCase("queue")) {
            try {
                destId = this.findQueue(destName).getAgentId();
            }
            catch (QueueNotFoundException e) {
                System.err.println("Error: " + e);
                return;
            }
        }
        if (category.equalsIgnoreCase("topic")) {
            try {
                destId = this.findTopic(destName).getAgentId();
            }
            catch (TopicNotFoundException e) {
                System.err.println("Error: " + e);
                return;
            }
        }
        try {
            if (SynchronousAgent.getSynchronousAgent().setFreeWriting(freeWriting, destId)) {
                if (freeWriting) {
                    System.out.println("Destination is now freely writable.");
                } else {
                    System.out.println("Destination is no longer freely writable.");
                }
            } else {
                System.out.println("Destination's rights' modification failed.");
            }
        }
        catch (Exception e) {
            System.err.println("Error: " + e);
        }
    }

    @Override
    public void queueLoad(String[] args) {
        if (args.length != 1) {
            MOMCommandsImpl.help("queueLoad");
            return;
        }
        String name = args[0];
        try {
            QueueMBean queue = this.findQueue(name);
            int c = queue.getPendingMessageCount();
            System.out.println("Pending count of \"" + name + "\" : " + c);
        }
        catch (QueueNotFoundException e) {
            System.err.println("Error: There is no queue with the name \"" + name + "\".");
        }
    }

    private QueueMBean findQueue(String name) throws QueueNotFoundException {
        Object[] objs = queueTracker.getServices();
        if (objs == null) {
            throw new QueueNotFoundException(name);
        }
        for (Object o : objs) {
            QueueMBean q = (QueueMBean)o;
            if (!q.getName().equals(name)) continue;
            return q;
        }
        throw new QueueNotFoundException(name);
    }

    private TopicMBean findTopic(String name) throws TopicNotFoundException {
        Object[] objs = topicTracker.getServices();
        if (objs == null) {
            throw new TopicNotFoundException(name);
        }
        for (Object o : objs) {
            TopicMBean t = (TopicMBean)o;
            if (!t.getName().equals(name)) continue;
            return t;
        }
        return null;
    }

    private AdminTopicMBean findAdminTopic() {
        try {
            return (AdminTopicMBean)adminTracker.waitForService(1000L);
        }
        catch (InterruptedException e) {
            return null;
        }
    }

    @Override
    public void subscriptionLoad(String[] args) {
        if (args.length != 2) {
            MOMCommandsImpl.help("subscriptionLoad");
            return;
        }
        String userName = args[0];
        String subName = args[1];
        ClientSubscriptionMBean sub = null;
        try {
            sub = this.findClientSubscription(userName, subName);
            System.out.println("Pending count of \"" + subName + "\" (" + userName + ") : " + sub.getPendingMessageCount());
        }
        catch (UserNotFoundException e) {
            System.err.println("Error: The user " + userName + " does not exist.");
        }
        catch (SubscriptionNotFoundException e) {
            System.err.println("Error: There is no subscription of " + userName + " to " + subName);
        }
    }

    private UserAgentMBean findUser(String userName) {
        Object[] objs;
        for (Object o : objs = userTracker.getServices()) {
            UserAgentMBean u = (UserAgentMBean)o;
            if (!u.getName().equals(userName)) continue;
            return u;
        }
        return null;
    }

    private ClientSubscriptionMBean findClientSubscription(String userName, String subName) throws UserNotFoundException, SubscriptionNotFoundException {
        UserAgentMBean user = this.findUser(userName);
        if (user == null) {
            throw new UserNotFoundException(userName);
        }
        user.getSubscriptionNames();
        Object[] objs = clientSubTracker.getServices();
        if (objs == null) {
            return null;
        }
        for (Object o : objs) {
            ClientSubscriptionMBean c = (ClientSubscriptionMBean)o;
            if (!c.getName().equals(subName)) continue;
            return c;
        }
        throw new SubscriptionNotFoundException(userName, subName);
    }

    @Override
    public void info(String[] args) {
        if (args.length < 2) {
            MOMCommandsImpl.help("info");
            return;
        }
        String category = args[0];
        String destName = args[1];
        if (category.equals("topic")) {
            this.infoTopic(destName);
        } else if (category.equals("queue")) {
            this.infoQueue(destName);
        } else if (category.equals("subscription")) {
            this.infoSubscription(args[1], args[2]);
        } else {
            System.err.println("Error: Unknown category.");
            MOMCommandsImpl.help("info");
            return;
        }
    }

    private void infoTopic(String name) {
        TopicMBean dest;
        try {
            dest = this.findTopic(name);
        }
        catch (TopicNotFoundException e) {
            System.err.println("Error: Topic \"" + name + "\" not found.");
            return;
        }
        System.out.println("Topic name        : " + dest.getName());
        System.out.println("Destination ID    : " + dest.getDestinationId());
        System.out.println("Creation date     : " + dest.getCreationDate());
        System.out.println("Free reading      : " + (dest.isFreeReading() ? "Yes" : "No"));
        System.out.println("Free writing      : " + (dest.isFreeWriting() ? "Yes" : "No"));
        System.out.println("Message sent      : " + dest.getNbMsgsDeliverSinceCreation());
        System.out.println("Message received  : " + dest.getNbMsgsReceiveSinceCreation());
        System.out.println("Nb of subscribers : " + dest.getNumberOfSubscribers());
        System.out.println("Nb of DMQ messages: " + dest.getNbMsgsSentToDMQSinceCreation());
    }

    private void infoQueue(String name) {
        QueueMBean dest;
        try {
            dest = this.findQueue(name);
        }
        catch (QueueNotFoundException e) {
            System.err.println("Error: Queue \"" + name + "\" not found.");
            return;
        }
        System.out.println("Topic name              : " + dest.getName());
        System.out.println("Destination ID          : " + dest.getDestinationId());
        System.out.println("Creation date           : " + dest.getCreationDate());
        System.out.println("Free reading            : " + (dest.isFreeReading() ? "Yes" : "No"));
        System.out.println("Free writing            : " + (dest.isFreeWriting() ? "Yes" : "No"));
        System.out.println("Nb of pending messages  : " + dest.getPendingMessageCount());
        System.out.println("Messages sent           : " + dest.getNbMsgsDeliverSinceCreation());
        System.out.println("Messages received       : " + dest.getNbMsgsReceiveSinceCreation());
        System.out.println("Nb of DMQ messages      : " + dest.getNbMsgsSentToDMQSinceCreation());
    }

    private void infoSubscription(String userName, String subName) {
        ClientSubscriptionMBean sub = null;
        try {
            sub = this.findClientSubscription(userName, subName);
            System.out.println("Subscription name        : " + sub.getName());
            System.out.println("Nb of pending messages   : " + sub.getPendingMessageCount());
            System.out.println("Nb of delivered messages : " + sub.getNbMsgsDeliveredSinceCreation());
            System.out.println("Nb of DMQ messages       : " + sub.getNbMsgsSentToDMQSinceCreation());
        }
        catch (UserNotFoundException e) {
            System.err.println("Error: The user " + userName + " does not exist.");
            return;
        }
        catch (SubscriptionNotFoundException e) {
            System.err.println("Error: Subscription not found.");
        }
    }

    @Override
    public void lsMsg(String[] args) {
        if (args.length < 2) {
            MOMCommandsImpl.help("lsMsg");
            return;
        }
        String category = args[0].toLowerCase();
        String range = null;
        List<? extends MessageView> msgs = null;
        if (category.equals("queue")) {
            if (args.length > 3) {
                MOMCommandsImpl.help("lsMsg");
                return;
            }
            String queueName = args[1];
            if (args.length == 3) {
                range = args[2];
            }
            try {
                msgs = this.getQueueMessages(queueName);
            }
            catch (QueueNotFoundException e) {
                System.err.println("Error: Queue not found.");
                return;
            }
        } else if (category.equals("subscription")) {
            if (args.length > 4 || args.length < 3) {
                MOMCommandsImpl.help("lsMsg");
                return;
            }
            String userName = args[1];
            String subName = args[2];
            if (args.length == 4) {
                range = args[3];
            }
            try {
                msgs = this.getSubscriptionMessages(userName, subName);
            }
            catch (UserNotFoundException e) {
                System.err.println("Error: The user " + userName + " does not exist.");
                return;
            }
            catch (SubscriptionNotFoundException e) {
                System.err.println("Error: Subscription not found.");
                return;
            }
        } else {
            System.err.println("Error: Unknown category: " + category);
            return;
        }
        if (msgs.isEmpty()) {
            System.out.println("There is no pending message in this " + category + ".");
            return;
        }
        if (range != null) {
            if (range.matches("\\d*:\\d*")) {
                String[] parts = range.split(":", 2);
                int start = parts[0].length() != 0 ? Integer.parseInt(parts[0]) : 0;
                int end = parts[1].length() != 0 ? Integer.parseInt(parts[1]) : msgs.size() - 1;
                msgs = this.getMessageRange(msgs, start, end);
            } else {
                System.err.println("Error: Incorrect range format. Must be [start]:[end].");
                return;
            }
        }
        String[][] table = new String[msgs.size() + 1][];
        table[0] = new String[]{"Msg ID", "Type", "Creation date", "Exp. Date", "Priority"};
        int i = 1;
        SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss dd/M/y");
        for (MessageView messageView : msgs) {
            String type = "UNKNOWN";
            switch (messageView.getType()) {
                case 0: {
                    type = "SIMPLE";
                    break;
                }
                case 1: {
                    type = "TEXT";
                    break;
                }
                case 2: {
                    type = "OBJECT";
                    break;
                }
                case 3: {
                    type = "MAP";
                    break;
                }
                case 4: {
                    type = "STREAM";
                    break;
                }
                case 5: {
                    type = "BYTES";
                    break;
                }
                case 6: {
                    type = "ADMIN";
                    break;
                }
            }
            String expDate = messageView.getExpiration() != 0L ? sdf.format(new Date(messageView.getExpiration())) : "-";
            table[i++] = new String[]{messageView.getId(), type, sdf.format(new Date(messageView.getTimestamp())), expDate, Integer.toString(messageView.getPriority())};
        }
        ShellDisplay.displayTable(table, true);
    }

    public void infoMsg(String[] args) {
        if (args.length < 2) {
            MOMCommandsImpl.help("infoMsg");
            return;
        }
        String category = args[0].toLowerCase();
        MessageView msg = null;
        if (category.equals("queue")) {
            if (args.length > 3) {
                MOMCommandsImpl.help("infoMsg");
                return;
            }
            String queueName = args[1];
            String msgId = args[2];
            try {
                msg = this.getQueueMessage(queueName, msgId);
            }
            catch (QueueNotFoundException e) {
                System.err.println("Error: Queue not found.");
                return;
            }
        } else if (category.equals("subscription")) {
            if (args.length > 4 || args.length < 3) {
                MOMCommandsImpl.help("lsMsg");
                return;
            }
            String userName = args[1];
            String subName = args[2];
            String msgId = args[3];
            try {
                msg = this.getSubscriptionMessage(userName, subName, msgId);
            }
            catch (UserNotFoundException e) {
                System.err.println("Error: The user " + userName + " does not exist.");
                return;
            }
            catch (SubscriptionNotFoundException e) {
                System.err.println("Error: Subscription not found.");
                return;
            }
        } else {
            System.err.println("Error: Unknown category: " + category);
            return;
        }
        if (msg != null) {
            Map props;
            String type = "UNKNOWN";
            switch (msg.getType()) {
                case 0: {
                    type = "SIMPLE";
                    break;
                }
                case 1: {
                    type = "TEXT";
                    break;
                }
                case 2: {
                    type = "OBJECT";
                    break;
                }
                case 3: {
                    type = "MAP";
                    break;
                }
                case 4: {
                    type = "STREAM";
                    break;
                }
                case 5: {
                    type = "BYTES";
                    break;
                }
                case 6: {
                    type = "ADMIN";
                    break;
                }
            }
            System.out.println("Message ID: " + msg.getId());
            System.out.println("Message type: " + type);
            System.out.println("Creation date: " + msg.getTimestamp());
            System.out.println("Priority: " + msg.getPriority());
            if (msg.getType() == 1) {
                System.out.println("Text: " + msg.getText());
            }
            if ((props = msg.getProperties()) != null) {
                System.out.println("Properties:");
                for (Object k : props.keySet()) {
                    System.out.println("  " + k + " : " + props.get(k));
                }
            }
            System.out.println("Expiration date: " + msg.getExpiration());
        } else {
            System.err.println("Error: Message not found.");
        }
    }

    @Override
    public void ping() {
        AdminTopicMBean adminTopic = this.findAdminTopic();
        System.out.println(adminTopic == null ? "KO" : "OK");
    }

    @Override
    public void deleteMsg(String[] args) {
        if (args.length == 3 && args[0].equalsIgnoreCase("queue")) {
            this.deleteMsgQueue(args[1], args[2]);
        } else if (args.length == 4 && args[0].equalsIgnoreCase("subscription")) {
            this.deleteMsgSub(args[1], args[2], args[3]);
        } else {
            MOMCommandsImpl.help("deleteMsg");
        }
    }

    private void deleteMsgQueue(String queueName, String msgId) {
        try {
            if (!SynchronousAgent.getSynchronousAgent().deleteQueueMessage(queueName, msgId)) {
                System.err.println("Error: The queue \"" + queueName + "\" does not exist.");
            }
        }
        catch (InterruptedException e) {
            System.err.println("Error: Interrupted.");
            return;
        }
        catch (Exception e) {
            System.err.println("Error: Exception raised");
            e.printStackTrace();
            return;
        }
    }

    private void deleteMsgSub(String userName, String subName, String msgId) {
        try {
            this.findClientSubscription(userName, subName);
        }
        catch (UserNotFoundException e) {
            System.err.println("Error: The user \"" + userName + "\" does not exist.");
            return;
        }
        catch (SubscriptionNotFoundException e) {
            System.err.println("Error: The user \"" + userName + "\" has no subscription of the name \"" + subName + "\"");
            return;
        }
        try {
            if (!SynchronousAgent.getSynchronousAgent().deleteSubMessage(userName, subName, msgId)) {
                System.err.println("Error: Couldn't delete message from " + userName + "'s subscription " + subName);
            }
        }
        catch (InterruptedException e) {
            System.err.println("Error: Interrupted.");
            return;
        }
        catch (Exception e) {
            System.err.println("Error: Exception raised");
            e.printStackTrace();
            return;
        }
    }

    @Override
    public void clear(String[] args) {
        if (args.length == 2 && args[0].equalsIgnoreCase("queue")) {
            String queueName = args[1];
            if (!JoramHelper.clearQueue((String)queueName)) {
                System.err.println("Error: The queue " + queueName + " does not exist.");
            }
        } else if (args.length == 3 && args[0].equalsIgnoreCase("subscription")) {
            String userName = args[1];
            String subName = args[2];
            try {
                this.findClientSubscription(userName, subName);
            }
            catch (UserNotFoundException e) {
                System.err.println("Error: The user \"" + userName + "\" does not exist.");
                return;
            }
            catch (SubscriptionNotFoundException e) {
                System.err.println("Error: The user \"" + userName + "\" has no subscription of the name \"" + subName + "\"");
                return;
            }
            if (!JoramHelper.clearSubscription((String)userName, (String)subName)) {
                System.err.println("Error: Couldn't clear " + userName + "'s subscription " + subName);
            }
        } else {
            MOMCommandsImpl.help("clear");
        }
    }

    @Override
    public void sendMsg(String[] args) {
        System.err.println("Error: Not yet implemented.");
        MOMCommandsImpl.help("sendMsg");
    }

    @Override
    public void receiveMsg(String[] args) {
        System.err.println("Error: Not yet implemented.");
        MOMCommandsImpl.help("receiveMsg");
    }

    private List<? extends MessageView> getQueueMessages(String queueName) throws QueueNotFoundException {
        QueueMBean queue = this.findQueue(queueName);
        List msgs = ((Queue)queue).getMessagesView();
        return msgs == null ? new ArrayList() : msgs;
    }

    private MessageView getQueueMessage(String queueName, String msgId) throws QueueNotFoundException {
        for (MessageView messageView : this.getQueueMessages(queueName)) {
            if (!messageView.getId().equals(msgId)) continue;
            return messageView;
        }
        return null;
    }

    private List<MessageView> getSubscriptionMessages(String userName, String subscriptionName) throws UserNotFoundException, SubscriptionNotFoundException {
        ClientSubscriptionMBean sub = this.findClientSubscription(userName, subscriptionName);
        List msgs = ((ClientSubscription)sub).getMessagesView();
        return msgs == null ? new ArrayList() : msgs;
    }

    private MessageView getSubscriptionMessage(String userName, String subName, String msgId) throws UserNotFoundException, SubscriptionNotFoundException {
        for (MessageView msg : this.getSubscriptionMessages(userName, subName)) {
            if (!msg.getId().equals(msgId)) continue;
            return msg;
        }
        return null;
    }

    private List<? extends MessageView> getMessageRange(List<? extends MessageView> msgs, int start, int end) {
        if (start < 0) {
            start = 0;
        }
        if (end >= msgs.size()) {
            end = msgs.size() - 1;
        }
        if (start > end) {
            return msgs;
        }
        ArrayList<MessageView> res = new ArrayList<MessageView>();
        for (int i = start; i <= end; ++i) {
            res.add(msgs.get(i));
        }
        return res;
    }

    public static void main(String[] args) {
        for (String cmd : COMMANDS) {
            System.out.println("======== " + cmd + " ========");
            MOMCommandsImpl.help(cmd);
            System.out.println();
        }
    }

    static {
        COMMANDS = new String[]{"list", "create", "delete", "infoMsg", "queueLoad", "subscriptionLoad", "info", "lsMsg", "ping", "deleteMsg", "sendMsg", "receiveMsg", "setFreeRead", "setFreeWrite", "help", "clear"};
    }

    private class SubscriptionNotFoundException
    extends Exception {
        private static final long serialVersionUID = -7792553586609849268L;

        public SubscriptionNotFoundException(String userName, String subName) {
            super("The subscription [" + userName + ", " + subName + "] was not found.");
        }
    }

    private class TopicNotFoundException
    extends Exception {
        private static final long serialVersionUID = -7614138837435176364L;

        public TopicNotFoundException(String topicName) {
            super("The topic [" + topicName + "] was not found.");
        }
    }

    private class QueueNotFoundException
    extends Exception {
        private static final long serialVersionUID = -4968096805181928340L;

        public QueueNotFoundException(String queueName) {
            super("The queue [" + queueName + "] was not found.");
        }
    }

    private class UserNotFoundException
    extends Exception {
        private static final long serialVersionUID = -8029807791362829155L;

        public UserNotFoundException(String userName) {
            super("The user [" + userName + "] was not found.");
        }
    }
}

