/**
 * Monolog
 * Copyright (C) 2008 Bull S.A.S.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: JDKLevelImpl.java 550 2012-04-06 07:15:19Z benoitf $
 * --------------------------------------------------------------------------
 */

package org.objectweb.util.monolog.wrapper.javaLog;

import java.util.logging.Level;

/**
 * Allows to define our own levels.
 * @author Florent Benoit
 */
public class JDKLevelImpl extends Level {

    /**
     * FATAL is a message level indicating a very big serious failure.
     * <p>
     * This level is initialized to <CODE>1100</CODE>.
     */
    public static final Level FATAL = new JDKLevelImpl("FATAL",1100);

    /**
     * Call super constructor.
     * @param name given name
     * @param value given value
     */
    protected JDKLevelImpl(String name, int value) {
        super(name, value);
    }

}
