/**
 * Copyright (C) 2001-2004 France Telecom R&D
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.objectweb.util.monolog.wrapper.javaLog ;

import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Level;
import org.objectweb.util.monolog.api.LevelFactory;

/**
 * Is an implementation of the Monolog Level interface based on the common
 * LevelImpl class. It defines static method to convert a monolog level to
 * java.util.logging.Level .
 *
 * @author S.Chassande-Barrioz
 */
public class LevelImpl
    extends org.objectweb.util.monolog.wrapper.common.LevelImpl {


    /**
     * Level => java.util.logging.Level
     */
    static public java.util.logging.Level convertLevel(Level l) {
        return int2Level(l.getIntValue());
    }

    static public java.util.logging.Level int2Level(int value) {
        if ( value>=BasicLevel.FATAL ) {
            return JDKLevelImpl.FATAL;

        } else if ( value>=BasicLevel.ERROR ) {
            return java.util.logging.Level.SEVERE;

        } else if ( value>=BasicLevel.WARN ) {
            return java.util.logging.Level.WARNING;

        } else if ( value>=BasicLevel.INFO ) {
            return java.util.logging.Level.INFO;

        } else if ( value>=BasicLevel.DEBUG ) {
            return java.util.logging.Level.FINEST;

        } else if ( value==BasicLevel.INHERIT) {
            return null;

        } else {
            return java.util.logging.Level.FINEST;
        }
    }

    /**
     * int => org.objectweb.util.monolog.api.Level
     */
    static public Level getLevel(int value) {
        if ( value>=BasicLevel.FATAL ) {
            return BasicLevel.LEVEL_FATAL;

        } else if ( value>=BasicLevel.ERROR ) {
            return BasicLevel.LEVEL_ERROR;

        } else if ( value>=BasicLevel.WARN ) {
            return BasicLevel.LEVEL_WARN;

        } else if ( value>=BasicLevel.INFO ) {
            return BasicLevel.LEVEL_INFO;

        } else if ( value>=BasicLevel.DEBUG ) {
            return BasicLevel.LEVEL_DEBUG;
        } else {
            return BasicLevel.LEVEL_INHERIT;
        }
    }

    public LevelImpl(String n, int val) {
        super(n, val);
    }

    public LevelImpl(String n, String val, LevelFactory lf) {
        super(n, val, lf);
    }
}
