/**
 * Copyright (C) 2004 France Telecom R&D
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package org.objectweb.util.monolog.wrapper.log4j;

import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;

import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.spi.LoggingEvent;

/**
 * Represents an file handler which the file name changes every days.
 * The file name is named such as this example:
 * 2004_december_25_mylogfile.log
 * 
 * @author S.Chassande-Barrioz
 */
public class DayFileHandler extends FileHandler {

	private int lastDay;

	Calendar calendar = Calendar.getInstance();

	public DayFileHandler() {
		super();
	}

	public DayFileHandler(String name) {
		super(name);
	}

	protected void subAppend(LoggingEvent event) {
		super.subAppend(event);
		int currentDay = calendar.get(Calendar.DATE);
		if (fileName != null && currentDay != lastDay) {
			this.closeWriter(); // keep windows happy.
			//compute the name of the file from the current 
			//date: 2004_december_25_mylogfile.log
			Date d = calendar.getTime();
			StringBuffer sb = new StringBuffer();
			sb.append("_");
			sb.append(DateFormat.getDateInstance(
					DateFormat.YEAR_FIELD).format(d));
			sb.append("_");
			sb.append(DateFormat.getDateInstance(
					DateFormat.MONTH_FIELD).format(d));
			sb.append("_");
			sb.append(DateFormat.getDateInstance(
					DateFormat.DAY_OF_WEEK_IN_MONTH_FIELD).format(d));
			sb.append("_");
			sb.append(fileName);
			File file = new File(sb.toString());
			try {
				// This will also close the file. This is OK since multiple
				// close operations are safe.
				this.setFile(fileName, false, bufferedIO, bufferSize);
			} catch (IOException e) {
				LogLog.error("setFile(" + fileName + ", false) call failed.", e);
			}
			lastDay = currentDay;
		}
	}

	public void activateOptions() {
		lastDay = calendar.get(Calendar.DATE);
		super.activateOptions();
	}
}
