/**
 * Copyright (C) 2001-2003 France Telecom R&D
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.objectweb.util.monolog.wrapper.log4j;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

import org.apache.log4j.FileAppender;
import org.apache.log4j.PatternLayout;
import org.objectweb.util.monolog.Monolog;
import org.objectweb.util.monolog.api.Handler;
import org.objectweb.util.monolog.api.MonologFactory;
import org.objectweb.util.monolog.wrapper.common.RelatifEnvironmentPathGetter;

/**
 * This class is the wrapper to the org.apache.log4j.FileAppender
 *
 * @author Sebastien Chassande-Barrioz
 */
public class FileHandler extends FileAppender implements Handler {

	/**
	 * This fields contains the properties of the Handler
	 */
	protected HashMap prop = null;

	public FileHandler() {
		super();
	}

	/**
	 * It Builds a new FileHandler.
	 * @param name 	is the handler name.
	 */
	public FileHandler(String name) {
		super();
		setName(name);
		prop = new HashMap();
	}

	public Map getAttributes() {
		return prop;
	}

	public void setAttributes(Map attributes) {
		prop.clear();
		prop.putAll(attributes);
		Object mf = prop.get("activation");
		if (mf != null) {
		    prop.remove("activation");
		    setAttribute("activation", mf);
		}
	}

	// IMPLEMENTATION OF THE Handler INTERFACE //
	//---------------------------------------------//

	public String getType() {
		return "file";
	}

	public String[] getAttributeNames() {
		return (String[]) prop.keySet().toArray(new String[0]);
	}

	public Object getAttribute(String key) {
		return prop.get(key);
	}

	public Object setAttribute(String key, Object value) {
		if (prop == null) {
			prop = new HashMap();
		}
		if (!key.equalsIgnoreCase("activation")) {
			return prop.put(key, value);
		} else if (prop.containsKey(key)) {
		    return null; //already activated
		}
		MonologFactory mf = (MonologFactory) value;
		String output = (String) prop.get(Handler.OUTPUT_ATTRIBUTE);
		output = RelatifEnvironmentPathGetter.getRealPath(output);
		String append = (String) prop.get(Handler.APPEND_MODE_ATTRIBUTE);
		if (append != null && append.length() > 0) {
			fileAppend = Boolean.getBoolean(append);
		} else {
			fileAppend = true;
		}
		
		String buffersize = (String) prop.get(Handler.BUFFER_ATTRIBUTE);
		if (buffersize != null && buffersize.length() > 0) {
			try {
                setBufferSize(Integer.valueOf(buffersize).intValue());
            } catch (NumberFormatException e) {
                Monolog.error("Bad specified buffer size for the handler '" 
                        + name + "': " + buffersize, e);
            }
		}
		
		try {
			setFile(output, fileAppend, bufferedIO, bufferSize);
		} catch (IOException e) {
            Monolog.error("Error during the creation of the handler '" 
                    + name + "': ", e);
		}

		String pattern = (String) prop.get(Handler.PATTERN_ATTRIBUTE);
		setLayout(new PatternLayout(PatternConverter.monolog2log4j(pattern)));

		String level = (String) prop.get(Handler.LEVEL_ATTRIBUTE);
		if (level != null && level.length() > 0) {
			int levelVal = org.objectweb.util.monolog.wrapper.common.LevelImpl.evaluate(level, mf);
			setThreshold(org.apache.log4j.Level.toLevel(levelVal));
		}
		
		super.activateOptions();
		return null;
	}

}
