/**
 * Copyright (C) 2002
 */

package org.objectweb.util.monolog.wrapper.log4j;

import java.util.HashMap;
import java.util.Map;

import org.apache.log4j.PatternLayout;
import org.apache.log4j.nt.NTEventLogAppender;
import org.objectweb.util.monolog.api.Handler;
import org.objectweb.util.monolog.api.MonologFactory;

/**
 * This class is the wrapper to the org.apache.log4j.nt.NTEventLogAppender
 *
 * @author Sebastien Chassande-Barrioz
 * @author Igor Smirnov
 */
public class NTEventLogHandler extends NTEventLogAppender implements Handler {

	/**
	 * This fields contains the properties of the Handler
	 */
	protected HashMap prop = null;

	public NTEventLogHandler() {
		super();
	}

	/**
	 * It Builds a new NTEventLogHandler. It is needed to specify an handler
	 * type.
	 * @param name is the handler name.
	 */
	public NTEventLogHandler(String name) {
		super();
		setName(name);
		prop = new HashMap();
	}

	public Map getAttributes() {
		return prop;
	}

	public void setAttributes(Map attributes) {
		prop.clear();
		prop.putAll(attributes);
		Object mf = prop.get("activation");
		if (mf != null) {
		    prop.remove("activation");
		    setAttribute("activation", mf);
		}
	}

	// IMPLEMENTATION OF THE Handler INTERFACE //
	//---------------------------------------------//

	public String getType() {
		return "ntevent";
	}

	public String[] getAttributeNames() {
		return (String[]) prop.keySet().toArray(new String[0]);
	}

	public Object getAttribute(String key) {
		return prop.get(key);
	}

	public Object setAttribute(String key, Object value) {
		if (prop == null)
			prop = new HashMap();
		if (!key.equalsIgnoreCase("activation")) {
			return prop.put(key, value);
		} else if (prop.containsKey(key)) {
		    return null; //already activated
		}
		MonologFactory mf = (MonologFactory) value;
		String source = (String) prop.get("source");
		if (source != null) {
		    setSource((String) value);
		}
		String pattern = (String) prop.get(Handler.PATTERN_ATTRIBUTE);
		if (pattern != null) {
		    setLayout(new PatternLayout(PatternConverter.monolog2log4j(pattern)));
		}
		String level = (String) prop.get(Handler.LEVEL_ATTRIBUTE);
		if (level != null && level.length() > 0) {
			int levelVal = org.objectweb.util.monolog.wrapper.common.LevelImpl.evaluate(level, mf);
			setThreshold(org.apache.log4j.Level.toLevel(levelVal));
		}
		super.activateOptions();
		return null;
	}
}
