/**
 * Copyright (C) 2001-2003 France Telecom R&D
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package org.objectweb.util.monolog.wrapper.log4j;

import org.objectweb.util.monolog.file.api.Pattern;

/**
 * This tools class permits to convert the printing pattern between log4j
 * and monolog.
 *
 * @author Sebastien Chassande-Barrioz
 */
public class PatternConverter implements Pattern {

	public static String monolog2log4j(String p) {
		String res = new String(p);
		int percentPos = res.indexOf('%', 0);
		boolean end = (percentPos == -1);
		int nextPercentPos = 0;
		while (!end) {
			nextPercentPos = res.indexOf('%', percentPos + 1);
			if (nextPercentPos == -1) {
				nextPercentPos = res.length();
				end = true;
			}
			for (int i = percentPos + 1; i < nextPercentPos; i++) {
				char el = res.charAt(i);
				if (el == Pattern.LEVEL) {
					res = substitute(res, 'p', i);
					break;
				}
				else if (el == Pattern.OBJECT) {
					res = substitute(res, 'C', i);
					break;
				}
				else if (el == Pattern.THREAD) {
					res = substitute(res, 't', i);
					break;
				}
				else if (el == Pattern.TOPIC) {
					res = substitute(res, 'c', i);
					break;
				}
				else if(Character.isLetter(el)) {
					break;
				}
			}
			percentPos = nextPercentPos;
		}
		return res;
	}

	public static String log4j2monolog(String p) {
		String res = new String(p);
		int percentPos = res.indexOf('%', 0);
		boolean end = (percentPos == -1);
		int nextPercentPos = 0;
		while (!end) {
			nextPercentPos = res.indexOf('%', percentPos + 1);
			if (nextPercentPos == -1) {
				nextPercentPos = res.length();
				end = true;
			}
			for (int i = percentPos + 1; i < nextPercentPos; i++) {
				char el = res.charAt(i);
				if (el == 'p') {
					res = substitute(res, Pattern.LEVEL, i);
					break;
				}
				else if (el == 'C') {
					res = substitute(res, Pattern.OBJECT, i);
					break;
				}
				else if (el == 't') {
					res = substitute(res, Pattern.THREAD, i);
					break;
				}
				else if (el == 'c') {
					res = substitute(res, Pattern.TOPIC, i);
					break;
				}
			}
			percentPos = nextPercentPos;
		}
		return res;
	}

	private static String substitute(String s, char c, int pos) {
		if (s == null)
			return null;
		if (s.length() <= pos)
			return s;
		return s.substring(0, pos) + c + s.substring(pos + 1, s.length());
	}
}
