/**
 * Copyright (c) 2005-2012 EBM WebSourcing, 2012-2018 Linagora
 * 
 * This program/library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or (at your
 * option) any later version.
 * 
 * This program/library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License
 * for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program/library; If not, see http://www.gnu.org/licenses/
 * for the GNU Lesser General Public License version 2.1.
 */
package org.ow2.petals.engine.sampleclient;

import java.util.Properties;

/**
 * @author Christophe Hamerling - EBM WebSourcing
 */
public class PropertiesRequestBeanRW implements RequestBeanRW<Properties> {

    public static final String SERVICE = "service";

    public static final String INTERFACE = "interface";

    public static final String ENDPOINT = "endpoint";

    public static final String MEP = "mep";

    public static final String TIMEOUT = "timeout";

    public static final String IN = "in";

    public static final String OPERATION = "operation";

    public static final String PROPERTIES = "properties";

    /**
     * 
     */
    public PropertiesRequestBeanRW() {
    }

    /*
     * (non-Javadoc)
     * 
     * @see
     * org.ow2.petals.engine.sampleclient.RequestBeanRW#read(java.io.InputStream
     * )
     */
    public RequestBean read(Properties properties) {
        RequestBean result = new RequestBean();
        result.setEndpointName(properties.getProperty(ENDPOINT));
        result.setInterfaceName(properties.getProperty(INTERFACE));
        result.setMep(properties.getProperty(MEP));
        result.setMessage(properties.getProperty(IN));
        result.setProperties(properties.getProperty(PROPERTIES));
        result.setServiceName(properties.getProperty(SERVICE));
        result.setTimeout(properties.getProperty(TIMEOUT));
        result.setOperation(properties.getProperty(OPERATION));
        return result;
    }

    /*
     * (non-Javadoc)
     * @see org.ow2.petals.engine.sampleclient.RequestBeanRW#write(org.ow2.petals.engine.sampleclient.RequestBean, java.lang.Object)
     */
    public void write(RequestBean bean, Properties t) {
        t.setProperty(ENDPOINT, bean.getEndpointName());
        t.setProperty(IN, bean.getMessage());
        t.setProperty(INTERFACE, bean.getInterfaceName());
        t.setProperty(MEP, bean.getMep());
        t.setProperty(OPERATION, bean.getOperation());
        t.setProperty(PROPERTIES, bean.getProperties());
        t.setProperty(SERVICE, bean.getServiceName());
        t.setProperty(TIMEOUT, bean.getTimeout());
    }
}
