/**
 * Copyright (c) 2005-2012 EBM WebSourcing, 2012-2018 Linagora
 * 
 * This program/library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or (at your
 * option) any later version.
 * 
 * This program/library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License
 * for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program/library; If not, see http://www.gnu.org/licenses/
 * for the GNU Lesser General Public License version 2.1.
 */
package org.ow2.petals.engine.sampleclient;

import java.io.ByteArrayInputStream;
import java.io.InputStream;

import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;

import com.ebmwebsourcing.easycommons.xml.XMLHelper;

/**
 * @author Christophe HAMERLING - EBM WebSourcing
 */
public class Utils {

    private Utils() {
    }

    public static String createString(final Source source) throws Exception {
		String ret = null;
		if(source instanceof StreamSource) {
			InputStream is = ((StreamSource)source).getInputStream();
			int len = is.available();
			byte[] bytes = new byte[len];
			int count = is.read(bytes,0,len);
			if(count > 0) ret = new String(bytes, 0, count);
			is.close();
		} else {
			ret = XMLHelper.createStringFromDOMDocument(((DOMSource)source).getNode());
		}
		return ret;
    }

    /**
     * Return true if the String is null or its size is 0.
     * 
     * @param s
     * @return
     */
    public static boolean isNullOrEmpty(final String s) {
        return (s == null) || s.trim().equals("");
    }

    public static Source createSource(final String msg) throws Exception {
        StreamSource source = new StreamSource();
        byte[] msgByte = msg.getBytes("UTF-8");
        ByteArrayInputStream in = new ByteArrayInputStream(msgByte);
        source.setInputStream(in);
        return source;
    }
}
