/**
 * Copyright (c) 2008-2012 EBM WebSourcing, 2012-2018 Linagora
 * 
 * This program/library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or (at your
 * option) any later version.
 * 
 * This program/library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License
 * for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program/library; If not, see http://www.gnu.org/licenses/
 * for the GNU Lesser General Public License version 2.1.
 */
package org.ow2.petals.jsr181;

import org.ow2.petals.component.framework.api.message.Exchange;

/**
 * @author Christophe HAMERLING - EBM WebSourcing
 * @since 1.1.0
 */
public class JBIContext {

	private PetalsMessageSender petalsMessageSender;

	private Exchange exchange;

	public JBIContext(Exchange exchange, PetalsMessageSender petalsMessageSender) {
		this.exchange = exchange;
		this.petalsMessageSender = petalsMessageSender;
	}

	/**
	 * @return the petalsMessageSender
	 */
	public PetalsMessageSender getMessageSender() {
		return this.petalsMessageSender;
	}

	/**
	 * @param petalsMessageSender the petalsMessageSender to set
	 */
	public void setMessageSender(PetalsMessageSender petalsMessageSender) {
		this.petalsMessageSender = petalsMessageSender;
	}

	/**
	 * @return the exchange
	 */
	public Exchange getExchange() {
		return this.exchange;
	}

	/**
	 * @param exchange the exchange to set
	 */
	public void setExchange(Exchange exchange) {
		this.exchange = exchange;
	}
}
