/**
 * Copyright (c) 2008-2012 EBM WebSourcing, 2012-2018 Linagora
 * 
 * This program/library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or (at your
 * option) any later version.
 * 
 * This program/library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License
 * for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program/library; If not, see http://www.gnu.org/licenses/
 * for the GNU Lesser General Public License version 2.1.
 */
package org.ow2.petals.jsr181;

/**
 * The JBI Context will be used by annotated POJO classes to get access to the message sender. 
 * <p>
 * Since the {@link JBIContextManager} uses {@link ThreadLocal} each
 * worker (thread) will have access to its own sender.
 * </p>
 * 
 * @author Christophe HAMERLING - EBM WebSourcing
 * @since 1.1.0
 */
public class JBIContextManager {

	private static ThreadLocal<JBIContext> tl = new ThreadLocal<JBIContext>();

	/**
	 * Constructor.
	 */
	private JBIContextManager() {
	    // nothing
	}

	/**
	 * @return the JBI context
	 */
	public static JBIContext getJBIContext() {
		return tl.get();
	}

	/**
	 * @param ctx the JBI context to sets
	 */
	public static void setJBIContext(JBIContext ctx) {
		tl.set(ctx);
	}
}
