/**
 * Copyright (c) 2008-2012 EBM WebSourcing, 2012-2018 Linagora
 *
 * This program/library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or (at your
 * option) any later version.
 *
 * This program/library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License
 * for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program/library; If not, see http://www.gnu.org/licenses/
 * for the GNU Lesser General Public License version 2.1.
 */
package org.ow2.petals.usecase.jsr181.stock;

import javax.jws.WebMethod;
import javax.jws.WebService;

/**
 * @author Christophe HAMERLING - EBM WebSourcing
 */
@WebService(serviceName = "StockService", portName = "StockEndpoint", name = "StockInterface", targetNamespace = "http://petals.ow2.org")
public class Service {

    public Service() {
    }

    @WebMethod
    public float getStockValue(String stockCode) {
        System.out.println("Getting stock quote for " + stockCode);
        return new Float("100,87").floatValue();
    }

}
