/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.maxsat;

import java.math.BigInteger;
import java.util.HashSet;
import java.util.Set;
import org.sat4j.core.ConstrGroup;
import org.sat4j.core.Vec;
import org.sat4j.core.VecInt;
import org.sat4j.maxsat.UnitWeightedClause;
import org.sat4j.pb.IPBSolver;
import org.sat4j.pb.ObjectiveFunction;
import org.sat4j.pb.PBSolverDecorator;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IConstr;
import org.sat4j.specs.IVec;
import org.sat4j.specs.IVecInt;
import org.sat4j.specs.IteratorInt;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeightedMaxSatDecorator
extends PBSolverDecorator {
    public static final BigInteger SAT4J_MAX_BIG_INTEGER = new BigInteger("100000000000000000000000000000000000000000");
    protected int nbnewvar;
    private static final long serialVersionUID = 1L;
    private BigInteger falsifiedWeight = BigInteger.ZERO;
    private boolean maxVarIdFixed = false;
    private final boolean equivalence;
    private final IVecInt lits = new VecInt();
    private final IVec<BigInteger> coefs = new Vec();
    private final ObjectiveFunction obj = new ObjectiveFunction(this.lits, this.coefs);
    private final Set<Integer> unitClauses = new HashSet<Integer>();
    private boolean noNewVarForUnitSoftClauses = true;
    protected BigInteger top = SAT4J_MAX_BIG_INTEGER;

    public WeightedMaxSatDecorator(IPBSolver solver) {
        this(solver, false);
    }

    public WeightedMaxSatDecorator(IPBSolver solver, boolean equivalence) {
        super(solver);
        solver.setObjectiveFunction(this.obj);
        this.equivalence = equivalence;
    }

    public int newVar(int howmany) {
        int res = super.newVar(howmany);
        this.maxVarIdFixed = true;
        return res;
    }

    public void setExpectedNumberOfClauses(int nb) {
        this.lits.ensure(nb);
        this.falsifiedWeight = BigInteger.ZERO;
        super.setExpectedNumberOfClauses(nb);
    }

    public void setTopWeight(BigInteger top) {
        this.top = top;
    }

    protected void checkMaxVarId() {
        if (!this.maxVarIdFixed) {
            throw new IllegalStateException("Please call newVar(int) before adding constraints!!!");
        }
    }

    public IConstr addClause(IVecInt literals) throws ContradictionException {
        return this.addSoftClause(1, literals);
    }

    public IConstr addHardClause(IVecInt literals) throws ContradictionException {
        return super.addClause(literals);
    }

    public IConstr addSoftClause(IVecInt literals) throws ContradictionException {
        return this.addSoftClause(1, literals);
    }

    public IConstr addSoftClause(int weight, IVecInt literals) throws ContradictionException {
        return this.addSoftClause(BigInteger.valueOf(weight), literals);
    }

    public IConstr addSoftClause(BigInteger weight, IVecInt literals) throws ContradictionException {
        IConstr constr;
        this.checkMaxVarId();
        if (weight.compareTo(this.top) < 0) {
            if (literals.size() == 1 && this.noNewVarForUnitSoftClauses) {
                int lit = -literals.get(0);
                int index = this.lits.containsAt(lit);
                this.unitClauses.add(-lit);
                if (index == -1) {
                    index = this.lits.containsAt(-lit);
                    if (index != -1) {
                        this.falsifiedWeight = this.falsifiedWeight.add(weight);
                        BigInteger oldw = (BigInteger)this.coefs.get(index);
                        BigInteger diff = oldw.subtract(weight);
                        if (diff.signum() > 0) {
                            this.coefs.set(index, (Object)diff);
                        } else if (diff.signum() < 0) {
                            this.lits.set(index, lit);
                            this.coefs.set(index, (Object)diff.abs());
                            this.falsifiedWeight = this.falsifiedWeight.add(diff);
                        } else {
                            assert (diff.signum() == 0);
                            this.lits.delete(index);
                            this.coefs.delete(index);
                        }
                        this.obj.setCorrection(this.falsifiedWeight);
                    } else {
                        this.registerLiteral(lit);
                        this.lits.push(lit);
                        this.coefs.push((Object)weight);
                    }
                } else {
                    this.coefs.set(index, (Object)((BigInteger)this.coefs.get(index)).add(weight));
                }
                return UnitWeightedClause.instance();
            }
            this.coefs.push((Object)weight);
            int newvar = this.nextFreeVarId(true);
            literals.push(newvar);
            this.lits.push(newvar);
            if (this.equivalence) {
                ConstrGroup constrs = new ConstrGroup();
                IConstr constr2 = super.addClause(literals);
                if (constr2 == null && this.isVerbose()) {
                    System.out.println(String.valueOf(this.getLogPrefix()) + " solft constraint " + literals + "(" + weight + ") is ignored");
                }
                if (constr2 != null) {
                    constrs.add(constr2);
                    VecInt clause = new VecInt(2);
                    clause.push(-newvar);
                    int i = 0;
                    while (i < literals.size() - 1) {
                        clause.push(-literals.get(i));
                        constrs.add(super.addClause((IVecInt)clause));
                        clause.pop();
                        ++i;
                    }
                }
                return constrs;
            }
        }
        if ((constr = super.addClause(literals)) == null && this.isVerbose()) {
            System.out.println(String.valueOf(this.getLogPrefix()) + " hard constraint " + literals + "(" + weight + ") is ignored");
        }
        return constr;
    }

    public IConstr addSoftAtLeast(IVecInt literals, int degree) throws ContradictionException {
        return this.addSoftAtLeast(BigInteger.ONE, literals, degree);
    }

    public IConstr addSoftAtLeast(int weight, IVecInt literals, int degree) throws ContradictionException {
        return this.addSoftAtLeast(BigInteger.valueOf(weight), literals, degree);
    }

    public IConstr addSoftAtLeast(BigInteger weight, IVecInt literals, int degree) throws ContradictionException {
        this.checkMaxVarId();
        if (weight.compareTo(this.top) < 0) {
            this.coefs.push((Object)weight);
            int newvar = this.nextFreeVarId(true);
            this.lits.push(newvar);
            Vec cardcoeffs = new Vec(literals.size() + 1);
            cardcoeffs.growTo(literals.size(), (Object)BigInteger.ONE);
            literals.push(newvar);
            BigInteger bigDegree = BigInteger.valueOf(degree);
            cardcoeffs.push((Object)bigDegree);
            return this.addPseudoBoolean(literals, (IVec)cardcoeffs, true, bigDegree);
        }
        return this.addAtLeast(literals, degree);
    }

    public IConstr addSoftAtMost(IVecInt literals, int degree) throws ContradictionException {
        return this.addSoftAtMost(BigInteger.ONE, literals, degree);
    }

    public IConstr addSoftAtMost(int weight, IVecInt literals, int degree) throws ContradictionException {
        return this.addSoftAtMost(BigInteger.valueOf(weight), literals, degree);
    }

    public IConstr addSoftAtMost(BigInteger weight, IVecInt literals, int degree) throws ContradictionException {
        this.checkMaxVarId();
        if (weight.compareTo(this.top) < 0) {
            this.coefs.push((Object)weight);
            int newvar = this.nextFreeVarId(true);
            this.lits.push(newvar);
            Vec cardcoeffs = new Vec(literals.size() + 1);
            cardcoeffs.growTo(literals.size(), (Object)BigInteger.ONE);
            literals.push(newvar);
            BigInteger bigDegree = BigInteger.valueOf(degree);
            cardcoeffs.push((Object)bigDegree.negate());
            return this.addPseudoBoolean(literals, (IVec)cardcoeffs, true, bigDegree);
        }
        return this.addAtMost(literals, degree);
    }

    public void addLiteralsToMinimize(IVecInt literals) {
        IteratorInt it = literals.iterator();
        while (it.hasNext()) {
            this.lits.push(it.next());
            this.coefs.push((Object)BigInteger.ONE);
        }
    }

    public void addWeightedLiteralsToMinimize(IVecInt literals, IVec<BigInteger> coefficients) {
        if (literals.size() != this.coefs.size()) {
            throw new IllegalArgumentException();
        }
        int i = 0;
        while (i < literals.size()) {
            this.lits.push(literals.get(i));
            this.coefs.push((Object)((BigInteger)coefficients.get(i)));
            ++i;
        }
    }

    public void addWeightedLiteralsToMinimize(IVecInt literals, IVecInt coefficients) {
        if (literals.size() != coefficients.size()) {
            throw new IllegalArgumentException();
        }
        int i = 0;
        while (i < literals.size()) {
            this.lits.push(literals.get(i));
            this.coefs.push((Object)BigInteger.valueOf(coefficients.get(i)));
            ++i;
        }
    }

    public void reset() {
        this.coefs.clear();
        this.lits.clear();
        this.nbnewvar = 0;
        super.reset();
    }

    public void forceObjectiveValueTo(Number forcedValue) throws ContradictionException {
        if (this.lits.size() > 0) {
            super.addPseudoBoolean(this.lits, this.coefs, false, (BigInteger)forcedValue);
        }
    }

    public Set<Integer> getUnitClauses() {
        return this.unitClauses;
    }

    public boolean isNoNewVarForUnitSoftClauses() {
        return this.noNewVarForUnitSoftClauses;
    }

    public void setNoNewVarForUnitSoftClauses(boolean noNewVarForUnitSoftClauses) {
        this.noNewVarForUnitSoftClauses = noNewVarForUnitSoftClauses;
    }
}

