/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.maxsat;

import org.sat4j.core.ASolverFactory;
import org.sat4j.maxsat.MaxHSLikeSolver;
import org.sat4j.minisat.constraints.MixedDataStructureDanielWL;
import org.sat4j.minisat.core.DataStructureFactory;
import org.sat4j.minisat.core.IOrder;
import org.sat4j.minisat.core.LearningStrategy;
import org.sat4j.minisat.core.RestartStrategy;
import org.sat4j.minisat.core.SearchParams;
import org.sat4j.minisat.core.Solver;
import org.sat4j.minisat.core.VarActivityListener;
import org.sat4j.minisat.learning.MiniSATLearning;
import org.sat4j.minisat.orders.VarOrderHeap;
import org.sat4j.minisat.restarts.MiniSATRestarts;
import org.sat4j.pb.IPBSolver;
import org.sat4j.specs.ISolver;

public class SolverFactory
extends ASolverFactory<IPBSolver> {
    private static final long serialVersionUID = 1L;
    private static SolverFactory instance;

    public static Solver<DataStructureFactory> newMiniMaxSAT() {
        MiniSATLearning learning = new MiniSATLearning();
        Solver solver = new Solver((LearningStrategy)learning, (DataStructureFactory)new MixedDataStructureDanielWL(), new SearchParams(1.2, 100000), (IOrder)new VarOrderHeap(), (RestartStrategy)new MiniSATRestarts());
        learning.setDataStructureFactory(solver.getDSFactory());
        learning.setVarActivityListener((VarActivityListener)solver);
        return solver;
    }

    private SolverFactory() {
    }

    private static synchronized void createInstance() {
        if (instance == null) {
            instance = new SolverFactory();
        }
    }

    public static SolverFactory instance() {
        if (instance == null) {
            SolverFactory.createInstance();
        }
        return instance;
    }

    public IPBSolver defaultSolver() {
        return SolverFactory.newDefault();
    }

    public IPBSolver lightSolver() {
        return SolverFactory.newLight();
    }

    public static IPBSolver newDefault() {
        return org.sat4j.pb.SolverFactory.newDefault();
    }

    public static IPBSolver newLight() {
        return org.sat4j.pb.SolverFactory.newLight();
    }

    public static ISolver newMaxHSLike() {
        return new MaxHSLikeSolver(SolverFactory.newDefault(), (ISolver)SolverFactory.newDefault());
    }
}

