/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.maxsat.reader;

import java.io.IOException;
import java.math.BigInteger;
import org.sat4j.maxsat.WeightedMaxSatDecorator;
import org.sat4j.maxsat.WeightedPartialMaxsat;
import org.sat4j.reader.DimacsReader;
import org.sat4j.reader.ParseFormatException;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.ISolver;

public class WDimacsReader
extends DimacsReader {
    protected BigInteger weight;
    protected BigInteger top;
    private static final long serialVersionUID = 1L;
    private final WeightedPartialMaxsat decorator;

    protected void flushConstraint() throws ContradictionException {
        block2: {
            try {
                this.decorator.addSoftClause(this.weight, this.literals);
            }
            catch (IllegalArgumentException ex) {
                if (!this.isVerbose()) break block2;
                System.err.println("c Skipping constraint " + this.literals);
            }
        }
    }

    protected boolean handleLine() throws ContradictionException, IOException, ParseFormatException {
        this.weight = this.scanner.nextBigInteger();
        return super.handleLine();
    }

    public WDimacsReader(WeightedPartialMaxsat solver) {
        super((ISolver)solver, "wcnf");
        this.decorator = solver;
    }

    public WDimacsReader(WeightedPartialMaxsat solver, String format) {
        super((ISolver)solver, format);
        this.decorator = solver;
    }

    protected void readProblemLine() throws IOException, ParseFormatException {
        String line = this.scanner.nextLine().trim();
        if (line == null) {
            throw new ParseFormatException("premature end of file: <p cnf ...> expected");
        }
        String[] tokens = line.split("\\s+");
        if (tokens.length < 4 || !"p".equals(tokens[0]) || !this.formatString.equals(tokens[1])) {
            throw new ParseFormatException("problem line expected (p cnf ...)");
        }
        int vars = Integer.parseInt(tokens[2]);
        assert (vars > 0);
        this.solver.newVar(vars);
        this.expectedNbOfConstr = Integer.parseInt(tokens[3]);
        assert (this.expectedNbOfConstr > 0);
        this.solver.setExpectedNumberOfClauses(this.expectedNbOfConstr);
        if ("wcnf".equals(this.formatString)) {
            this.top = tokens.length == 5 ? new BigInteger(tokens[4]) : WeightedMaxSatDecorator.SAT4J_MAX_BIG_INTEGER;
            this.decorator.setTopWeight(this.top);
        }
    }
}

