/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb.constraints.pb;

import java.math.BigInteger;
import org.sat4j.minisat.core.Constr;
import org.sat4j.minisat.core.ILits;
import org.sat4j.minisat.core.Propagatable;
import org.sat4j.minisat.core.UnitPropagationListener;
import org.sat4j.pb.constraints.pb.IDataStructurePB;
import org.sat4j.pb.constraints.pb.WatchPbLongCP;
import org.sat4j.specs.ContradictionException;

public class MinWatchPbLongCP
extends WatchPbLongCP {
    private static final long serialVersionUID = 1L;
    protected long watchCumul = 0L;
    protected boolean[] watched;
    protected int[] watching;
    protected int watchingCount = 0;

    protected MinWatchPbLongCP(ILits voc, IDataStructurePB mpb) {
        super(mpb);
        this.voc = voc;
        this.watching = new int[this.coefs.length];
        this.watched = new boolean[this.coefs.length];
        this.activity = 0.0;
        this.watchCumul = 0L;
        this.watchingCount = 0;
    }

    protected MinWatchPbLongCP(ILits voc, int[] lits, BigInteger[] coefs, BigInteger degree, BigInteger sumCoefs) {
        super(lits, coefs, degree, sumCoefs);
        this.voc = voc;
        this.watching = new int[this.coefs.length];
        this.watched = new boolean[this.coefs.length];
        this.activity = 0.0;
        this.watchCumul = 0L;
        this.watchingCount = 0;
    }

    protected void computeWatches() throws ContradictionException {
        assert (this.watchCumul == 0L);
        assert (this.watchingCount == 0);
        int i = 0;
        while (i < this.lits.length && this.watchCumul - this.coefs[0] < this.degree) {
            if (!this.voc.isFalsified(this.lits[i])) {
                this.voc.watch(this.lits[i] ^ 1, (Propagatable)this);
                this.watching[this.watchingCount++] = i;
                this.watched[i] = true;
                this.watchCumul += this.coefs[i];
            }
            ++i;
        }
        if (this.learnt) {
            this.watchMoreForLearntConstraint();
        }
        if (this.watchCumul < this.degree) {
            throw new ContradictionException("non satisfiable constraint");
        }
        assert (this.nbOfWatched() == this.watchingCount);
    }

    private void watchMoreForLearntConstraint() {
        int free = 1;
        while (this.watchCumul - this.coefs[0] < this.degree && free > 0) {
            free = 0;
            int maxlevel = -1;
            int maxi = -1;
            int i = 0;
            while (i < this.lits.length) {
                if (this.voc.isFalsified(this.lits[i]) && !this.watched[i]) {
                    ++free;
                    int level = this.voc.getLevel(this.lits[i]);
                    if (level > maxlevel) {
                        maxi = i;
                        maxlevel = level;
                    }
                }
                ++i;
            }
            if (free <= 0) continue;
            assert (maxi >= 0);
            this.voc.watch(this.lits[maxi] ^ 1, (Propagatable)this);
            this.watching[this.watchingCount++] = maxi;
            this.watched[maxi] = true;
            this.watchCumul += this.coefs[maxi];
            assert (--free >= 0);
        }
        assert (this.lits.length == 1 || this.watchingCount > 1);
    }

    protected void computePropagation(UnitPropagationListener s) throws ContradictionException {
        int ind = 0;
        while (ind < this.lits.length && this.watchCumul - this.coefs[this.watching[ind]] < this.degree) {
            if (this.voc.isUnassigned(this.lits[ind]) && !s.enqueue(this.lits[ind], (Constr)this)) {
                throw new ContradictionException("non satisfiable constraint");
            }
            ++ind;
        }
    }

    public static MinWatchPbLongCP normalizedMinWatchPbNew(UnitPropagationListener s, ILits voc, int[] lits, BigInteger[] coefs, BigInteger degree, BigInteger sumCoefs) throws ContradictionException {
        MinWatchPbLongCP outclause = new MinWatchPbLongCP(voc, lits, coefs, degree, sumCoefs);
        if (outclause.degree <= 0L) {
            return null;
        }
        outclause.computeWatches();
        outclause.computePropagation(s);
        return outclause;
    }

    protected int nbOfWatched() {
        int retour = 0;
        int ind = 0;
        while (ind < this.watched.length) {
            int i = 0;
            while (i < this.watchingCount) {
                if (this.watching[i] == ind) assert (this.watched[ind]);
                ++i;
            }
            retour += this.watched[ind] ? 1 : 0;
            ++ind;
        }
        return retour;
    }

    public boolean propagate(UnitPropagationListener s, int p) {
        assert (this.nbOfWatched() == this.watchingCount);
        assert (this.watchingCount > 1);
        int pIndiceWatching = 0;
        while (pIndiceWatching < this.watchingCount && (this.lits[this.watching[pIndiceWatching]] ^ 1) != p) {
            ++pIndiceWatching;
        }
        int pIndice = this.watching[pIndiceWatching];
        assert (p == (this.lits[pIndice] ^ 1));
        assert (this.watched[pIndice]);
        long maxCoef = this.maximalCoefficient(pIndice);
        maxCoef = this.updateWatched(maxCoef, pIndice);
        long upWatchCumul = this.watchCumul - this.coefs[pIndice];
        assert (this.nbOfWatched() == this.watchingCount);
        if (upWatchCumul < this.degree) {
            this.voc.watch(p, (Propagatable)this);
            assert (this.watched[pIndice]);
            assert (!this.isSatisfiable());
            return false;
        }
        if (upWatchCumul < this.degree + maxCoef) {
            assert (this.watchingCount != 0);
            long limit = upWatchCumul - this.degree;
            int i = 0;
            while (i < this.watchingCount) {
                if (limit < this.coefs[this.watching[i]] && i != pIndiceWatching && !this.voc.isSatisfied(this.lits[this.watching[i]]) && !s.enqueue(this.lits[this.watching[i]], (Constr)this)) {
                    this.voc.watch(p, (Propagatable)this);
                    assert (!this.isSatisfiable());
                    return false;
                }
                ++i;
            }
            this.voc.undos(p).push((Object)this);
        }
        this.watched[pIndice] = false;
        this.watchCumul = upWatchCumul;
        this.watching[pIndiceWatching] = this.watching[--this.watchingCount];
        assert (this.watchingCount != 0);
        assert (this.nbOfWatched() == this.watchingCount);
        return true;
    }

    public void remove(UnitPropagationListener upl) {
        int i = 0;
        while (i < this.watchingCount) {
            this.voc.watches(this.lits[this.watching[i]] ^ 1).remove((Object)this);
            this.watched[this.watching[i]] = false;
            ++i;
        }
        this.watchingCount = 0;
        assert (this.nbOfWatched() == this.watchingCount);
    }

    public void undo(int p) {
        this.voc.watch(p, (Propagatable)this);
        int pIndice = 0;
        while ((this.lits[pIndice] ^ 1) != p) {
            ++pIndice;
        }
        assert (pIndice < this.lits.length);
        this.watchCumul += this.coefs[pIndice];
        assert (this.watchingCount == this.nbOfWatched());
        this.watched[pIndice] = true;
        this.watching[this.watchingCount++] = pIndice;
        assert (this.watchingCount == this.nbOfWatched());
    }

    public static WatchPbLongCP normalizedWatchPbNew(ILits voc, IDataStructurePB mpb) {
        return new MinWatchPbLongCP(voc, mpb);
    }

    protected long maximalCoefficient(int pIndice) {
        long maxCoef = 0L;
        int i = 0;
        while (i < this.watchingCount) {
            if (this.coefs[this.watching[i]] > maxCoef && this.watching[i] != pIndice) {
                maxCoef = this.coefs[this.watching[i]];
            }
            ++i;
        }
        assert (this.learnt || maxCoef != 0L);
        return maxCoef;
    }

    protected long updateWatched(long mc, int pIndice) {
        long maxCoef = mc;
        if (this.watchingCount < this.size()) {
            long upWatchCumul = this.watchCumul - this.coefs[pIndice];
            long degreePlusMaxCoef = this.degree + maxCoef;
            int ind = 0;
            while (ind < this.lits.length) {
                if (upWatchCumul >= degreePlusMaxCoef) break;
                if (!this.voc.isFalsified(this.lits[ind]) && !this.watched[ind]) {
                    upWatchCumul += this.coefs[ind];
                    this.watched[ind] = true;
                    assert (this.watchingCount < this.size());
                    this.watching[this.watchingCount++] = ind;
                    this.voc.watch(this.lits[ind] ^ 1, (Propagatable)this);
                    if (this.coefs[ind] > maxCoef) {
                        maxCoef = this.coefs[ind];
                        degreePlusMaxCoef = this.degree + maxCoef;
                    }
                }
                ++ind;
            }
            this.watchCumul = upWatchCumul + this.coefs[pIndice];
        }
        return maxCoef;
    }
}

