/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb.core;

import java.math.BigInteger;
import org.sat4j.core.ConstrGroup;
import org.sat4j.core.LiteralsUtils;
import org.sat4j.core.Vec;
import org.sat4j.core.VecInt;
import org.sat4j.minisat.core.ConflictTimer;
import org.sat4j.minisat.core.ConflictTimerAdapter;
import org.sat4j.minisat.core.Constr;
import org.sat4j.minisat.core.DataStructureFactory;
import org.sat4j.minisat.core.IOrder;
import org.sat4j.minisat.core.LearnedConstraintsDeletionStrategy;
import org.sat4j.minisat.core.LearningStrategy;
import org.sat4j.minisat.core.RestartStrategy;
import org.sat4j.minisat.core.SearchParams;
import org.sat4j.minisat.core.Solver;
import org.sat4j.minisat.core.UnitPropagationListener;
import org.sat4j.pb.IPBSolverService;
import org.sat4j.pb.ObjectiveFunction;
import org.sat4j.pb.core.IPBCDCLSolver;
import org.sat4j.pb.core.PBDataStructureFactory;
import org.sat4j.pb.core.PBSolverStats;
import org.sat4j.pb.orders.IOrderObjective;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IConstr;
import org.sat4j.specs.IVec;
import org.sat4j.specs.IVecInt;
import org.sat4j.specs.IteratorInt;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PBSolver
extends Solver<PBDataStructureFactory>
implements IPBCDCLSolver<PBDataStructureFactory>,
IPBSolverService {
    private ObjectiveFunction objf;
    private static final long serialVersionUID = 1L;
    protected PBSolverStats stats;
    private IConstr previousConstr = null;
    public final LearnedConstraintsDeletionStrategy objectiveFunctionBased = new LearnedConstraintsDeletionStrategy(){
        private static final long serialVersionUID = 1L;
        private boolean[] inObjectiveFunction;
        private final ConflictTimer clauseManagement = new ConflictTimerAdapter(1000){
            private static final long serialVersionUID = 1L;
            private int nbconflict;
            private static final int MAX_CLAUSE = 5000;
            private static final int INC_CLAUSE = 1000;
            private int nextbound;
            {
                this.nbconflict = 0;
                this.nextbound = 5000;
            }

            public void run() {
                this.nbconflict += this.bound();
                if (this.nbconflict >= this.nextbound) {
                    this.nextbound += 1000;
                    this.nbconflict = 0;
                    PBSolver.this.setNeedToReduceDB(true);
                }
            }

            public void reset() {
                super.reset();
                this.nextbound = 5000;
                if (this.nbconflict >= this.nextbound) {
                    this.nbconflict = 0;
                    PBSolver.this.setNeedToReduceDB(true);
                }
            }
        };

        public void reduce(IVec<Constr> learnedConstrs) {
            int j = 0;
            int i = 0;
            while (i < learnedConstrs.size()) {
                Constr c = (Constr)learnedConstrs.get(i);
                if (c.locked() || c.getActivity() <= 2.0) {
                    learnedConstrs.set(j++, (Object)((Constr)PBSolver.this.learnts.get(i)));
                } else {
                    c.remove((UnitPropagationListener)PBSolver.this);
                }
                ++i;
            }
            if (PBSolver.this.isVerbose()) {
                System.out.println(String.valueOf(PBSolver.this.getLogPrefix()) + "cleaning " + (learnedConstrs.size() - j) + " clauses out of " + learnedConstrs.size() + "/" + PBSolver.this.stats.conflicts);
                System.out.flush();
            }
            PBSolver.this.learnts.shrinkTo(j);
        }

        public ConflictTimer getTimer() {
            return this.clauseManagement;
        }

        public String toString() {
            return "Objective function driven learned constraints deletion strategy";
        }

        public void init() {
            this.inObjectiveFunction = new boolean[PBSolver.this.nVars() + 1];
            if (PBSolver.this.objf == null) {
                throw new IllegalStateException("The strategy does not make sense if there is no objective function");
            }
            IteratorInt it = PBSolver.this.objf.getVars().iterator();
            while (it.hasNext()) {
                this.inObjectiveFunction[Math.abs((int)it.next())] = true;
            }
            this.clauseManagement.reset();
        }

        public void onClauseLearning(Constr constr) {
            boolean fullObj = true;
            int i = 0;
            while (i < constr.size()) {
                fullObj = fullObj && this.inObjectiveFunction[LiteralsUtils.var((int)constr.get(i))];
                ++i;
            }
            if (fullObj) {
                constr.incActivity(1.0);
            } else {
                constr.incActivity((double)constr.size());
            }
        }

        public void onConflictAnalysis(Constr reason) {
        }

        public void onPropagation(Constr from) {
        }
    };

    public PBSolver(LearningStrategy<PBDataStructureFactory> learner, PBDataStructureFactory dsf, IOrder order, RestartStrategy restarter) {
        super(learner, (DataStructureFactory)dsf, order, restarter);
        this.stats = new PBSolverStats();
        this.initStats(this.stats);
    }

    public PBSolver(LearningStrategy<PBDataStructureFactory> learner, PBDataStructureFactory dsf, SearchParams params, IOrder order, RestartStrategy restarter) {
        super(learner, (DataStructureFactory)dsf, params, order, restarter);
        this.stats = new PBSolverStats();
        this.initStats(this.stats);
    }

    @Override
    public IConstr addPseudoBoolean(IVecInt literals, IVec<BigInteger> coeffs, boolean moreThan, BigInteger degree) throws ContradictionException {
        IVecInt vlits = this.dimacs2internal(literals);
        assert (vlits.size() == literals.size());
        assert (literals.size() == coeffs.size());
        return this.addConstr(((PBDataStructureFactory)this.dsfactory).createPseudoBooleanConstraint(vlits, coeffs, moreThan, degree));
    }

    @Override
    public void setObjectiveFunction(ObjectiveFunction obj) {
        this.objf = obj;
        IOrder order = this.getOrder();
        if (order instanceof IOrderObjective) {
            ((IOrderObjective)order).setObjectiveFunction(obj);
        }
    }

    @Override
    public ObjectiveFunction getObjectiveFunction() {
        return this.objf;
    }

    @Override
    public IConstr addAtMost(IVecInt literals, IVecInt coeffs, int degree) throws ContradictionException {
        Vec bcoeffs = new Vec(coeffs.size());
        int i = 0;
        while (i < coeffs.size()) {
            bcoeffs.push((Object)BigInteger.valueOf(coeffs.get(i)));
            ++i;
        }
        return this.addAtMost(literals, (IVec<BigInteger>)bcoeffs, BigInteger.valueOf(degree));
    }

    @Override
    public IConstr addAtMost(IVecInt literals, IVec<BigInteger> coeffs, BigInteger degree) throws ContradictionException {
        IVecInt vlits = this.dimacs2internal(literals);
        assert (vlits.size() == literals.size());
        assert (literals.size() == coeffs.size());
        return this.addConstr(((PBDataStructureFactory)this.dsfactory).createPseudoBooleanConstraint(vlits, coeffs, false, degree));
    }

    @Override
    public IConstr addAtLeast(IVecInt literals, IVecInt coeffs, int degree) throws ContradictionException {
        Vec bcoeffs = new Vec(coeffs.size());
        int i = 0;
        while (i < coeffs.size()) {
            bcoeffs.push((Object)BigInteger.valueOf(coeffs.get(i)));
            ++i;
        }
        return this.addAtLeast(literals, (IVec<BigInteger>)bcoeffs, BigInteger.valueOf(degree));
    }

    @Override
    public IConstr addAtLeast(IVecInt literals, IVec<BigInteger> coeffs, BigInteger degree) throws ContradictionException {
        IVecInt vlits = this.dimacs2internal(literals);
        assert (vlits.size() == literals.size());
        assert (literals.size() == coeffs.size());
        return this.addConstr(((PBDataStructureFactory)this.dsfactory).createPseudoBooleanConstraint(vlits, coeffs, true, degree));
    }

    @Override
    public IConstr addExactly(IVecInt literals, IVecInt coeffs, int weight) throws ContradictionException {
        Vec bcoeffs = new Vec(coeffs.size());
        int i = 0;
        while (i < coeffs.size()) {
            bcoeffs.push((Object)BigInteger.valueOf(coeffs.get(i)));
            ++i;
        }
        return this.addExactly(literals, (IVec<BigInteger>)bcoeffs, BigInteger.valueOf(weight));
    }

    @Override
    public IConstr addExactly(IVecInt literals, IVec<BigInteger> coeffs, BigInteger weight) throws ContradictionException {
        IVecInt vlits = this.dimacs2internal(literals);
        assert (vlits.size() == literals.size());
        assert (literals.size() == coeffs.size());
        ConstrGroup group = new ConstrGroup(false);
        group.add(this.addConstr(((PBDataStructureFactory)this.dsfactory).createPseudoBooleanConstraint(vlits, coeffs, false, weight)));
        group.add(this.addConstr(((PBDataStructureFactory)this.dsfactory).createPseudoBooleanConstraint(vlits, coeffs, true, weight)));
        return group;
    }

    @Override
    public IConstr addAtMostOnTheFly(IVecInt literals, IVec<BigInteger> coefs, BigInteger degree) {
        IVecInt vlits = this.dimacs2internal(literals);
        if (this.previousConstr != null) {
            this.removeSubsumedConstr(this.previousConstr);
        }
        this.sharedConflict = ((PBDataStructureFactory)this.dsfactory).createUnregisteredAtMostConstraint(vlits, coefs, degree);
        this.sharedConflict.register();
        this.addConstr(this.sharedConflict);
        this.previousConstr = this.sharedConflict;
        VecInt outReason = new VecInt();
        this.sharedConflict.calcReasonOnTheFly(-1, this.trail, (IVecInt)outReason);
        while (!this.trail.isEmpty() && !outReason.contains(this.trail.last())) {
            this.undoOne();
            if (this.trailLim.isEmpty() || this.trailLim.last() != this.trail.size()) continue;
            this.trailLim.pop();
        }
        return this.sharedConflict;
    }

    @Override
    public IConstr addAtMostOnTheFly(IVecInt literals, IVecInt coefs, int degree) {
        Vec coeffsCpy = new Vec(coefs.size());
        IteratorInt iterator = coefs.iterator();
        while (iterator.hasNext()) {
            coeffsCpy.push((Object)BigInteger.valueOf(iterator.next()));
        }
        return this.addAtMostOnTheFly(literals, (IVec<BigInteger>)coeffsCpy, BigInteger.valueOf(degree));
    }
}

