/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.sat;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import org.sat4j.maxsat.WeightedMaxSatDecorator;
import org.sat4j.maxsat.reader.MSInstanceReader;
import org.sat4j.minisat.SolverFactory;
import org.sat4j.minisat.core.ConflictTimer;
import org.sat4j.minisat.core.ICDCL;
import org.sat4j.minisat.core.IOrder;
import org.sat4j.minisat.core.IPhaseSelectionStrategy;
import org.sat4j.minisat.core.LearnedConstraintsEvaluationType;
import org.sat4j.minisat.core.RestartStrategy;
import org.sat4j.minisat.core.SearchParams;
import org.sat4j.minisat.core.SimplificationType;
import org.sat4j.minisat.core.SolverStats;
import org.sat4j.minisat.orders.RandomWalkDecorator;
import org.sat4j.minisat.orders.VarOrderHeap;
import org.sat4j.pb.ConstraintRelaxingPseudoOptDecorator;
import org.sat4j.pb.IPBSolver;
import org.sat4j.pb.OptToPBSATAdapter;
import org.sat4j.pb.PseudoOptDecorator;
import org.sat4j.pb.orders.RandomWalkDecoratorObjective;
import org.sat4j.pb.orders.VarOrderHeapObjective;
import org.sat4j.pb.reader.PBInstanceReader;
import org.sat4j.pb.tools.ClausalConstraintsDecorator;
import org.sat4j.reader.InstanceReader;
import org.sat4j.reader.ParseFormatException;
import org.sat4j.reader.Reader;
import org.sat4j.sat.CleanCommandComponent;
import org.sat4j.sat.HotSolverCommandComponent;
import org.sat4j.sat.PhaseCommandComponent;
import org.sat4j.sat.ProblemType;
import org.sat4j.sat.RandomWalkCommandComponent;
import org.sat4j.sat.RemoteControlFrame;
import org.sat4j.sat.RemoteControlStrategy;
import org.sat4j.sat.RestartCommandComponent;
import org.sat4j.sat.SimplifierCommandComponent;
import org.sat4j.sat.SolverController;
import org.sat4j.sat.Solvers;
import org.sat4j.sat.StartSolverEnum;
import org.sat4j.sat.visu.ChartBasedVisualizationTool;
import org.sat4j.sat.visu.GnuplotBasedSolverVisualisation;
import org.sat4j.sat.visu.JChartBasedSolverVisualisation;
import org.sat4j.sat.visu.SolverVisualisation;
import org.sat4j.sat.visu.TraceComposite;
import org.sat4j.sat.visu.VisuPreferences;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IConstr;
import org.sat4j.specs.ILogAble;
import org.sat4j.specs.IOptimizationProblem;
import org.sat4j.specs.IProblem;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.ISolverService;
import org.sat4j.specs.Lbool;
import org.sat4j.specs.RandomAccessModel;
import org.sat4j.specs.SearchListener;
import org.sat4j.specs.TimeoutException;
import org.sat4j.tools.ClausalCardinalitiesDecorator;
import org.sat4j.tools.ConflictDepthTracing;
import org.sat4j.tools.ConflictLevelTracing;
import org.sat4j.tools.DecisionTracing;
import org.sat4j.tools.FileBasedVisualizationTool;
import org.sat4j.tools.HeuristicsTracing;
import org.sat4j.tools.IVisualizationTool;
import org.sat4j.tools.LearnedClausesSizeTracing;
import org.sat4j.tools.LearnedTracing;
import org.sat4j.tools.MultiTracing;
import org.sat4j.tools.SpeedTracing;
import org.sat4j.tools.encoding.EncodingStrategy;
import org.sat4j.tools.encoding.EncodingStrategyAdapter;
import org.sat4j.tools.encoding.Policy;

public class DetailedCommandPanel
extends JPanel
implements SolverController,
SearchListener<ISolverService>,
ILogAble {
    private static final String EXACTLY_1 = "Exactly 1:";
    private static final String EXACTLY_K = "Exactly K:";
    private static final String AT_MOST_1 = "At Most 1:";
    private static final String AT_MOST_K = "At Most K:";
    private Policy encodingPolicy = new Policy();
    private static final long serialVersionUID = 1L;
    public static final EmptyBorder BORDER5 = new EmptyBorder(5, 5, 5, 5);
    private String ramdisk;
    private RemoteControlStrategy telecomStrategy;
    private RandomWalkDecorator randomWalk;
    private ISolver solver;
    private Reader reader;
    private IProblem problem;
    private ProblemType problemType;
    private boolean optimizationMode;
    private boolean equivalenceMode;
    private boolean lowerMode;
    private String[] commandLines;
    private boolean firstStart;
    private StartSolverEnum startConfig;
    private StringWriter stringWriter;
    private JPanel aboutSolverPanel;
    private JTextArea textArea;
    private JPanel instancePanel;
    private static final String INSTANCE_PANEL = "Instance";
    private JLabel instanceLabel;
    private static final String INSTANCE = "Path to instance: ";
    private JTextField instancePathField;
    private String instancePath;
    private JButton browseButton;
    private static final String BROWSE = "Browse";
    private String whereToWriteFiles;
    private static final String MINISAT_PREFIX = "minisat";
    private static final String PB_PREFIX = "pb";
    private static final String MAXSAT_PREFIX = "maxsat";
    private JPanel choixSolverPanel;
    private static final String CHOIX_SOLVER_PANEL = "Solver";
    private JLabel choixSolver;
    private static final String CHOIX_SOLVER = "Choose solver: ";
    private JComboBox listeSolvers;
    private static final String OPTMIZATION_MODE = "Optimization problem";
    private JCheckBox optimisationModeCB;
    private static final String EQUIVALENCE = "Use equivalence instead of implication";
    private JCheckBox equivalenceCB;
    private static final String LOWER = "Search solution by lower bounding instead of upper bounding";
    private JCheckBox lowerCB;
    private JComboBox atMostKCB;
    private JComboBox atMost1CB;
    private JComboBox exactlyKCB;
    private JComboBox exactly1CB;
    private JRadioButton solverLineParamLineRadio;
    private JRadioButton solverLineParamRemoteRadio;
    private JRadioButton solverListParamListRadio;
    private JRadioButton solverListParamRemoteRadio;
    private static final String SOLVER_LINE_PARAM_LINE_CONFIG = "Start customized solver as given in command line";
    private static final String SOLVER_LINE_PARAM_REMOTE_CONFIG = "Start customized solver as given in command line with configuration given in the remote";
    private static final String SOLVER_LIST_PARAM_LIST_CONFIG = "Start solver as chosen in list with its default configuration";
    private static final String SOLVER_LIST_PARAM_REMOTE_CONFIG = "Start solver as chosen in list with configuration given in the remote";
    private static final String CHOOSE_START_CONFIG = "Choose start configuration : ";
    private JButton startStopButton;
    private static final String START = "Start";
    private static final String STOP = "Stop";
    private JButton pauseButton;
    private static final String PAUSE = "Pause";
    private static final String RESUME = "Resume";
    private static final String RESTART_PANEL = "Restart strategy";
    private RestartCommandComponent restartPanel;
    private static final String RW_PANEL = "Random Walk";
    private RandomWalkCommandComponent rwPanel;
    private static final String CLEAN_PANEL = "Learned Constraint Deletion Strategy";
    private CleanCommandComponent cleanPanel;
    private PhaseCommandComponent phasePanel;
    private static final String PHASE_PANEL = "Phase Strategy";
    private SimplifierCommandComponent simplifierPanel;
    private static final String SIMPLIFIER_PANEL = "Simplification strategy";
    private HotSolverCommandComponent hotSolverPanel;
    private static final String HOT_SOLVER_PANEL = "Hot solver";
    private JTextArea console;
    private boolean isPlotActivated;
    private SolverVisualisation solverVisu;
    private VisuPreferences visuPreferences;
    private boolean gnuplotBased = false;
    private boolean chartBased = false;
    private RemoteControlFrame frame;
    private long begin;
    private long end;
    private int propagationsCounter;
    private int conflictCounter;
    private PrintStream outSolutionFound;

    public DetailedCommandPanel(String filename, RemoteControlFrame frame) {
        this(filename, "", frame);
    }

    public DetailedCommandPanel(String filename, String ramdisk, RemoteControlFrame frame) {
        this(filename, ramdisk, new String[0], frame);
    }

    public DetailedCommandPanel(String filename, String ramdisk, String[] args, RemoteControlFrame frame) {
        this.frame = frame;
        this.visuPreferences = new VisuPreferences();
        this.telecomStrategy = new RemoteControlStrategy(this);
        this.instancePath = filename;
        this.ramdisk = ramdisk;
        this.console = new JTextArea();
        this.commandLines = (String[])args.clone();
        if (args.length > 0) {
            this.solver = Solvers.configureSolver(args, this);
            this.optimizationMode = Solvers.containsOptValue(args);
        }
        this.equivalenceMode = false;
        this.lowerMode = false;
        this.isPlotActivated = false;
        this.startConfig = this.solver != null ? StartSolverEnum.SOLVER_LINE_PARAM_LINE : StartSolverEnum.SOLVER_LIST_PARAM_DEFAULT;
        this.firstStart = true;
        this.setPreferredSize(new Dimension(800, 800));
        this.setLayout(new BoxLayout(this, 1));
        this.createInstancePanel();
        this.createChoixSolverPanel();
        this.restartPanel = new RestartCommandComponent(RESTART_PANEL, this, this.telecomStrategy.getRestartStrategy().getClass().getSimpleName(), this);
        this.rwPanel = new RandomWalkCommandComponent(RW_PANEL, this);
        this.cleanPanel = new CleanCommandComponent(CLEAN_PANEL, this);
        this.phasePanel = new PhaseCommandComponent(PHASE_PANEL, this, this.telecomStrategy.getPhaseSelectionStrategy().getClass().getSimpleName());
        this.simplifierPanel = new SimplifierCommandComponent(SIMPLIFIER_PANEL, this);
        this.hotSolverPanel = new HotSolverCommandComponent(HOT_SOLVER_PANEL, this);
        JScrollPane scrollPane = new JScrollPane(this.console);
        scrollPane.setPreferredSize(new Dimension(400, 200));
        scrollPane.getVerticalScrollBar().setValue(scrollPane.getVerticalScrollBar().getMaximum());
        MyTabbedPane tabbedPane = new MyTabbedPane();
        JPanel solverBigPanel = new JPanel();
        solverBigPanel.setLayout(new BoxLayout(solverBigPanel, 1));
        solverBigPanel.add(this.instancePanel);
        solverBigPanel.add(this.choixSolverPanel);
        tabbedPane.addTab(CHOIX_SOLVER_PANEL, null, solverBigPanel, "instance & solver options");
        JPanel restartBigPanel = new JPanel();
        restartBigPanel.setLayout(new GridBagLayout());
        GridBagConstraints cRestart = new GridBagConstraints();
        cRestart.anchor = 19;
        cRestart.fill = 2;
        cRestart.weightx = 1.0;
        cRestart.weighty = 1.0;
        restartBigPanel.add((Component)this.restartPanel, cRestart);
        tabbedPane.addTab("Restart", null, restartBigPanel, "restart strategy & options");
        JPanel rwPhaseBigPanel = new JPanel();
        rwPhaseBigPanel.setLayout(new GridBagLayout());
        GridBagConstraints cP = new GridBagConstraints();
        cP.anchor = 19;
        cP.fill = 2;
        cP.weightx = 1.0;
        cP.weighty = 1.0;
        JPanel tmpPhasePanel = new JPanel();
        tmpPhasePanel.setLayout(new GridBagLayout());
        GridBagConstraints cPhase = new GridBagConstraints();
        cPhase.fill = 2;
        cPhase.weightx = 1.0;
        cPhase.weighty = 0.2;
        tmpPhasePanel.add((Component)this.rwPanel, cPhase);
        cPhase.gridy = 1;
        cPhase.weighty = 0.2;
        tmpPhasePanel.add((Component)this.phasePanel, cPhase);
        cPhase.gridy = 2;
        tmpPhasePanel.add((Component)this.hotSolverPanel, cPhase);
        rwPhaseBigPanel.add((Component)tmpPhasePanel, cP);
        tabbedPane.addTab("Heuristics", null, rwPhaseBigPanel, "random walk and phase strategy");
        JPanel clausesBigPanel = new JPanel();
        clausesBigPanel.setLayout(new GridBagLayout());
        GridBagConstraints cC = new GridBagConstraints();
        cC.anchor = 19;
        cC.fill = 2;
        cC.weightx = 1.0;
        cC.weighty = 1.0;
        JPanel tmpClausesPanel = new JPanel();
        tmpClausesPanel.setLayout(new GridBagLayout());
        GridBagConstraints cClauses = new GridBagConstraints();
        cClauses.fill = 2;
        cClauses.weightx = 1.0;
        cClauses.weighty = 0.2;
        tmpClausesPanel.add((Component)this.cleanPanel, cClauses);
        cClauses.gridy = 1;
        tmpClausesPanel.add((Component)this.simplifierPanel, cClauses);
        clausesBigPanel.add((Component)tmpClausesPanel, cC);
        tabbedPane.addTab("Learned Constraints", null, clausesBigPanel, "deletion and simplification strategy");
        this.aboutSolverPanel = new JPanel();
        this.textArea = new JTextArea("No solver is running at the moment");
        this.textArea.setColumns(50);
        this.aboutSolverPanel.add(this.textArea);
        tabbedPane.addTab("About Solver", null, this.aboutSolverPanel, "information about solver");
        this.add(tabbedPane);
        this.add(scrollPane);
        this.restartPanel.setRestartPanelEnabled(false);
        this.rwPanel.setRWPanelEnabled(false);
        this.cleanPanel.setCleanPanelEnabled(false);
        this.phasePanel.setPhasePanelEnabled(false);
        this.simplifierPanel.setSimplifierPanelEnabled(false);
        this.hotSolverPanel.setKeepSolverHotPanelEnabled(false);
        this.solverVisu = new JChartBasedSolverVisualisation(this.visuPreferences);
        this.updateWriter();
    }

    private void createInstancePanel() {
        this.instancePanel = new JPanel();
        this.instancePanel.setName(INSTANCE_PANEL);
        this.instancePanel.setBorder(new CompoundBorder(new TitledBorder(null, this.instancePanel.getName(), 1, 2), BORDER5));
        this.instancePanel.setLayout(new BorderLayout(0, 0));
        this.instanceLabel = new JLabel(INSTANCE);
        this.instancePathField = new JTextField(20);
        this.instancePathField.setText(this.instancePath);
        this.instanceLabel.setLabelFor(this.instancePathField);
        this.browseButton = new JButton(BROWSE);
        this.browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DetailedCommandPanel.this.openFileChooser();
                DetailedCommandPanel.this.updateListOfSolvers();
            }
        });
        this.optimisationModeCB = new JCheckBox(OPTMIZATION_MODE);
        this.optimisationModeCB.setSelected(this.optimizationMode);
        this.equivalenceCB = new JCheckBox(EQUIVALENCE);
        this.equivalenceCB.setSelected(this.equivalenceMode);
        this.lowerCB = new JCheckBox(LOWER);
        this.lowerCB.setSelected(this.lowerMode);
        JPanel tmpPanel11 = new JPanel();
        tmpPanel11.add(this.instanceLabel);
        tmpPanel11.add(this.instancePathField);
        tmpPanel11.add(this.browseButton);
        JPanel tmpPanel12 = new JPanel();
        tmpPanel12.setLayout(new BoxLayout(tmpPanel12, 1));
        tmpPanel12.add(this.optimisationModeCB);
        tmpPanel12.add(this.equivalenceCB);
        tmpPanel12.add(this.lowerCB);
        this.optimisationModeCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DetailedCommandPanel.this.setOptimisationMode(DetailedCommandPanel.this.optimisationModeCB.isSelected());
                DetailedCommandPanel.this.log("use optimization mode: " + DetailedCommandPanel.this.optimizationMode);
                DetailedCommandPanel.this.updateListOfSolvers();
            }
        });
        this.equivalenceCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DetailedCommandPanel.this.equivalenceMode = DetailedCommandPanel.this.equivalenceCB.isSelected();
            }
        });
        this.lowerCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DetailedCommandPanel.this.lowerMode = DetailedCommandPanel.this.lowerCB.isSelected();
            }
        });
        this.instancePanel.setLayout(new BoxLayout(this.instancePanel, 1));
        this.instancePanel.add(tmpPanel11);
        this.instancePanel.add(tmpPanel12);
    }

    private void createChoixSolverPanel() {
        this.choixSolverPanel = new JPanel();
        this.choixSolverPanel.setName(CHOIX_SOLVER_PANEL);
        this.choixSolverPanel.setBorder(new CompoundBorder(new TitledBorder(null, this.choixSolverPanel.getName(), 1, 2), BORDER5));
        this.choixSolverPanel.setLayout(new BoxLayout(this.choixSolverPanel, 1));
        this.choixSolver = new JLabel(CHOIX_SOLVER);
        this.listeSolvers = new JComboBox();
        this.updateListOfSolvers();
        JPanel tmpPanel1 = new JPanel();
        tmpPanel1.add(this.choixSolver);
        tmpPanel1.add(this.listeSolvers);
        this.startStopButton = new JButton(START);
        this.startStopButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DetailedCommandPanel.this.manageStartStopButton();
            }
        });
        this.pauseButton = new JButton(PAUSE);
        this.pauseButton.setEnabled(false);
        this.pauseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DetailedCommandPanel.this.pauseButton.getText().equals(DetailedCommandPanel.PAUSE)) {
                    DetailedCommandPanel.this.pauseButton.setText(DetailedCommandPanel.RESUME);
                    DetailedCommandPanel.this.telecomStrategy.setInterrupted(true);
                } else {
                    DetailedCommandPanel.this.pauseButton.setText(DetailedCommandPanel.PAUSE);
                    DetailedCommandPanel.this.telecomStrategy.setInterrupted(false);
                }
            }
        });
        JPanel tmpPanel = new JPanel();
        tmpPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        tmpPanel.setName("Cardinality Constraints Encodings");
        tmpPanel.setBorder(new CompoundBorder(new TitledBorder(null, tmpPanel.getName(), 1, 2), BORDER5));
        JLabel atMostKLabel = new JLabel(AT_MOST_K);
        this.atMostKCB = new JComboBox<Object>(new DefaultComboBoxModel<Object>(this.getListOfEncodings(AT_MOST_K).toArray()));
        JLabel atMost1Label = new JLabel(AT_MOST_1);
        this.atMost1CB = new JComboBox<Object>(new DefaultComboBoxModel<Object>(this.getListOfEncodings(AT_MOST_1).toArray()));
        JLabel exactlyKLabel = new JLabel(EXACTLY_K);
        this.exactlyKCB = new JComboBox<Object>(new DefaultComboBoxModel<Object>(this.getListOfEncodings(EXACTLY_K).toArray()));
        JLabel exactly1Label = new JLabel(EXACTLY_1);
        this.exactly1CB = new JComboBox<Object>(new DefaultComboBoxModel<Object>(this.getListOfEncodings(EXACTLY_1).toArray()));
        c.fill = 0;
        c.weightx = 0.2;
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 22;
        tmpPanel.add((Component)atMostKLabel, c);
        c.gridx = 0;
        c.gridy = 1;
        tmpPanel.add((Component)atMost1Label, c);
        c.gridx = 2;
        c.gridy = 1;
        tmpPanel.add((Component)exactly1Label, c);
        c.gridx = 2;
        c.gridy = 0;
        tmpPanel.add((Component)exactlyKLabel, c);
        c.fill = 2;
        c.anchor = 21;
        c.weightx = 0.8;
        c.gridx = 1;
        c.gridy = 0;
        tmpPanel.add((Component)this.atMostKCB, c);
        c.gridx = 3;
        c.gridy = 0;
        tmpPanel.add((Component)this.exactlyKCB, c);
        c.gridx = 1;
        c.gridy = 1;
        tmpPanel.add((Component)this.atMost1CB, c);
        c.gridx = 3;
        c.gridy = 1;
        tmpPanel.add((Component)this.exactly1CB, c);
        JPanel tmpPanel2 = new JPanel();
        tmpPanel2.setLayout(new GridBagLayout());
        GridBagConstraints c2 = new GridBagConstraints();
        c2.anchor = 21;
        c2.fill = 0;
        c2.weightx = 1.0;
        c2.gridx = 0;
        tmpPanel2.setName(CHOOSE_START_CONFIG);
        tmpPanel2.setBorder(new CompoundBorder(new TitledBorder(null, tmpPanel2.getName(), 1, 2), BORDER5));
        this.solverLineParamLineRadio = new JRadioButton(SOLVER_LINE_PARAM_LINE_CONFIG);
        this.solverLineParamRemoteRadio = new JRadioButton(SOLVER_LINE_PARAM_REMOTE_CONFIG);
        this.solverListParamRemoteRadio = new JRadioButton(SOLVER_LIST_PARAM_REMOTE_CONFIG);
        this.solverListParamListRadio = new JRadioButton(SOLVER_LIST_PARAM_LIST_CONFIG);
        ButtonGroup solverConfigGroup = new ButtonGroup();
        solverConfigGroup.add(this.solverLineParamLineRadio);
        solverConfigGroup.add(this.solverLineParamRemoteRadio);
        solverConfigGroup.add(this.solverListParamListRadio);
        solverConfigGroup.add(this.solverListParamRemoteRadio);
        this.solverListParamListRadio.setSelected(true);
        this.startConfig = StartSolverEnum.SOLVER_LIST_PARAM_DEFAULT;
        c2.gridy = 0;
        tmpPanel2.add((Component)this.solverLineParamLineRadio, c2);
        c2.gridy = 1;
        tmpPanel2.add((Component)this.solverLineParamRemoteRadio, c2);
        c2.gridy = 2;
        tmpPanel2.add((Component)this.solverListParamListRadio, c2);
        c2.gridy = 3;
        tmpPanel2.add((Component)this.solverListParamRemoteRadio, c2);
        JPanel tmpPanel3 = new JPanel();
        tmpPanel3.setLayout(new FlowLayout());
        tmpPanel3.add(this.startStopButton);
        tmpPanel3.add(this.pauseButton);
        this.choixSolverPanel.add(tmpPanel1);
        this.choixSolverPanel.add(tmpPanel);
        this.choixSolverPanel.add(tmpPanel2);
        this.choixSolverPanel.add(tmpPanel3);
        this.atMostKCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DetailedCommandPanel.this.encodingPolicy.setAtMostKEncoding((EncodingStrategy)DetailedCommandPanel.this.atMostKCB.getSelectedItem());
            }
        });
        this.atMost1CB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DetailedCommandPanel.this.encodingPolicy.setAtMostOneEncoding((EncodingStrategy)DetailedCommandPanel.this.atMost1CB.getSelectedItem());
            }
        });
        this.exactlyKCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DetailedCommandPanel.this.encodingPolicy.setExactlyKEncoding((EncodingStrategy)DetailedCommandPanel.this.exactlyKCB.getSelectedItem());
            }
        });
        this.exactly1CB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DetailedCommandPanel.this.encodingPolicy.setExactlyOneEncoding((EncodingStrategy)DetailedCommandPanel.this.exactly1CB.getSelectedItem());
            }
        });
        this.solverLineParamLineRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DetailedCommandPanel.this.solverLineParamLineRadio.isSelected()) {
                    DetailedCommandPanel.this.startConfig = StartSolverEnum.SOLVER_LINE_PARAM_LINE;
                }
            }
        });
        this.solverLineParamRemoteRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DetailedCommandPanel.this.solverLineParamRemoteRadio.isSelected()) {
                    DetailedCommandPanel.this.startConfig = StartSolverEnum.SOLVER_LINE_PARAM_REMOTE;
                }
            }
        });
        this.solverListParamListRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DetailedCommandPanel.this.solverListParamListRadio.isSelected()) {
                    DetailedCommandPanel.this.startConfig = StartSolverEnum.SOLVER_LIST_PARAM_DEFAULT;
                }
            }
        });
        this.solverListParamRemoteRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DetailedCommandPanel.this.solverListParamRemoteRadio.isSelected()) {
                    DetailedCommandPanel.this.startConfig = StartSolverEnum.SOLVER_LIST_PARAM_REMOTE;
                }
            }
        });
        this.setChoixSolverPanelEnabled(true);
        if (this.solver == null) {
            this.solverLineParamLineRadio.setEnabled(false);
            this.solverLineParamRemoteRadio.setEnabled(false);
        }
        if (this.firstStart) {
            this.solverLineParamRemoteRadio.setEnabled(false);
            this.solverListParamRemoteRadio.setEnabled(false);
        }
    }

    public void manageStartStopButton() {
        if (this.startStopButton.getText().equals(START)) {
            this.launchSolverWithConfigs();
            this.pauseButton.setEnabled(true);
            this.setInstancePanelEnabled(false);
            this.restartPanel.setRestartPanelEnabled(true);
            this.rwPanel.setRWPanelEnabled(true);
            this.cleanPanel.setCleanPanelEnabled(true);
            this.cleanPanel.setCleanPanelOriginalStrategyEnabled(true);
            this.phasePanel.setPhasePanelEnabled(true);
            this.setChoixSolverPanelEnabled(false);
            this.simplifierPanel.setSimplifierPanelEnabled(true);
            this.hotSolverPanel.setKeepSolverHotPanelEnabled(true);
            this.startStopButton.setText(STOP);
            this.solverListParamListRadio.setSelected(true);
            this.startConfig = StartSolverEnum.SOLVER_LIST_PARAM_DEFAULT;
            this.getThis().paintAll(this.getThis().getGraphics());
            this.frame.setActivateTracingEditableUnderCondition(false);
            this.frame.setActivateRadioTracing(false);
        } else {
            ((ISolver)this.problem).expireTimeout();
            this.pauseButton.setEnabled(false);
            this.log("Asked the solver to stop");
            this.setInstancePanelEnabled(true);
            this.setChoixSolverPanelEnabled(true);
            this.startStopButton.setText(START);
            this.getThis().paintAll(this.getThis().getGraphics());
            this.frame.setActivateTracingEditable(true);
            this.frame.setActivateRadioTracing(true);
        }
    }

    public String getStartStopText() {
        return this.startStopButton.getText();
    }

    public void setOptimisationMode(boolean optimizationMode) {
        this.optimizationMode = optimizationMode;
        this.optimisationModeCB.setSelected(optimizationMode);
    }

    public void launchSolverWithConfigs() {
        ICDCL cdclSolver;
        switch (this.startConfig) {
            case SOLVER_LIST_PARAM_REMOTE: {
                String selectedSolver = (String)this.listeSolvers.getSelectedItem();
                String[] partsSelectedSolver = selectedSolver.split("\\.");
                assert (partsSelectedSolver.length == 2);
                assert (partsSelectedSolver[0].equals(MINISAT_PREFIX) || partsSelectedSolver[0].equals(PB_PREFIX) || partsSelectedSolver[0].equals(MAXSAT_PREFIX));
                Object factory = partsSelectedSolver[0].equals(MINISAT_PREFIX) ? SolverFactory.instance() : (partsSelectedSolver[0].equals(PB_PREFIX) ? org.sat4j.pb.SolverFactory.instance() : org.sat4j.maxsat.SolverFactory.instance());
                this.solver = (ICDCL)factory.createSolverByName(partsSelectedSolver[1]);
                cdclSolver = (ICDCL)this.solver.getSolvingEngine();
                this.telecomStrategy.setSolver(cdclSolver);
                cdclSolver.setRestartStrategy((RestartStrategy)this.telecomStrategy);
                cdclSolver.setOrder((IOrder)this.randomWalk);
                cdclSolver.getOrder().setPhaseSelectionStrategy((IPhaseSelectionStrategy)this.telecomStrategy);
                this.restartPanel.hasClickedOnRestart();
                this.rwPanel.hasClickedOnApplyRW();
                this.phasePanel.hasClickedOnApplyPhase();
                this.simplifierPanel.hasClickedOnApplySimplification();
                break;
            }
            case SOLVER_LINE_PARAM_LINE: {
                this.solver = Solvers.configureSolver(this.commandLines, this);
                cdclSolver = (ICDCL)this.solver.getSolvingEngine();
                this.telecomStrategy.setSolver(cdclSolver);
                this.telecomStrategy.setRestartStrategy(cdclSolver.getRestartStrategy());
                cdclSolver.setRestartStrategy((RestartStrategy)this.telecomStrategy);
                this.restartPanel.setCurrentRestart(this.telecomStrategy.getRestartStrategy().getClass().getSimpleName());
                IOrder order = cdclSolver.getOrder();
                double proba = 0.0;
                if (this.optimizationMode) {
                    if (order instanceof RandomWalkDecoratorObjective) {
                        this.randomWalk = (RandomWalkDecorator)order;
                        proba = this.randomWalk.getProbability();
                    } else if (order instanceof VarOrderHeapObjective) {
                        this.randomWalk = new RandomWalkDecoratorObjective((VarOrderHeapObjective)order, 0.0);
                    }
                } else if (cdclSolver.getOrder() instanceof RandomWalkDecorator) {
                    this.randomWalk = (RandomWalkDecorator)order;
                    proba = this.randomWalk.getProbability();
                } else {
                    this.randomWalk = new RandomWalkDecorator((VarOrderHeap)order, 0.0);
                }
                this.randomWalk.setProbability(proba);
                this.rwPanel.setProba(proba);
                cdclSolver.setOrder((IOrder)this.randomWalk);
                this.telecomStrategy.setPhaseSelectionStrategy(cdclSolver.getOrder().getPhaseSelectionStrategy());
                cdclSolver.getOrder().setPhaseSelectionStrategy((IPhaseSelectionStrategy)this.telecomStrategy);
                this.phasePanel.setPhaseListSelectedItem(this.telecomStrategy.getPhaseSelectionStrategy().getClass().getSimpleName());
                this.simplifierPanel.setSelectedSimplification(cdclSolver.getSimplifier().toString());
                this.phasePanel.repaint();
                break;
            }
            case SOLVER_LINE_PARAM_REMOTE: {
                this.solver = Solvers.configureSolver(this.commandLines, this);
                cdclSolver = (ICDCL)this.solver.getSolvingEngine();
                cdclSolver.setRestartStrategy((RestartStrategy)this.telecomStrategy);
                cdclSolver.setOrder((IOrder)this.randomWalk);
                cdclSolver.getOrder().setPhaseSelectionStrategy((IPhaseSelectionStrategy)this.telecomStrategy);
                this.restartPanel.hasClickedOnRestart();
                this.rwPanel.hasClickedOnApplyRW();
                this.phasePanel.hasClickedOnApplyPhase();
                this.simplifierPanel.hasClickedOnApplySimplification();
                break;
            }
            default: {
                String selectedSolver = (String)this.listeSolvers.getSelectedItem();
                String[] partsSelectedSolver = selectedSolver.split("\\.");
                assert (partsSelectedSolver.length == 2);
                assert (partsSelectedSolver[0].equals(MINISAT_PREFIX) || partsSelectedSolver[0].equals(PB_PREFIX) || partsSelectedSolver[0].equals(MAXSAT_PREFIX));
                Object factory = partsSelectedSolver[0].equals(MINISAT_PREFIX) ? SolverFactory.instance() : (partsSelectedSolver[0].equals(PB_PREFIX) ? org.sat4j.pb.SolverFactory.instance() : org.sat4j.maxsat.SolverFactory.instance());
                this.solver = factory.createSolverByName(partsSelectedSolver[1]);
                cdclSolver = (ICDCL)this.solver.getSolvingEngine();
                this.telecomStrategy.setSolver(cdclSolver);
                this.telecomStrategy.setRestartStrategy(cdclSolver.getRestartStrategy());
                cdclSolver.setRestartStrategy((RestartStrategy)this.telecomStrategy);
                this.restartPanel.setCurrentRestart(this.telecomStrategy.getRestartStrategy().getClass().getSimpleName());
                IOrder order = cdclSolver.getOrder();
                double proba = 0.0;
                if (this.optimizationMode) {
                    if (order instanceof RandomWalkDecoratorObjective) {
                        this.randomWalk = (RandomWalkDecorator)order;
                        proba = this.randomWalk.getProbability();
                    } else if (order instanceof VarOrderHeapObjective) {
                        this.randomWalk = new RandomWalkDecoratorObjective((VarOrderHeapObjective)order, 0.0);
                    }
                } else if (cdclSolver.getOrder() instanceof RandomWalkDecorator) {
                    this.randomWalk = (RandomWalkDecorator)order;
                    proba = this.randomWalk.getProbability();
                } else {
                    this.randomWalk = new RandomWalkDecorator((VarOrderHeap)order, 0.0);
                }
                this.randomWalk.setProbability(proba);
                this.rwPanel.setProba(proba);
                cdclSolver.setOrder((IOrder)this.randomWalk);
                this.telecomStrategy.setPhaseSelectionStrategy(cdclSolver.getOrder().getPhaseSelectionStrategy());
                this.phasePanel.setPhaseListSelectedItem(this.telecomStrategy.getPhaseSelectionStrategy().getClass().getSimpleName());
                cdclSolver.getOrder().setPhaseSelectionStrategy((IPhaseSelectionStrategy)this.telecomStrategy);
                this.simplifierPanel.setSelectedSimplification(cdclSolver.getSimplifier().toString());
            }
        }
        this.whereToWriteFiles = this.instancePath;
        if (this.ramdisk.length() > 0) {
            String[] instancePathSplit = this.instancePath.split("/");
            this.whereToWriteFiles = this.ramdisk + "/" + instancePathSplit[instancePathSplit.length - 1];
        }
        this.solver.setVerbose(true);
        this.initSearchListeners();
        cdclSolver.setLogger((ILogAble)this);
        try {
            switch (this.problemType) {
                case PB_OPT: {
                    this.solver = new ClausalConstraintsDecorator((IPBSolver)this.solver, (EncodingStrategyAdapter)this.encodingPolicy);
                    this.solver = this.lowerMode ? new ConstraintRelaxingPseudoOptDecorator((IPBSolver)this.solver) : new PseudoOptDecorator((IPBSolver)this.solver);
                    this.reader = this.createReader(this.solver, this.instancePath);
                    this.problem = this.reader.parseInstance(this.instancePath);
                    this.problem = new OptToPBSATAdapter((IOptimizationProblem)this.problem);
                    break;
                }
                case CNF_MAXSAT: 
                case WCNF_MAXSAT: {
                    this.solver = new ClausalConstraintsDecorator((IPBSolver)this.solver, (EncodingStrategyAdapter)this.encodingPolicy);
                    this.solver = new WeightedMaxSatDecorator((IPBSolver)this.solver, this.equivalenceMode);
                    this.reader = this.createReader(this.solver, this.instancePath);
                    this.problem = this.reader.parseInstance(this.instancePath);
                    this.problem = this.lowerMode ? new ConstraintRelaxingPseudoOptDecorator((IPBSolver)((WeightedMaxSatDecorator)this.problem)) : new PseudoOptDecorator((IPBSolver)((WeightedMaxSatDecorator)this.problem), false, false);
                    this.problem = new OptToPBSATAdapter((IOptimizationProblem)this.problem);
                    break;
                }
                case PB_SAT: {
                    this.solver = new ClausalConstraintsDecorator((IPBSolver)this.solver, (EncodingStrategyAdapter)this.encodingPolicy);
                    this.reader = this.createReader(this.solver, this.instancePath);
                    this.problem = this.reader.parseInstance(this.instancePath);
                    break;
                }
                default: {
                    this.solver = new ClausalCardinalitiesDecorator(this.solver, (EncodingStrategyAdapter)this.encodingPolicy);
                    this.reader = this.createReader(this.solver, this.instancePath);
                    this.problem = this.reader.parseInstance(this.instancePath);
                    break;
                }
            }
        }
        catch (FileNotFoundException e) {
            this.log(e.getMessage());
        }
        catch (ParseFormatException e) {
            this.log(e.getMessage());
        }
        catch (IOException e) {
            this.log(e.getMessage());
        }
        catch (ContradictionException e) {
            this.log("Unsatisfiable (trivial)!");
            return;
        }
        this.log("# Started solver " + this.solver.getSolvingEngine().getClass().getSimpleName());
        this.log("# on instance " + this.instancePath);
        this.log("# Optimisation = " + this.optimizationMode);
        this.log("# Restart strategy = " + this.telecomStrategy.getRestartStrategy().getClass().getSimpleName());
        this.log("# Random walk probability = " + this.randomWalk.getProbability());
        this.log("# variables : " + this.solver.nVars());
        Thread solveurThread = new Thread(){

            @Override
            public void run() {
                try {
                    DetailedCommandPanel.this.stringWriter = new StringWriter();
                    if (DetailedCommandPanel.this.problem.isSatisfiable()) {
                        DetailedCommandPanel.this.log("Satisfiable !");
                        if (DetailedCommandPanel.this.problem instanceof OptToPBSATAdapter) {
                            DetailedCommandPanel.this.log(((OptToPBSATAdapter)DetailedCommandPanel.this.problem).getCurrentObjectiveValue() + "");
                            DetailedCommandPanel.this.reader.decode(((OptToPBSATAdapter)DetailedCommandPanel.this.problem).model(new PrintWriter(DetailedCommandPanel.this.stringWriter)), new PrintWriter(DetailedCommandPanel.this.stringWriter));
                        } else {
                            DetailedCommandPanel.this.reader.decode(DetailedCommandPanel.this.problem.model(), new PrintWriter(DetailedCommandPanel.this.stringWriter));
                        }
                        DetailedCommandPanel.this.log(DetailedCommandPanel.this.stringWriter.toString());
                    } else {
                        DetailedCommandPanel.this.log("Unsatisfiable !");
                    }
                }
                catch (TimeoutException e) {
                    DetailedCommandPanel.this.log("Timeout, sorry!");
                }
            }
        };
        solveurThread.start();
        if (this.isPlotActivated) {
            this.solverVisu.setnVar(this.solver.nVars());
            this.startVisu();
        }
    }

    public void initSearchListeners() {
        ArrayList<Object> listeners = new ArrayList<Object>();
        if (this.isPlotActivated) {
            if (this.gnuplotBased) {
                this.solverVisu = new GnuplotBasedSolverVisualisation(this.visuPreferences, this.solver.nVars(), this.instancePath, this);
                if (this.visuPreferences.isDisplayClausesEvaluation()) {
                    listeners.add(new LearnedTracing((IVisualizationTool)new FileBasedVisualizationTool(this.whereToWriteFiles + "-learned")));
                }
                if (this.visuPreferences.isDisplayClausesSize()) {
                    listeners.add(new LearnedClausesSizeTracing((IVisualizationTool)new FileBasedVisualizationTool(this.whereToWriteFiles + "-learned-clauses-size"), (IVisualizationTool)new FileBasedVisualizationTool(this.whereToWriteFiles + "-learned-clauses-size-restart"), (IVisualizationTool)new FileBasedVisualizationTool(this.whereToWriteFiles + "-learned-clauses-size-clean")));
                }
                if (this.visuPreferences.isDisplayConflictsDecision()) {
                    listeners.add(new ConflictLevelTracing((IVisualizationTool)new FileBasedVisualizationTool(this.whereToWriteFiles + "-conflict-level"), (IVisualizationTool)new FileBasedVisualizationTool(this.whereToWriteFiles + "-conflict-level-restart"), (IVisualizationTool)new FileBasedVisualizationTool(this.whereToWriteFiles + "-conflict-level-clean")));
                }
                if (this.visuPreferences.isDisplayConflictsTrail()) {
                    listeners.add(new ConflictDepthTracing((IVisualizationTool)new FileBasedVisualizationTool(this.whereToWriteFiles + "-conflict-depth"), (IVisualizationTool)new FileBasedVisualizationTool(this.whereToWriteFiles + "-conflict-depth-restart"), (IVisualizationTool)new FileBasedVisualizationTool(this.whereToWriteFiles + "-conflict-depth-clean")));
                }
                if (this.visuPreferences.isDisplayDecisionIndexes()) {
                    listeners.add(new DecisionTracing((IVisualizationTool)new FileBasedVisualizationTool(this.whereToWriteFiles + "-decision-indexes-pos"), (IVisualizationTool)new FileBasedVisualizationTool(this.whereToWriteFiles + "-decision-indexes-neg"), (IVisualizationTool)new FileBasedVisualizationTool(this.whereToWriteFiles + "-decision-indexes-restart"), (IVisualizationTool)new FileBasedVisualizationTool(this.whereToWriteFiles + "-decision-indexes-clean")));
                }
                if (this.visuPreferences.isDisplaySpeed()) {
                    listeners.add(new SpeedTracing((IVisualizationTool)new FileBasedVisualizationTool(this.whereToWriteFiles + "-speed"), (IVisualizationTool)new FileBasedVisualizationTool(this.whereToWriteFiles + "-speed-clean"), (IVisualizationTool)new FileBasedVisualizationTool(this.whereToWriteFiles + "-speed-restart")));
                }
                if (this.visuPreferences.isDisplayVariablesEvaluation()) {
                    listeners.add(new HeuristicsTracing((IVisualizationTool)new FileBasedVisualizationTool(this.whereToWriteFiles + "-heuristics")));
                }
            } else if (this.chartBased) {
                if (this.solverVisu != null) {
                    this.solverVisu.end();
                }
                this.solverVisu = new JChartBasedSolverVisualisation(this.visuPreferences);
                ((JChartBasedSolverVisualisation)this.solverVisu).setnVar(this.solver.nVars());
                if (this.visuPreferences.isDisplayClausesEvaluation()) {
                    listeners.add(new LearnedTracing((IVisualizationTool)new ChartBasedVisualizationTool(((JChartBasedSolverVisualisation)this.solverVisu).getClausesEvaluationTrace())));
                }
                if (this.visuPreferences.isDisplayClausesSize()) {
                    listeners.add(new LearnedClausesSizeTracing((IVisualizationTool)new ChartBasedVisualizationTool(((JChartBasedSolverVisualisation)this.solverVisu).getLearnedClausesSizeTrace()), (IVisualizationTool)new ChartBasedVisualizationTool(((JChartBasedSolverVisualisation)this.solverVisu).getLearnedClausesSizeRestartTrace()), (IVisualizationTool)new ChartBasedVisualizationTool(((JChartBasedSolverVisualisation)this.solverVisu).getLearnedClausesSizeCleanTrace())));
                }
                if (this.visuPreferences.isDisplayConflictsDecision()) {
                    listeners.add(new ConflictLevelTracing((IVisualizationTool)new ChartBasedVisualizationTool(((JChartBasedSolverVisualisation)this.solverVisu).getConflictLevelTrace()), (IVisualizationTool)new ChartBasedVisualizationTool(((JChartBasedSolverVisualisation)this.solverVisu).getConflictLevelRestartTrace()), (IVisualizationTool)new ChartBasedVisualizationTool(((JChartBasedSolverVisualisation)this.solverVisu).getConflictLevelCleanTrace())));
                }
                if (this.visuPreferences.isDisplayConflictsTrail()) {
                    listeners.add(new ConflictDepthTracing((IVisualizationTool)new ChartBasedVisualizationTool(((JChartBasedSolverVisualisation)this.solverVisu).getConflictDepthTrace()), (IVisualizationTool)new ChartBasedVisualizationTool(((JChartBasedSolverVisualisation)this.solverVisu).getConflictDepthRestartTrace()), (IVisualizationTool)new ChartBasedVisualizationTool(((JChartBasedSolverVisualisation)this.solverVisu).getConflictDepthCleanTrace())));
                }
                if (this.visuPreferences.isDisplayDecisionIndexes()) {
                    listeners.add(new DecisionTracing((IVisualizationTool)new ChartBasedVisualizationTool(((JChartBasedSolverVisualisation)this.solverVisu).getPositiveDecisionTrace()), (IVisualizationTool)new ChartBasedVisualizationTool(((JChartBasedSolverVisualisation)this.solverVisu).getNegativeDecisionTrace()), (IVisualizationTool)new ChartBasedVisualizationTool(new TraceComposite(((JChartBasedSolverVisualisation)this.solverVisu).getRestartPosDecisionTrace(), ((JChartBasedSolverVisualisation)this.solverVisu).getRestartNegDecisionTrace())), (IVisualizationTool)new ChartBasedVisualizationTool(new TraceComposite(((JChartBasedSolverVisualisation)this.solverVisu).getCleanPosDecisionTrace(), ((JChartBasedSolverVisualisation)this.solverVisu).getCleanNegDecisionTrace()))));
                }
                if (this.visuPreferences.isDisplaySpeed()) {
                    listeners.add(new SpeedTracing((IVisualizationTool)new ChartBasedVisualizationTool(((JChartBasedSolverVisualisation)this.solverVisu).getSpeedTrace()), (IVisualizationTool)new ChartBasedVisualizationTool(((JChartBasedSolverVisualisation)this.solverVisu).getSpeedCleanTrace()), (IVisualizationTool)new ChartBasedVisualizationTool(((JChartBasedSolverVisualisation)this.solverVisu).getSpeedRestartTrace())));
                }
                if (this.visuPreferences.isDisplayVariablesEvaluation()) {
                    listeners.add(new HeuristicsTracing((IVisualizationTool)new ChartBasedVisualizationTool(((JChartBasedSolverVisualisation)this.solverVisu).getHeuristicsTrace())));
                }
            }
        }
        listeners.add(this);
        this.solver.setSearchListener((SearchListener)new MultiTracing(listeners));
    }

    @Override
    public int getNVar() {
        if (this.solver != null) {
            return this.solver.nVars();
        }
        return 0;
    }

    @Override
    public void setPhaseSelectionStrategy(IPhaseSelectionStrategy phase) {
        this.telecomStrategy.setPhaseSelectionStrategy(phase);
        this.log("Told the solver to apply a new phase strategy :" + phase.getClass().getSimpleName());
    }

    @Override
    public void shouldRestartNow() {
        this.telecomStrategy.setHasClickedOnRestart(true);
    }

    @Override
    public void setRestartStrategy(RestartStrategy strategy) {
        this.telecomStrategy.setRestartStrategy(strategy);
        this.log("Set Restart to " + strategy);
    }

    @Override
    public RestartStrategy getRestartStrategy() {
        return this.telecomStrategy.getRestartStrategy();
    }

    @Override
    public SearchParams getSearchParams() {
        return this.telecomStrategy.getSearchParams();
    }

    @Override
    public SolverStats getSolverStats() {
        return this.telecomStrategy.getSolverStats();
    }

    @Override
    public void init(SearchParams params, SolverStats stats) {
        this.telecomStrategy.init(params, stats);
        this.log("Init restart with params");
    }

    @Override
    public void setNbClausesAtWhichWeShouldClean(int nbConflicts) {
        this.telecomStrategy.setNbClausesAtWhichWeShouldClean(nbConflicts);
        this.log("Changed number of conflicts before cleaning to " + nbConflicts);
    }

    @Override
    public void setUseTelecomStrategyAsLearnedConstraintsDeletionStrategy() {
        this.telecomStrategy.setUseTelecomStrategyAsLearnedConstraintsDeletionStrategy(true);
        this.log("Solver now cleans clauses every " + this.cleanPanel.getCleanSliderValue() + " conflicts and bases evaluation of clauses on activity");
    }

    @Override
    public void setLearnedDeletionStrategyTypeToSolver(LearnedConstraintsEvaluationType type) {
        ((ICDCL)this.solver.getSolvingEngine()).setLearnedConstraintsDeletionStrategy((ConflictTimer)this.telecomStrategy, type);
        this.log("Changed clauses evaluation type to " + type);
    }

    public LearnedConstraintsEvaluationType getLearnedConstraintsEvaluationType() {
        return LearnedConstraintsEvaluationType.ACTIVITY;
    }

    @Override
    public void shouldCleanNow() {
        this.log("Told the solver to clean");
        this.telecomStrategy.setHasClickedOnClean(true);
    }

    @Override
    public void setKeepSolverHot(boolean keepHot) {
        this.solver.setKeepSolverHot(keepHot);
        if (keepHot) {
            this.log("Keep hot solver is now activated");
        } else {
            this.log("Keep hot solver is now desactivated");
        }
    }

    public boolean isGnuplotBased() {
        return this.gnuplotBased;
    }

    public void setGnuplotBased(boolean gnuplotBased) {
        this.gnuplotBased = gnuplotBased;
    }

    public boolean isChartBased() {
        return this.chartBased;
    }

    public void setChartBased(boolean chartBased) {
        this.chartBased = chartBased;
    }

    public boolean isPlotActivated() {
        return this.isPlotActivated;
    }

    public void setPlotActivated(boolean isPlotActivated) {
        this.isPlotActivated = isPlotActivated;
    }

    @Override
    public void setRandomWalkProba(double proba) {
        this.randomWalk.setProbability(proba);
        this.log("Set probability to " + proba);
    }

    @Override
    public void setSimplifier(SimplificationType type) {
        ((ICDCL)this.solver.getSolvingEngine()).setSimplifier(type);
        this.log("Told the solver to use " + type);
    }

    public List<String> getListOfSolvers() {
        ArrayList<String> result = new ArrayList<String>();
        SolverFactory factory = SolverFactory.instance();
        for (String s : factory.solverNames()) {
            result.add("minisat." + s);
        }
        factory = org.sat4j.pb.SolverFactory.instance();
        for (String s : factory.solverNames()) {
            result.add("pb." + s);
        }
        Collections.sort(result);
        factory = org.sat4j.maxsat.SolverFactory.instance();
        for (String s : factory.solverNames()) {
            result.add("maxsat." + s);
        }
        Collections.sort(result);
        return result;
    }

    public List<String> getListOfSatSolvers() {
        ArrayList<String> result = new ArrayList<String>();
        SolverFactory factory = SolverFactory.instance();
        for (String s : factory.solverNames()) {
            result.add("minisat." + s);
        }
        Collections.sort(result);
        return result;
    }

    public List<String> getListOfPBSolvers() {
        ArrayList<String> result = new ArrayList<String>();
        org.sat4j.pb.SolverFactory factory = org.sat4j.pb.SolverFactory.instance();
        for (String s : factory.solverNames()) {
            result.add("pb." + s);
        }
        Collections.sort(result);
        return result;
    }

    public List<String> getListOfMaxsatSolvers() {
        ArrayList<String> result = new ArrayList<String>();
        org.sat4j.pb.SolverFactory factory = org.sat4j.pb.SolverFactory.instance();
        for (String s : factory.solverNames()) {
            result.add("maxsat." + s);
        }
        Collections.sort(result);
        return result;
    }

    public List<EncodingStrategy> getListOfEncodings(String typeOfConstraint) {
        ArrayList<EncodingStrategy> v = new ArrayList<EncodingStrategy>();
        v.add(EncodingStrategy.NATIVE);
        if (typeOfConstraint.equals(AT_MOST_K) || typeOfConstraint.equals(AT_MOST_1)) {
            v.add(EncodingStrategy.BINARY);
            v.add(EncodingStrategy.BINOMIAL);
            v.add(EncodingStrategy.COMMANDER);
        }
        if (typeOfConstraint.equals(AT_MOST_K)) {
            v.add(EncodingStrategy.SEQUENTIAL);
        }
        if (typeOfConstraint.equals(AT_MOST_1) || typeOfConstraint.equals(EXACTLY_1)) {
            v.add(EncodingStrategy.LADDER);
        }
        if (typeOfConstraint.equals(AT_MOST_1)) {
            v.add(EncodingStrategy.PRODUCT);
        }
        return v;
    }

    public void log(String message) {
        this.logsameline(message + "\n");
    }

    public void logsameline(String message) {
        if (this.console != null) {
            this.console.append(message);
            this.console.setCaretPosition(this.console.getDocument().getLength());
            this.console.repaint();
        }
        this.repaint();
    }

    public void openFileChooser() {
        JFileChooser fc = new JFileChooser();
        int returnVal = fc.showDialog(this, "Choose instance");
        if (returnVal == 0) {
            File file = fc.getSelectedFile();
            this.instancePath = file.getAbsolutePath();
            this.instancePathField.setText(this.instancePath);
            this.updateListOfSolvers();
        }
    }

    protected Reader createReader(ISolver theSolver, String problemname) {
        InstanceReader instance = new InstanceReader(theSolver);
        switch (this.problemType) {
            case CNF_MAXSAT: 
            case WCNF_MAXSAT: {
                instance = new MSInstanceReader((WeightedMaxSatDecorator)theSolver);
                break;
            }
            case PB_OPT: 
            case PB_SAT: {
                instance = new PBInstanceReader((IPBSolver)theSolver);
                break;
            }
            case CNF_SAT: {
                instance = new InstanceReader(theSolver);
            }
        }
        return instance;
    }

    public void updateListOfSolvers() {
        List<Object> theList = new ArrayList();
        String defaultSolver = "";
        if (this.instancePath == null || this.instancePath.length() == 0) {
            theList = this.getListOfSolvers();
            defaultSolver = "minisat.Default";
            this.problemType = ProblemType.CNF_SAT;
            this.equivalenceCB.setEnabled(false);
            this.lowerCB.setEnabled(false);
        } else if (this.instancePath.endsWith(".cnf")) {
            this.optimisationModeCB.setEnabled(true);
            if (this.optimizationMode) {
                theList.addAll(this.getListOfMaxsatSolvers());
                theList.addAll(this.getListOfPBSolvers());
                defaultSolver = "maxsat.Default";
                this.equivalenceCB.setEnabled(true);
                this.lowerCB.setEnabled(true);
                this.problemType = ProblemType.CNF_MAXSAT;
                this.log("cnf file + opt => pb/maxsat solvers");
            } else {
                theList.addAll(this.getListOfSatSolvers());
                theList.addAll(this.getListOfPBSolvers());
                defaultSolver = "minisat.Default";
                this.log("cnf file + non opt => sat/pb solvers");
                this.problemType = ProblemType.CNF_SAT;
                this.equivalenceCB.setEnabled(false);
                this.lowerCB.setEnabled(false);
            }
        } else if (this.instancePath.endsWith(".opb")) {
            this.optimisationModeCB.setEnabled(true);
            theList.addAll(this.getListOfPBSolvers());
            defaultSolver = "pb.Default";
            if (this.optimizationMode) {
                this.problemType = ProblemType.PB_OPT;
                this.equivalenceCB.setEnabled(true);
                this.lowerCB.setEnabled(true);
            } else {
                this.problemType = ProblemType.PB_SAT;
                this.equivalenceCB.setEnabled(false);
                this.lowerCB.setEnabled(false);
            }
            this.log("opb file => pb solvers");
        } else if (this.instancePath.endsWith(".wcnf")) {
            this.equivalenceCB.setEnabled(true);
            this.lowerCB.setEnabled(true);
            theList.addAll(this.getListOfMaxsatSolvers());
            theList.addAll(this.getListOfPBSolvers());
            defaultSolver = "maxsat.Default";
            this.optimisationModeCB.setSelected(true);
            this.optimisationModeCB.setEnabled(false);
            this.problemType = ProblemType.WCNF_MAXSAT;
            this.log("wcnf file => pb/maxsat solvers");
        }
        this.listeSolvers.setModel(new DefaultComboBoxModel<Object>(theList.toArray()));
        this.listeSolvers.setSelectedItem(defaultSolver);
        this.choixSolverPanel.repaint();
    }

    public void setInstancePanelEnabled(boolean enabled) {
        this.instanceLabel.setEnabled(enabled);
        this.instancePathField.setEnabled(enabled);
        this.browseButton.setEnabled(enabled);
        this.instancePanel.repaint();
    }

    public void setChoixSolverPanelEnabled(boolean enabled) {
        this.listeSolvers.setEnabled(enabled);
        this.choixSolver.setEnabled(enabled);
        this.solverLineParamLineRadio.setEnabled(enabled);
        this.solverLineParamRemoteRadio.setEnabled(enabled);
        this.solverListParamListRadio.setEnabled(enabled);
        this.solverListParamRemoteRadio.setEnabled(enabled);
        this.choixSolverPanel.repaint();
    }

    public void setSolverVisualisation(SolverVisualisation visu) {
        this.solverVisu = visu;
    }

    public void activateGnuplotTracing(boolean b) {
        this.isPlotActivated = b;
        if (this.solver != null) {
            this.initSearchListeners();
        }
    }

    public void startVisu() {
        this.solverVisu.start();
    }

    public void stopVisu() {
        this.solverVisu.end();
    }

    public VisuPreferences getGnuplotPreferences() {
        return this.visuPreferences;
    }

    public void setGnuplotPreferences(VisuPreferences gnuplotPreferences) {
        this.visuPreferences = gnuplotPreferences;
    }

    public DetailedCommandPanel getThis() {
        return this;
    }

    public ISolver getSolver() {
        return (ISolver)this.problem;
    }

    private void updateWriter() {
        try {
            this.outSolutionFound = new PrintStream(new FileOutputStream(this.whereToWriteFiles + "_solutions.dat"));
        }
        catch (FileNotFoundException e) {
            this.outSolutionFound = System.out;
        }
    }

    public void init(ISolverService solverService) {
        this.conflictCounter = 0;
    }

    public void assuming(int p) {
    }

    public void propagating(int p) {
        this.end = System.currentTimeMillis();
        if (this.end - this.begin >= 2000L) {
            long tmp = this.end - this.begin;
            this.cleanPanel.setSpeedLabeltext((long)this.propagationsCounter / tmp * 1000L + "");
            this.begin = System.currentTimeMillis();
            this.propagationsCounter = 0;
        }
        ++this.propagationsCounter;
    }

    public void enqueueing(int p, IConstr reason) {
    }

    public void backtracking(int p) {
    }

    public void adding(int p) {
    }

    public void learn(IConstr c) {
    }

    public void delete(IConstr c) {
    }

    public void learnUnit(int p) {
    }

    public void conflictFound(IConstr confl, int dlevel, int trailLevel) {
        ++this.conflictCounter;
    }

    public void conflictFound(int p) {
    }

    public void solutionFound(int[] model, RandomAccessModel lazyModel) {
        this.log("Found a solution !! ");
        this.logsameline(this.stringWriter.toString());
        this.stringWriter.getBuffer().delete(0, this.stringWriter.getBuffer().length());
        this.outSolutionFound.println(this.conflictCounter + "\t");
    }

    public void beginLoop() {
    }

    public void start() {
    }

    public void end(Lbool result) {
    }

    public void restarting() {
        this.end = System.currentTimeMillis();
        if (this.end != this.begin) {
            this.cleanPanel.setSpeedLabeltext((long)this.propagationsCounter / (this.end - this.begin) * 1000L + "");
        }
    }

    public void backjump(int backjumpLevel) {
    }

    public void cleaning() {
        this.end = System.currentTimeMillis();
        this.cleanPanel.setSpeedLabeltext((long)this.propagationsCounter / (this.end - this.begin) * 1000L + "");
    }

    public class MyTabbedPane
    extends JTabbedPane {
        private static final long serialVersionUID = 1L;

        @Override
        public void setSelectedIndex(int index) {
            if (this.getTabCount() == 5 && index == 4) {
                if (DetailedCommandPanel.this.solver != null && DetailedCommandPanel.this.startStopButton.getText().equals(DetailedCommandPanel.STOP)) {
                    String s = DetailedCommandPanel.this.solver.toString();
                    String res = DetailedCommandPanel.this.solver.toString();
                    int j = 0;
                    for (int i = 0; i < s.length(); ++i) {
                        j = s.charAt(i) != '\n' ? ++j : 0;
                        if (j <= 80) continue;
                        res = new StringBuilder(res).insert(i, '\n').toString();
                        j = 0;
                    }
                    DetailedCommandPanel.this.textArea.setText(res);
                    DetailedCommandPanel.this.textArea.setEditable(false);
                    DetailedCommandPanel.this.textArea.repaint();
                    DetailedCommandPanel.this.aboutSolverPanel.paint(DetailedCommandPanel.this.aboutSolverPanel.getGraphics());
                    DetailedCommandPanel.this.aboutSolverPanel.repaint();
                } else {
                    DetailedCommandPanel.this.textArea.setText("No solver is running at the moment");
                    DetailedCommandPanel.this.textArea.repaint();
                    DetailedCommandPanel.this.textArea.setEditable(false);
                    DetailedCommandPanel.this.aboutSolverPanel.paint(DetailedCommandPanel.this.aboutSolverPanel.getGraphics());
                    DetailedCommandPanel.this.aboutSolverPanel.repaint();
                }
            }
            super.setSelectedIndex(index);
        }
    }
}

