/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.sat;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.sat4j.AbstractLauncher;
import org.sat4j.ExitCode;
import org.sat4j.core.VecInt;
import org.sat4j.minisat.core.ICDCL;
import org.sat4j.pb.IPBSolver;
import org.sat4j.pb.PseudoOptDecorator;
import org.sat4j.pb.core.IPBCDCLSolver;
import org.sat4j.pb.reader.PBInstanceReader;
import org.sat4j.reader.InstanceReader;
import org.sat4j.reader.ParseFormatException;
import org.sat4j.reader.Reader;
import org.sat4j.sat.RemoteControlFrame;
import org.sat4j.sat.Solvers;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.ILogAble;
import org.sat4j.specs.IOptimizationProblem;
import org.sat4j.specs.IProblem;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.IVecInt;
import org.sat4j.specs.SearchListener;
import org.sat4j.specs.TimeoutException;
import org.sat4j.tools.ConflictDepthTracing;
import org.sat4j.tools.ConflictLevelTracing;
import org.sat4j.tools.DecisionTracing;
import org.sat4j.tools.DotSearchTracing;
import org.sat4j.tools.FileBasedVisualizationTool;
import org.sat4j.tools.IVisualizationTool;
import org.sat4j.tools.LearnedClausesSizeTracing;
import org.sat4j.tools.MultiTracing;

@Deprecated
public class Lanceur
extends AbstractLauncher
implements ILogAble {
    private static final String NUMBER = "number";
    private static final long serialVersionUID = 1L;
    private static final String CURRENT_OPTIMUM_VALUE_PREFIX = "o ";
    private boolean incomplete = false;
    private boolean isModeOptimization = false;
    private IProblem problem;
    private boolean modeTracing = false;
    private boolean launchRemoteControl;
    private static AbstractLauncher lanceur;
    private String filename;
    private int k = -1;

    public static void main(String[] args) {
        lanceur = new Lanceur();
        lanceur.addHook();
        lanceur.run(args);
    }

    protected ICDCL configureSolver(String[] args) {
        Options options = Lanceur.createCLIOptions();
        try {
            Integer myk;
            CommandLine cmd = new PosixParser().parse(options, args);
            if (cmd.hasOption("opt")) {
                this.isModeOptimization = true;
            }
            String framework = cmd.getOptionValue("l");
            if (this.isModeOptimization) {
                framework = "pb";
            } else if (framework == null) {
                framework = "minisat";
            }
            try {
                Class<?> clazz = Class.forName("org.sat4j." + framework + ".SolverFactory");
                Class[] params = new Class[]{};
                Method method = clazz.getMethod("instance", params);
            }
            catch (Exception e) {
                this.log("Wrong framework: " + framework + ". Using minisat instead.");
            }
            ICDCL asolver = Solvers.configureSolver(args, this);
            this.launchRemoteControl = cmd.hasOption("remote");
            this.filename = cmd.getOptionValue("f");
            if (cmd.hasOption("d")) {
                String dotfilename = null;
                if (this.filename != null) {
                    dotfilename = cmd.getOptionValue("d");
                }
                if (dotfilename == null) {
                    dotfilename = "sat4j.dot";
                }
                asolver.setSearchListener((SearchListener)new DotSearchTracing(dotfilename));
            }
            if (cmd.hasOption("m")) {
                this.setSilent(true);
            }
            if (cmd.hasOption("k") && (myk = Integer.valueOf(cmd.getOptionValue("k"))) != null) {
                this.k = myk;
            }
            if (this.isModeOptimization) {
                assert (asolver instanceof IPBSolver);
                this.problem = new PseudoOptDecorator((IPBSolver)((IPBCDCLSolver)asolver));
            }
            int others = 0;
            String[] rargs = cmd.getArgs();
            if (this.filename == null && rargs.length > 0) {
                this.filename = rargs[others++];
            }
            if (cmd.hasOption("r")) {
                this.modeTracing = true;
                if (!cmd.hasOption("remote")) {
                    asolver.setSearchListener((SearchListener)new MultiTracing(new SearchListener[]{new ConflictLevelTracing((IVisualizationTool)new FileBasedVisualizationTool(this.filename + "-conflict-level"), (IVisualizationTool)new FileBasedVisualizationTool(this.filename + "-conflict-level-restart"), (IVisualizationTool)new FileBasedVisualizationTool(this.filename + "-conflict-level-clean")), new DecisionTracing((IVisualizationTool)new FileBasedVisualizationTool(this.filename + "-decision-indexes-pos"), (IVisualizationTool)new FileBasedVisualizationTool(this.filename + "-decision-indexes-neg"), (IVisualizationTool)new FileBasedVisualizationTool(this.filename + "-decision-indexes-restart"), (IVisualizationTool)new FileBasedVisualizationTool(this.filename + "-decision-indexes-clean")), new LearnedClausesSizeTracing((IVisualizationTool)new FileBasedVisualizationTool(this.filename + "-learned-clauses-size"), (IVisualizationTool)new FileBasedVisualizationTool(this.filename + "-learned-clauses-size-restart"), (IVisualizationTool)new FileBasedVisualizationTool(this.filename + "-learned-clauses-size-clean")), new ConflictDepthTracing((IVisualizationTool)new FileBasedVisualizationTool(this.filename + "-conflict-depth"), (IVisualizationTool)new FileBasedVisualizationTool(this.filename + "-conflict-depth-restart"), (IVisualizationTool)new FileBasedVisualizationTool(this.filename + "-conflict-depth-clean"))}));
                }
            }
            while (others < rargs.length) {
                String[] param = rargs[others].split("=");
                assert (param.length == 2);
                this.log("setting " + param[0] + " to " + param[1]);
                try {
                    BeanUtils.setProperty((Object)asolver, (String)param[0], (Object)param[1]);
                }
                catch (Exception e) {
                    this.log("Cannot set parameter : " + args[others]);
                }
                ++others;
            }
            this.getLogWriter().println(asolver.toString("c "));
            return asolver;
        }
        catch (ParseException e1) {
            HelpFormatter helpf = new HelpFormatter();
            helpf.printHelp("java -jar sat4j.jar", options, true);
            this.usage();
            return null;
        }
    }

    protected Reader createReader(ISolver theSolver, String problemname) {
        if (theSolver instanceof IPBSolver) {
            return new PBInstanceReader((IPBSolver)theSolver);
        }
        return new InstanceReader(theSolver);
    }

    public void displayLicense() {
        super.displayLicense();
        this.log("This software uses some libraries from the Jakarta Commons project. See jakarta.apache.org for details.");
    }

    protected String getInstanceName(String[] args) {
        return this.filename;
    }

    protected IProblem readProblem(String problemname) throws ParseFormatException, IOException, ContradictionException {
        ISolver theSolver = (ISolver)super.readProblem(problemname);
        if (this.k > 0) {
            VecInt literals = new VecInt();
            for (int i = 1; i <= theSolver.nVars(); ++i) {
                literals.push(-i);
            }
            theSolver.addAtLeast((IVecInt)literals, this.k);
            this.log("Limiting solutions to those having at least " + this.k + " variables assigned to false");
        }
        return theSolver;
    }

    protected void solve(IProblem problem) throws TimeoutException {
        block12: {
            if (this.isModeOptimization) {
                boolean isSatisfiable = false;
                IOptimizationProblem optproblem = (IOptimizationProblem)problem;
                try {
                    while (optproblem.admitABetterSolution()) {
                        if (!isSatisfiable) {
                            if (optproblem.nonOptimalMeansSatisfiable()) {
                                this.setExitCode(ExitCode.SATISFIABLE);
                                if (optproblem.hasNoObjectiveFunction()) {
                                    return;
                                }
                                this.log("SATISFIABLE");
                            } else if (this.incomplete) {
                                this.setExitCode(ExitCode.UPPER_BOUND);
                            }
                            isSatisfiable = true;
                            this.log("OPTIMIZING...");
                        }
                        this.log("Got one! Elapsed wall clock time (in seconds):" + (double)(System.currentTimeMillis() - this.getBeginTime()) / 1000.0);
                        this.getLogWriter().println(CURRENT_OPTIMUM_VALUE_PREFIX + optproblem.getObjectiveValue());
                        optproblem.discardCurrentSolution();
                    }
                    if (isSatisfiable) {
                        this.setExitCode(ExitCode.OPTIMUM_FOUND);
                        break block12;
                    }
                    this.setExitCode(ExitCode.UNSATISFIABLE);
                }
                catch (ContradictionException ex) {
                    assert (isSatisfiable);
                    this.setExitCode(ExitCode.OPTIMUM_FOUND);
                }
            } else {
                this.setExitCode(problem.isSatisfiable() ? ExitCode.SATISFIABLE : ExitCode.UNSATISFIABLE);
            }
        }
    }

    protected void displayResult() {
        if (this.isModeOptimization) {
            this.displayAnswer();
            this.log("Total wall clock time (in seconds): " + (double)(System.currentTimeMillis() - this.getBeginTime()) / 1000.0);
        } else {
            super.displayResult();
        }
    }

    protected void displayAnswer() {
        if (this.solver == null) {
            return;
        }
        System.out.flush();
        PrintWriter out = this.getLogWriter();
        out.flush();
        this.solver.printStat(out, "c ");
        this.solver.printInfos(out, "c ");
        ExitCode exitCode = this.getExitCode();
        out.println("s " + exitCode);
        if (exitCode == ExitCode.SATISFIABLE || exitCode == ExitCode.OPTIMUM_FOUND || this.incomplete && exitCode == ExitCode.UPPER_BOUND) {
            IOptimizationProblem optproblem;
            out.print("v ");
            this.getReader().decode(this.problem.model(), out);
            out.println();
            if (this.isModeOptimization && !(optproblem = (IOptimizationProblem)this.problem).hasNoObjectiveFunction()) {
                this.log("objective function=" + optproblem.getObjectiveValue());
            }
        }
    }

    public void run(String[] args) {
        block13: {
            try {
                String instanceName;
                this.displayHeader();
                this.solver = this.configureSolver(args);
                if (this.solver == null) {
                    this.usage();
                    return;
                }
                if (!this.isSilent()) {
                    this.solver.setVerbose(true);
                }
                if ((instanceName = this.getInstanceName(args)) == null) {
                    this.usage();
                    return;
                }
                this.beginTime = System.currentTimeMillis();
                if (!this.launchRemoteControl) {
                    this.readProblem(instanceName);
                    try {
                        if (this.problem != null) {
                            this.solve(this.problem);
                        } else {
                            this.solve((IProblem)this.solver);
                        }
                    }
                    catch (TimeoutException e) {
                        this.log("timeout");
                    }
                    System.exit(lanceur.getExitCode().value());
                    break block13;
                }
                RemoteControlFrame frame = new RemoteControlFrame(this.filename, "", args);
                frame.activateTracing(this.modeTracing);
                frame.setOptimisationMode(this.isModeOptimization);
            }
            catch (FileNotFoundException e) {
                System.err.println("FATAL " + e.getLocalizedMessage());
            }
            catch (IOException e) {
                System.err.println("FATAL " + e.getLocalizedMessage());
            }
            catch (ContradictionException e) {
                this.setExitCode(ExitCode.UNSATISFIABLE);
                this.log("(trivial inconsistency)");
            }
            catch (ParseFormatException e) {
                System.err.println("FATAL " + e.getLocalizedMessage());
            }
        }
    }

    public void usage() {
        Solvers.usage(this);
    }

    public static Options createCLIOptions() {
        Options options = new Options();
        options.addOption("l", "library", true, "specifies the name of the library used (minisat by default)");
        options.addOption("s", "solver", true, "specifies the name of a prebuilt solver from the library");
        options.addOption("S", "Solver", true, "setup a solver using a solver config string");
        options.addOption("t", "timeout", true, "specifies the timeout (in seconds)");
        options.addOption("T", "timeoutms", true, "specifies the timeout (in milliseconds)");
        options.addOption("C", "conflictbased", false, "conflict based timeout (for deterministic behavior)");
        options.addOption("d", "dot", true, "creates a sat4j.dot file in current directory representing the search");
        options.addOption("f", "filename", true, "specifies the file to use (in conjunction with -d for instance)");
        options.addOption("m", "mute", false, "Set launcher in silent mode");
        options.addOption("k", "kleast", true, "limit the search to models having at least k variables set to false");
        options.addOption("r", "trace", false, "traces the behavior of the solver");
        options.addOption("opt", "optimize", false, "uses solver in optimize mode instead of sat mode (default)");
        options.addOption("rw", "randomWalk", true, "specifies the random walk probability ");
        options.addOption("remote", "remoteControl", false, "launches remote control");
        options.addOption("H", "hot", false, "keep the solver hot (do not reset heuristics) when a model is found");
        options.addOption("y", "simplify", false, "simplify the set of clauses is possible");
        Option op = options.getOption("l");
        op.setArgName("libname");
        op = options.getOption("s");
        op.setArgName("solvername");
        op = options.getOption("S");
        op.setArgName("solverStringDefinition");
        op = options.getOption("t");
        op.setArgName(NUMBER);
        op = options.getOption("T");
        op.setArgName(NUMBER);
        op = options.getOption("C");
        op.setArgName(NUMBER);
        op = options.getOption("k");
        op.setArgName(NUMBER);
        op = options.getOption("d");
        op.setArgName("filename");
        op = options.getOption("f");
        op.setArgName("filename");
        op = options.getOption("r");
        op.setArgName("searchlistener");
        op = options.getOption("rw");
        op.setArgName(NUMBER);
        return options;
    }
}

