/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.sat;

import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.sat4j.AbstractLauncher;
import org.sat4j.ExitCode;
import org.sat4j.ILauncherMode;
import org.sat4j.maxsat.WeightedMaxSatDecorator;
import org.sat4j.maxsat.reader.MSInstanceReader;
import org.sat4j.minisat.core.ICDCL;
import org.sat4j.pb.ConstraintRelaxingPseudoOptDecorator;
import org.sat4j.pb.IPBSolver;
import org.sat4j.pb.PseudoOptDecorator;
import org.sat4j.pb.core.IPBCDCLSolver;
import org.sat4j.pb.reader.PBInstanceReader;
import org.sat4j.reader.InstanceReader;
import org.sat4j.reader.ParseFormatException;
import org.sat4j.reader.Reader;
import org.sat4j.sat.ProblemType;
import org.sat4j.sat.RemoteControlFrame;
import org.sat4j.sat.Solvers;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.ILogAble;
import org.sat4j.specs.IProblem;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.SearchListener;
import org.sat4j.specs.TimeoutException;
import org.sat4j.tools.ConflictDepthTracing;
import org.sat4j.tools.ConflictLevelTracing;
import org.sat4j.tools.DecisionTracing;
import org.sat4j.tools.FileBasedVisualizationTool;
import org.sat4j.tools.IVisualizationTool;
import org.sat4j.tools.LearnedClausesSizeTracing;
import org.sat4j.tools.MultiTracing;

public class Launcher
extends AbstractLauncher
implements ILogAble {
    private static final long serialVersionUID = 1L;
    private boolean isModeOptimization = false;
    private boolean modeTracing = false;
    private boolean launchRemoteControl;
    private static AbstractLauncher launcher;
    private String filename;
    private ProblemType typeProbleme = ProblemType.CNF_SAT;

    public static void main(String[] args) {
        launcher = new Launcher();
        launcher.addHook();
        launcher.run(args);
    }

    public void usage() {
        Solvers.usage(this);
    }

    protected Reader createReader(ISolver theSolver, String problemname) {
        InstanceReader instance = new InstanceReader(theSolver);
        switch (this.typeProbleme) {
            case CNF_MAXSAT: 
            case WCNF_MAXSAT: {
                instance = new MSInstanceReader((WeightedMaxSatDecorator)theSolver);
                break;
            }
            case PB_OPT: 
            case PB_SAT: {
                instance = new PBInstanceReader((IPBSolver)theSolver);
                break;
            }
            case CNF_SAT: {
                instance = new InstanceReader(theSolver);
            }
        }
        instance.setUseMapping(true);
        return instance;
    }

    protected String getInstanceName(String[] args) {
        return this.filename;
    }

    protected ISolver configureSolver(String[] args) {
        Options options = Solvers.createCLIOptions();
        try {
            CommandLine cmd = new PosixParser().parse(options, args);
            this.isModeOptimization = cmd.hasOption("opt");
            this.filename = cmd.getOptionValue("f");
            boolean equivalence = cmd.hasOption("e");
            int others = 0;
            String[] rargs = cmd.getArgs();
            if (this.filename == null && rargs.length > 0) {
                this.filename = rargs[others++];
            }
            if (this.filename != null) {
                String unzipped = Solvers.uncompressed(this.filename);
                if (unzipped.endsWith(".cnf") && this.isModeOptimization) {
                    this.typeProbleme = ProblemType.CNF_MAXSAT;
                } else if (unzipped.endsWith(".wcnf")) {
                    this.typeProbleme = ProblemType.WCNF_MAXSAT;
                    this.isModeOptimization = true;
                } else {
                    this.typeProbleme = unzipped.endsWith(".opb") ? (this.isModeOptimization ? ProblemType.PB_OPT : ProblemType.PB_SAT) : ProblemType.CNF_SAT;
                }
            } else {
                this.typeProbleme = ProblemType.CNF_SAT;
            }
            ICDCL asolver = Solvers.configureSolver(args, this);
            this.launchRemoteControl = cmd.hasOption("remote");
            if (cmd.hasOption("m")) {
                this.setSilent(true);
            }
            if (cmd.hasOption("k")) {
                Integer n = Integer.valueOf(cmd.getOptionValue("k"));
            }
            if (cmd.hasOption("r")) {
                this.modeTracing = true;
                if (!cmd.hasOption("remote")) {
                    asolver.setSearchListener((SearchListener)new MultiTracing(new SearchListener[]{new ConflictLevelTracing((IVisualizationTool)new FileBasedVisualizationTool(this.filename + "-conflict-level"), (IVisualizationTool)new FileBasedVisualizationTool(this.filename + "-conflict-level-restart"), (IVisualizationTool)new FileBasedVisualizationTool(this.filename + "-conflict-level-clean")), new DecisionTracing((IVisualizationTool)new FileBasedVisualizationTool(this.filename + "-decision-indexes-pos"), (IVisualizationTool)new FileBasedVisualizationTool(this.filename + "-decision-indexes-neg"), (IVisualizationTool)new FileBasedVisualizationTool(this.filename + "-decision-indexes-restart"), (IVisualizationTool)new FileBasedVisualizationTool(this.filename + "-decision-indexes-clean")), new LearnedClausesSizeTracing((IVisualizationTool)new FileBasedVisualizationTool(this.filename + "-learned-clauses-size"), (IVisualizationTool)new FileBasedVisualizationTool(this.filename + "-learned-clauses-size-restart"), (IVisualizationTool)new FileBasedVisualizationTool(this.filename + "-learned-clauses-size-clean")), new ConflictDepthTracing((IVisualizationTool)new FileBasedVisualizationTool(this.filename + "-conflict-depth"), (IVisualizationTool)new FileBasedVisualizationTool(this.filename + "-conflict-depth-restart"), (IVisualizationTool)new FileBasedVisualizationTool(this.filename + "-conflict-depth-clean"))}));
                }
            }
            switch (this.typeProbleme) {
                case PB_OPT: {
                    this.setLauncherMode(ILauncherMode.OPTIMIZATION);
                    if (cmd.hasOption("lo")) {
                        this.problem = new ConstraintRelaxingPseudoOptDecorator((IPBSolver)asolver);
                        break;
                    }
                    this.problem = new PseudoOptDecorator((IPBSolver)asolver);
                    break;
                }
                case CNF_MAXSAT: 
                case WCNF_MAXSAT: {
                    this.setLauncherMode(ILauncherMode.OPTIMIZATION);
                    asolver = new WeightedMaxSatDecorator((IPBSolver)((IPBCDCLSolver)asolver), equivalence);
                    if (cmd.hasOption("lo")) {
                        this.problem = new ConstraintRelaxingPseudoOptDecorator((IPBSolver)((WeightedMaxSatDecorator)asolver));
                        break;
                    }
                    this.problem = new PseudoOptDecorator((IPBSolver)((WeightedMaxSatDecorator)asolver), false, false);
                    break;
                }
                default: {
                    this.setLauncherMode(ILauncherMode.DECISION);
                    this.problem = asolver;
                }
            }
            this.setIncomplete(cmd.hasOption("i"));
            this.setDisplaySolutionLine(!cmd.hasOption("n"));
            while (others < rargs.length) {
                String[] param = rargs[others].split("=");
                assert (param.length == 2);
                this.log("setting " + param[0] + " to " + param[1]);
                try {
                    BeanUtils.setProperty((Object)asolver, (String)param[0], (Object)param[1]);
                }
                catch (Exception e) {
                    this.log("Cannot set parameter : " + args[others]);
                }
                ++others;
            }
            if (asolver != null) {
                this.getLogWriter().println(asolver.toString("c "));
            }
            return asolver;
        }
        catch (ParseException e1) {
            HelpFormatter helpf = new HelpFormatter();
            helpf.printHelp("java -jar sat4j.jar", options, true);
            this.usage();
            System.exit(0);
            return null;
        }
    }

    public void run(String[] args) {
        block13: {
            try {
                String instanceName;
                this.displayHeader();
                this.solver = this.configureSolver(args);
                if (this.solver == null) {
                    this.usage();
                    System.exit(0);
                }
                if (!this.isSilent()) {
                    this.solver.setVerbose(true);
                }
                if ((instanceName = this.getInstanceName(args)) == null) {
                    this.usage();
                    System.exit(0);
                }
                this.beginTime = System.currentTimeMillis();
                if (!this.launchRemoteControl) {
                    this.readProblem(instanceName);
                    try {
                        if (this.problem != null) {
                            this.solve(this.problem);
                        } else {
                            this.solve((IProblem)this.solver);
                        }
                    }
                    catch (TimeoutException e) {
                        this.log("timeout");
                    }
                    System.exit(launcher.getExitCode().value());
                    break block13;
                }
                RemoteControlFrame frame = new RemoteControlFrame(this.filename, "", args);
                frame.activateTracing(this.modeTracing);
                frame.setOptimisationMode(this.isModeOptimization);
            }
            catch (FileNotFoundException e) {
                System.err.println("FATAL " + e.getLocalizedMessage());
            }
            catch (IOException e) {
                System.err.println("FATAL " + e.getLocalizedMessage());
            }
            catch (ContradictionException e) {
                this.getLauncherMode().setExitCode(ExitCode.UNSATISFIABLE);
                this.log("(trivial inconsistency)");
            }
            catch (ParseFormatException e) {
                System.err.println("FATAL " + e.getLocalizedMessage());
            }
        }
    }
}

