/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.sat;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import org.sat4j.minisat.core.IPhaseSelectionStrategy;
import org.sat4j.sat.CommandComponent;
import org.sat4j.sat.DetailedCommandPanel;
import org.sat4j.sat.RTSI;
import org.sat4j.sat.SolverController;

public class PhaseCommandComponent
extends CommandComponent {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger("org.sat4j.sat");
    private String currentPhaseSelectionStrategy;
    private JComboBox phaseList;
    private JLabel phaseListLabel;
    private static final String PHASE_STRATEGY = "Choose phase strategy :";
    private JButton phaseApplyButton;
    private static final String PHASE_APPLY = "Apply";
    private static final String PHASE_STRATEGY_CLASS = "org.sat4j.minisat.core.IPhaseSelectionStrategy";
    private static final String PHASE_PATH_SAT = "org.sat4j.minisat.orders";
    private SolverController solverController;

    public PhaseCommandComponent(String name, SolverController commandPanel, String initialPhaseStrategyName) {
        this.currentPhaseSelectionStrategy = initialPhaseStrategyName;
        this.solverController = commandPanel;
        this.setName(name);
        this.createPanel();
    }

    @Override
    public void createPanel() {
        this.createPhasePanel();
    }

    public void createPhasePanel() {
        this.setBorder(new CompoundBorder(new TitledBorder(null, this.getName(), 1, 2), DetailedCommandPanel.BORDER5));
        this.setLayout(new BorderLayout());
        JPanel tmpPanel1 = new JPanel();
        tmpPanel1.setLayout(new FlowLayout());
        this.phaseListLabel = new JLabel(PHASE_STRATEGY);
        this.phaseList = new JComboBox<Object>(this.getListOfPhaseStrategies().toArray());
        this.phaseList.setSelectedItem(this.currentPhaseSelectionStrategy);
        tmpPanel1.add(this.phaseListLabel);
        tmpPanel1.add(this.phaseList);
        this.phaseApplyButton = new JButton(PHASE_APPLY);
        this.phaseApplyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PhaseCommandComponent.this.hasClickedOnApplyPhase();
            }
        });
        JPanel tmpPanel2 = new JPanel();
        tmpPanel2.add(this.phaseApplyButton);
        this.add((Component)tmpPanel1, "Center");
        this.add((Component)tmpPanel2, "South");
    }

    public void hasClickedOnApplyPhase() {
        String phaseName;
        this.currentPhaseSelectionStrategy = phaseName = (String)this.phaseList.getSelectedItem();
        IPhaseSelectionStrategy phase = null;
        try {
            phase = (IPhaseSelectionStrategy)Class.forName("org.sat4j.minisat.orders." + phaseName).newInstance();
            phase.init(this.solverController.getNVar() + 1);
            this.solverController.setPhaseSelectionStrategy(phase);
        }
        catch (ClassNotFoundException e) {
            LOGGER.log(Level.INFO, "Invalid Phase Class error", e);
        }
        catch (IllegalAccessException e) {
            LOGGER.log(Level.INFO, "Invalid Phase Access error", e);
        }
        catch (InstantiationException e) {
            LOGGER.log(Level.INFO, "Invalid Phase Instanciation error", e);
        }
    }

    public void setPhasePanelEnabled(boolean enabled) {
        this.phaseList.setEnabled(enabled);
        this.phaseListLabel.setEnabled(enabled);
        this.phaseApplyButton.setEnabled(enabled);
        this.repaint();
    }

    public List<String> getListOfPhaseStrategies() {
        List<String> resultRTSI = RTSI.find(PHASE_STRATEGY_CLASS);
        ArrayList<String> finalResult = new ArrayList<String>();
        for (String s : resultRTSI) {
            if (s.contains("Remote")) continue;
            finalResult.add(s);
        }
        return finalResult;
    }

    public void setPhaseListSelectedItem(String name) {
        this.currentPhaseSelectionStrategy = name;
        this.phaseList.setSelectedItem(this.currentPhaseSelectionStrategy);
        this.repaint();
    }
}

