/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.sat;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;

public class RTSI {
    private static List<String> alreadySeenPckges;

    private RTSI() {
    }

    public static List<String> find(String tosubclassname, boolean fullname) {
        alreadySeenPckges = new ArrayList<String>();
        HashSet<String> v = new HashSet<String>();
        try {
            Package[] pcks;
            Class<?> tosubclass = Class.forName(tosubclassname);
            for (Package pck : pcks = Package.getPackages()) {
                Set<String> tmp = RTSI.find(pck.getName(), tosubclass, fullname);
                if (tmp == null) continue;
                v.addAll(tmp);
            }
        }
        catch (ClassNotFoundException ex) {
            System.err.println("Class " + tosubclassname + " not found!");
        }
        return new ArrayList<String>(v);
    }

    public static Set<String> find(String pckname, String tosubclassname, boolean fullname) {
        HashSet<String> v = new HashSet();
        try {
            Class<?> tosubclass = Class.forName(tosubclassname);
            v = RTSI.find(pckname, tosubclass, fullname);
        }
        catch (ClassNotFoundException ex) {
            System.err.println("Class " + tosubclassname + " not found!");
        }
        return v;
    }

    public static Set<String> find(String pckgname, Class<?> tosubclass, boolean fullname) {
        if (alreadySeenPckges.contains(pckgname)) {
            return new HashSet<String>();
        }
        alreadySeenPckges.add(pckgname);
        return RTSI.findnames(pckgname, tosubclass, fullname);
    }

    public static List<String> find(String tosubclassname) {
        return RTSI.find(tosubclassname, false);
    }

    public static Set<String> find(String pckname, String tosubclassname) {
        return RTSI.find(pckname, tosubclassname, false);
    }

    public static Set<String> find(String pckgname, Class<?> tosubclass) {
        return RTSI.find(pckgname, tosubclass, false);
    }

    public static Set<String> findnames(String pckgname, Class<?> tosubclass) {
        return RTSI.findnames(pckgname, tosubclass, false);
    }

    public static Set<String> findnames(String pckgname, Class<?> tosubclass, boolean fullname) {
        URL url;
        HashSet<String> v = new HashSet<String>();
        String name = pckgname;
        if (!name.startsWith("/")) {
            name = "/" + name;
        }
        if ((url = RTSI.class.getResource(name = name.replace('.', '/'))) == null) {
            return null;
        }
        File directory = new File(url.getFile());
        if (directory.exists()) {
            File[] dirs;
            String[] files;
            for (String file : files = directory.list()) {
                if (!file.endsWith(".class")) continue;
                String classname = file.substring(0, file.length() - 6);
                try {
                    Class<?> o = Class.forName(pckgname + "." + classname);
                    if (!tosubclass.isAssignableFrom(o) || o.isInterface() || Modifier.isAbstract(o.getModifiers())) continue;
                    if (fullname) {
                        v.add(pckgname + "." + classname);
                        continue;
                    }
                    v.add(classname);
                }
                catch (NoClassDefFoundError o) {
                }
                catch (ClassNotFoundException cnfex) {
                    System.err.println(cnfex);
                }
            }
            for (File dir : dirs = directory.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return new File(dir.getAbsolutePath() + "/" + name).isDirectory();
                }
            })) {
                String newName = pckgname + "." + dir.getName();
                Set<String> tmp = RTSI.find(newName, tosubclass, fullname);
                if (tmp == null) continue;
                v.addAll(tmp);
            }
        } else {
            try {
                JarURLConnection conn = (JarURLConnection)url.openConnection();
                String starts = conn.getEntryName();
                JarFile jfile = conn.getJarFile();
                Enumeration<JarEntry> e = jfile.entries();
                while (e.hasMoreElements()) {
                    ZipEntry entry = e.nextElement();
                    String entryname = entry.getName();
                    if (!entryname.startsWith(starts) || !entryname.endsWith(".class")) continue;
                    String classname = entryname.substring(0, entryname.length() - 6);
                    if (classname.startsWith("/")) {
                        classname = classname.substring(1);
                    }
                    classname = classname.replace('/', '.');
                    try {
                        Class<?> o = Class.forName(classname);
                        if (!tosubclass.isAssignableFrom(o) || o.isInterface() || Modifier.isAbstract(o.getModifiers())) continue;
                        if (fullname) {
                            v.add(classname);
                            continue;
                        }
                        v.add(classname.substring(classname.lastIndexOf(46) + 1));
                    }
                    catch (NoClassDefFoundError o) {
                    }
                    catch (ClassNotFoundException cnfex) {
                        System.err.print(cnfex);
                    }
                }
            }
            catch (IOException ioex) {
                System.err.println(ioex);
            }
        }
        return v;
    }

    public static void displayResultOfFind(String tosubclassname) {
        System.out.println(RTSI.find(tosubclassname));
    }

    public static void displayResultOfFind(String pckname, String tosubclassname) {
        System.out.println(RTSI.find(pckname, tosubclassname));
    }

    public static void displayResultOfFind(String pckgname, Class<?> tosubclass) {
        System.out.println(RTSI.findnames(pckgname, tosubclass));
    }

    public static void main(String[] args) {
        if (args.length == 2) {
            RTSI.displayResultOfFind(args[0], args[1]);
        } else if (args.length == 1) {
            RTSI.displayResultOfFind(args[0]);
        } else {
            System.out.println("Usage: java RTSI [<package>] <subclass>");
        }
    }
}

