/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.sat;

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import org.sat4j.sat.DetailedCommandPanel;
import org.sat4j.sat.visu.VisuPreferencesFrame;
import org.sat4j.specs.ILogAble;

public class RemoteControlFrame
extends JFrame
implements ILogAble {
    private static final long serialVersionUID = 1L;
    private JMenuItem activateTracing;
    private JRadioButtonMenuItem gnuplotBasedRadio;
    private JRadioButtonMenuItem jChartBasedRadio;
    private DetailedCommandPanel commandePanel;
    private String filename;
    private String ramdisk;
    private String[] args;
    private VisuPreferencesFrame visuFrame;
    private static final String ACTIVATE = "Activate Tracing";
    private static final String DEACTIVATE = "Deactivate Tracing";

    public RemoteControlFrame(String filename, String ramdisk, String[] args) {
        super("Remote Control");
        this.filename = filename;
        this.ramdisk = ramdisk;
        this.args = (String[])args.clone();
        JFrame.setDefaultLookAndFeelDecorated(true);
        this.createAndShowGUI();
    }

    public RemoteControlFrame(String filename, String ramdisk) {
        this(filename, ramdisk, new String[0]);
    }

    public RemoteControlFrame(String filename) {
        this(filename, "", new String[0]);
    }

    public RemoteControlFrame(String filename, String[] args) {
        this(filename, "", args);
    }

    public void reinitialiser() {
    }

    public void setActivateGnuplot(boolean b) {
        this.activateTracing.setSelected(b);
        this.activateTracing(b);
    }

    private void createAndShowGUI() {
        Container c = this.getContentPane();
        c.setLayout(new BorderLayout());
        this.createMenuBar();
        this.commandePanel = new DetailedCommandPanel(this.filename, this.ramdisk, this.args, this);
        this.commandePanel.setChartBased(true);
        this.commandePanel.activateGnuplotTracing(true);
        this.visuFrame = new VisuPreferencesFrame(this.commandePanel.getGnuplotPreferences());
        JScrollPane scrollPane = new JScrollPane(this.commandePanel);
        this.add(scrollPane);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                RemoteControlFrame.this.commandePanel.stopVisu();
                RemoteControlFrame.this.setVisible(false);
                RemoteControlFrame.this.dispose();
            }
        });
        this.pack();
        this.setVisible(true);
    }

    public void clickOnAboutSolver() {
        if (this.commandePanel.getSolver() != null) {
            JOptionPane.showMessageDialog(this, this.commandePanel.getSolver().toString());
        } else {
            JOptionPane.showMessageDialog(this, "No solver is running at the moment. Please start solver.");
        }
    }

    public void setActivateTracingEditableUnderCondition(boolean b) {
        if (this.activateTracing.getText().equals(ACTIVATE)) {
            this.activateTracing.setEnabled(b);
        }
    }

    public void setActivateTracingEditable(boolean b) {
        this.activateTracing.setEnabled(b);
    }

    public void setActivateRadioTracing(boolean activate) {
        this.gnuplotBasedRadio.setEnabled(activate);
        this.jChartBasedRadio.setEnabled(activate);
    }

    public void createMenuBar() {
        JMenuBar barreMenu = new JMenuBar();
        JMenu menu = new JMenu("File");
        barreMenu.add(menu);
        this.activateTracing = new JMenuItem(DEACTIVATE);
        menu.add(this.activateTracing);
        this.activateTracing.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RemoteControlFrame.this.activateTracing(RemoteControlFrame.this.activateTracing.getText().equals(RemoteControlFrame.ACTIVATE));
            }
        });
        menu.addSeparator();
        this.gnuplotBasedRadio = new JRadioButtonMenuItem("Trace with Gnuplot");
        this.jChartBasedRadio = new JRadioButtonMenuItem("Trace with Java");
        ButtonGroup visuGroup = new ButtonGroup();
        visuGroup.add(this.gnuplotBasedRadio);
        visuGroup.add(this.jChartBasedRadio);
        menu.add(this.gnuplotBasedRadio);
        this.gnuplotBasedRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RemoteControlFrame.this.commandePanel.setGnuplotBased(true);
                RemoteControlFrame.this.commandePanel.setChartBased(false);
                RemoteControlFrame.this.commandePanel.activateGnuplotTracing(RemoteControlFrame.this.activateTracing.getText().equals(RemoteControlFrame.DEACTIVATE));
                RemoteControlFrame.this.log("Use gnuplot tracing");
            }
        });
        this.jChartBasedRadio.setSelected(true);
        menu.add(this.jChartBasedRadio);
        this.jChartBasedRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RemoteControlFrame.this.commandePanel.setGnuplotBased(false);
                RemoteControlFrame.this.commandePanel.setChartBased(true);
                RemoteControlFrame.this.commandePanel.activateGnuplotTracing(RemoteControlFrame.this.activateTracing.getText().equals(RemoteControlFrame.DEACTIVATE));
                RemoteControlFrame.this.log("Use java tracing");
            }
        });
        menu.addSeparator();
        JMenuItem quit = new JMenuItem("Exit");
        menu.add(quit);
        quit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RemoteControlFrame.this.commandePanel.stopVisu();
                System.exit(0);
            }
        });
        JMenu preferences = new JMenu("Preferences");
        JMenuItem gnuplotPreferencesItem = new JMenuItem("Visualisation preferences");
        gnuplotPreferencesItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RemoteControlFrame.this.visuFrame.setVisible(true);
            }
        });
        preferences.add(gnuplotPreferencesItem);
        barreMenu.add(preferences);
        barreMenu.add(Box.createHorizontalGlue());
        JLabel version = new JLabel(this.getVersion());
        barreMenu.add(version);
        this.setJMenuBar(barreMenu);
    }

    public void log(String message) {
        this.commandePanel.log(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getVersion() {
        URL url = RemoteControlFrame.class.getResource("/sat4j.version");
        String s = "";
        if (url == null) {
            s = "no version file found!!!";
        } else {
            BufferedReader in = null;
            try {
                in = new BufferedReader(new InputStreamReader(url.openStream()));
                s = "version " + in.readLine();
            }
            catch (IOException e) {
                s = "c ERROR: " + e.getMessage();
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        s = "c ERROR: " + e.getMessage();
                    }
                }
            }
        }
        return s;
    }

    public void activateTracing(boolean b) {
        if (b) {
            this.log("Activated tracing");
            this.activateTracing.setText(DEACTIVATE);
            this.commandePanel.setPlotActivated(true);
        } else {
            this.log("Deactivated tracing.");
            this.activateTracing.setText(ACTIVATE);
            this.commandePanel.stopVisu();
            this.commandePanel.setPlotActivated(false);
        }
        if (this.commandePanel.getStartStopText().equals("Stop") && this.activateTracing.getText().equals(ACTIVATE)) {
            this.activateTracing.setEnabled(false);
        } else {
            this.activateTracing.setEnabled(true);
        }
    }

    public void setOptimisationMode(boolean optimizationMode) {
        this.commandePanel.setOptimisationMode(optimizationMode);
    }
}

