/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.sat;

import org.sat4j.minisat.core.ICDCL;
import org.sat4j.minisat.core.IPhaseSelectionStrategy;
import org.sat4j.minisat.core.RestartStrategy;
import org.sat4j.minisat.core.SearchParams;
import org.sat4j.minisat.core.SolverStats;
import org.sat4j.minisat.orders.RSATPhaseSelectionStrategy;
import org.sat4j.minisat.restarts.NoRestarts;
import org.sat4j.specs.Constr;
import org.sat4j.specs.ILogAble;

public class RemoteControlStrategy
implements RestartStrategy,
IPhaseSelectionStrategy {
    private static final int SLEEP_TIME = 1000;
    private static final long serialVersionUID = 1L;
    private RestartStrategy restart = new NoRestarts();
    private IPhaseSelectionStrategy phaseSelectionStrategy = new RSATPhaseSelectionStrategy();
    private ILogAble logger;
    private boolean isInterrupted;
    private boolean hasClickedOnRestart = false;
    private boolean hasClickedOnClean = false;
    private int conflictNumber;
    private int nbClausesAtWhichWeShouldClean;
    private boolean useTelecomStrategyAsLearnedConstraintsDeletionStrategy;
    private ICDCL<?> solver;

    public RemoteControlStrategy(ILogAble log) {
        this.logger = log;
        this.isInterrupted = false;
        this.useTelecomStrategyAsLearnedConstraintsDeletionStrategy = false;
    }

    public RemoteControlStrategy() {
        this(null);
    }

    public boolean isHasClickedOnRestart() {
        return this.hasClickedOnRestart;
    }

    public void setHasClickedOnRestart(boolean hasClickedOnRestart) {
        this.hasClickedOnRestart = hasClickedOnRestart;
    }

    public boolean isHasClickedOnClean() {
        return this.hasClickedOnClean;
    }

    public void setHasClickedOnClean(boolean hasClickedOnClean) {
        this.hasClickedOnClean = hasClickedOnClean;
        this.clickedOnClean();
    }

    public boolean isUseTelecomStrategyAsLearnedConstraintsDeletionStrategy() {
        return this.useTelecomStrategyAsLearnedConstraintsDeletionStrategy;
    }

    public void setUseTelecomStrategyAsLearnedConstraintsDeletionStrategy(boolean useTelecomStrategyAsLearnedConstraintsDeletionStrategy) {
        this.useTelecomStrategyAsLearnedConstraintsDeletionStrategy = useTelecomStrategyAsLearnedConstraintsDeletionStrategy;
    }

    public void clickedOnClean() {
        if (this.hasClickedOnClean) {
            this.solver.setNeedToReduceDB(true);
            this.hasClickedOnClean = false;
        }
    }

    public RestartStrategy getRestartStrategy() {
        return this.restart;
    }

    public IPhaseSelectionStrategy getPhaseSelectionStrategy() {
        return this.phaseSelectionStrategy;
    }

    public void setPhaseSelectionStrategy(IPhaseSelectionStrategy phaseSelectionStrategy) {
        this.phaseSelectionStrategy = phaseSelectionStrategy;
    }

    public void setRestartStrategy(RestartStrategy restart) {
        this.restart = restart;
    }

    public int getNbClausesAtWhichWeShouldClean() {
        return this.nbClausesAtWhichWeShouldClean;
    }

    public void setNbClausesAtWhichWeShouldClean(int nbClausesAtWhichWeShouldClean) {
        this.nbClausesAtWhichWeShouldClean = nbClausesAtWhichWeShouldClean;
    }

    public ILogAble getLogger() {
        return this.logger;
    }

    public void setLogger(ILogAble logger) {
        this.logger = logger;
    }

    public void init(SearchParams params, SolverStats stats) {
        this.restart.init(params, stats);
    }

    @Deprecated
    public long nextRestartNumberOfConflict() {
        return this.restart.nextRestartNumberOfConflict();
    }

    public boolean shouldRestart() {
        if (this.hasClickedOnRestart) {
            this.hasClickedOnRestart = false;
            this.logger.log("Told the solver to restart");
            return true;
        }
        return this.restart.shouldRestart();
    }

    public void onRestart() {
        this.restart.onRestart();
    }

    public void onBackjumpToRootLevel() {
        this.restart.onBackjumpToRootLevel();
    }

    public SearchParams getSearchParams() {
        return this.solver.getSearchParams();
    }

    public SolverStats getSolverStats() {
        return this.solver.getStats();
    }

    public ICDCL<?> getSolver() {
        return this.solver;
    }

    public void setSolver(ICDCL<?> solver) {
        this.solver = solver;
    }

    public void reset() {
        this.restart.newConflict();
    }

    public void newConflict() {
        this.restart.newConflict();
        ++this.conflictNumber;
        if (this.useTelecomStrategyAsLearnedConstraintsDeletionStrategy && this.conflictNumber > this.nbClausesAtWhichWeShouldClean) {
            this.conflictNumber = 0;
            this.solver.setNeedToReduceDB(true);
        }
    }

    public void updateVar(int p) {
        this.phaseSelectionStrategy.updateVar(p);
    }

    public void init(int nlength) {
        this.phaseSelectionStrategy.init(nlength);
    }

    public void init(int var, int p) {
        this.phaseSelectionStrategy.init(var, p);
    }

    public void assignLiteral(int p) {
        while (this.isInterrupted) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                this.logger.log(e.getMessage());
                Thread.currentThread().interrupt();
            }
        }
        this.phaseSelectionStrategy.assignLiteral(p);
    }

    public int select(int var) {
        return this.phaseSelectionStrategy.select(var);
    }

    public void updateVarAtDecisionLevel(int q) {
        this.phaseSelectionStrategy.updateVarAtDecisionLevel(q);
    }

    public String toString() {
        return "RemoteControlStrategy [restartStrategy = " + this.restart + ", learnedClausesDeletionStrategy = clean after " + this.nbClausesAtWhichWeShouldClean + " conflicts, phaseSelectionStrategy = " + this.phaseSelectionStrategy + "]";
    }

    public void setInterrupted(boolean b) {
        this.isInterrupted = b;
        if (this.isInterrupted) {
            this.logger.log("Solver paused");
        } else {
            this.logger.log("Resume solving");
        }
    }

    public void newLearnedClause(Constr learned, int trailLevel) {
        this.restart.newLearnedClause(learned, trailLevel);
    }
}

