/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.sat.visu;

import java.awt.Color;
import org.sat4j.sat.visu.GnuplotDataFile;
import org.sat4j.sat.visu.GnuplotFunction;

public class VisuPreferences {
    private static final int DEFAULT_TIME_BEFORE_LAUNCHING = 8000;
    private static final int DEFAULT_REFRESH_TIME = 500;
    private static final int DEFAULT_LINES_READ = 11000;
    private static final String AXIS_X1Y1 = "\" axis x1y1";
    private static final String TITLE = "\" title \"";
    private static final String LC_RGB = " lc rgb \"#";
    private Color backgroundColor = Color.white;
    private Color borderColor = Color.black;
    private int timeBeforeLaunching = 8000;
    private int refreshTime = 500;
    private int nbLinesRead = 11000;
    private boolean displayRestarts = true;
    private Color restartColor = Color.LIGHT_GRAY;
    private boolean slidingWindows = true;
    private boolean displayDecisionIndexes = true;
    private boolean displaySpeed = false;
    private boolean displayConflictsTrail = true;
    private boolean displayConflictsDecision = true;
    private boolean displayVariablesEvaluation = false;
    private boolean displayClausesEvaluation = true;
    private boolean displayClausesSize = true;

    public boolean isDisplayClausesSize() {
        return this.displayClausesSize;
    }

    public void setDisplayClausesSize(boolean displayClausesSize) {
        this.displayClausesSize = displayClausesSize;
    }

    public int getNumberOfDisplayedGraphs() {
        int n = 0;
        if (this.displayClausesEvaluation) {
            ++n;
        }
        if (this.displayConflictsTrail) {
            ++n;
        }
        if (this.displayConflictsDecision) {
            ++n;
        }
        if (this.displayDecisionIndexes) {
            n += 2;
        }
        if (this.displaySpeed) {
            ++n;
        }
        if (this.displayVariablesEvaluation) {
            ++n;
        }
        if (this.displayClausesSize) {
            ++n;
        }
        return n;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color borderColor) {
        this.borderColor = borderColor;
    }

    public int getTimeBeforeLaunching() {
        return this.timeBeforeLaunching;
    }

    public void setTimeBeforeLaunching(int timeBeforeLaunching) {
        this.timeBeforeLaunching = timeBeforeLaunching;
    }

    public int getRefreshTime() {
        return this.refreshTime;
    }

    public void setRefreshTime(int refreshTime) {
        this.refreshTime = refreshTime;
    }

    public int getNbLinesRead() {
        return this.nbLinesRead;
    }

    public void setNbLinesRead(int nbLinesRead) {
        this.nbLinesRead = nbLinesRead;
    }

    public boolean isDisplayRestarts() {
        return this.displayRestarts;
    }

    public void setDisplayRestarts(boolean displayRestarts) {
        this.displayRestarts = displayRestarts;
    }

    public Color getRestartColor() {
        return this.restartColor;
    }

    public void setRestartColor(Color restartColor) {
        this.restartColor = restartColor;
    }

    public boolean isSlidingWindows() {
        return this.slidingWindows;
    }

    public void setSlidingWindows(boolean slidingWindows) {
        this.slidingWindows = slidingWindows;
    }

    public boolean isDisplayDecisionIndexes() {
        return this.displayDecisionIndexes;
    }

    public void setDisplayDecisionIndexes(boolean displayDecisionIndexes) {
        this.displayDecisionIndexes = displayDecisionIndexes;
    }

    public boolean isDisplaySpeed() {
        return this.displaySpeed;
    }

    public void setDisplaySpeed(boolean displaySpeed) {
        this.displaySpeed = displaySpeed;
    }

    public boolean isDisplayConflictsTrail() {
        return this.displayConflictsTrail;
    }

    public void setDisplayConflictsTrail(boolean displayConflictsTrail) {
        this.displayConflictsTrail = displayConflictsTrail;
    }

    public boolean isDisplayConflictsDecision() {
        return this.displayConflictsDecision;
    }

    public void setDisplayConflictsDecision(boolean displayConflictsDecision) {
        this.displayConflictsDecision = displayConflictsDecision;
    }

    public boolean isDisplayVariablesEvaluation() {
        return this.displayVariablesEvaluation;
    }

    public void setDisplayVariablesEvaluation(boolean displayVariablesEvaluation) {
        this.displayVariablesEvaluation = displayVariablesEvaluation;
    }

    public boolean isDisplayClausesEvaluation() {
        return this.displayClausesEvaluation;
    }

    public void setDisplayClausesEvaluation(boolean displayClausesEvaluation) {
        this.displayClausesEvaluation = displayClausesEvaluation;
    }

    public String toString() {
        return "GnuplotPreferences [backgroundColor=" + this.backgroundColor + ", borderColor=" + this.borderColor + ", timeBeforeLaunching=" + this.timeBeforeLaunching + ", refreshTime=" + this.refreshTime + ", slidingWindows=" + this.slidingWindows + ", nbLinesRead=" + this.nbLinesRead + ", displayRestarts=" + this.displayRestarts + "]";
    }

    public String[] createCommandLine(String gnuplotFilename) {
        String rgb = Integer.toHexString(this.backgroundColor.getRGB());
        rgb = rgb.substring(2, rgb.length());
        String rgbBorder = Integer.toHexString(this.borderColor.getRGB());
        rgbBorder = rgbBorder.substring(2, rgbBorder.length());
        String[] cmd = new String[]{"gnuplot", "-bg", "#" + rgb, "-xrm", "gnuplot*borderColor:#" + rgbBorder, gnuplotFilename};
        return cmd;
    }

    public String generatePlotLine(GnuplotDataFile file, boolean slidingThisWindow) {
        return this.generatePlotLine(new GnuplotDataFile[]{file}, "", slidingThisWindow);
    }

    public String generatePlotLine(GnuplotDataFile file) {
        return this.generatePlotLine(new GnuplotDataFile[]{file}, "", this.slidingWindows);
    }

    public String generatePlotLine(GnuplotDataFile file, String restartFile) {
        return this.generatePlotLine(new GnuplotDataFile[]{file}, restartFile, this.slidingWindows);
    }

    public String generatePlotLine(GnuplotDataFile file, String restartFile, boolean slidingThisWindows) {
        return this.generatePlotLine(new GnuplotDataFile[]{file}, restartFile, slidingThisWindows);
    }

    public String generatePlotLine(GnuplotDataFile file, String restartFile, boolean slidingThisWindows, int nbLinesToShow) {
        return this.generatePlotLine(new GnuplotDataFile[]{file}, new GnuplotFunction[0], restartFile, slidingThisWindows, nbLinesToShow);
    }

    public String generatePlotLine(GnuplotDataFile[] dataFilesArray, String restartFileName, boolean slidingThisWindows) {
        return this.generatePlotLine(dataFilesArray, new GnuplotFunction[0], restartFileName, slidingThisWindows);
    }

    public String generatePlotLine(GnuplotDataFile file, GnuplotFunction function, String restartFile, boolean slidingThisWindows, int nbLinesToShow) {
        return this.generatePlotLine(new GnuplotDataFile[]{file}, new GnuplotFunction[]{function}, restartFile, slidingThisWindows, nbLinesToShow);
    }

    public String generatePlotLine(GnuplotDataFile dataFile, GnuplotFunction function, String restartFileName, boolean slidingThisWindows) {
        return this.generatePlotLine(new GnuplotDataFile[]{dataFile}, new GnuplotFunction[]{function}, restartFileName, slidingThisWindows);
    }

    public String generatePlotLine(GnuplotDataFile[] dataFilesArray, GnuplotFunction[] functions, String restartFileName, boolean slidingThisWindows) {
        return this.generatePlotLine(dataFilesArray, functions, restartFileName, slidingThisWindows, this.nbLinesRead);
    }

    public String generatePlotLine(GnuplotDataFile[] dataFilesArray, GnuplotFunction[] functions, String restartFileName, boolean slidingThisWindows, int nbLinesTosShow) {
        String comma;
        String rgb;
        int i;
        boolean useRestart;
        String result = restartFileName.length() == 0 ? "if(system(\"head " + dataFilesArray[0].getFilename() + " | wc -l\")!=0){" : "if(system(\"head " + dataFilesArray[0].getFilename() + " | wc -l\")!=0 && system(\"head " + restartFileName + " | wc -l\")!=0){";
        StringBuilder buf = new StringBuilder();
        buf.append("plot");
        String tailString = "";
        if (this.slidingWindows && slidingThisWindows) {
            tailString = "< tail -" + nbLinesTosShow + " ";
        }
        boolean bl = useRestart = this.displayRestarts && restartFileName.length() > 0;
        if (useRestart) {
            String rgb2 = Integer.toHexString(this.restartColor.getRGB());
            rgb2 = rgb2.substring(2, rgb2.length());
            String restartString = "\"" + tailString + restartFileName + "\" with impulses lc rgb \"#" + rgb2 + "\" title \"Restart\" axis x1y2";
            buf.append(restartString);
        }
        for (i = 0; i < dataFilesArray.length; ++i) {
            rgb = Integer.toHexString(dataFilesArray[i].getColor().getRGB());
            rgb = rgb.substring(2, rgb.length());
            comma = "";
            if (useRestart || i != 0) {
                comma = ",";
            }
            String style = "";
            if (dataFilesArray[i].getStyle().length() > 0) {
                style = " with " + dataFilesArray[i].getStyle();
            }
            buf.append(comma + "\"" + tailString + dataFilesArray[i].getFilename() + "\"" + style + LC_RGB + rgb + TITLE + dataFilesArray[i].getTitle() + AXIS_X1Y1);
        }
        for (i = 0; i < functions.length; ++i) {
            rgb = Integer.toHexString(functions[i].getColor().getRGB());
            rgb = rgb.substring(2, rgb.length());
            comma = "";
            if (dataFilesArray.length > 0 || useRestart || i != 0) {
                comma = ",";
            }
            buf.append(comma + functions[i].getFunctionExpression() + LC_RGB + rgb + TITLE + functions[i].getFunctionLegend() + AXIS_X1Y1);
        }
        result = result + buf.toString() + "}";
        return result;
    }

    public String generatePlotLineOnDifferenteAxes(GnuplotDataFile[] dfArray1, GnuplotDataFile[] dfArray2, boolean slidingThisWindow) {
        return this.generatePlotLineOnDifferenteAxes(dfArray1, dfArray2, slidingThisWindow, this.nbLinesRead);
    }

    public String generatePlotLineOnDifferenteAxes(GnuplotDataFile[] dfArray1, GnuplotDataFile[] dfArray2, boolean slidingThisWindow, int nbLines) {
        return this.generatePlotLineOnDifferenteAxes(dfArray1, dfArray2, new GnuplotFunction[0], slidingThisWindow, nbLines);
    }

    public String generatePlotLineOnDifferenteAxes(GnuplotDataFile[] dfArray1, GnuplotDataFile[] dfArray2, GnuplotFunction[] functions, boolean slidingThisWindow) {
        return this.generatePlotLineOnDifferenteAxes(dfArray1, dfArray2, new GnuplotFunction[0], slidingThisWindow, this.nbLinesRead);
    }

    public String generatePlotLineOnDifferenteAxes(GnuplotDataFile[] dfArray1, GnuplotDataFile[] dfArray2, GnuplotFunction[] functions, boolean slidingThisWindows, int nbLines) {
        String style;
        String comma;
        String rgb;
        int i;
        StringBuilder buf = new StringBuilder();
        buf.append("plot ");
        String tailString = "";
        if (this.slidingWindows && slidingThisWindows) {
            tailString = "< tail -" + nbLines + " ";
        }
        for (i = 0; i < dfArray2.length; ++i) {
            rgb = Integer.toHexString(dfArray2[i].getColor().getRGB());
            rgb = rgb.substring(2, rgb.length());
            comma = "";
            if (i != 0) {
                comma = ",";
            }
            style = "";
            if (dfArray2[i].getStyle().length() > 0) {
                style = " with " + dfArray2[i].getStyle();
            }
            buf.append(comma + "\"" + tailString + dfArray2[i].getFilename() + "\"" + style + LC_RGB + rgb + TITLE + dfArray2[i].getTitle() + "\" axis x1y2");
        }
        for (i = 0; i < dfArray1.length; ++i) {
            rgb = Integer.toHexString(dfArray1[i].getColor().getRGB());
            rgb = rgb.substring(2, rgb.length());
            comma = "";
            if (dfArray2.length > 0 || i != 0) {
                comma = ",";
            }
            style = "";
            if (dfArray1[i].getStyle().length() > 0) {
                style = " with " + dfArray1[i].getStyle();
            }
            buf.append(comma + "\"" + tailString + dfArray1[i].getFilename() + "\"" + style + LC_RGB + rgb + TITLE + dfArray1[i].getTitle() + AXIS_X1Y1);
        }
        for (i = 0; i < functions.length; ++i) {
            rgb = Integer.toHexString(functions[i].getColor().getRGB());
            rgb = rgb.substring(2, rgb.length());
            comma = "";
            if (dfArray1.length > 0 || dfArray2.length > 0 || i != 0) {
                comma = ",";
            }
            buf.append(comma + functions[i].getFunctionExpression() + LC_RGB + rgb + TITLE + functions[i].getFunctionLegend() + AXIS_X1Y1);
        }
        return buf.toString();
    }
}

