/*
 * Decompiled with CFR 0.152.
 */
package org.nocrala.tools.texttablefmt;

import java.util.List;
import org.apache.log4j.Logger;
import org.nocrala.tools.texttablefmt.BorderStyle;
import org.nocrala.tools.texttablefmt.Column;
import org.nocrala.tools.texttablefmt.Row;
import org.nocrala.tools.utils.Filler;

public class ShownBorders {
    private static Logger logger = Logger.getLogger(ShownBorders.class);
    public static final ShownBorders NONE = new ShownBorders("..........");
    public static final ShownBorders HEADER_ONLY = new ShownBorders("t...t.....");
    public static final ShownBorders HEADER_AND_FOOTER = new ShownBorders("t.t.......");
    public static final ShownBorders HEADER_FOOTER_AND_COLUMNS = new ShownBorders("t.tttt....");
    public static final ShownBorders HEADER_AND_FIRST_COLLUMN = new ShownBorders("t..t......");
    public static final ShownBorders HEADER_FIRST_AND_LAST_COLLUMN = new ShownBorders("t..t.t....");
    public static final ShownBorders HEADER_FOOTER_AND_FIRST_COLLUMN = new ShownBorders("t.tt......");
    public static final ShownBorders HEADER_FOOTER_FIRST_AND_LAST_COLLUMN = new ShownBorders("t.tt.t....");
    public static final ShownBorders HEADER_AND_COLUMNS = new ShownBorders("t..ttt....");
    public static final ShownBorders SURROUND_HEADER_AND_COLUMNS = new ShownBorders("t..ttttttt");
    public static final ShownBorders SURROUND_HEADER_FOOTER_AND_COLUMNS = new ShownBorders("t.tttttttt");
    public static final ShownBorders SURROUND = new ShownBorders("......tttt");
    public static final ShownBorders ALL = new ShownBorders("tttttttttt");
    private boolean headerSeparator;
    private boolean middleSeparator;
    private boolean footerSeparator;
    private boolean leftSeparator;
    private boolean centerSeparator;
    private boolean rightSeparator;
    private boolean topBorder;
    private boolean bottomBorder;
    private boolean leftBorder;
    private boolean rightBorder;

    public ShownBorders(boolean headerSeparator, boolean middleSeparator, boolean footerSeparator, boolean leftSeparator, boolean centerSeparator, boolean rightSeparator, boolean topBorder, boolean bottomBorder, boolean leftBorder, boolean rightBorder) {
        this.headerSeparator = headerSeparator;
        this.middleSeparator = middleSeparator;
        this.footerSeparator = footerSeparator;
        this.leftSeparator = leftSeparator;
        this.centerSeparator = centerSeparator;
        this.rightSeparator = rightSeparator;
        this.topBorder = topBorder;
        this.bottomBorder = bottomBorder;
        this.leftBorder = leftBorder;
        this.rightBorder = rightBorder;
    }

    public ShownBorders(String separatorsAndBordersToRender) {
        this.headerSeparator = this.get(separatorsAndBordersToRender, 0);
        this.middleSeparator = this.get(separatorsAndBordersToRender, 1);
        this.footerSeparator = this.get(separatorsAndBordersToRender, 2);
        this.leftSeparator = this.get(separatorsAndBordersToRender, 3);
        this.centerSeparator = this.get(separatorsAndBordersToRender, 4);
        this.rightSeparator = this.get(separatorsAndBordersToRender, 5);
        this.topBorder = this.get(separatorsAndBordersToRender, 6);
        this.bottomBorder = this.get(separatorsAndBordersToRender, 7);
        this.leftBorder = this.get(separatorsAndBordersToRender, 8);
        this.rightBorder = this.get(separatorsAndBordersToRender, 9);
    }

    private boolean get(String flags, int index) {
        if (flags == null) {
            return false;
        }
        if (index < 0 || index > flags.length()) {
            return false;
        }
        return "t".equalsIgnoreCase(flags.substring(index, index + 1));
    }

    String renderTopBorder(List<Column> columns, BorderStyle tiles, Row lowerRow) {
        return this.renderHorizontalSeparator(columns, tiles.getTLCorner(), tiles.getTCCorner(), tiles.getTRCorner(), tiles.getTop(), null, lowerRow, null, tiles.getTCCorner(), tiles.getCenterWidth());
    }

    String renderMiddleSeparator(List<Column> columns, BorderStyle tiles, Row upperRow, Row lowerRow) {
        return this.renderHorizontalSeparator(columns, tiles.getMLCorner(), tiles.getMCCorner(), tiles.getMRCorner(), tiles.getMiddle(), upperRow, lowerRow, tiles.getUpperColSpan(), tiles.getLowerColSpan(), tiles.getCenterWidth());
    }

    String renderBottomBorder(List<Column> columns, BorderStyle tiles, Row upperRow) {
        return this.renderHorizontalSeparator(columns, tiles.getBLCorner(), tiles.getBCCorner(), tiles.getBRCorner(), tiles.getBottom(), upperRow, null, tiles.getBCCorner(), null, tiles.getCenterWidth());
    }

    private String renderHorizontalSeparator(List<Column> columns, String left, String cross, String right, String horizontal, Row upperRow, Row lowerRow, String upperColSpan, String lowerColSpan, int centerWidth) {
        StringBuffer sb = new StringBuffer();
        if (this.showLeftBorder()) {
            sb.append(left);
        }
        int totalColumns = columns.size();
        for (int j = 0; j < totalColumns; ++j) {
            boolean upperSep = upperRow != null ? upperRow.hasSeparator(j) : false;
            boolean lowerSep = lowerRow != null ? lowerRow.hasSeparator(j) : false;
            logger.debug((Object)("upperSep=" + upperSep + " lowerSep=" + lowerSep + " centerWidth=" + centerWidth));
            if (j != 0 && (j > 1 && j < totalColumns - 1 && this.showCenterSeparator() || j == 1 && this.showLeftSeparator() || j == totalColumns - 1 && this.showRightSeparator())) {
                if (upperSep) {
                    if (lowerSep) {
                        sb.append(cross);
                    } else {
                        sb.append(upperColSpan);
                    }
                } else if (lowerSep) {
                    sb.append(lowerColSpan);
                } else {
                    logger.debug((Object)("centerWidth=" + centerWidth));
                    for (int i = 0; i < centerWidth; ++i) {
                        sb.append(horizontal);
                    }
                }
            }
            Column col = columns.get(j);
            sb.append(Filler.getFiller(horizontal, col.getColumnWidth()));
        }
        if (this.showRightBorder()) {
            sb.append(right);
        }
        return sb.toString();
    }

    boolean showBottomBorder() {
        return this.bottomBorder;
    }

    boolean showCenterSeparator() {
        return this.centerSeparator;
    }

    boolean showFooterSeparator() {
        return this.footerSeparator;
    }

    boolean showHeaderSeparator() {
        return this.headerSeparator;
    }

    boolean showLeftBorder() {
        return this.leftBorder;
    }

    boolean showLeftSeparator() {
        return this.leftSeparator;
    }

    boolean showMiddleSeparator() {
        return this.middleSeparator;
    }

    boolean showRightBorder() {
        return this.rightBorder;
    }

    boolean showRightSeparator() {
        return this.rightSeparator;
    }

    boolean showTopBorder() {
        return this.topBorder;
    }
}

