/**
 * OW2 Specifications
 * Copyright (C) 2007 Bull S.A.S.
 * Contact: easybeans@objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: TransactionRolledbackException.java 6166 2012-02-09 14:18:49Z sauthieg $
 * --------------------------------------------------------------------------
 */

package javax.transaction;

import java.rmi.RemoteException;
 
/**
 * This exception indicates that the transaction associated with
 * processing of the request has been rolled back, or it has been
 * marked to roll back. Thus the requested operation either could
 * not be performed or was not performed because further computation
 * on behalf of the transaction would be fruitless.
 * @author Guillaume Sauthier
 */
public class TransactionRolledbackException extends RemoteException {

    /**
     * Serial Version UID.
     * TODO Check for interop
     */
    private static final long serialVersionUID = -3142798139623020577L;

    /**
     * Creates a new TransactionRolledbackException.
     */
    public TransactionRolledbackException() {
        super();
    }

    /**
     * Creates a new TransactionRolledbackException.
     * @param msg Exception message
     */
    public TransactionRolledbackException(String msg) {
        super(msg);
    }
}
