/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.csrfguard;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.owasp.csrfguard.CsrfGuardException;
import org.owasp.csrfguard.action.IAction;
import org.owasp.csrfguard.log.ILogger;
import org.owasp.csrfguard.log.LogLevel;
import org.owasp.csrfguard.util.RandomGenerator;
import org.owasp.csrfguard.util.Streams;
import org.owasp.csrfguard.util.Writers;

public final class CsrfGuard {
    public static final String PAGE_TOKENS_KEY = "Owasp_CsrfGuard_Pages_Tokens_Key";
    private static final String ACTION_PREFIX = "org.owasp.csrfguard.action.";
    private static final String PROTECTED_PAGE_PREFIX = "org.owasp.csrfguard.protected.";
    private static final String UNPROTECTED_PAGE_PREFIX = "org.owasp.csrfguard.unprotected.";
    private ILogger logger = null;
    private String tokenName = null;
    private int tokenLength = -1;
    private boolean rotate = false;
    private boolean tokenPerPage = false;
    private boolean tokenPerPagePrecreate;
    private SecureRandom prng = null;
    private String newTokenLandingPage = null;
    private boolean useNewTokenLandingPage = false;
    private boolean ajax = false;
    private boolean protect = false;
    private String sessionKey = null;
    private Set<String> protectedPages = null;
    private Set<String> unprotectedPages = null;
    private Set<String> protectedMethods = null;
    private List<IAction> actions = new ArrayList<IAction>();

    public static CsrfGuard getInstance() {
        return SingletonHolder.instance;
    }

    public static void load(Properties properties) throws NoSuchAlgorithmException, InstantiationException, IllegalAccessException, ClassNotFoundException, IOException, NoSuchProviderException {
        IAction action;
        String directive;
        int index;
        String key;
        CsrfGuard csrfGuard = SingletonHolder.instance;
        csrfGuard.setLogger((ILogger)Class.forName(properties.getProperty("org.owasp.csrfguard.Logger", "org.owasp.csrfguard.log.ConsoleLogger")).newInstance());
        csrfGuard.setTokenName(properties.getProperty("org.owasp.csrfguard.TokenName", "OWASP_CSRFGUARD"));
        csrfGuard.setTokenLength(Integer.parseInt(properties.getProperty("org.owasp.csrfguard.TokenLength", "32")));
        csrfGuard.setRotate(Boolean.valueOf(properties.getProperty("org.owasp.csrfguard.Rotate", "false")));
        csrfGuard.setTokenPerPage(Boolean.valueOf(properties.getProperty("org.owasp.csrfguard.TokenPerPage", "false")));
        csrfGuard.setTokenPerPagePrecreate(Boolean.valueOf(properties.getProperty("org.owasp.csrfguard.TokenPerPagePrecreate", "false")));
        csrfGuard.setPrng(SecureRandom.getInstance(properties.getProperty("org.owasp.csrfguard.PRNG", "SHA1PRNG"), properties.getProperty("org.owasp.csrfguard.PRNG.Provider", "SUN")));
        csrfGuard.setNewTokenLandingPage(properties.getProperty("org.owasp.csrfguard.NewTokenLandingPage"));
        if (csrfGuard.getNewTokenLandingPage() == null) {
            csrfGuard.setUseNewTokenLandingPage(Boolean.valueOf(properties.getProperty("org.owasp.csrfguard.UseNewTokenLandingPage", "false")));
        } else {
            csrfGuard.setUseNewTokenLandingPage(Boolean.valueOf(properties.getProperty("org.owasp.csrfguard.UseNewTokenLandingPage", "true")));
        }
        csrfGuard.setSessionKey(properties.getProperty("org.owasp.csrfguard.SessionKey", "OWASP_CSRFGUARD_KEY"));
        csrfGuard.setAjax(Boolean.valueOf(properties.getProperty("org.owasp.csrfguard.Ajax", "false")));
        csrfGuard.setProtect(Boolean.valueOf(properties.getProperty("org.owasp.csrfguard.Protect", "false")));
        HashMap<String, IAction> actionsMap = new HashMap<String, IAction>();
        for (Object obj : properties.keySet()) {
            key = (String)obj;
            if (!key.startsWith(ACTION_PREFIX) || (index = (directive = key.substring(ACTION_PREFIX.length())).indexOf(46)) >= 0) continue;
            String actionClass = properties.getProperty(key);
            action = (IAction)Class.forName(actionClass).newInstance();
            action.setName(directive);
            actionsMap.put(action.getName(), action);
            csrfGuard.getActions().add(action);
        }
        for (Object obj : properties.keySet()) {
            key = (String)obj;
            if (!key.startsWith(ACTION_PREFIX) || (index = (directive = key.substring(ACTION_PREFIX.length())).indexOf(46)) < 0) continue;
            String actionName = directive.substring(0, index);
            action = (IAction)actionsMap.get(actionName);
            if (action == null) {
                throw new IOException(String.format("action class %s has not yet been specified", actionName));
            }
            String parameterName = directive.substring(index + 1);
            String parameterValue = properties.getProperty(key);
            action.setParameter(parameterName, parameterValue);
        }
        if (csrfGuard.getActions().size() <= 0) {
            throw new IOException("failure to define at least one action");
        }
        for (Object obj : properties.keySet()) {
            String pageUri;
            key = (String)obj;
            if (key.startsWith(PROTECTED_PAGE_PREFIX) && (index = (directive = key.substring(PROTECTED_PAGE_PREFIX.length())).indexOf(46)) < 0) {
                pageUri = properties.getProperty(key);
                csrfGuard.getProtectedPages().add(pageUri);
            }
            if (!key.startsWith(UNPROTECTED_PAGE_PREFIX) || (index = (directive = key.substring(UNPROTECTED_PAGE_PREFIX.length())).indexOf(46)) >= 0) continue;
            pageUri = properties.getProperty(key);
            csrfGuard.getUnprotectedPages().add(pageUri);
        }
        String methodList = properties.getProperty("org.owasp.csrfguard.ProtectedMethods");
        if (methodList != null && methodList.trim().length() != 0) {
            for (String method : methodList.split(",")) {
                csrfGuard.getProtectedMethods().add(method.trim());
            }
        }
    }

    public CsrfGuard() {
        this.protectedPages = new HashSet<String>();
        this.unprotectedPages = new HashSet<String>();
        this.protectedMethods = new HashSet<String>();
    }

    public ILogger getLogger() {
        return this.logger;
    }

    private void setLogger(ILogger logger) {
        this.logger = logger;
    }

    public String getTokenName() {
        return this.tokenName;
    }

    private void setTokenName(String tokenName) {
        this.tokenName = tokenName;
    }

    public int getTokenLength() {
        return this.tokenLength;
    }

    private void setTokenLength(int tokenLength) {
        this.tokenLength = tokenLength;
    }

    public boolean isRotateEnabled() {
        return this.rotate;
    }

    private void setRotate(boolean rotate) {
        this.rotate = rotate;
    }

    public boolean isTokenPerPageEnabled() {
        return this.tokenPerPage;
    }

    private void setTokenPerPage(boolean tokenPerPage) {
        this.tokenPerPage = tokenPerPage;
    }

    public boolean isTokenPerPagePrecreate() {
        return this.tokenPerPagePrecreate;
    }

    private void setTokenPerPagePrecreate(boolean tokenPerPagePrecreate) {
        this.tokenPerPagePrecreate = tokenPerPagePrecreate;
    }

    public SecureRandom getPrng() {
        return this.prng;
    }

    private void setPrng(SecureRandom prng) {
        this.prng = prng;
    }

    public String getNewTokenLandingPage() {
        return this.newTokenLandingPage;
    }

    private void setNewTokenLandingPage(String newTokenLandingPage) {
        this.newTokenLandingPage = newTokenLandingPage;
    }

    public boolean isUseNewTokenLandingPage() {
        return this.useNewTokenLandingPage;
    }

    private void setUseNewTokenLandingPage(boolean useNewTokenLandingPage) {
        this.useNewTokenLandingPage = useNewTokenLandingPage;
    }

    public boolean isAjaxEnabled() {
        return this.ajax;
    }

    private void setAjax(boolean ajax) {
        this.ajax = ajax;
    }

    public boolean isProtectEnabled() {
        return this.protect;
    }

    public void setProtect(boolean protect) {
        this.protect = protect;
    }

    public String getSessionKey() {
        return this.sessionKey;
    }

    private void setSessionKey(String sessionKey) {
        this.sessionKey = sessionKey;
    }

    public Set<String> getProtectedPages() {
        return this.protectedPages;
    }

    public Set<String> getUnprotectedPages() {
        return this.unprotectedPages;
    }

    public Set<String> getProtectedMethods() {
        return this.protectedMethods;
    }

    public List<IAction> getActions() {
        return this.actions;
    }

    public String getTokenValue(HttpServletRequest request) {
        return this.getTokenValue(request, request.getRequestURI());
    }

    public String getTokenValue(HttpServletRequest request, String uri) {
        String tokenValue = null;
        HttpSession session = request.getSession(false);
        if (session != null) {
            Map pageTokens;
            if (this.isTokenPerPageEnabled() && (pageTokens = (Map)session.getAttribute(PAGE_TOKENS_KEY)) != null) {
                if (this.isTokenPerPagePrecreate()) {
                    this.createPageToken(pageTokens, uri);
                }
                tokenValue = (String)pageTokens.get(uri);
            }
            if (tokenValue == null) {
                tokenValue = (String)session.getAttribute(this.getSessionKey());
            }
        }
        return tokenValue;
    }

    public boolean isValidRequest(HttpServletRequest request, HttpServletResponse response) {
        boolean valid = !this.isProtectedPageAndMethod(request);
        HttpSession session = request.getSession(true);
        String tokenFromSession = (String)session.getAttribute(this.getSessionKey());
        if (tokenFromSession != null && !valid) {
            try {
                if (this.isAjaxEnabled() && this.isAjaxRequest(request)) {
                    this.verifyAjaxToken(request);
                } else if (this.isTokenPerPageEnabled()) {
                    this.verifyPageToken(request);
                } else {
                    this.verifySessionToken(request);
                }
                valid = true;
            }
            catch (CsrfGuardException csrfe) {
                for (IAction action : this.getActions()) {
                    try {
                        action.execute(request, response, csrfe, this);
                    }
                    catch (CsrfGuardException exception) {
                        this.getLogger().log(LogLevel.Error, exception);
                    }
                }
            }
            if (!this.isAjaxRequest(request) && this.isRotateEnabled()) {
                this.rotateTokens(request);
            }
        } else if (tokenFromSession == null) {
            throw new IllegalStateException("CsrfGuard expects the token to exist in session at this point");
        }
        return valid;
    }

    public void updateToken(HttpSession session) {
        String tokenValue = (String)session.getAttribute(this.getSessionKey());
        if (tokenValue == null) {
            try {
                tokenValue = RandomGenerator.generateRandomId(this.getPrng(), this.getTokenLength());
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("unable to generate the random token - %s", e.getLocalizedMessage()), e);
            }
            session.setAttribute(this.getSessionKey(), (Object)tokenValue);
        }
    }

    public void updateTokens(HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        if (session != null) {
            this.updateToken(session);
            if (this.isTokenPerPageEnabled()) {
                HashMap<String, String> pageTokens = (HashMap<String, String>)session.getAttribute(PAGE_TOKENS_KEY);
                if (pageTokens == null) {
                    pageTokens = new HashMap<String, String>();
                    session.setAttribute(PAGE_TOKENS_KEY, pageTokens);
                }
                if (this.isProtectedPageAndMethod(request)) {
                    this.createPageToken(pageTokens, request.getRequestURI());
                }
            }
        }
    }

    private void createPageToken(Map<String, String> pageTokens, String uri) {
        if (pageTokens == null) {
            return;
        }
        if (pageTokens.containsKey(uri)) {
            return;
        }
        try {
            pageTokens.put(uri, RandomGenerator.generateRandomId(this.getPrng(), this.getTokenLength()));
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("unable to generate the random token - %s", e.getLocalizedMessage()), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeLandingPage(HttpServletRequest request, HttpServletResponse response) throws IOException {
        StringBuilder sb;
        String landingPage = this.getNewTokenLandingPage();
        if (landingPage == null) {
            sb = new StringBuilder();
            sb.append(request.getContextPath());
            sb.append(request.getServletPath());
            landingPage = sb.toString();
        }
        sb = new StringBuilder();
        sb.append("<html>\r\n");
        sb.append("<head>\r\n");
        sb.append("<title>OWASP CSRFGuard Project - New Token Landing Page</title>\r\n");
        sb.append("</head>\r\n");
        sb.append("<body>\r\n");
        sb.append("<script type=\"text/javascript\">\r\n");
        sb.append("var form = document.createElement(\"form\");\r\n");
        sb.append("form.setAttribute(\"method\", \"post\");\r\n");
        sb.append("form.setAttribute(\"action\", \"");
        sb.append(landingPage);
        sb.append("\");\r\n");
        if (this.isProtectedPage(landingPage)) {
            sb.append("var hiddenField = document.createElement(\"input\");\r\n");
            sb.append("hiddenField.setAttribute(\"type\", \"hidden\");\r\n");
            sb.append("hiddenField.setAttribute(\"name\", \"");
            sb.append(this.getTokenName());
            sb.append("\");\r\n");
            sb.append("hiddenField.setAttribute(\"value\", \"");
            sb.append(this.getTokenValue(request, landingPage));
            sb.append("\");\r\n");
            sb.append("form.appendChild(hiddenField);\r\n");
        }
        sb.append("document.body.appendChild(form);\r\n");
        sb.append("form.submit();\r\n");
        sb.append("</script>\r\n");
        sb.append("</body>\r\n");
        sb.append("</html>\r\n");
        String code = sb.toString();
        response.setContentType("text/html");
        response.setContentLength(code.length());
        ServletOutputStream output = null;
        PrintWriter writer = null;
        try {
            output = response.getOutputStream();
            writer = new PrintWriter((OutputStream)output);
            writer.write(code);
            writer.flush();
        }
        catch (Throwable throwable) {
            Writers.close(writer);
            Streams.close((OutputStream)output);
            throw throwable;
        }
        Writers.close(writer);
        Streams.close((OutputStream)output);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("\r\n*****************************************************\r\n");
        sb.append("* Owasp.CsrfGuard Properties\r\n");
        sb.append("*\r\n");
        sb.append(String.format("* Logger: %s\r\n", this.getLogger().getClass().getName()));
        sb.append(String.format("* NewTokenLandingPage: %s\r\n", this.getNewTokenLandingPage()));
        sb.append(String.format("* PRNG: %s\r\n", this.getPrng().getAlgorithm()));
        sb.append(String.format("* SessionKey: %s\r\n", this.getSessionKey()));
        sb.append(String.format("* TokenLength: %s\r\n", this.getTokenLength()));
        sb.append(String.format("* TokenName: %s\r\n", this.getTokenName()));
        sb.append(String.format("* Ajax: %s\r\n", this.isAjaxEnabled()));
        sb.append(String.format("* Rotate: %s\r\n", this.isRotateEnabled()));
        sb.append(String.format("* TokenPerPage: %s\r\n", this.isTokenPerPageEnabled()));
        for (IAction action : this.actions) {
            sb.append(String.format("* Action: %s\r\n", action.getClass().getName()));
            for (String name : action.getParameterMap().keySet()) {
                String value = action.getParameter(name);
                sb.append(String.format("*\tParameter: %s = %s\r\n", name, value));
            }
        }
        sb.append("*****************************************************\r\n");
        return sb.toString();
    }

    private boolean isAjaxRequest(HttpServletRequest request) {
        return request.getHeader("X-Requested-With") != null;
    }

    private void verifyAjaxToken(HttpServletRequest request) throws CsrfGuardException {
        HttpSession session = request.getSession(true);
        String tokenFromSession = (String)session.getAttribute(this.getSessionKey());
        String tokenFromRequest = request.getHeader(this.getTokenName());
        if (tokenFromRequest == null) {
            throw new CsrfGuardException("required token is missing from the request");
        }
        if (!tokenFromSession.equals(tokenFromRequest)) {
            throw new CsrfGuardException("request token does not match session token");
        }
    }

    private void verifyPageToken(HttpServletRequest request) throws CsrfGuardException {
        HttpSession session = request.getSession(true);
        Map pageTokens = (Map)session.getAttribute(PAGE_TOKENS_KEY);
        String tokenFromPages = pageTokens != null ? (String)pageTokens.get(request.getRequestURI()) : null;
        String tokenFromSession = (String)session.getAttribute(this.getSessionKey());
        String tokenFromRequest = request.getParameter(this.getTokenName());
        if (tokenFromRequest == null) {
            throw new CsrfGuardException("required token is missing from the request");
        }
        if (tokenFromPages != null) {
            if (!tokenFromPages.equals(tokenFromRequest)) {
                throw new CsrfGuardException("request token does not match page token");
            }
        } else if (!tokenFromSession.equals(tokenFromRequest)) {
            throw new CsrfGuardException("request token does not match session token");
        }
    }

    private void verifySessionToken(HttpServletRequest request) throws CsrfGuardException {
        HttpSession session = request.getSession(true);
        String tokenFromSession = (String)session.getAttribute(this.getSessionKey());
        String tokenFromRequest = request.getParameter(this.getTokenName());
        if (tokenFromRequest == null) {
            throw new CsrfGuardException("required token is missing from the request");
        }
        if (!tokenFromSession.equals(tokenFromRequest)) {
            throw new CsrfGuardException("request token does not match session token");
        }
    }

    private void rotateTokens(HttpServletRequest request) {
        HttpSession session = request.getSession(true);
        String tokenFromSession = null;
        try {
            tokenFromSession = RandomGenerator.generateRandomId(this.getPrng(), this.getTokenLength());
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("unable to generate the random token - %s", e.getLocalizedMessage()), e);
        }
        session.setAttribute(this.getSessionKey(), (Object)tokenFromSession);
        if (this.isTokenPerPageEnabled()) {
            Map pageTokens = (Map)session.getAttribute(PAGE_TOKENS_KEY);
            try {
                pageTokens.put(request.getRequestURI(), RandomGenerator.generateRandomId(this.getPrng(), this.getTokenLength()));
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("unable to generate the random token - %s", e.getLocalizedMessage()), e);
            }
        }
    }

    public boolean isProtectedPage(String uri) {
        boolean retval = !this.isProtectEnabled();
        for (String protectedPage : this.protectedPages) {
            if (this.isUriExactMatch(protectedPage, uri)) {
                return true;
            }
            if (!this.isUriMatch(protectedPage, uri)) continue;
            retval = true;
        }
        for (String unprotectedPage : this.unprotectedPages) {
            if (this.isUriExactMatch(unprotectedPage, uri)) {
                return false;
            }
            if (!this.isUriMatch(unprotectedPage, uri)) continue;
            retval = false;
        }
        return retval;
    }

    public boolean isProtectedMethod(String method) {
        boolean retval = false;
        if (this.protectedMethods.isEmpty() || this.protectedMethods.contains(method)) {
            retval = true;
        }
        return retval;
    }

    public boolean isProtectedPageAndMethod(String page, String method) {
        return this.isProtectedPage(page) && this.isProtectedMethod(method);
    }

    public boolean isProtectedPageAndMethod(HttpServletRequest request) {
        return this.isProtectedPageAndMethod(request.getRequestURI(), request.getMethod());
    }

    private boolean isUriMatch(String testPath, String requestPath) {
        boolean retval = false;
        if (testPath.equals(requestPath)) {
            retval = true;
        }
        if (testPath.equals("/*")) {
            retval = true;
        }
        if (testPath.endsWith("/*") && testPath.regionMatches(0, requestPath, 0, testPath.length() - 2)) {
            if (requestPath.length() == testPath.length() - 2) {
                retval = true;
            } else if ('/' == requestPath.charAt(testPath.length() - 2)) {
                retval = true;
            }
        }
        if (testPath.startsWith("*.")) {
            int slash = requestPath.lastIndexOf(47);
            int period = requestPath.lastIndexOf(46);
            if (slash >= 0 && period > slash && period != requestPath.length() - 1 && requestPath.length() - period == testPath.length() - 1) {
                retval = testPath.regionMatches(2, requestPath, period + 1, testPath.length() - 2);
            }
        }
        return retval;
    }

    private boolean isUriExactMatch(String testPath, String requestPath) {
        boolean retval = false;
        if (testPath.equals(requestPath)) {
            retval = true;
        }
        return retval;
    }

    private static class SingletonHolder {
        public static final CsrfGuard instance = new CsrfGuard();

        private SingletonHolder() {
        }
    }
}

