/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.csrfguard.action;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.owasp.csrfguard.CsrfGuard;
import org.owasp.csrfguard.CsrfGuardException;
import org.owasp.csrfguard.action.AbstractAction;
import org.owasp.csrfguard.log.LogLevel;
import org.owasp.csrfguard.util.CsrfGuardUtils;

public final class Log
extends AbstractAction {
    private static final long serialVersionUID = 8238761463376338707L;

    @Override
    public void execute(HttpServletRequest request, HttpServletResponse response, CsrfGuardException csrfe, CsrfGuard csrfGuard) throws CsrfGuardException {
        String logMessage = this.getParameter("Message");
        logMessage = logMessage.replace("%exception%", String.valueOf(csrfe));
        logMessage = logMessage.replace("%exception_message%", csrfe.getLocalizedMessage());
        logMessage = logMessage.replace("%remote_ip%", CsrfGuardUtils.defaultString(request.getRemoteAddr()));
        logMessage = logMessage.replace("%remote_host%", CsrfGuardUtils.defaultString(request.getRemoteHost()));
        logMessage = logMessage.replace("%remote_port%", String.valueOf(request.getRemotePort()));
        logMessage = logMessage.replace("%local_ip%", CsrfGuardUtils.defaultString(request.getLocalAddr()));
        logMessage = logMessage.replace("%local_host%", CsrfGuardUtils.defaultString(request.getLocalName()));
        logMessage = logMessage.replace("%local_port%", String.valueOf(request.getLocalPort()));
        logMessage = logMessage.replace("%request_method%", CsrfGuardUtils.defaultString(request.getMethod()));
        logMessage = logMessage.replace("%request_uri%", CsrfGuardUtils.defaultString(request.getRequestURI()));
        logMessage = logMessage.replace("%request_url%", request.getRequestURL().toString());
        String user = request.getRemoteUser();
        if (user == null || "".equals(user.trim())) {
            user = (String)request.getAttribute("REMOTE_USER");
        }
        if ((user == null || "".equals(user.trim())) && request.getUserPrincipal() != null) {
            user = request.getUserPrincipal().getName();
        }
        logMessage = user != null && !"".equals(user.trim()) ? logMessage.replace("%user%", user) : logMessage.replace("%user%", "<anonymous>");
        csrfGuard.getLogger().log(LogLevel.Error, logMessage);
    }
}

