/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.csrfguard.token.businessobject;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.tuple.Pair;

public class TokenBO {
    private final Map<String, String> updatedPageTokens;
    private String updatedMasterToken;
    private Pair<TokenType, String> usedToken;

    public TokenBO() {
        this(null, new HashMap<String, String>());
    }

    public TokenBO(String updatedMasterToken) {
        this(updatedMasterToken, null);
    }

    public TokenBO(Map<String, String> updatedPageTokens) {
        this(null, updatedPageTokens);
    }

    public TokenBO(String updatedMasterToken, Map<String, String> updatedPageTokens) {
        this.updatedMasterToken = updatedMasterToken;
        this.updatedPageTokens = updatedPageTokens;
    }

    public TokenBO setUsedPageToken(String tokenValue) {
        this.setUsedToken(TokenType.PAGE, tokenValue);
        return this;
    }

    public TokenBO setUpdatedPageToken(String uri, String pageTokenValue) {
        if (this.updatedPageTokens.containsKey(uri)) {
            throw new IllegalStateException(String.format("Logical Error! A new value for the page token with the URI [%s] has already been prepared for update.", uri));
        }
        this.updatedPageTokens.put(uri, pageTokenValue);
        return this;
    }

    public String getUpdatedMasterToken() {
        return this.updatedMasterToken;
    }

    public TokenBO setUpdatedMasterToken(String masterToken) {
        if (Objects.isNull(this.updatedMasterToken)) {
            this.updatedMasterToken = masterToken;
            return this;
        }
        throw new IllegalStateException("Logical Error! A new value for the master token has already been prepared for update.");
    }

    public Map<String, String> getUpdatedPageTokens() {
        return this.updatedPageTokens;
    }

    public boolean isUsedMasterToken() {
        if (Objects.isNull(this.usedToken)) {
            throw new IllegalStateException("Internal error! The token used to validate the request is not set.");
        }
        return this.usedToken.getKey() == TokenType.MASTER;
    }

    public TokenBO setUsedMasterToken(String tokenValue) {
        this.setUsedToken(TokenType.MASTER, tokenValue);
        return this;
    }

    private void setUsedToken(TokenType page, String tokenValue) {
        if (!Objects.isNull(this.usedToken)) {
            throw new IllegalStateException("Used token was already set. A request cannot be validated by two different tokens!");
        }
        this.usedToken = Pair.of((Object)((Object)page), (Object)tokenValue);
    }

    private static enum TokenType {
        MASTER,
        PAGE;

    }
}

