/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.csrfguard.token.storage.impl;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.owasp.csrfguard.token.storage.Token;
import org.owasp.csrfguard.token.storage.impl.PageTokenValue;

public class InMemoryToken
implements Token {
    private String masterToken;
    private Map<String, PageTokenValue> pageTokens;

    public InMemoryToken(String masterToken) {
        this(masterToken, new ConcurrentHashMap<String, PageTokenValue>());
    }

    public InMemoryToken(String masterToken, Pair<String, String> pageToken) {
        this(masterToken, InMemoryToken.toMap(pageToken));
    }

    private InMemoryToken(String masterToken, Map<String, PageTokenValue> pageTokens) {
        Objects.requireNonNull(masterToken, "Master token cannot be null");
        Objects.requireNonNull(pageTokens, "Page tokens cannot be null");
        this.masterToken = masterToken;
        this.pageTokens = new ConcurrentHashMap<String, PageTokenValue>(pageTokens);
    }

    @Override
    public String getMasterToken() {
        return this.masterToken;
    }

    @Override
    public void setMasterToken(String masterToken) {
        this.masterToken = masterToken;
    }

    @Override
    public String getPageToken(String uri) {
        return this.pageTokens.get(uri).getValue();
    }

    @Override
    public PageTokenValue getTimedPageToken(String uri) {
        return this.pageTokens.get(uri);
    }

    @Override
    public void setPageToken(String uri, String pageToken) {
        this.pageTokens.put(uri, PageTokenValue.from(pageToken));
    }

    @Override
    public String setPageTokenIfAbsent(String uri, Supplier<String> valueSupplier) {
        return this.pageTokens.computeIfAbsent(uri, k -> PageTokenValue.from((String)valueSupplier.get())).getValue();
    }

    @Override
    public Map<String, String> getPageTokens() {
        return this.pageTokens.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((PageTokenValue)e.getValue()).getValue()));
    }

    @Override
    public void setPageTokens(Map<String, String> pageTokens) {
        this.pageTokens = pageTokens.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> PageTokenValue.from((String)e.getValue()), (e1, e2) -> e2, ConcurrentHashMap::new));
    }

    @Override
    public void rotateAllPageTokens(Supplier<String> tokenValueSupplier) {
        this.pageTokens.entrySet().forEach(e -> e.setValue(PageTokenValue.from((String)tokenValueSupplier.get())));
    }

    @Override
    public void regenerateUsedPageToken(String tokenFromRequest, Supplier<String> tokenValueSupplier) {
        this.pageTokens.replaceAll((k, v) -> v.getValue().equals(tokenFromRequest) ? PageTokenValue.from((String)tokenValueSupplier.get()) : v);
    }

    private static Map<String, PageTokenValue> toMap(Pair<String, String> pageToken) {
        ConcurrentHashMap<String, PageTokenValue> pageTokens = new ConcurrentHashMap<String, PageTokenValue>();
        pageTokens.put((String)pageToken.getKey(), PageTokenValue.from((String)pageToken.getValue()));
        return pageTokens;
    }
}

