/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.classic.filter.ThresholdFilter;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.filter.Filter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.cli.ParseException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.types.LogLevel;
import org.owasp.dependencycheck.CliParser;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.data.nvdcve.DatabaseException;
import org.owasp.dependencycheck.data.update.exception.UpdateException;
import org.owasp.dependencycheck.dependency.Dependency;
import org.owasp.dependencycheck.dependency.Vulnerability;
import org.owasp.dependencycheck.exception.ExceptionCollection;
import org.owasp.dependencycheck.exception.ReportException;
import org.owasp.dependencycheck.utils.CveUrlParser;
import org.owasp.dependencycheck.utils.InvalidSettingException;
import org.owasp.dependencycheck.utils.Settings;
import org.owasp.dependencycheck.utils.SeverityUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class App {
    private static final Logger LOGGER = LoggerFactory.getLogger(App.class);
    private static final String ERROR_LOADING_PROPERTIES_FILE = "Error loading properties file";
    private static final String NEW_LINE = System.getProperty("line.separator", "\n");
    private final Settings settings;

    public static void main(String[] args) {
        App app = new App();
        int exitCode = app.run(args);
        LOGGER.debug("Exit code: {}", (Object)exitCode);
        System.exit(exitCode);
    }

    public App() {
        this.settings = new Settings();
    }

    protected App(Settings settings) {
        this.settings = settings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int run(String[] args) {
        int exitCode = 0;
        CliParser cli = new CliParser(this.settings);
        try {
            cli.parse(args);
        }
        catch (FileNotFoundException ex) {
            System.err.println(ex.getMessage());
            cli.printHelp();
            return -1;
        }
        catch (ParseException ex) {
            System.err.println(ex.getMessage());
            cli.printHelp();
            return -2;
        }
        String verboseLog = cli.getStringArgument("log");
        if (verboseLog != null) {
            this.prepareLogger(verboseLog);
        }
        if (cli.isPurge()) {
            String connStr = cli.getStringArgument("connectionString");
            if (connStr != null) {
                LOGGER.error("Unable to purge the database when using a non-default connection string");
                return -3;
            }
            try {
                this.populateSettings(cli);
            }
            catch (InvalidSettingException ex) {
                LOGGER.error(ex.getMessage());
                LOGGER.debug(ERROR_LOADING_PROPERTIES_FILE, (Throwable)ex);
                return -4;
            }
            try (Engine engine = new Engine(Engine.Mode.EVIDENCE_PROCESSING, this.settings);){
                if (engine.purge()) return exitCode;
                int n = exitCode = -7;
                return n;
            }
            finally {
                this.settings.cleanup();
            }
        }
        if (cli.isGetVersion()) {
            cli.printVersionInfo();
            return exitCode;
        }
        if (cli.isUpdateOnly()) {
            try {
                this.populateSettings(cli);
                this.settings.setBoolean("odc.autoupdate", true);
            }
            catch (InvalidSettingException ex) {
                LOGGER.error(ex.getMessage());
                LOGGER.debug(ERROR_LOADING_PROPERTIES_FILE, (Throwable)ex);
                return -4;
            }
            try {
                this.runUpdateOnly();
                return exitCode;
            }
            catch (UpdateException ex) {
                LOGGER.error(ex.getMessage(), (Throwable)ex);
                exitCode = -8;
                return exitCode;
            }
            catch (DatabaseException ex) {
                LOGGER.error(ex.getMessage(), (Throwable)ex);
                exitCode = -9;
                return exitCode;
            }
            finally {
                this.settings.cleanup();
            }
        }
        if (cli.isRunScan()) {
            try {
                this.populateSettings(cli);
            }
            catch (InvalidSettingException ex) {
                LOGGER.error(ex.getMessage(), (Throwable)ex);
                LOGGER.debug(ERROR_LOADING_PROPERTIES_FILE, (Throwable)ex);
                return -4;
            }
            try {
                String[] scanFiles = cli.getScanFiles();
                if (scanFiles != null) {
                    exitCode = this.runScan(cli.getReportDirectory(), cli.getReportFormat(), cli.getProjectName(), scanFiles, cli.getExcludeList(), cli.getSymLinkDepth(), cli.getFailOnCVSS());
                    return exitCode;
                }
                LOGGER.error("No scan files configured");
                return exitCode;
            }
            catch (DatabaseException ex) {
                LOGGER.error(ex.getMessage());
                LOGGER.debug("database exception", (Throwable)ex);
                exitCode = -11;
                return exitCode;
            }
            catch (ReportException ex) {
                LOGGER.error(ex.getMessage());
                LOGGER.debug("report exception", (Throwable)ex);
                exitCode = -12;
                return exitCode;
            }
            catch (ExceptionCollection ex) {
                if (ex.isFatal()) {
                    exitCode = -13;
                    LOGGER.error("One or more fatal errors occurred");
                } else {
                    exitCode = -14;
                }
                Iterator iterator = ex.getExceptions().iterator();
                while (iterator.hasNext()) {
                    Throwable e = (Throwable)iterator.next();
                    if (e.getMessage() == null) continue;
                    LOGGER.error(e.getMessage());
                    LOGGER.debug("unexpected error", e);
                }
                return exitCode;
            }
            finally {
                this.settings.cleanup();
            }
        }
        cli.printHelp();
        return exitCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int runScan(String reportDirectory, String[] outputFormats, String applicationName, String[] files, String[] excludes, int symLinkDepth, float cvssFailScore) throws DatabaseException, ExceptionCollection, ReportException {
        try (Engine engine = null;){
            List<String> antStylePaths = this.getPaths(files);
            Set<File> paths = this.scanAntStylePaths(antStylePaths, symLinkDepth, excludes);
            engine = new Engine(this.settings);
            engine.scan(paths);
            ExceptionCollection exCol = null;
            try {
                engine.analyzeDependencies();
            }
            catch (ExceptionCollection ex) {
                if (ex.isFatal()) {
                    throw ex;
                }
                exCol = ex;
            }
            try {
                for (String outputFormat : outputFormats) {
                    engine.writeReports(applicationName, new File(reportDirectory), outputFormat, exCol);
                }
            }
            catch (ReportException ex) {
                if (exCol != null) {
                    exCol.addException((Throwable)ex);
                    throw exCol;
                }
                throw ex;
            }
            if (exCol != null && !exCol.getExceptions().isEmpty()) {
                throw exCol;
            }
            int n = this.determineReturnCode(engine, cvssFailScore);
            return n;
        }
    }

    private int determineReturnCode(Engine engine, float cvssFailScore) {
        int retCode = 0;
        StringBuilder ids = new StringBuilder();
        for (Dependency d : engine.getDependencies()) {
            boolean addName = true;
            for (Vulnerability v : d.getVulnerabilities()) {
                float unscoredCvss;
                float cvssV2 = v.getCvssV2() != null ? v.getCvssV2().getScore() : -1.0f;
                float cvssV3 = v.getCvssV3() != null ? v.getCvssV3().getBaseScore() : -1.0f;
                float f = unscoredCvss = v.getUnscoredSeverity() != null ? SeverityUtil.estimateCvssV2((String)v.getUnscoredSeverity()) : -1.0f;
                if (!(cvssV2 >= cvssFailScore || cvssV3 >= cvssFailScore || unscoredCvss >= cvssFailScore) && !(cvssFailScore <= 0.0f)) continue;
                float score = 0.0f;
                if (cvssV3 >= 0.0f) {
                    score = cvssV3;
                } else if (cvssV2 >= 0.0f) {
                    score = cvssV2;
                } else if (unscoredCvss >= 0.0f) {
                    score = unscoredCvss;
                }
                if (addName) {
                    addName = false;
                    ids.append(NEW_LINE).append(d.getFileName()).append(": ");
                    ids.append(v.getName()).append('(').append(score).append(')');
                    continue;
                }
                ids.append(", ").append(v.getName()).append('(').append(score).append(')');
            }
        }
        if (ids.length() > 0) {
            LOGGER.error(String.format("%n%nOne or more dependencies were identified with vulnerabilities that have a CVSS score greater than or equal to '%.1f': %n%s%n%nSee the dependency-check report for more details.%n%n", Float.valueOf(cvssFailScore), ids));
            retCode = 1;
        }
        return retCode;
    }

    private Set<File> scanAntStylePaths(List<String> antStylePaths, int symLinkDepth, String[] excludes) {
        TreeSet<File> paths = new TreeSet<File>();
        for (String file : antStylePaths) {
            File baseDir;
            LOGGER.debug("Scanning {}", (Object)file);
            DirectoryScanner scanner = new DirectoryScanner();
            String include = file.replace('\\', '/');
            int pos = this.getLastFileSeparator(include);
            String tmpBase = include.substring(0, pos);
            String tmpInclude = include.substring(pos + 1);
            if (tmpInclude.indexOf(42) >= 0 || tmpInclude.indexOf(63) >= 0 || new File(include).isFile()) {
                baseDir = new File(tmpBase);
                include = tmpInclude;
            } else {
                baseDir = new File(tmpBase, tmpInclude);
                include = "**/*";
            }
            LOGGER.debug("BaseDir: " + baseDir);
            LOGGER.debug("Include: " + include);
            scanner.setBasedir(baseDir);
            String[] includes = new String[]{include};
            scanner.setIncludes(includes);
            scanner.setMaxLevelsOfSymlinks(symLinkDepth);
            if (symLinkDepth <= 0) {
                scanner.setFollowSymlinks(false);
            }
            if (excludes != null && excludes.length > 0) {
                for (String e : excludes) {
                    LOGGER.debug("Exclude: " + e);
                }
                scanner.addExcludes(excludes);
            }
            scanner.scan();
            if (scanner.getIncludedFilesCount() <= 0) continue;
            for (String s : scanner.getIncludedFiles()) {
                File f = new File(baseDir, s);
                LOGGER.debug("Found file {}", (Object)f);
                paths.add(f);
            }
        }
        return paths;
    }

    private List<String> getPaths(String[] files) {
        ArrayList<String> antStylePaths = new ArrayList<String>();
        for (String file : files) {
            String antPath = this.ensureCanonicalPath(file);
            antStylePaths.add(antPath);
        }
        return antStylePaths;
    }

    private void runUpdateOnly() throws UpdateException, DatabaseException {
        try (Engine engine = new Engine(this.settings);){
            engine.doUpdates();
        }
    }

    protected void populateSettings(CliParser cli) throws InvalidSettingException {
        String dataDirectory;
        File propertiesFile = cli.getFileArgument("propertyfile");
        if (propertiesFile != null) {
            try {
                this.settings.mergeProperties(propertiesFile);
            }
            catch (FileNotFoundException ex) {
                throw new InvalidSettingException("Unable to find properties file '" + propertiesFile.getPath() + "'", (Throwable)ex);
            }
            catch (IOException ex) {
                throw new InvalidSettingException("Error reading properties file '" + propertiesFile.getPath() + "'", (Throwable)ex);
            }
        }
        if ((dataDirectory = cli.getStringArgument("data")) != null) {
            this.settings.setString("data.directory", dataDirectory);
        } else if (System.getProperty("basedir") != null) {
            File dataDir = new File(System.getProperty("basedir"), "data");
            this.settings.setString("data.directory", dataDir.getAbsolutePath());
        } else {
            File jarPath = new File(App.class.getProtectionDomain().getCodeSource().getLocation().getPath());
            File base = jarPath.getParentFile();
            String sub = this.settings.getString("data.directory");
            File dataDir = new File(base, sub);
            this.settings.setString("data.directory", dataDir.getAbsolutePath());
        }
        Boolean autoUpdate = cli.hasOption("noupdate") != null ? Boolean.valueOf(false) : null;
        this.settings.setBooleanIfNotNull("odc.autoupdate", autoUpdate);
        this.settings.setStringIfNotEmpty("proxy.server", cli.getStringArgument("proxyserver"));
        this.settings.setStringIfNotEmpty("proxy.port", cli.getStringArgument("proxyport"));
        this.settings.setStringIfNotEmpty("proxy.username", cli.getStringArgument("proxyuser"));
        this.settings.setStringIfNotEmpty("proxy.password", cli.getStringArgument("proxypass", "proxy.password"));
        this.settings.setStringIfNotEmpty("proxy.nonproxyhosts", cli.getStringArgument("nonProxyHosts"));
        this.settings.setStringIfNotEmpty("connection.timeout", cli.getStringArgument("connectiontimeout"));
        this.settings.setStringIfNotEmpty("connection.read.timeout", cli.getStringArgument("readtimeout"));
        this.settings.setStringIfNotEmpty("hints.file", cli.getStringArgument("hints"));
        this.settings.setIntIfNotNull("cve.check.validforhours", cli.getIntegerValue("cveValidForHours"));
        this.settings.setIntIfNotNull("cve.startyear", cli.getIntegerValue("cveStartYear"));
        this.settings.setArrayIfNotEmpty("suppression.file", cli.getStringArguments("suppression"));
        this.settings.setBooleanIfNotNull("analyzer.experimental.enabled", cli.hasOption("enableExperimental"));
        this.settings.setBooleanIfNotNull("analyzer.retired.enabled", cli.hasOption("enableRetired"));
        this.settings.setStringIfNotNull("analyzer.golang.path", cli.getStringArgument("go"));
        this.settings.setStringIfNotNull("analyzer.yarn.path", cli.getStringArgument("yarn"));
        this.settings.setStringIfNotNull("analyzer.pnpm.path", cli.getStringArgument("pnpm"));
        this.settings.setBooleanIfNotNull("odc.reports.pretty.print", cli.hasOption("prettyPrint"));
        this.settings.setStringIfNotNull("analyzer.retirejs.repo.js.url", cli.getStringArgument("retireJsUrl"));
        this.settings.setBooleanIfNotNull("analyzer.retirejs.forceupdate", cli.hasOption("retireJsForceUpdate"));
        this.settings.setBoolean("analyzer.jar.enabled", !cli.hasDisableOption("disableJar", "analyzer.jar.enabled"));
        this.settings.setBoolean("analyzer.msbuildproject.enabled", !cli.hasDisableOption("disableMSBuild", "analyzer.msbuildproject.enabled"));
        this.settings.setBoolean("analyzer.archive.enabled", !cli.hasDisableOption("disableArchive", "analyzer.archive.enabled"));
        this.settings.setBoolean("analyzer.python.distribution.enabled", !cli.hasDisableOption("disablePyDist", "analyzer.python.distribution.enabled"));
        this.settings.setBoolean("analyzer.python.package.enabled", !cli.hasDisableOption("disablePyPkg", "analyzer.python.package.enabled"));
        this.settings.setBoolean("analyzer.autoconf.enabled", !cli.hasDisableOption("disableAutoconf", "analyzer.autoconf.enabled"));
        this.settings.setBoolean("analyzer.maveninstall.enabled", !cli.hasDisableOption("disableMavenInstall", "analyzer.maveninstall.enabled"));
        this.settings.setBoolean("analyzer.pip.enabled", !cli.hasDisableOption("disablePip", "analyzer.pip.enabled"));
        this.settings.setBoolean("analyzer.pipfile.enabled", !cli.hasDisableOption("disablePipfile", "analyzer.pipfile.enabled"));
        this.settings.setBoolean("analyzer.poetry.enabled", !cli.hasDisableOption("disablePoetry", "analyzer.poetry.enabled"));
        this.settings.setBoolean("analyzer.cmake.enabled", !cli.hasDisableOption("disableCmake", "analyzer.cmake.enabled"));
        this.settings.setBoolean("analyzer.nuspec.enabled", !cli.hasDisableOption("disableNuspec", "analyzer.nuspec.enabled"));
        this.settings.setBoolean("analyzer.nugetconf.enabled", !cli.hasDisableOption("disableNugetconf", "analyzer.nugetconf.enabled"));
        this.settings.setBoolean("analyzer.assembly.enabled", !cli.hasDisableOption("disableAssembly", "analyzer.assembly.enabled"));
        this.settings.setBoolean("analyzer.bundle.audit.enabled", !cli.hasDisableOption("disableBundleAudit", "analyzer.bundle.audit.enabled"));
        this.settings.setBoolean("analyzer.filename.enabled", !cli.hasDisableOption("disableFileName", "analyzer.filename.enabled"));
        this.settings.setBoolean("analyzer.mix.audit.enabled", !cli.hasDisableOption("disableMixAudit", "analyzer.mix.audit.enabled"));
        this.settings.setBoolean("analyzer.openssl.enabled", !cli.hasDisableOption("disableOpenSSL", "analyzer.openssl.enabled"));
        this.settings.setBoolean("analyzer.composer.lock.enabled", !cli.hasDisableOption("disableComposer", "analyzer.composer.lock.enabled"));
        this.settings.setBoolean("analyzer.cpanfile.enabled", !cli.hasDisableOption("disableCpan", "analyzer.cpanfile.enabled"));
        this.settings.setBoolean("analyzer.golang.dep.enabled", !cli.hasDisableOption("disableGolangDep", "analyzer.golang.dep.enabled"));
        this.settings.setBoolean("analyzer.golang.mod.enabled", !cli.hasDisableOption("disableGolangMod", "analyzer.golang.mod.enabled"));
        this.settings.setBoolean("analyzer.dart.enabled", !cli.hasDisableOption("disableDart", "analyzer.dart.enabled"));
        this.settings.setBoolean("analyzer.node.package.enabled", !cli.hasDisableOption("disableNodeJS", "analyzer.node.package.enabled"));
        this.settings.setBoolean("analyzer.node.audit.enabled", !cli.isNodeAuditDisabled());
        this.settings.setBoolean("analyzer.yarn.audit.enabled", !cli.isYarnAuditDisabled());
        this.settings.setBoolean("analyzer.pnpm.audit.enabled", !cli.isPnpmAuditDisabled());
        this.settings.setBoolean("analyzer.node.audit.use.cache", !cli.hasDisableOption("disableNodeAuditCache", "analyzer.node.audit.use.cache"));
        this.settings.setBoolean("analyzer.retirejs.enabled", !cli.hasDisableOption("disableRetireJS", "analyzer.retirejs.enabled"));
        this.settings.setBoolean("analyzer.swift.package.manager.enabled", !cli.hasDisableOption("disableSwiftPackageManagerAnalyzer", "analyzer.swift.package.manager.enabled"));
        this.settings.setBoolean("analyzer.swift.package.resolved.enabled", !cli.hasDisableOption("disableSwiftPackageResolvedAnalyzer", "analyzer.swift.package.resolved.enabled"));
        this.settings.setBoolean("analyzer.cocoapods.enabled", !cli.hasDisableOption("disableCocoapodsAnalyzer", "analyzer.cocoapods.enabled"));
        this.settings.setBoolean("analyzer.ruby.gemspec.enabled", !cli.hasDisableOption("disableRubygems", "analyzer.ruby.gemspec.enabled"));
        this.settings.setBoolean("analyzer.central.enabled", !cli.hasDisableOption("disableCentral", "analyzer.central.enabled"));
        this.settings.setBoolean("analyzer.central.use.cache", !cli.hasDisableOption("disableCentralCache", "analyzer.central.use.cache"));
        this.settings.setBoolean("analyzer.ossindex.enabled", !cli.hasDisableOption("disableOssIndex", "analyzer.ossindex.enabled"));
        this.settings.setBoolean("analyzer.ossindex.use.cache", !cli.hasDisableOption("disableOssIndexCache", "analyzer.ossindex.use.cache"));
        this.settings.setBooleanIfNotNull("analyzer.node.package.skipdev", cli.hasOption("nodePackageSkipDevDependencies"));
        this.settings.setBooleanIfNotNull("analyzer.node.audit.skipdev", cli.hasOption("nodeAuditSkipDevDependencies"));
        this.settings.setBooleanIfNotNull("analyzer.nexus.enabled", cli.hasOption("enableNexus"));
        this.settings.setStringIfNotEmpty("analyzer.ossindex.user", cli.getStringArgument("ossIndexUsername"));
        this.settings.setStringIfNotEmpty("analyzer.ossindex.password", cli.getStringArgument("ossIndexPassword", "analyzer.ossindex.password"));
        this.settings.setStringIfNotEmpty("analyzer.ossindex.remote-error.warn-only", cli.getStringArgument("ossIndexRemoteErrorWarnOnly", "analyzer.ossindex.remote-error.warn-only"));
        this.settings.setFloat("junit.fail.on.cvss", cli.getFloatArgument("junitFailOnCVSS", 0.0f));
        this.settings.setBooleanIfNotNull("analyzer.artifactory.enabled", cli.hasOption("enableArtifactory"));
        this.settings.setBooleanIfNotNull("analyzer.artifactory.parallel.analysis", cli.getBooleanArgument("artifactoryParallelAnalysis"));
        this.settings.setBooleanIfNotNull("analyzer.artifactory.proxy", cli.getBooleanArgument("artifactoryUseProxy"));
        this.settings.setStringIfNotEmpty("analyzer.artifactory.url", cli.getStringArgument("artifactoryUrl"));
        this.settings.setStringIfNotEmpty("analyzer.artifactory.api.username", cli.getStringArgument("artifactoryUsername"));
        this.settings.setStringIfNotEmpty("analyzer.artifactory.api.token", cli.getStringArgument("artifactoryApiToken"));
        this.settings.setStringIfNotEmpty("analyzer.artifactory.bearer.token", cli.getStringArgument("artifactoryBearerToken"));
        this.settings.setStringIfNotEmpty("analyzer.mix.audit.path", cli.getStringArgument("mixAudit"));
        this.settings.setStringIfNotEmpty("analyzer.bundle.audit.path", cli.getStringArgument("bundleAudit"));
        this.settings.setStringIfNotEmpty("analyzer.bundle.audit.working.directory", cli.getStringArgument("bundleAuditWorkingDirectory"));
        this.settings.setStringIfNotEmpty("analyzer.nexus.url", cli.getStringArgument("nexus"));
        this.settings.setStringIfNotEmpty("analyzer.nexus.username", cli.getStringArgument("nexusUser"));
        this.settings.setStringIfNotEmpty("analyzer.nexus.password", cli.getStringArgument("nexusPass", "analyzer.nexus.password"));
        boolean nexusUsesProxy = cli.isNexusUsesProxy();
        this.settings.setBoolean("analyzer.nexus.proxy", nexusUsesProxy);
        this.settings.setStringIfNotEmpty("data.driver_name", cli.getStringArgument("dbDriverName"));
        this.settings.setStringIfNotEmpty("data.driver_path", cli.getStringArgument("dbDriverPath"));
        this.settings.setStringIfNotEmpty("data.connection_string", cli.getStringArgument("connectionString"));
        this.settings.setStringIfNotEmpty("data.user", cli.getStringArgument("dbUser"));
        this.settings.setStringIfNotEmpty("data.password", cli.getStringArgument("dbPassword", "data.password"));
        this.settings.setStringIfNotEmpty("extensions.zip", cli.getStringArgument("zipExtensions"));
        this.settings.setStringIfNotEmpty("analyzer.assembly.dotnet.path", cli.getStringArgument("dotnet"));
        this.settings.setStringIfNotEmpty("cve.url.base", cli.getStringArgument("cveUrlBase"));
        this.settings.setStringIfNotEmpty("cve.download.waittime", cli.getStringArgument("cveDownloadWait"));
        String cveModifiedJson = Optional.ofNullable(cli.getStringArgument("cveUrlModified")).filter(arg -> !arg.isEmpty()).orElseGet(() -> this.getDefaultCveUrlModified(cli));
        this.settings.setStringIfNotEmpty("cve.url.modified", cveModifiedJson);
        this.settings.setStringIfNotEmpty("cve.user", cli.getStringArgument("cveUser"));
        this.settings.setStringIfNotEmpty("cve.password", cli.getStringArgument("cvePassword", "cve.password"));
    }

    private String getDefaultCveUrlModified(CliParser cli) {
        return CveUrlParser.newInstance((Settings)this.settings).getDefaultCveUrlModified(cli.getStringArgument("cveUrlBase"));
    }

    private void prepareLogger(String verboseLog) {
        LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
        PatternLayoutEncoder encoder = new PatternLayoutEncoder();
        encoder.setPattern("%d %C:%L%n%-5level - %msg%n");
        encoder.setContext((Context)context);
        encoder.start();
        FileAppender fa = new FileAppender();
        fa.setAppend(true);
        fa.setEncoder((Encoder)encoder);
        fa.setContext((Context)context);
        fa.setFile(verboseLog);
        File f = new File(verboseLog);
        String name = f.getName();
        int i = name.lastIndexOf(46);
        if (i > 1) {
            name = name.substring(0, i);
        }
        fa.setName(name);
        fa.start();
        ch.qos.logback.classic.Logger rootLogger = context.getLogger("ROOT");
        rootLogger.setLevel(Level.DEBUG);
        ThresholdFilter filter = new ThresholdFilter();
        filter.setLevel(LogLevel.INFO.getValue());
        filter.setContext((Context)context);
        filter.start();
        rootLogger.iteratorForAppenders().forEachRemaining(action -> action.addFilter((Filter)filter));
        rootLogger.addAppender((Appender)fa);
    }

    protected String ensureCanonicalPath(String path) {
        String basePath;
        String wildCards = null;
        String file = path.replace('\\', '/');
        if (file.contains("*") || file.contains("?")) {
            int pos = this.getLastFileSeparator(file);
            if (pos < 0) {
                return file;
            }
            basePath = file.substring(0, ++pos);
            wildCards = file.substring(pos);
        } else {
            basePath = file;
        }
        File f = new File(basePath);
        try {
            f = f.getCanonicalFile();
            if (wildCards != null) {
                f = new File(f, wildCards);
            }
        }
        catch (IOException ex) {
            LOGGER.warn("Invalid path '{}' was provided.", (Object)path);
            LOGGER.debug("Invalid path provided", (Throwable)ex);
        }
        return f.getAbsolutePath().replace('\\', '/');
    }

    private int getLastFileSeparator(String file) {
        if (file.contains("*") || file.contains("?")) {
            int p1 = file.indexOf(42);
            int p2 = file.indexOf(63);
            p1 = p1 > 0 ? p1 : file.length();
            p2 = p2 > 0 ? p2 : file.length();
            int pos = p1 < p2 ? p1 : p2;
            pos = file.lastIndexOf(47, pos);
            return pos;
        }
        return file.lastIndexOf(47);
    }
}

