/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.maven;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.DateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.sink.SinkFactory;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.MavenMultiPageReport;
import org.apache.maven.reporting.MavenReportException;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.dependency.Dependency;
import org.owasp.dependencycheck.dependency.Evidence;
import org.owasp.dependencycheck.dependency.Identifier;
import org.owasp.dependencycheck.dependency.Reference;
import org.owasp.dependencycheck.dependency.Vulnerability;
import org.owasp.dependencycheck.dependency.VulnerableSoftware;
import org.owasp.dependencycheck.reporting.ReportGenerator;
import org.owasp.dependencycheck.utils.LogUtils;
import org.owasp.dependencycheck.utils.Settings;

@Mojo(name="check", defaultPhase=LifecyclePhase.COMPILE, threadSafe=true, requiresDependencyResolution=ResolutionScope.RUNTIME_PLUS_SYSTEM, requiresOnline=true)
public class DependencyCheckMojo
extends AbstractMojo
implements MavenMultiPageReport {
    private static final String PROPERTIES_FILE = "mojo.properties";
    private static final String LOG_PROPERTIES_FILE = "log.properties";
    public static final String TEST_SCOPE = "test";
    @Component
    private MavenProject project;
    @Parameter(property="report-name", defaultValue="dependency-check-report")
    private String reportName;
    @Parameter(property="logfile", defaultValue="")
    private String logFile;
    @Parameter(property="name", defaultValue="Dependency-Check")
    private String name;
    @Parameter(property="description", defaultValue="A report providing details on any published vulnerabilities within project dependencies. This report is a best effort but may contain false positives and false negatives.")
    private String description;
    @Parameter(property="reportOutputDirectory", defaultValue="${project.reporting.outputDirectory}", required=true)
    private File reportOutputDirectory;
    @Parameter(property="failBuildOnCVSS", defaultValue="11", required=true)
    private float failBuildOnCVSS = 11.0f;
    @Parameter(defaultValue="${project.build.directory}", required=true)
    private File outputDirectory;
    @Parameter(property="autoupdate", defaultValue="true", required=true)
    private boolean autoUpdate = true;
    @Parameter(property="format", defaultValue="HTML", required=true)
    private String format = "HTML";
    @Parameter(property="externalReport", defaultValue="false", required=true)
    private boolean externalReport = false;
    @Parameter(property="proxyUrl", defaultValue="", required=false)
    private String proxyUrl = null;
    @Parameter(property="proxyPort", defaultValue="", required=false)
    private String proxyPort = null;
    @Parameter(property="proxyUsername", defaultValue="", required=false)
    private String proxyUsername = null;
    @Parameter(property="proxyPassword", defaultValue="", required=false)
    private String proxyPassword = null;
    @Parameter(property="connectionTimeout", defaultValue="", required=false)
    private String connectionTimeout = null;
    @Parameter(property="suppressionFile", defaultValue="", required=false)
    private String suppressionFile = null;

    private Engine executeDependencyCheck() {
        InputStream in = DependencyCheckMojo.class.getClassLoader().getResourceAsStream(LOG_PROPERTIES_FILE);
        LogUtils.prepareLogger((InputStream)in, (String)this.logFile);
        this.populateSettings();
        Engine engine = new Engine();
        Set artifacts = this.project.getArtifacts();
        for (Artifact a : artifacts) {
            if (TEST_SCOPE.equals(a.getScope())) continue;
            engine.scan(a.getFile().getAbsolutePath());
        }
        engine.analyzeDependencies();
        return engine;
    }

    private void generateExternalReports(Engine engine) {
        ReportGenerator r = new ReportGenerator(this.project.getName(), engine.getDependencies(), engine.getAnalyzers());
        try {
            r.generateReports(this.outputDirectory.getCanonicalPath(), this.format);
        }
        catch (IOException ex) {
            Logger.getLogger(DependencyCheckMojo.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (Exception ex) {
            Logger.getLogger(DependencyCheckMojo.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void generateMavenSiteReport(Engine engine, Sink sink) {
        List dependencies = engine.getDependencies();
        this.writeSiteReportHeader(sink, this.project.getName());
        this.writeSiteReportTOC(sink, dependencies);
        int cnt = 0;
        for (Dependency d : dependencies) {
            this.writeSiteReportDependencyHeader(sink, d);
            cnt = this.writeSiteReportDependencyAnalysisExceptions(d, cnt, sink);
            cnt = this.writeSiteReportDependencyEvidenceUsed(d, cnt, sink);
            cnt = this.writeSiteReportDependencyRelatedDependencies(d, cnt, sink);
            this.writeSiteReportDependencyIdentifiers(d, sink);
            this.writeSiteReportDependencyVulnerabilities(d, sink, cnt);
        }
        sink.body_();
    }

    private void writeSiteReportDependencyVulnerabilities(Dependency d, Sink sink, int collapsibleHeaderCount) {
        int cnt = collapsibleHeaderCount;
        if (d.getVulnerabilities() != null && !d.getVulnerabilities().isEmpty()) {
            for (Vulnerability v : d.getVulnerabilities()) {
                sink.paragraph();
                sink.bold();
                try {
                    sink.link("http://web.nvd.nist.gov/view/vuln/detail?vulnId=" + URLEncoder.encode(v.getName(), "US-ASCII"));
                    sink.text(v.getName());
                    sink.link_();
                    sink.bold_();
                }
                catch (UnsupportedEncodingException ex) {
                    sink.text(v.getName());
                    sink.bold_();
                    sink.lineBreak();
                    sink.text("http://web.nvd.nist.gov/view/vuln/detail?vulnId=" + v.getName());
                }
                sink.paragraph_();
                sink.paragraph();
                sink.text("Severity: ");
                if ((double)v.getCvssScore() < 4.0) {
                    sink.text("Low");
                } else if ((double)v.getCvssScore() >= 7.0) {
                    sink.text("High");
                } else {
                    sink.text("Medium");
                }
                sink.lineBreak();
                sink.text("CVSS Score: " + v.getCvssScore());
                if (v.getCwe() != null && !v.getCwe().isEmpty()) {
                    sink.lineBreak();
                    sink.text("CWE: ");
                    sink.text(v.getCwe());
                }
                sink.paragraph_();
                sink.paragraph();
                sink.text(v.getDescription());
                if (v.getReferences() != null && !v.getReferences().isEmpty()) {
                    sink.list();
                    for (Reference ref : v.getReferences()) {
                        sink.listItem();
                        sink.text(ref.getSource());
                        sink.text(" - ");
                        sink.link(ref.getUrl());
                        sink.text(ref.getName());
                        sink.link_();
                        sink.listItem_();
                    }
                    sink.list_();
                }
                sink.paragraph_();
                if (v.getVulnerableSoftware() == null || v.getVulnerableSoftware().isEmpty()) continue;
                sink.paragraph();
                sink.rawText("Vulnerable Software <a href=\"javascript:toggleElement(this, 'vulnSoft" + ++cnt + "')\">[-]</a>");
                sink.rawText("<div id=\"vulnSoft" + cnt + "\" style=\"display:block\">");
                sink.list();
                for (VulnerableSoftware vs : v.getVulnerableSoftware()) {
                    sink.listItem();
                    try {
                        sink.link("http://web.nvd.nist.gov/view/vuln/search-results?cpe=" + URLEncoder.encode(vs.getName(), "US-ASCII"));
                        sink.text(vs.getName());
                        sink.link_();
                        if (vs.hasPreviousVersion()) {
                            sink.text(" and all previous versions.");
                        }
                    }
                    catch (UnsupportedEncodingException ex) {
                        sink.text(vs.getName());
                        if (vs.hasPreviousVersion()) {
                            sink.text(" and all previous versions.");
                        }
                        sink.text(" (http://web.nvd.nist.gov/view/vuln/search-results?cpe=" + vs.getName() + ")");
                    }
                    sink.listItem_();
                }
                sink.list_();
                sink.rawText("</div>");
                sink.paragraph_();
            }
        }
    }

    private void writeSiteReportDependencyIdentifiers(Dependency d, Sink sink) {
        if (d.getIdentifiers() != null && !d.getIdentifiers().isEmpty()) {
            sink.sectionTitle4();
            sink.text("Identifiers");
            sink.sectionTitle4_();
            sink.list();
            for (Identifier i : d.getIdentifiers()) {
                sink.listItem();
                sink.text(i.getType());
                sink.text(": ");
                if (i.getUrl() != null && i.getUrl().length() > 0) {
                    sink.link(i.getUrl());
                    sink.text(i.getValue());
                    sink.link_();
                } else {
                    sink.text(i.getValue());
                }
                if (i.getDescription() != null && i.getDescription().length() > 0) {
                    sink.lineBreak();
                    sink.text(i.getDescription());
                }
                sink.listItem_();
            }
            sink.list_();
        }
    }

    private int writeSiteReportDependencyRelatedDependencies(Dependency d, int collapsibleHeaderCount, Sink sink) {
        int cnt = collapsibleHeaderCount;
        if (d.getRelatedDependencies() != null && !d.getRelatedDependencies().isEmpty()) {
            sink.sectionTitle4();
            sink.rawText("Related Dependencies <a href=\"javascript:toggleElement(this, 'related" + ++cnt + "')\">[+]</a>");
            sink.sectionTitle4_();
            sink.rawText("<div id=\"related" + cnt + "\" style=\"display:none\">");
            sink.list();
            for (Dependency r : d.getRelatedDependencies()) {
                sink.listItem();
                sink.text(r.getFileName());
                sink.list();
                this.writeListItem(sink, "File Path: " + r.getFilePath());
                this.writeListItem(sink, "SHA1: " + r.getSha1sum());
                this.writeListItem(sink, "MD5: " + r.getMd5sum());
                sink.list_();
                sink.listItem_();
            }
            sink.list_();
            sink.rawText("</div>");
        }
        return cnt;
    }

    private int writeSiteReportDependencyEvidenceUsed(Dependency d, int collapsibleHeaderCount, Sink sink) {
        int cnt = collapsibleHeaderCount;
        if (d.getEvidenceUsed() != null && d.getEvidenceUsed().size() > 0) {
            sink.sectionTitle4();
            sink.rawText("Evidence Collected <a href=\"javascript:toggleElement(this, 'evidence" + ++cnt + "')\">[+]</a>");
            sink.sectionTitle4_();
            sink.rawText("<div id=\"evidence" + cnt + "\" style=\"display:none\">");
            sink.table();
            sink.tableRow();
            this.writeTableHeaderCell(sink, "Source");
            this.writeTableHeaderCell(sink, "Name");
            this.writeTableHeaderCell(sink, "Value");
            sink.tableRow_();
            for (Evidence e : d.getEvidenceUsed()) {
                sink.tableRow();
                this.writeTableCell(sink, e.getSource());
                this.writeTableCell(sink, e.getName());
                this.writeTableCell(sink, e.getValue());
                sink.tableRow_();
            }
            sink.table_();
            sink.rawText("</div>");
        }
        return cnt;
    }

    private int writeSiteReportDependencyAnalysisExceptions(Dependency d, int collapsibleHeaderCount, Sink sink) {
        int cnt = collapsibleHeaderCount;
        if (d.getAnalysisExceptions() != null && !d.getAnalysisExceptions().isEmpty()) {
            sink.sectionTitle4();
            sink.rawText("<font style=\"color:red\">Errors occurred during analysis:</font> <a href=\"javascript:toggleElement(this, 'errors" + ++cnt + "')\">[+]</a>");
            sink.sectionTitle4_();
            sink.rawText("<div id=\"errors" + cnt + "\">");
            sink.list();
            for (Exception e : d.getAnalysisExceptions()) {
                sink.listItem();
                sink.text(e.getMessage());
                sink.listItem_();
            }
            sink.list_();
            sink.rawText("</div>");
        }
        return cnt;
    }

    private void writeSiteReportDependencyHeader(Sink sink, Dependency d) {
        sink.sectionTitle2();
        sink.anchor("sha1" + d.getSha1sum());
        sink.text(d.getFileName());
        sink.anchor_();
        sink.sectionTitle2_();
        if (d.getDescription() != null && d.getDescription().length() > 0) {
            sink.paragraph();
            sink.bold();
            sink.text("Description: ");
            sink.bold_();
            sink.text(d.getDescription());
            sink.paragraph_();
        }
        if (d.getLicense() != null && d.getLicense().length() > 0) {
            sink.paragraph();
            sink.bold();
            sink.text("License: ");
            sink.bold_();
            if (d.getLicense().startsWith("http://") && !d.getLicense().contains(" ")) {
                sink.link(d.getLicense());
                sink.text(d.getLicense());
                sink.link_();
            } else {
                sink.text(d.getLicense());
            }
            sink.paragraph_();
        }
    }

    private void writeListItem(Sink sink, String text) {
        sink.listItem();
        sink.text(text);
        sink.listItem_();
    }

    private void writeTableCell(Sink sink, String text) {
        sink.tableCell();
        sink.text(text);
        sink.tableCell_();
    }

    private void writeTableHeaderCell(Sink sink, String text) {
        sink.tableHeaderCell();
        sink.text(text);
        sink.tableHeaderCell_();
    }

    private void writeSiteReportTOC(Sink sink, List<Dependency> dependencies) {
        sink.list();
        for (Dependency d : dependencies) {
            sink.listItem();
            sink.link("#sha1" + d.getSha1sum());
            sink.text(d.getFileName());
            sink.link_();
            if (!d.getVulnerabilities().isEmpty()) {
                sink.rawText(" <font style=\"color:red\">\u2022</font>");
            }
            if (!d.getRelatedDependencies().isEmpty()) {
                sink.list();
                for (Dependency r : d.getRelatedDependencies()) {
                    this.writeListItem(sink, r.getFileName());
                }
                sink.list_();
            }
            sink.listItem_();
        }
        sink.list_();
    }

    private void writeSiteReportHeader(Sink sink, String projectName) {
        sink.head();
        sink.title();
        sink.text("Dependency-Check Report: " + projectName);
        sink.title_();
        sink.head_();
        sink.body();
        sink.rawText("<script type=\"text/javascript\">");
        sink.rawText("function toggleElement(el, targetId) {");
        sink.rawText("if (el.innerText == '[+]') {");
        sink.rawText("    el.innerText = '[-]';");
        sink.rawText("    document.getElementById(targetId).style.display='block';");
        sink.rawText("} else {");
        sink.rawText("    el.innerText = '[+]';");
        sink.rawText("    document.getElementById(targetId).style.display='none';");
        sink.rawText("}");
        sink.rawText("}");
        sink.rawText("</script>");
        sink.section1();
        sink.sectionTitle1();
        sink.text("Project: " + projectName);
        sink.sectionTitle1_();
        sink.date();
        Date now = new Date();
        sink.text(DateFormat.getDateTimeInstance().format(now));
        sink.date_();
        sink.section1_();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateSettings() {
        InputStream mojoProperties = null;
        try {
            mojoProperties = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(PROPERTIES_FILE);
            Settings.mergeProperties((InputStream)mojoProperties);
        }
        catch (IOException ex) {
            Logger.getLogger(DependencyCheckMojo.class.getName()).log(Level.WARNING, "Unable to load the dependency-check ant task.properties file.");
            Logger.getLogger(DependencyCheckMojo.class.getName()).log(Level.FINE, null, ex);
        }
        finally {
            if (mojoProperties != null) {
                try {
                    mojoProperties.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(DependencyCheckMojo.class.getName()).log(Level.FINEST, null, ex);
                }
            }
        }
        Settings.setBoolean((String)"autoupdate", (boolean)this.autoUpdate);
        if (this.proxyUrl != null && !this.proxyUrl.isEmpty()) {
            Settings.setString((String)"proxy.url", (String)this.proxyUrl);
        }
        if (this.proxyPort != null && !this.proxyPort.isEmpty()) {
            Settings.setString((String)"proxy.port", (String)this.proxyPort);
        }
        if (this.proxyUsername != null && !this.proxyUsername.isEmpty()) {
            Settings.setString((String)"proxy.username", (String)this.proxyUsername);
        }
        if (this.proxyPassword != null && !this.proxyPassword.isEmpty()) {
            Settings.setString((String)"proxy.password", (String)this.proxyPassword);
        }
        if (this.connectionTimeout != null && !this.connectionTimeout.isEmpty()) {
            Settings.setString((String)"connection.timeout", (String)this.connectionTimeout);
        }
        if (this.suppressionFile != null && !this.suppressionFile.isEmpty()) {
            Settings.setString((String)"suppression.file", (String)this.suppressionFile);
        }
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        Engine engine = this.executeDependencyCheck();
        this.generateExternalReports(engine);
        if (this.failBuildOnCVSS <= 10.0f) {
            this.checkForFailure(engine.getDependencies());
        }
    }

    public void generate(org.codehaus.doxia.sink.Sink sink, Locale locale) throws MavenReportException {
        this.generate((Sink)sink, null, locale);
    }

    public void generate(Sink sink, SinkFactory sinkFactory, Locale locale) throws MavenReportException {
        Engine engine = this.executeDependencyCheck();
        this.generateMavenSiteReport(engine, sink);
    }

    public String getOutputName() {
        return this.reportName;
    }

    public String getCategoryName() {
        return "Project Reports";
    }

    public String getName(Locale locale) {
        return this.name;
    }

    public void setReportOutputDirectory(File directory) {
        this.reportOutputDirectory = directory;
    }

    public File getReportOutputDirectory() {
        return this.reportOutputDirectory;
    }

    public String getDescription(Locale locale) {
        return this.description;
    }

    public boolean isExternalReport() {
        return this.externalReport;
    }

    public boolean canGenerateReport() {
        return true;
    }

    private void checkForFailure(List<Dependency> dependencies) throws MojoFailureException {
        StringBuilder ids = new StringBuilder();
        for (Dependency d : dependencies) {
            for (Vulnerability v : d.getVulnerabilities()) {
                if (!(v.getCvssScore() >= this.failBuildOnCVSS)) continue;
                if (ids.length() == 0) {
                    ids.append(v.getName());
                    continue;
                }
                ids.append(", ").append(v.getName());
            }
        }
        if (ids.length() > 0) {
            String msg = String.format("%n%nDependency-Check Failure:%nOne or more dependencies were identified with vulnerabilities that have a CVSS score greater then '%.1f': %s%nSee the dependency-check report for more details.%n%n", Float.valueOf(this.failBuildOnCVSS), ids.toString());
            throw new MojoFailureException(msg);
        }
    }
}

