/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.maven;

import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.owasp.dependencycheck.data.nvdcve.DatabaseException;
import org.owasp.dependencycheck.maven.BaseDependencyCheckMojo;
import org.owasp.dependencycheck.maven.Engine;
import org.owasp.dependencycheck.utils.Settings;

@Mojo(name="update-only", defaultPhase=LifecyclePhase.GENERATE_RESOURCES, threadSafe=true, requiresDependencyResolution=ResolutionScope.NONE, requiresOnline=true)
public class UpdateMojo
extends BaseDependencyCheckMojo {
    private static final Logger LOGGER = Logger.getLogger(UpdateMojo.class.getName());

    public boolean canGenerateReport() {
        return false;
    }

    @Override
    public void runCheck() throws MojoExecutionException, MojoFailureException {
        Engine engine;
        try {
            engine = this.initializeEngine();
            engine.update();
        }
        catch (DatabaseException ex) {
            LOGGER.log(Level.FINE, "Database connection error", ex);
            throw new MojoExecutionException("An exception occured connecting to the local database. Please see the log file for more details.", (Exception)((Object)ex));
        }
        engine.cleanup();
        Settings.cleanup();
    }

    public String getName(Locale locale) {
        return "dependency-check-update";
    }

    public String getDescription(Locale locale) {
        return "Updates the local cache of the NVD data from NIST.";
    }
}

