/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.maven;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.DateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.doxia.sink.SinkFactory;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.MavenMultiPageReport;
import org.apache.maven.reporting.MavenReportException;
import org.apache.maven.settings.Proxy;
import org.codehaus.doxia.sink.Sink;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.data.nvdcve.CveDB;
import org.owasp.dependencycheck.data.nvdcve.DatabaseException;
import org.owasp.dependencycheck.data.nvdcve.DatabaseProperties;
import org.owasp.dependencycheck.dependency.Dependency;
import org.owasp.dependencycheck.dependency.Evidence;
import org.owasp.dependencycheck.dependency.Identifier;
import org.owasp.dependencycheck.dependency.Reference;
import org.owasp.dependencycheck.dependency.Vulnerability;
import org.owasp.dependencycheck.dependency.VulnerableSoftware;
import org.owasp.dependencycheck.reporting.ReportGenerator;
import org.owasp.dependencycheck.utils.LogUtils;
import org.owasp.dependencycheck.utils.Settings;

@Mojo(name="check", defaultPhase=LifecyclePhase.COMPILE, threadSafe=true, requiresDependencyResolution=ResolutionScope.RUNTIME_PLUS_SYSTEM, requiresOnline=true)
public class DependencyCheckMojo
extends AbstractMojo
implements MavenMultiPageReport {
    private final Logger logger = Logger.getLogger(DependencyCheckMojo.class.getName());
    private static final String PROPERTIES_FILE = "mojo.properties";
    private static final String LOG_PROPERTIES_FILE = "log.properties";
    private static final String NEW_LINE = System.getProperty("line.separator", "\n").intern();
    @Component
    private MavenProject project;
    @Parameter(property="logfile", defaultValue="")
    private String logFile;
    @Parameter(property="name", defaultValue="Dependency-Check")
    private String name;
    @Parameter(property="description", defaultValue="A report providing details on any published vulnerabilities within project dependencies. This report is a best effort but may contain false positives and false negatives.")
    private String description;
    @Parameter(property="reportOutputDirectory", defaultValue="${project.reporting.outputDirectory}", required=true)
    private File reportOutputDirectory;
    @Parameter(defaultValue="${project.build.directory}", required=true)
    private File outputDirectory;
    @Parameter(property="failBuildOnCVSS", defaultValue="11", required=true)
    private float failBuildOnCVSS = 11.0f;
    @Parameter(property="autoupdate", defaultValue="true", required=true)
    private boolean autoUpdate = true;
    @Parameter(property="format", defaultValue="HTML", required=true)
    private String format = "HTML";
    @Parameter(property="externalReport", defaultValue="false", required=true)
    private boolean externalReport = false;
    @Parameter(property="mavenSettings", defaultValue="${settings}", required=false)
    private org.apache.maven.settings.Settings mavenSettings;
    @Parameter(property="mavenSettingsProxyId", required=false)
    private String mavenSettingsProxyId;
    @Parameter(property="connectionTimeout", defaultValue="", required=false)
    private String connectionTimeout = null;
    @Parameter(property="suppressionFile", defaultValue="", required=false)
    private String suppressionFile = null;
    @Parameter(property="showSummary", defaultValue="true", required=false)
    private boolean showSummary = true;
    @Parameter(property="jarAnalyzerEnabled", defaultValue="true", required=false)
    private boolean jarAnalyzerEnabled = true;
    @Parameter(property="archiveAnalyzerEnabled", defaultValue="true", required=false)
    private boolean archiveAnalyzerEnabled = true;
    @Parameter(property="assemblyAnalyzerEnabled", defaultValue="true", required=false)
    private boolean assemblyAnalyzerEnabled = true;
    @Parameter(property="nuspecAnalyzerEnabled", defaultValue="true", required=false)
    private boolean nuspecAnalyzerEnabled = true;
    @Parameter(property="nexusAnalyzerEnabled", defaultValue="true", required=false)
    private boolean nexusAnalyzerEnabled = true;
    @Parameter(property="nexusUrl", defaultValue="", required=false)
    private String nexusUrl;
    @Parameter(property="nexusUsesProxy", defaultValue="true", required=false)
    private boolean nexusUsesProxy = true;
    @Parameter(property="connectionString", defaultValue="", required=false)
    private String connectionString;
    @Parameter(property="databaseDriverName", defaultValue="", required=false)
    private String databaseDriverName;
    @Parameter(property="databaseDriverPath", defaultValue="", required=false)
    private String databaseDriverPath;
    @Parameter(property="databaseUser", defaultValue="", required=false)
    private String databaseUser;
    @Parameter(property="databasePassword", defaultValue="", required=false)
    private String databasePassword;
    @Parameter(property="zipExtensions", required=false)
    private String zipExtensions;
    @Parameter(property="skipTestScope", defaultValue="true", required=false)
    private boolean skipTestScope = true;
    @Parameter(property="skipRuntimeScope", defaultValue="false", required=false)
    private boolean skipRuntimeScope = false;
    @Parameter(property="skipProvidedScope", defaultValue="false", required=false)
    private boolean skipProvidedScope = false;
    @Parameter(property="dataDirectory", defaultValue="", required=false)
    private String dataDirectory;
    @Parameter(property="cveUrl12Modified", defaultValue="", required=false)
    private String cveUrl12Modified;
    @Parameter(property="cveUrl20Modified", defaultValue="", required=false)
    private String cveUrl20Modified;
    @Parameter(property="cveUrl12Base", defaultValue="", required=false)
    private String cveUrl12Base;
    @Parameter(property="cveUrl20Base", defaultValue="", required=false)
    private String cveUrl20Base;
    @Parameter(property="pathToMono", defaultValue="", required=false)
    private String pathToMono;
    @Deprecated
    @Parameter(property="proxyUrl", defaultValue="", required=false)
    private String proxyUrl = null;

    private Engine executeDependencyCheck() throws DatabaseException {
        InputStream in = DependencyCheckMojo.class.getClassLoader().getResourceAsStream(LOG_PROPERTIES_FILE);
        LogUtils.prepareLogger((InputStream)in, (String)this.logFile);
        this.populateSettings();
        Engine engine = new Engine();
        Set artifacts = this.project.getArtifacts();
        for (Artifact a : artifacts) {
            if (this.skipTestScope && "test".equals(a.getScope()) || this.skipProvidedScope && "provided".equals(a.getScope()) || this.skipRuntimeScope && !"runtime".equals(a.getScope())) continue;
            engine.scan(a.getFile().getAbsolutePath());
        }
        engine.analyzeDependencies();
        return engine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateExternalReports(Engine engine, File outDirectory) {
        DatabaseProperties prop = null;
        CveDB cve = null;
        try {
            cve = new CveDB();
            cve.open();
            prop = cve.getDatabaseProperties();
        }
        catch (DatabaseException ex) {
            this.logger.log(Level.FINE, "Unable to retrieve DB Properties", ex);
        }
        finally {
            if (cve != null) {
                cve.close();
            }
        }
        ReportGenerator r = new ReportGenerator(this.project.getName(), engine.getDependencies(), engine.getAnalyzers(), prop);
        try {
            r.generateReports(outDirectory.getCanonicalPath(), this.format);
        }
        catch (IOException ex) {
            this.logger.log(Level.SEVERE, "Unexpected exception occurred during analysis; please see the verbose error log for more details.");
            this.logger.log(Level.FINE, null, ex);
        }
        catch (Throwable ex) {
            this.logger.log(Level.SEVERE, "Unexpected exception occurred during analysis; please see the verbose error log for more details.");
            this.logger.log(Level.FINE, null, ex);
        }
    }

    private void generateMavenSiteReport(Engine engine, org.apache.maven.doxia.sink.Sink sink) {
        List dependencies = engine.getDependencies();
        this.writeSiteReportHeader(sink, this.project.getName());
        this.writeSiteReportTOC(sink, dependencies);
        int cnt = 0;
        for (Dependency d : dependencies) {
            this.writeSiteReportDependencyHeader(sink, d);
            cnt = this.writeSiteReportDependencyEvidenceUsed(d, cnt, sink);
            cnt = this.writeSiteReportDependencyRelatedDependencies(d, cnt, sink);
            this.writeSiteReportDependencyIdentifiers(d, sink);
            this.writeSiteReportDependencyVulnerabilities(d, sink, cnt);
        }
        sink.body_();
    }

    private void writeSiteReportDependencyVulnerabilities(Dependency d, org.apache.maven.doxia.sink.Sink sink, int collapsibleHeaderCount) {
        int cnt = collapsibleHeaderCount;
        if (d.getVulnerabilities() != null && !d.getVulnerabilities().isEmpty()) {
            for (Vulnerability v : d.getVulnerabilities()) {
                sink.paragraph();
                sink.bold();
                try {
                    sink.link("http://web.nvd.nist.gov/view/vuln/detail?vulnId=" + URLEncoder.encode(v.getName(), "US-ASCII"));
                    sink.text(v.getName());
                    sink.link_();
                    sink.bold_();
                }
                catch (UnsupportedEncodingException ex) {
                    sink.text(v.getName());
                    sink.bold_();
                    sink.lineBreak();
                    sink.text("http://web.nvd.nist.gov/view/vuln/detail?vulnId=" + v.getName());
                }
                sink.paragraph_();
                sink.paragraph();
                sink.text("Severity: ");
                if ((double)v.getCvssScore() < 4.0) {
                    sink.text("Low");
                } else if ((double)v.getCvssScore() >= 7.0) {
                    sink.text("High");
                } else {
                    sink.text("Medium");
                }
                sink.lineBreak();
                sink.text("CVSS Score: " + v.getCvssScore());
                if (v.getCwe() != null && !v.getCwe().isEmpty()) {
                    sink.lineBreak();
                    sink.text("CWE: ");
                    sink.text(v.getCwe());
                }
                sink.paragraph_();
                sink.paragraph();
                sink.text(v.getDescription());
                if (v.getReferences() != null && !v.getReferences().isEmpty()) {
                    sink.list();
                    for (Reference ref : v.getReferences()) {
                        sink.listItem();
                        sink.text(ref.getSource());
                        sink.text(" - ");
                        sink.link(ref.getUrl());
                        sink.text(ref.getName());
                        sink.link_();
                        sink.listItem_();
                    }
                    sink.list_();
                }
                sink.paragraph_();
                if (v.getVulnerableSoftware() == null || v.getVulnerableSoftware().isEmpty()) continue;
                sink.paragraph();
                sink.rawText("Vulnerable Software <a href=\"javascript:toggleElement(this, 'vulnSoft" + ++cnt + "')\">[-]</a>");
                sink.rawText("<div id=\"vulnSoft" + cnt + "\" style=\"display:block\">");
                sink.list();
                for (VulnerableSoftware vs : v.getVulnerableSoftware()) {
                    sink.listItem();
                    try {
                        sink.link("http://web.nvd.nist.gov/view/vuln/search-results?cpe=" + URLEncoder.encode(vs.getName(), "US-ASCII"));
                        sink.text(vs.getName());
                        sink.link_();
                        if (vs.hasPreviousVersion()) {
                            sink.text(" and all previous versions.");
                        }
                    }
                    catch (UnsupportedEncodingException ex) {
                        sink.text(vs.getName());
                        if (vs.hasPreviousVersion()) {
                            sink.text(" and all previous versions.");
                        }
                        sink.text(" (http://web.nvd.nist.gov/view/vuln/search-results?cpe=" + vs.getName() + ")");
                    }
                    sink.listItem_();
                }
                sink.list_();
                sink.rawText("</div>");
                sink.paragraph_();
            }
        }
    }

    private void writeSiteReportDependencyIdentifiers(Dependency d, org.apache.maven.doxia.sink.Sink sink) {
        if (d.getIdentifiers() != null && !d.getIdentifiers().isEmpty()) {
            sink.sectionTitle4();
            sink.text("Identifiers");
            sink.sectionTitle4_();
            sink.list();
            for (Identifier i : d.getIdentifiers()) {
                sink.listItem();
                sink.text(i.getType());
                sink.text(": ");
                if (i.getUrl() != null && i.getUrl().length() > 0) {
                    sink.link(i.getUrl());
                    sink.text(i.getValue());
                    sink.link_();
                } else {
                    sink.text(i.getValue());
                }
                if (i.getDescription() != null && i.getDescription().length() > 0) {
                    sink.lineBreak();
                    sink.text(i.getDescription());
                }
                sink.listItem_();
            }
            sink.list_();
        }
    }

    private int writeSiteReportDependencyRelatedDependencies(Dependency d, int collapsibleHeaderCount, org.apache.maven.doxia.sink.Sink sink) {
        int cnt = collapsibleHeaderCount;
        if (d.getRelatedDependencies() != null && !d.getRelatedDependencies().isEmpty()) {
            sink.sectionTitle4();
            sink.rawText("Related Dependencies <a href=\"javascript:toggleElement(this, 'related" + ++cnt + "')\">[+]</a>");
            sink.sectionTitle4_();
            sink.rawText("<div id=\"related" + cnt + "\" style=\"display:none\">");
            sink.list();
            for (Dependency r : d.getRelatedDependencies()) {
                sink.listItem();
                sink.text(r.getFileName());
                sink.list();
                this.writeListItem(sink, "File Path: " + r.getFilePath());
                this.writeListItem(sink, "SHA1: " + r.getSha1sum());
                this.writeListItem(sink, "MD5: " + r.getMd5sum());
                sink.list_();
                sink.listItem_();
            }
            sink.list_();
            sink.rawText("</div>");
        }
        return cnt;
    }

    private int writeSiteReportDependencyEvidenceUsed(Dependency d, int collapsibleHeaderCount, org.apache.maven.doxia.sink.Sink sink) {
        int cnt = collapsibleHeaderCount;
        Set evidence = d.getEvidenceForDisplay();
        if (evidence != null && evidence.size() > 0) {
            sink.sectionTitle4();
            sink.rawText("Evidence Collected <a href=\"javascript:toggleElement(this, 'evidence" + ++cnt + "')\">[+]</a>");
            sink.sectionTitle4_();
            sink.rawText("<div id=\"evidence" + cnt + "\" style=\"display:none\">");
            sink.table();
            sink.tableRow();
            this.writeTableHeaderCell(sink, "Source");
            this.writeTableHeaderCell(sink, "Name");
            this.writeTableHeaderCell(sink, "Value");
            sink.tableRow_();
            for (Evidence e : evidence) {
                sink.tableRow();
                this.writeTableCell(sink, e.getSource());
                this.writeTableCell(sink, e.getName());
                this.writeTableCell(sink, e.getValue());
                sink.tableRow_();
            }
            sink.table_();
            sink.rawText("</div>");
        }
        return cnt;
    }

    private void writeSiteReportDependencyHeader(org.apache.maven.doxia.sink.Sink sink, Dependency d) {
        sink.sectionTitle2();
        sink.anchor("sha1" + d.getSha1sum());
        sink.text(d.getFileName());
        sink.anchor_();
        sink.sectionTitle2_();
        if (d.getDescription() != null && d.getDescription().length() > 0) {
            sink.paragraph();
            sink.bold();
            sink.text("Description: ");
            sink.bold_();
            sink.text(d.getDescription());
            sink.paragraph_();
        }
        if (d.getLicense() != null && d.getLicense().length() > 0) {
            sink.paragraph();
            sink.bold();
            sink.text("License: ");
            sink.bold_();
            if (d.getLicense().startsWith("http://") && !d.getLicense().contains(" ")) {
                sink.link(d.getLicense());
                sink.text(d.getLicense());
                sink.link_();
            } else {
                sink.text(d.getLicense());
            }
            sink.paragraph_();
        }
    }

    private void writeListItem(org.apache.maven.doxia.sink.Sink sink, String text) {
        sink.listItem();
        sink.text(text);
        sink.listItem_();
    }

    private void writeTableCell(org.apache.maven.doxia.sink.Sink sink, String text) {
        sink.tableCell();
        sink.text(text);
        sink.tableCell_();
    }

    private void writeTableHeaderCell(org.apache.maven.doxia.sink.Sink sink, String text) {
        sink.tableHeaderCell();
        sink.text(text);
        sink.tableHeaderCell_();
    }

    private void writeSiteReportTOC(org.apache.maven.doxia.sink.Sink sink, List<Dependency> dependencies) {
        sink.list();
        for (Dependency d : dependencies) {
            sink.listItem();
            sink.link("#sha1" + d.getSha1sum());
            sink.text(d.getFileName());
            sink.link_();
            if (!d.getVulnerabilities().isEmpty()) {
                sink.rawText(" <font style=\"color:red\">\u2022</font>");
            }
            if (!d.getRelatedDependencies().isEmpty()) {
                sink.list();
                for (Dependency r : d.getRelatedDependencies()) {
                    this.writeListItem(sink, r.getFileName());
                }
                sink.list_();
            }
            sink.listItem_();
        }
        sink.list_();
    }

    private void writeSiteReportHeader(org.apache.maven.doxia.sink.Sink sink, String projectName) {
        sink.head();
        sink.title();
        sink.text("Dependency-Check Report: " + projectName);
        sink.title_();
        sink.head_();
        sink.body();
        sink.rawText("<script type=\"text/javascript\">");
        sink.rawText("function toggleElement(el, targetId) {");
        sink.rawText("if (el.innerText == '[+]') {");
        sink.rawText("    el.innerText = '[-]';");
        sink.rawText("    document.getElementById(targetId).style.display='block';");
        sink.rawText("} else {");
        sink.rawText("    el.innerText = '[+]';");
        sink.rawText("    document.getElementById(targetId).style.display='none';");
        sink.rawText("}");
        sink.rawText("}");
        sink.rawText("</script>");
        sink.section1();
        sink.sectionTitle1();
        sink.text("Project: " + projectName);
        sink.sectionTitle1_();
        sink.date();
        Date now = new Date();
        sink.text(DateFormat.getDateTimeInstance().format(now));
        sink.date_();
        sink.section1_();
    }

    private String getMavenSettingsProxyServer(Proxy proxy) {
        return proxy.getProtocol() + "://" + proxy.getHost();
    }

    private Proxy getMavenProxy() {
        List proxies;
        if (this.mavenSettings != null && (proxies = this.mavenSettings.getProxies()) != null && proxies.size() > 0) {
            if (this.mavenSettingsProxyId != null) {
                for (Proxy proxy : proxies) {
                    if (!this.mavenSettingsProxyId.equalsIgnoreCase(proxy.getId())) continue;
                    return proxy;
                }
            } else {
                if (proxies.size() == 1) {
                    return (Proxy)proxies.get(0);
                }
                throw new IllegalStateException("Ambiguous proxy definition");
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateSettings() {
        Proxy proxy;
        Settings.initialize();
        InputStream mojoProperties = null;
        try {
            mojoProperties = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(PROPERTIES_FILE);
            Settings.mergeProperties((InputStream)mojoProperties);
        }
        catch (IOException ex) {
            this.logger.log(Level.WARNING, "Unable to load the dependency-check ant task.properties file.");
            this.logger.log(Level.FINE, null, ex);
        }
        finally {
            if (mojoProperties != null) {
                try {
                    mojoProperties.close();
                }
                catch (IOException ex) {
                    this.logger.log(Level.FINEST, null, ex);
                }
            }
        }
        Settings.setBoolean((String)"autoupdate", (boolean)this.autoUpdate);
        if (this.proxyUrl != null && !this.proxyUrl.isEmpty()) {
            this.logger.warning("Deprecated configuration detected, proxyUrl will be ignored; use the maven settings to configure the proxy instead");
        }
        if ((proxy = this.getMavenProxy()) != null) {
            Settings.setString((String)"proxy.server", (String)this.getMavenSettingsProxyServer(proxy));
            Settings.setString((String)"proxy.port", (String)Integer.toString(proxy.getPort()));
            String userName = proxy.getUsername();
            String password = proxy.getPassword();
            if (userName != null && password != null) {
                Settings.setString((String)"proxy.username", (String)userName);
                Settings.setString((String)"proxy.password", (String)password);
            }
        }
        if (this.connectionTimeout != null && !this.connectionTimeout.isEmpty()) {
            Settings.setString((String)"connection.timeout", (String)this.connectionTimeout);
        }
        if (this.suppressionFile != null && !this.suppressionFile.isEmpty()) {
            Settings.setString((String)"suppression.file", (String)this.suppressionFile);
        }
        Settings.setBoolean((String)"analyzer.jar.enabled", (boolean)this.jarAnalyzerEnabled);
        Settings.setBoolean((String)"analyzer.nuspec.enabled", (boolean)this.nuspecAnalyzerEnabled);
        Settings.setBoolean((String)"analyzer.nexus.enabled", (boolean)this.nexusAnalyzerEnabled);
        if (this.nexusUrl != null && !this.nexusUrl.isEmpty()) {
            Settings.setString((String)"analyzer.nexus.url", (String)this.nexusUrl);
        }
        Settings.setBoolean((String)"analyzer.nexus.proxy", (boolean)this.nexusUsesProxy);
        Settings.setBoolean((String)"analyzer.archive.enabled", (boolean)this.archiveAnalyzerEnabled);
        if (this.zipExtensions != null && !this.zipExtensions.isEmpty()) {
            Settings.setString((String)"extensions.zip", (String)this.zipExtensions);
        }
        Settings.setBoolean((String)"analyzer.assembly.enabled", (boolean)this.assemblyAnalyzerEnabled);
        if (this.pathToMono != null && !this.pathToMono.isEmpty()) {
            Settings.setString((String)"analyzer.assembly.mono.path", (String)this.pathToMono);
        }
        if (this.databaseDriverName != null && !this.databaseDriverName.isEmpty()) {
            Settings.setString((String)"data.driver_name", (String)this.databaseDriverName);
        }
        if (this.databaseDriverPath != null && !this.databaseDriverPath.isEmpty()) {
            Settings.setString((String)"data.driver_path", (String)this.databaseDriverPath);
        }
        if (this.connectionString != null && !this.connectionString.isEmpty()) {
            Settings.setString((String)"data.connection_string", (String)this.connectionString);
        }
        if (this.databaseUser != null && !this.databaseUser.isEmpty()) {
            Settings.setString((String)"data.user", (String)this.databaseUser);
        }
        if (this.databasePassword != null && !this.databasePassword.isEmpty()) {
            Settings.setString((String)"data.password", (String)this.databasePassword);
        }
        if (this.dataDirectory != null && !this.dataDirectory.isEmpty()) {
            Settings.setString((String)"data.directory", (String)this.dataDirectory);
        }
        Settings.setBoolean((String)"skip.test.scope", (boolean)this.skipTestScope);
        Settings.setBoolean((String)"skip.runtime.scope", (boolean)this.skipRuntimeScope);
        Settings.setBoolean((String)"skip.provided.scope", (boolean)this.skipProvidedScope);
        if (this.cveUrl12Modified != null && !this.cveUrl12Modified.isEmpty()) {
            Settings.setString((String)"cve.url-1.2.modified", (String)this.cveUrl12Modified);
        }
        if (this.cveUrl20Modified != null && !this.cveUrl20Modified.isEmpty()) {
            Settings.setString((String)"cve.url-2.0.modified", (String)this.cveUrl20Modified);
        }
        if (this.cveUrl12Base != null && !this.cveUrl12Base.isEmpty()) {
            Settings.setString((String)"cve.url-1.2.base", (String)this.cveUrl12Base);
        }
        if (this.cveUrl20Base != null && !this.cveUrl20Base.isEmpty()) {
            Settings.setString((String)"cve.url-2.0.base", (String)this.cveUrl20Base);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        Engine engine = null;
        try {
            engine = this.executeDependencyCheck();
            this.generateExternalReports(engine, this.outputDirectory);
            if (this.showSummary) {
                this.showSummary(engine.getDependencies());
            }
            if (this.failBuildOnCVSS <= 10.0f) {
                this.checkForFailure(engine.getDependencies());
            }
        }
        catch (DatabaseException ex) {
            this.logger.log(Level.SEVERE, "Unable to connect to the dependency-check database; analysis has stopped");
            this.logger.log(Level.FINE, "", ex);
        }
        finally {
            Settings.cleanup((boolean)true);
            if (engine != null) {
                engine.cleanup();
            }
        }
    }

    public void generate(Sink sink, Locale locale) throws MavenReportException {
        this.generate((org.apache.maven.doxia.sink.Sink)sink, null, locale);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate(org.apache.maven.doxia.sink.Sink sink, SinkFactory sinkFactory, Locale locale) throws MavenReportException {
        Engine engine = null;
        try {
            engine = this.executeDependencyCheck();
            if (this.externalReport) {
                this.generateExternalReports(engine, this.reportOutputDirectory);
            } else {
                this.generateMavenSiteReport(engine, sink);
            }
        }
        catch (DatabaseException ex) {
            this.logger.log(Level.SEVERE, "Unable to connect to the dependency-check database; analysis has stopped");
            this.logger.log(Level.FINE, "", ex);
        }
        finally {
            Settings.cleanup((boolean)true);
            if (engine != null) {
                engine.cleanup();
            }
        }
    }

    public String getOutputName() {
        if ("HTML".equalsIgnoreCase(this.format) || "ALL".equalsIgnoreCase(this.format)) {
            return "dependency-check-report";
        }
        if ("XML".equalsIgnoreCase(this.format)) {
            return "dependency-check-report.xml#";
        }
        if ("VULN".equalsIgnoreCase(this.format)) {
            return "dependency-check-vulnerability";
        }
        this.logger.log(Level.WARNING, "Unknown report format used during site generation.");
        return "dependency-check-report";
    }

    public String getCategoryName() {
        return "Project Reports";
    }

    public String getName(Locale locale) {
        return this.name;
    }

    public void setReportOutputDirectory(File directory) {
        this.reportOutputDirectory = directory;
    }

    public File getReportOutputDirectory() {
        return this.reportOutputDirectory;
    }

    public String getDescription(Locale locale) {
        return this.description;
    }

    public boolean isExternalReport() {
        return this.externalReport;
    }

    public boolean canGenerateReport() {
        return true;
    }

    private void checkForFailure(List<Dependency> dependencies) throws MojoFailureException {
        StringBuilder ids = new StringBuilder();
        for (Dependency d : dependencies) {
            boolean addName = true;
            for (Vulnerability v : d.getVulnerabilities()) {
                if (!(v.getCvssScore() >= this.failBuildOnCVSS)) continue;
                if (addName) {
                    addName = false;
                    ids.append(NEW_LINE).append(d.getFileName()).append(": ");
                    ids.append(v.getName());
                    continue;
                }
                ids.append(", ").append(v.getName());
            }
        }
        if (ids.length() > 0) {
            String msg = String.format("%n%nDependency-Check Failure:%nOne or more dependencies were identified with vulnerabilities that have a CVSS score greater then '%.1f': %s%nSee the dependency-check report for more details.%n%n", Float.valueOf(this.failBuildOnCVSS), ids.toString());
            throw new MojoFailureException(msg);
        }
    }

    private void showSummary(List<Dependency> dependencies) {
        StringBuilder summary = new StringBuilder();
        for (Dependency d : dependencies) {
            boolean firstEntry = true;
            StringBuilder ids = new StringBuilder();
            for (Vulnerability v : d.getVulnerabilities()) {
                if (firstEntry) {
                    firstEntry = false;
                } else {
                    ids.append(", ");
                }
                ids.append(v.getName());
            }
            if (ids.length() <= 0) continue;
            summary.append(d.getFileName()).append(" (");
            firstEntry = true;
            for (Identifier id : d.getIdentifiers()) {
                if (firstEntry) {
                    firstEntry = false;
                } else {
                    summary.append(", ");
                }
                summary.append(id.getValue());
            }
            summary.append(") : ").append((CharSequence)ids).append(NEW_LINE);
        }
        if (summary.length() > 0) {
            String msg = String.format("%n%nOne or more dependencies were identified with known vulnerabilities:%n%n%s%n%nSee the dependency-check report for more details.%n%n", summary.toString());
            this.logger.log(Level.WARNING, msg);
        }
    }
}

