/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.maven;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.MavenReport;
import org.apache.maven.reporting.MavenReportException;

public abstract class ReportAggregationMojo
extends AbstractMojo
implements MavenReport {
    @Component
    private MavenProject project;
    private static final Logger LOGGER = Logger.getLogger(ReportAggregationMojo.class.getName());
    @Parameter(readonly=true, required=true, property="reactorProjects")
    private List<MavenProject> reactorProjects;
    @Parameter(property="aggregate", defaultValue="false")
    private boolean aggregate;
    @Parameter(property="metaFileName", defaultValue="dependency-check.ser", required=true)
    private String dataFileName;
    @Parameter(property="reportOutputDirectory", defaultValue="${project.reporting.outputDirectory}", required=true)
    private File reportOutputDirectory;
    private final Map<MavenProject, Set<MavenProject>> projectChildren = new HashMap<MavenProject, Set<MavenProject>>();

    public void setReportOutputDirectory(File directory) {
        this.reportOutputDirectory = directory;
    }

    public File getReportOutputDirectory() {
        return this.reportOutputDirectory;
    }

    public File getReportOutputDirectory(MavenProject project) {
        Object o = project.getContextValue(this.getOutputDirectoryContextKey());
        if (o != null && o instanceof File) {
            return (File)o;
        }
        return null;
    }

    public final boolean isExternalReport() {
        return true;
    }

    protected void preExecute() throws MojoExecutionException, MojoFailureException {
        this.buildAggregateInfo();
    }

    protected abstract void performExecute() throws MojoExecutionException, MojoFailureException;

    protected void postExecute() throws MojoExecutionException, MojoFailureException {
        File written = this.writeDataFile();
        if (written != null) {
            this.project.setContextValue(this.getDataFileContextKey(), (Object)written.getAbsolutePath());
        }
    }

    protected String getDataFileContextKey() {
        return "dependency-check-path-" + this.getDataFileName();
    }

    protected String getOutputDirectoryContextKey() {
        return "dependency-output-dir-" + this.getDataFileName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void execute() throws MojoExecutionException, MojoFailureException {
        try {
            this.preExecute();
            this.performExecute();
        }
        finally {
            this.postExecute();
        }
    }

    protected void preGenerate() throws MavenReportException {
        this.buildAggregateInfo();
        this.project.setContextValue(this.getOutputDirectoryContextKey(), (Object)this.getReportOutputDirectory());
    }

    protected void postGenerate() throws MavenReportException {
        File written = this.writeDataFile();
        if (written != null) {
            this.project.setContextValue(this.getDataFileContextKey(), (Object)written.getAbsolutePath());
        }
    }

    protected abstract void executeNonAggregateReport(Locale var1) throws MavenReportException;

    protected abstract void executeAggregateReport(MavenProject var1, Locale var2) throws MavenReportException;

    @Deprecated
    public final void generate(org.codehaus.doxia.sink.Sink sink, Locale locale) throws MavenReportException {
        this.generate((Sink)sink, locale);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void generate(Sink sink, Locale locale) throws MavenReportException {
        try {
            this.preGenerate();
            if (this.canGenerateNonAggregateReport()) {
                this.executeNonAggregateReport(locale);
            }
            if (this.canGenerateAggregateReport()) {
                for (MavenProject proj : this.reactorProjects) {
                    if (!this.isMultiModule(proj)) continue;
                    this.executeAggregateReport(proj, locale);
                }
            }
        }
        finally {
            this.postGenerate();
        }
    }

    protected abstract boolean canGenerateNonAggregateReport();

    protected abstract boolean canGenerateAggregateReport();

    protected String getDataFileName() {
        return this.dataFileName;
    }

    protected abstract File writeDataFile();

    private void buildAggregateInfo() {
        for (MavenProject proj : this.reactorProjects) {
            Set<MavenProject> depList = this.projectChildren.get(proj.getParent());
            if (depList == null) {
                depList = new HashSet<MavenProject>();
                this.projectChildren.put(proj.getParent(), depList);
            }
            depList.add(proj);
        }
    }

    protected List<MavenProject> getAllChildren() {
        return this.getAllChildren(this.project);
    }

    protected List<MavenProject> getAllChildren(MavenProject parentProject) {
        Set<MavenProject> children = this.projectChildren.get(parentProject);
        if (children == null) {
            return Collections.emptyList();
        }
        ArrayList<MavenProject> result = new ArrayList<MavenProject>();
        for (MavenProject child : children) {
            if (this.isMultiModule(child)) {
                result.addAll(this.getAllChildren(child));
                continue;
            }
            result.add(child);
        }
        return result;
    }

    protected List<File> getAllChildDataFiles(MavenProject project) {
        List<MavenProject> children = this.getAllChildren(project);
        return this.getDataFiles(children);
    }

    protected List<File> getDataFiles(List<MavenProject> projects) {
        ArrayList<File> files = new ArrayList<File>();
        for (MavenProject proj : projects) {
            Object path = this.project.getContextValue(this.getDataFileContextKey());
            if (path == null) {
                String msg = String.format("Unable to aggregate data for '%s' - aggregate data file was not generated", proj.getName());
                LOGGER.warning(msg);
                continue;
            }
            File outputFile = new File((String)path);
            if (outputFile.exists()) {
                files.add(outputFile);
                continue;
            }
            if (this.isMultiModule(this.project)) continue;
            String msg = String.format("Unable to aggregate data for '%s' - missing data file '%s'", proj.getName(), outputFile.getPath());
            LOGGER.warning(msg);
        }
        return files;
    }

    protected boolean isMultiModule(MavenProject mavenProject) {
        return "pom".equals(mavenProject.getPackaging());
    }

    protected boolean isMultiModule() {
        return this.isMultiModule(this.project);
    }

    protected boolean isLastProject() {
        return this.project.equals((Object)this.reactorProjects.get(this.reactorProjects.size() - 1));
    }

    public boolean isAggregate() {
        return this.aggregate;
    }

    protected MavenProject getProject() {
        return this.project;
    }
}

