/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.maven;

import java.util.logging.Logger;
import org.apache.maven.project.MavenProject;
import org.owasp.dependencycheck.analyzer.Analyzer;
import org.owasp.dependencycheck.analyzer.CPEAnalyzer;
import org.owasp.dependencycheck.data.nvdcve.DatabaseException;

public class Engine
extends org.owasp.dependencycheck.Engine {
    private static final transient Logger LOGGER = Logger.getLogger(Engine.class.getName());
    private static final String CPE_ANALYZER_KEY = "dependency-check-CPEAnalyzer";
    private MavenProject currentProject;

    public Engine(MavenProject project) throws DatabaseException {
        this.currentProject = project;
        MavenProject parent = this.getRootParent();
        if (parent != null && parent.getContextValue("dependency-check-data-was-updated") != null) {
            System.setProperty("autoupdate", Boolean.FALSE.toString());
        }
        this.initializeEngine();
        if (parent != null) {
            parent.setContextValue("dependency-check-data-was-updated", (Object)true);
        }
    }

    private Engine() throws DatabaseException {
    }

    protected Analyzer initializeAnalyzer(Analyzer analyzer) {
        if (analyzer instanceof CPEAnalyzer) {
            CPEAnalyzer cpe = this.getPreviouslyLoadedAnalyzer();
            if (cpe != null) {
                return cpe;
            }
            cpe = (CPEAnalyzer)super.initializeAnalyzer(analyzer);
            this.storeCPEAnalyzer(cpe);
        }
        return super.initializeAnalyzer(analyzer);
    }

    protected void closeAnalyzer(Analyzer analyzer) {
        if (analyzer instanceof CPEAnalyzer) {
            if (this.getPreviouslyLoadedAnalyzer() == null) {
                super.closeAnalyzer(analyzer);
            }
        } else {
            super.closeAnalyzer(analyzer);
        }
    }

    public void cleanupFinal() {
        CPEAnalyzer cpe = this.getPreviouslyLoadedAnalyzer();
        if (cpe != null) {
            cpe.close();
        }
    }

    private CPEAnalyzer getPreviouslyLoadedAnalyzer() {
        CPEAnalyzer cpe = null;
        MavenProject project = this.getRootParent();
        if (project != null) {
            cpe = (CPEAnalyzer)project.getContextValue(CPE_ANALYZER_KEY);
        }
        return cpe;
    }

    private void storeCPEAnalyzer(CPEAnalyzer cpe) {
        MavenProject p = this.getRootParent();
        if (p != null) {
            p.setContextValue(CPE_ANALYZER_KEY, (Object)cpe);
        }
    }

    private MavenProject getRootParent() {
        if (this.currentProject == null) {
            return null;
        }
        MavenProject p = this.currentProject;
        while (p.getParent() != null) {
            p = p.getParent();
        }
        return p;
    }
}

