/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.maven;

import java.util.List;
import java.util.logging.Logger;
import org.apache.maven.project.MavenProject;
import org.owasp.dependencycheck.analyzer.Analyzer;
import org.owasp.dependencycheck.analyzer.CPEAnalyzer;
import org.owasp.dependencycheck.analyzer.FileTypeAnalyzer;
import org.owasp.dependencycheck.data.nvdcve.DatabaseException;

public class Engine
extends org.owasp.dependencycheck.Engine {
    private static final transient Logger LOGGER = Logger.getLogger(Engine.class.getName());
    private static final String CPE_ANALYZER_KEY = "dependency-check-CPEAnalyzer";
    private MavenProject currentProject;
    private List<MavenProject> reactorProjects;
    public static final String UPDATE_EXECUTED_FLAG = "dependency-check-update-executed";

    public Engine(MavenProject project, List<MavenProject> reactorProjects) throws DatabaseException {
        this.currentProject = project;
        this.reactorProjects = reactorProjects;
        this.initializeEngine();
    }

    public void analyzeDependencies() {
        MavenProject root = this.getExecutionRoot();
        if (root != null) {
            LOGGER.fine(String.format("Checking root project, %s, if updates have already been completed", root.getArtifactId()));
        } else {
            LOGGER.fine("Checking root project, null, if updates have already been completed");
        }
        if (root != null && root.getContextValue(UPDATE_EXECUTED_FLAG) != null) {
            System.setProperty("autoupdate", Boolean.FALSE.toString());
        }
        super.analyzeDependencies();
        if (root != null) {
            root.setContextValue(UPDATE_EXECUTED_FLAG, (Object)Boolean.TRUE);
        }
    }

    private Engine() throws DatabaseException {
    }

    protected Analyzer initializeAnalyzer(Analyzer analyzer) {
        if (analyzer instanceof CPEAnalyzer) {
            CPEAnalyzer cpe = this.getPreviouslyLoadedCPEAnalyzer();
            if (cpe != null) {
                return cpe;
            }
            cpe = (CPEAnalyzer)super.initializeAnalyzer(analyzer);
            this.storeCPEAnalyzer(cpe);
        }
        return super.initializeAnalyzer(analyzer);
    }

    public void cleanup() {
        CPEAnalyzer cpe;
        super.cleanup();
        if (this.currentProject == null || this.reactorProjects == null) {
            return;
        }
        if (this.currentProject == this.reactorProjects.get(this.reactorProjects.size() - 1) && (cpe = this.getPreviouslyLoadedCPEAnalyzer()) != null) {
            cpe.close();
        }
    }

    protected void closeAnalyzer(Analyzer analyzer) {
        if (analyzer instanceof CPEAnalyzer) {
            if (this.getPreviouslyLoadedCPEAnalyzer() == null) {
                super.closeAnalyzer(analyzer);
            }
        } else {
            super.closeAnalyzer(analyzer);
        }
    }

    private CPEAnalyzer getPreviouslyLoadedCPEAnalyzer() {
        Object obj;
        CPEAnalyzer cpe = null;
        MavenProject project = this.getExecutionRoot();
        if (project != null && (obj = project.getContextValue(CPE_ANALYZER_KEY)) != null && obj instanceof CPEAnalyzer) {
            cpe = (CPEAnalyzer)project.getContextValue(CPE_ANALYZER_KEY);
        }
        return cpe;
    }

    private void storeCPEAnalyzer(CPEAnalyzer cpe) {
        MavenProject p = this.getExecutionRoot();
        if (p != null) {
            p.setContextValue(CPE_ANALYZER_KEY, (Object)cpe);
        }
    }

    private MavenProject getExecutionRoot() {
        if (this.reactorProjects == null) {
            return null;
        }
        for (MavenProject p : this.reactorProjects) {
            if (!p.isExecutionRoot()) continue;
            return p;
        }
        if (this.currentProject == null) {
            return null;
        }
        MavenProject p = this.currentProject;
        while (p.getParent() != null) {
            p = p.getParent();
        }
        return p;
    }

    public void resetFileTypeAnalyzers() {
        for (FileTypeAnalyzer a : this.getFileTypeAnalyzers()) {
            a.reset();
        }
    }
}

