/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.maven;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.analyzer.DependencyBundlingAnalyzer;
import org.owasp.dependencycheck.analyzer.exception.AnalysisException;
import org.owasp.dependencycheck.data.nvdcve.DatabaseException;
import org.owasp.dependencycheck.dependency.Dependency;
import org.owasp.dependencycheck.maven.BaseDependencyCheckMojo;
import org.owasp.dependencycheck.utils.Settings;

@Mojo(name="aggregate", defaultPhase=LifecyclePhase.COMPILE, threadSafe=true, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, requiresOnline=true)
public class AggregateMojo
extends BaseDependencyCheckMojo {
    @Override
    public void runCheck() throws MojoExecutionException, MojoFailureException {
        org.owasp.dependencycheck.maven.Engine engine = this.generateDataFile();
        if (this.getProject() == this.getReactorProjects().get(this.getReactorProjects().size() - 1)) {
            for (MavenProject current : this.getReactorProjects()) {
                File dataFile = this.getDataFile(current);
                if (dataFile != null) continue;
                this.getLog().error((CharSequence)String.format("Module '%s' did not execute dependency-check; an attempt will be made to perform the check but dependencies may be missed resulting in false negatives.", current.getName()));
                this.generateDataFile(engine, current);
            }
            for (MavenProject current : this.getReactorProjects()) {
                List<Dependency> dependencies = this.readDataFile(current);
                if (dependencies == null) {
                    dependencies = new ArrayList<Dependency>();
                }
                Set<MavenProject> childProjects = this.getDescendants(current);
                for (MavenProject reportOn : childProjects) {
                    List<Dependency> childDeps = this.readDataFile(reportOn);
                    if (childDeps != null && !childDeps.isEmpty()) {
                        if (this.getLog().isDebugEnabled()) {
                            this.getLog().debug((CharSequence)String.format("Adding %d dependencies from %s", childDeps.size(), reportOn.getName()));
                        }
                        dependencies.addAll(childDeps);
                        continue;
                    }
                    if (!this.getLog().isDebugEnabled()) continue;
                    this.getLog().debug((CharSequence)String.format("No dependencies read for %s", reportOn.getName()));
                }
                engine.getDependencies().clear();
                engine.getDependencies().addAll(dependencies);
                DependencyBundlingAnalyzer bundler = new DependencyBundlingAnalyzer();
                try {
                    if (this.getLog().isDebugEnabled()) {
                        this.getLog().debug((CharSequence)String.format("Dependency count pre-bundler: %s", engine.getDependencies().size()));
                    }
                    bundler.analyze(null, (Engine)engine);
                    if (this.getLog().isDebugEnabled()) {
                        this.getLog().debug((CharSequence)String.format("Dependency count post-bundler: %s", engine.getDependencies().size()));
                    }
                }
                catch (AnalysisException ex) {
                    this.getLog().warn((CharSequence)"An error occured grouping the dependencies; duplicate entries may exist in the report", (Throwable)ex);
                    this.getLog().debug((CharSequence)"Bundling Exception", (Throwable)ex);
                }
                File outputDir = this.getCorrectOutputDirectory(current);
                if (outputDir == null) {
                    outputDir = new File(current.getBuild().getDirectory());
                }
                this.writeReports(engine, current, outputDir);
            }
        }
        engine.cleanup();
        Settings.cleanup();
    }

    protected Set<MavenProject> getDescendants(MavenProject project) {
        if (project == null) {
            return Collections.emptySet();
        }
        HashSet<MavenProject> descendants = new HashSet<MavenProject>();
        int size = 0;
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)String.format("Collecting descendants of %s", project.getName()));
        }
        for (String m : project.getModules()) {
            for (MavenProject mod : this.getReactorProjects()) {
                try {
                    File mpp = new File(project.getBasedir(), m);
                    if ((mpp = mpp.getCanonicalFile()).compareTo(mod.getBasedir()) != 0 || !descendants.add(mod) || !this.getLog().isDebugEnabled()) continue;
                    this.getLog().debug((CharSequence)String.format("Decendent module %s added", mod.getName()));
                }
                catch (IOException ex) {
                    if (!this.getLog().isDebugEnabled()) continue;
                    this.getLog().debug((CharSequence)"Unable to determine module path", (Throwable)ex);
                }
            }
        }
        do {
            size = descendants.size();
            for (MavenProject p : this.getReactorProjects()) {
                if (project.equals((Object)p.getParent()) || descendants.contains(p.getParent())) {
                    if (descendants.add(p) && this.getLog().isDebugEnabled()) {
                        this.getLog().debug((CharSequence)String.format("Decendent %s added", p.getName()));
                    }
                    for (MavenProject modTest : this.getReactorProjects()) {
                        if (p.getModules() == null || !p.getModules().contains(modTest.getName()) || !descendants.add(modTest) || !this.getLog().isDebugEnabled()) continue;
                        this.getLog().debug((CharSequence)String.format("Decendent %s added", modTest.getName()));
                    }
                }
                for (MavenProject dec : descendants) {
                    for (String mod : dec.getModules()) {
                        try {
                            File mpp = new File(dec.getBasedir(), mod);
                            if ((mpp = mpp.getCanonicalFile()).compareTo(p.getBasedir()) != 0 || !descendants.add(p) || !this.getLog().isDebugEnabled()) continue;
                            this.getLog().debug((CharSequence)String.format("Decendent module %s added", p.getName()));
                        }
                        catch (IOException ex) {
                            if (!this.getLog().isDebugEnabled()) continue;
                            this.getLog().debug((CharSequence)"Unable to determine module path", (Throwable)ex);
                        }
                    }
                }
            }
        } while (size != 0 && size != descendants.size());
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)String.format("%s has %d children", project, descendants.size()));
        }
        return descendants;
    }

    protected boolean isMultiModule(MavenProject mavenProject) {
        return "pom".equals(mavenProject.getPackaging());
    }

    protected org.owasp.dependencycheck.maven.Engine generateDataFile() throws MojoExecutionException, MojoFailureException {
        org.owasp.dependencycheck.maven.Engine engine;
        try {
            engine = this.initializeEngine();
        }
        catch (DatabaseException ex) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)"Database connection error", (Throwable)ex);
            }
            throw new MojoExecutionException("An exception occured connecting to the local database. Please see the log file for more details.", (Exception)((Object)ex));
        }
        return this.generateDataFile(engine, this.getProject());
    }

    protected org.owasp.dependencycheck.maven.Engine generateDataFile(org.owasp.dependencycheck.maven.Engine engine, MavenProject project) throws MojoExecutionException, MojoFailureException {
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)String.format("Begin Scanning: %s", project.getName()));
        }
        engine.getDependencies().clear();
        engine.resetFileTypeAnalyzers();
        this.scanArtifacts(project, engine);
        engine.analyzeDependencies();
        File target = new File(project.getBuild().getDirectory());
        this.writeDataFile(project, target, engine.getDependencies());
        this.showSummary(project, engine.getDependencies());
        this.checkForFailure(engine.getDependencies());
        return engine;
    }

    public boolean canGenerateReport() {
        return true;
    }

    public String getName(Locale locale) {
        return "dependency-check:aggregate";
    }

    public String getDescription(Locale locale) {
        return "Generates an aggregate report of all child Maven projects providing details on any published vulnerabilities within project dependencies. This report is a best effort and may contain false positives and false negatives.";
    }
}

