/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.maven;

import java.util.Locale;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.owasp.dependencycheck.data.nvdcve.DatabaseException;
import org.owasp.dependencycheck.exception.ExceptionCollection;
import org.owasp.dependencycheck.exception.ReportException;
import org.owasp.dependencycheck.maven.BaseDependencyCheckMojo;
import org.owasp.dependencycheck.maven.MavenEngine;
import org.owasp.dependencycheck.utils.Settings;

@Mojo(name="check", defaultPhase=LifecyclePhase.VERIFY, threadSafe=false, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, requiresOnline=true)
public class CheckMojo
extends BaseDependencyCheckMojo {
    @Parameter(property="name", defaultValue="dependency-check", required=true)
    private String name = "dependency-check";

    public boolean canGenerateReport() {
        boolean isCapable = false;
        for (Artifact a : this.getProject().getArtifacts()) {
            if (this.excludeFromScan(a.getScope())) continue;
            isCapable = true;
            break;
        }
        return isCapable;
    }

    @Override
    public void runCheck() throws MojoExecutionException, MojoFailureException {
        MavenEngine engine = null;
        try {
            engine = this.initializeEngine();
        }
        catch (DatabaseException ex) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)"Database connection error", (Throwable)ex);
            }
            String msg = "An exception occured connecting to the local database. Please see the log file for more details.";
            if (this.isFailOnError()) {
                throw new MojoExecutionException("An exception occured connecting to the local database. Please see the log file for more details.", (Exception)((Object)ex));
            }
            this.getLog().error((CharSequence)"An exception occured connecting to the local database. Please see the log file for more details.");
        }
        if (engine != null) {
            ExceptionCollection exCol = this.scanArtifacts(this.getProject(), engine);
            if (engine.getDependencies().isEmpty()) {
                this.getLog().info((CharSequence)"No dependencies were identified that could be analyzed by dependency-check");
            } else {
                try {
                    engine.analyzeDependencies();
                }
                catch (ExceptionCollection ex) {
                    if (this.isFailOnError() && ex.isFatal()) {
                        throw new MojoExecutionException("One or more exceptions occured during analysis", (Exception)((Object)ex));
                    }
                    exCol = ex;
                }
                if (exCol == null || !exCol.isFatal()) {
                    block15: {
                        try {
                            this.writeReports(engine, this.getProject(), this.getCorrectOutputDirectory());
                        }
                        catch (ReportException ex) {
                            if (!this.isFailOnError()) break block15;
                            if (exCol != null) {
                                exCol.addException((Throwable)ex);
                            }
                            exCol = new ExceptionCollection("Unable to write the dependency-check report", (Throwable)ex);
                        }
                    }
                    this.writeDataFile(this.getProject(), null, engine.getDependencies());
                    this.showSummary(this.getProject(), engine.getDependencies());
                    this.checkForFailure(engine.getDependencies());
                    if (exCol != null && this.isFailOnError()) {
                        throw new MojoExecutionException("One or more exceptions occured during dependency-check analysis", (Exception)((Object)exCol));
                    }
                }
            }
            engine.cleanup();
        }
        Settings.cleanup();
    }

    public String getName(Locale locale) {
        return this.name;
    }

    public String getDescription(Locale locale) {
        return "Generates a report providing details on any published vulnerabilities within project dependencies. This report is a best effort and may contain false positives and false negatives.";
    }
}

