/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.maven;

import java.util.Locale;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.owasp.dependencycheck.data.nvdcve.DatabaseException;
import org.owasp.dependencycheck.data.update.exception.UpdateException;
import org.owasp.dependencycheck.maven.BaseDependencyCheckMojo;
import org.owasp.dependencycheck.maven.MavenEngine;
import org.owasp.dependencycheck.utils.Settings;

@Mojo(name="update-only", defaultPhase=LifecyclePhase.GENERATE_RESOURCES, threadSafe=false, requiresDependencyResolution=ResolutionScope.NONE, requiresOnline=true)
public class UpdateMojo
extends BaseDependencyCheckMojo {
    public boolean canGenerateReport() {
        return false;
    }

    @Override
    public void runCheck() throws MojoExecutionException, MojoFailureException {
        MavenEngine engine = null;
        try {
            engine = this.initializeEngine();
            engine.update();
        }
        catch (DatabaseException ex) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)"Database connection error", (Throwable)ex);
            }
            String msg = "An exception occurred connecting to the local database. Please see the log file for more details.";
            if (this.isFailOnError()) {
                throw new MojoExecutionException("An exception occurred connecting to the local database. Please see the log file for more details.", (Exception)((Object)ex));
            }
            this.getLog().error((CharSequence)"An exception occurred connecting to the local database. Please see the log file for more details.");
        }
        catch (UpdateException ex) {
            String msg = "An exception occurred while downloading updates. Please see the log file for more details.";
            if (this.isFailOnError()) {
                throw new MojoExecutionException("An exception occurred while downloading updates. Please see the log file for more details.", (Exception)((Object)ex));
            }
            this.getLog().error((CharSequence)"An exception occurred while downloading updates. Please see the log file for more details.");
        }
        if (engine != null) {
            engine.cleanup();
        }
        Settings.cleanup();
    }

    public String getName(Locale locale) {
        return "dependency-check-update";
    }

    public String getDescription(Locale locale) {
        return "Updates the local cache of the NVD data from NIST.";
    }
}

