/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.maven;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.reporting.MavenReport;
import org.apache.maven.reporting.MavenReportException;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Server;
import org.apache.maven.shared.artifact.ArtifactCoordinate;
import org.apache.maven.shared.artifact.TransferUtils;
import org.apache.maven.shared.artifact.resolve.ArtifactResolver;
import org.apache.maven.shared.artifact.resolve.ArtifactResolverException;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilder;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilderException;
import org.apache.maven.shared.dependency.graph.DependencyNode;
import org.codehaus.doxia.sink.Sink;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.data.nexus.MavenArtifact;
import org.owasp.dependencycheck.data.nvdcve.DatabaseException;
import org.owasp.dependencycheck.dependency.Confidence;
import org.owasp.dependencycheck.dependency.Identifier;
import org.owasp.dependencycheck.dependency.Vulnerability;
import org.owasp.dependencycheck.exception.DependencyNotFoundException;
import org.owasp.dependencycheck.exception.ExceptionCollection;
import org.owasp.dependencycheck.maven.ArtifactScopeExcluded;
import org.owasp.dependencycheck.maven.ArtifactTypeExcluded;
import org.owasp.dependencycheck.utils.Filter;
import org.owasp.dependencycheck.utils.Settings;
import org.sonatype.plexus.components.sec.dispatcher.DefaultSecDispatcher;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcher;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcherException;

public abstract class BaseDependencyCheckMojo
extends AbstractMojo
implements MavenReport {
    private static final String PROPERTIES_FILE = "mojo.properties";
    private static final String NEW_LINE = System.getProperty("line.separator", "\n").intern();
    private boolean generatingSite = false;
    @Parameter(property="metaFileName", defaultValue="dependency-check.ser", required=true)
    private String dataFileName;
    @Parameter(property="failOnError", defaultValue="true", required=true)
    private boolean failOnError;
    @Parameter(property="project", required=true, readonly=true)
    private MavenProject project;
    @Parameter(readonly=true, required=true, property="reactorProjects")
    private List<MavenProject> reactorProjects;
    @Component
    private ArtifactResolver artifactResolver;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    private MavenSession session;
    @Parameter(defaultValue="${project.remoteArtifactRepositories}", readonly=true, required=true)
    private List<ArtifactRepository> remoteRepositories;
    @Component
    private DependencyGraphBuilder dependencyGraphBuilder;
    @Parameter(defaultValue="${project.build.directory}", required=true)
    private File outputDirectory;
    @Parameter(property="project.reporting.outputDirectory", required=true)
    private File reportOutputDirectory;
    @Parameter(property="failBuildOnCVSS", defaultValue="11", required=true)
    private float failBuildOnCVSS = 11.0f;
    @Parameter(property="failBuildOnAnyVulnerability", defaultValue="false", required=true)
    private boolean failBuildOnAnyVulnerability = false;
    @Parameter(property="autoUpdate")
    private Boolean autoUpdate;
    @Parameter(property="enableExperimental")
    private Boolean enableExperimental;
    @Deprecated
    @Parameter(property="aggregate")
    private Boolean aggregate;
    @Parameter(property="format", defaultValue="HTML", required=true)
    private String format = "HTML";
    @Parameter(property="mavenSettings", defaultValue="${settings}", required=false)
    private org.apache.maven.settings.Settings mavenSettings;
    @Parameter(property="mavenSettingsProxyId", required=false)
    private String mavenSettingsProxyId;
    @Parameter(property="connectionTimeout", defaultValue="", required=false)
    private String connectionTimeout;
    @Parameter(required=false)
    private String[] suppressionFiles;
    @Parameter(required=false)
    private String suppressionFile;
    @Parameter(property="hintsFile", defaultValue="", required=false)
    private String hintsFile;
    @Parameter(property="showSummary", defaultValue="true", required=false)
    private boolean showSummary = true;
    @Parameter(property="jarAnalyzerEnabled", required=false)
    private Boolean jarAnalyzerEnabled;
    @Parameter(property="archiveAnalyzerEnabled", required=false)
    private Boolean archiveAnalyzerEnabled;
    @Parameter(property="pyDistributionAnalyzerEnabled", required=false)
    private Boolean pyDistributionAnalyzerEnabled;
    @Parameter(property="pyPackageAnalyzerEnabled", required=false)
    private Boolean pyPackageAnalyzerEnabled;
    @Parameter(property="rubygemsAnalyzerEnabled", required=false)
    private Boolean rubygemsAnalyzerEnabled;
    @Parameter(property="opensslAnalyzerEnabled", required=false)
    private Boolean opensslAnalyzerEnabled;
    @Parameter(property="cmakeAnalyzerEnabled", required=false)
    private Boolean cmakeAnalyzerEnabled;
    @Parameter(property="autoconfAnalyzerEnabled", required=false)
    private Boolean autoconfAnalyzerEnabled;
    @Parameter(property="composerAnalyzerEnabled", required=false)
    private Boolean composerAnalyzerEnabled;
    @Parameter(property="nodeAnalyzerEnabled", required=false)
    private Boolean nodeAnalyzerEnabled;
    @Parameter(property="nspAnalyzerEnabled", required=false)
    private Boolean nspAnalyzerEnabled;
    @Parameter(property="assemblyAnalyzerEnabled", required=false)
    private Boolean assemblyAnalyzerEnabled;
    @Parameter(property="nuspecAnalyzerEnabled", required=false)
    private Boolean nuspecAnalyzerEnabled;
    @Parameter(property="centralAnalyzerEnabled", required=false)
    private Boolean centralAnalyzerEnabled;
    @Parameter(property="nexusAnalyzerEnabled", required=false)
    private Boolean nexusAnalyzerEnabled;
    @Parameter(property="bundleAuditAnalyzerEnabled", required=false)
    private Boolean bundleAuditAnalyzerEnabled;
    @Parameter(property="bundleAuditPath", defaultValue="", required=false)
    private String bundleAuditPath;
    @Parameter(property="cocoapodsAnalyzerEnabled", required=false)
    private Boolean cocoapodsAnalyzerEnabled;
    @Parameter(property="swiftPackageManagerAnalyzerEnabled", required=false)
    private Boolean swiftPackageManagerAnalyzerEnabled;
    @Parameter(property="nexusUrl", required=false)
    private String nexusUrl;
    @Parameter(property="nexusUsesProxy", required=false)
    private Boolean nexusUsesProxy;
    @Parameter(property="connectionString", defaultValue="", required=false)
    private String connectionString;
    @Parameter(property="databaseDriverName", defaultValue="", required=false)
    private String databaseDriverName;
    @Parameter(property="databaseDriverPath", defaultValue="", required=false)
    private String databaseDriverPath;
    @Parameter(property="serverId", defaultValue="", required=false)
    private String serverId;
    @Parameter(defaultValue="${settings}", readonly=true, required=true)
    private org.apache.maven.settings.Settings settingsXml;
    @Component(role=SecDispatcher.class, hint="default")
    private SecDispatcher securityDispatcher;
    @Parameter(property="databaseUser", defaultValue="", required=false)
    private String databaseUser;
    @Parameter(property="databasePassword", defaultValue="", required=false)
    private String databasePassword;
    @Parameter(property="zipExtensions", required=false)
    private String zipExtensions;
    @Parameter(property="dependency-check.skip", defaultValue="false", required=false)
    private boolean skip = false;
    @Parameter(property="skipTestScope", defaultValue="true", required=false)
    private boolean skipTestScope = true;
    @Parameter(property="skipRuntimeScope", defaultValue="false", required=false)
    private boolean skipRuntimeScope = false;
    @Parameter(property="skipProvidedScope", defaultValue="false", required=false)
    private boolean skipProvidedScope = false;
    @Parameter(property="skipSystemScope", defaultValue="false", required=false)
    private boolean skipSystemScope = false;
    @Parameter(property="skipArtifactType", required=false)
    private String skipArtifactType;
    @Parameter(property="dataDirectory", defaultValue="", required=false)
    private String dataDirectory;
    @Parameter(property="cveUrl12Modified", defaultValue="", required=false)
    private String cveUrl12Modified;
    @Parameter(property="cveUrl20Modified", defaultValue="", required=false)
    private String cveUrl20Modified;
    @Parameter(property="cveUrl12Base", defaultValue="", required=false)
    private String cveUrl12Base;
    @Parameter(property="cveUrl20Base", defaultValue="", required=false)
    private String cveUrl20Base;
    @Parameter(property="cveValidForHours", defaultValue="", required=false)
    private Integer cveValidForHours;
    @Parameter(property="pathToMono", defaultValue="", required=false)
    private String pathToMono;
    @Deprecated
    @Parameter(property="proxyUrl", defaultValue="", required=false)
    private String proxyUrl = null;
    @Deprecated
    @Parameter(property="externalReport")
    private String externalReport = null;
    private Filter<String> artifactScopeExcluded;
    private Filter<String> artifactTypeExcluded;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.generatingSite = false;
        if (this.skip) {
            this.getLog().info((CharSequence)("Skipping " + this.getName(Locale.US)));
        } else {
            this.validateAggregate();
            this.project.setContextValue(this.getOutputDirectoryContextKey(), (Object)this.outputDirectory);
            this.runCheck();
        }
    }

    private void validateAggregate() throws MojoExecutionException {
        if (this.aggregate != null && this.aggregate.booleanValue()) {
            String msg = "Aggregate configuration detected - as of dependency-check 1.2.8 this no longer supported. Please use the aggregate goal instead.";
            throw new MojoExecutionException("Aggregate configuration detected - as of dependency-check 1.2.8 this no longer supported. Please use the aggregate goal instead.");
        }
    }

    @Deprecated
    public final void generate(Sink sink, Locale locale) throws MavenReportException {
        this.generate((org.apache.maven.doxia.sink.Sink)sink, locale);
    }

    protected boolean isGeneratingSite() {
        return this.generatingSite;
    }

    protected String getConnectionString() {
        return this.connectionString;
    }

    protected boolean isFailOnError() {
        return this.failOnError;
    }

    public void generate(org.apache.maven.doxia.sink.Sink sink, Locale locale) throws MavenReportException {
        this.generatingSite = true;
        try {
            this.validateAggregate();
        }
        catch (MojoExecutionException ex) {
            throw new MavenReportException(ex.getMessage());
        }
        this.project.setContextValue(this.getOutputDirectoryContextKey(), (Object)this.getReportOutputDirectory());
        try {
            this.runCheck();
        }
        catch (MojoExecutionException ex) {
            throw new MavenReportException(ex.getMessage(), (Exception)((Object)ex));
        }
        catch (MojoFailureException ex) {
            this.getLog().warn((CharSequence)"Vulnerabilities were identifies that exceed the CVSS threshold for failing the build");
        }
    }

    protected File getCorrectOutputDirectory() throws MojoExecutionException {
        return this.getCorrectOutputDirectory(this.project);
    }

    protected File getCorrectOutputDirectory(MavenProject current) {
        Object obj = current.getContextValue(this.getOutputDirectoryContextKey());
        if (obj != null && obj instanceof File) {
            return (File)obj;
        }
        File target = new File(current.getBuild().getDirectory());
        if (target.getParentFile() != null && "target".equals(target.getParentFile().getName())) {
            target = target.getParentFile();
        }
        return target;
    }

    protected ExceptionCollection scanArtifacts(MavenProject project, Engine engine) {
        try {
            DependencyNode dn = this.dependencyGraphBuilder.buildDependencyGraph(project, null, this.reactorProjects);
            ProjectBuildingRequest buildingRequest = this.newResolveArtifactProjectBuildingRequest();
            return this.collectDependencies(engine, project, dn.getChildren(), buildingRequest);
        }
        catch (DependencyGraphBuilderException ex) {
            String msg = String.format("Unable to build dependency graph on project %s", project.getName());
            this.getLog().debug((CharSequence)msg, (Throwable)ex);
            return new ExceptionCollection(msg, (Throwable)ex);
        }
    }

    private ExceptionCollection collectDependencies(Engine engine, MavenProject project, List<DependencyNode> nodes, ProjectBuildingRequest buildingRequest) {
        ExceptionCollection exCol = null;
        for (DependencyNode dependencyNode : nodes) {
            if (this.artifactScopeExcluded.passes((Object)dependencyNode.getArtifact().getScope()) || this.artifactTypeExcluded.passes((Object)dependencyNode.getArtifact().getType())) continue;
            exCol = this.collectDependencies(engine, project, dependencyNode.getChildren(), buildingRequest);
            try {
                boolean isResolved = false;
                File artifactFile = null;
                String artifactId = null;
                String groupId = null;
                String version = null;
                if ("system".equals(dependencyNode.getArtifact().getScope())) {
                    for (Dependency d : project.getDependencies()) {
                        Artifact a = dependencyNode.getArtifact();
                        if (d.getSystemPath() == null || !BaseDependencyCheckMojo.artifactsMatch(d, a)) continue;
                        artifactFile = new File(d.getSystemPath());
                        isResolved = artifactFile.isFile();
                        groupId = a.getGroupId();
                        artifactId = a.getArtifactId();
                        version = a.getVersion();
                        break;
                    }
                    if (!isResolved) {
                        this.getLog().error((CharSequence)("Unable to resolve system scoped dependency: " + dependencyNode.toNodeString()));
                        exCol.addException((Throwable)new DependencyNotFoundException("Unable to resolve system scoped dependency: " + dependencyNode.toNodeString()));
                    }
                } else {
                    ArtifactCoordinate coordinate = TransferUtils.toArtifactCoordinate((Artifact)dependencyNode.getArtifact());
                    Artifact result = this.artifactResolver.resolveArtifact(buildingRequest, coordinate).getArtifact();
                    isResolved = result.isResolved();
                    artifactFile = result.getFile();
                    groupId = result.getGroupId();
                    artifactId = result.getArtifactId();
                    version = result.getVersion();
                }
                if (isResolved && artifactFile != null) {
                    String msg;
                    List deps = engine.scan(artifactFile.getAbsoluteFile(), project.getName() + ":" + dependencyNode.getArtifact().getScope());
                    if (deps != null) {
                        if (deps.size() == 1) {
                            Dependency d;
                            d = (org.owasp.dependencycheck.dependency.Dependency)deps.get(0);
                            if (d == null) continue;
                            MavenArtifact ma = new MavenArtifact(groupId, artifactId, version);
                            d.addAsEvidence("pom", ma, Confidence.HIGHEST);
                            if (!this.getLog().isDebugEnabled()) continue;
                            this.getLog().debug((CharSequence)String.format("Adding project reference %s on dependency %s", project.getName(), d.getDisplayFileName()));
                            continue;
                        }
                        if (!this.getLog().isDebugEnabled()) continue;
                        msg = String.format("More than 1 dependency was identified in first pass scan of '%s' in project %s", dependencyNode.getArtifact().getId(), project.getName());
                        this.getLog().debug((CharSequence)msg);
                        continue;
                    }
                    msg = String.format("Error resolving '%s' in project %s", dependencyNode.getArtifact().getId(), project.getName());
                    if (exCol == null) {
                        exCol = new ExceptionCollection();
                    }
                    this.getLog().error((CharSequence)msg);
                    continue;
                }
                String msg = String.format("Unable to resolve '%s' in project %s", dependencyNode.getArtifact().getId(), project.getName());
                this.getLog().debug((CharSequence)msg);
                if (exCol != null) continue;
                exCol = new ExceptionCollection();
            }
            catch (ArtifactResolverException ex) {
                if (exCol == null) {
                    exCol = new ExceptionCollection();
                }
                exCol.addException((Throwable)ex);
            }
        }
        return exCol;
    }

    private static boolean artifactsMatch(Dependency d, Artifact a) {
        return BaseDependencyCheckMojo.isEqualOrNull(a.getArtifactId(), d.getArtifactId()) && BaseDependencyCheckMojo.isEqualOrNull(a.getGroupId(), d.getGroupId()) && BaseDependencyCheckMojo.isEqualOrNull(a.getVersion(), d.getVersion());
    }

    private static boolean isEqualOrNull(String left, String right) {
        return left != null && left.equals(right) || left == null && right == null;
    }

    public ProjectBuildingRequest newResolveArtifactProjectBuildingRequest() {
        DefaultProjectBuildingRequest buildingRequest = new DefaultProjectBuildingRequest(this.session.getProjectBuildingRequest());
        buildingRequest.setRemoteRepositories(this.remoteRepositories);
        return buildingRequest;
    }

    public abstract void runCheck() throws MojoExecutionException, MojoFailureException;

    public void setReportOutputDirectory(File directory) {
        this.reportOutputDirectory = directory;
    }

    public File getReportOutputDirectory() {
        return this.reportOutputDirectory;
    }

    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    public final boolean isExternalReport() {
        return true;
    }

    public String getOutputName() {
        if ("HTML".equalsIgnoreCase(this.format) || "ALL".equalsIgnoreCase(this.format)) {
            return "dependency-check-report";
        }
        if ("XML".equalsIgnoreCase(this.format)) {
            return "dependency-check-report.xml#";
        }
        if ("VULN".equalsIgnoreCase(this.format)) {
            return "dependency-check-vulnerability";
        }
        if ("JSON".equalsIgnoreCase(this.format)) {
            return "dependency-check-report.json";
        }
        if ("CSV".equalsIgnoreCase(this.format)) {
            return "dependency-check-report.csv";
        }
        this.getLog().warn((CharSequence)"Unknown report format used during site generation.");
        return "dependency-check-report";
    }

    public String getCategoryName() {
        return "Project Reports";
    }

    protected Engine initializeEngine() throws DatabaseException {
        this.populateSettings();
        return new Engine();
    }

    protected void populateSettings() {
        block27: {
            Proxy proxy;
            Settings.initialize();
            InputStream mojoProperties = null;
            try {
                mojoProperties = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(PROPERTIES_FILE);
                Settings.mergeProperties((InputStream)mojoProperties);
            }
            catch (IOException ex) {
                this.getLog().warn((CharSequence)"Unable to load the dependency-check ant task.properties file.");
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)"", (Throwable)ex);
                }
            }
            finally {
                block26: {
                    if (mojoProperties != null) {
                        try {
                            mojoProperties.close();
                        }
                        catch (IOException ex) {
                            if (!this.getLog().isDebugEnabled()) break block26;
                            this.getLog().debug((CharSequence)"", (Throwable)ex);
                        }
                    }
                }
            }
            Settings.setBooleanIfNotNull((String)"autoupdate", (Boolean)this.autoUpdate);
            Settings.setBooleanIfNotNull((String)"analyzer.experimental.enabled", (Boolean)this.enableExperimental);
            if (this.externalReport != null) {
                this.getLog().warn((CharSequence)"The 'externalReport' option was set; this configuration option has been removed. Please update the dependency-check-maven plugin's configuration");
            }
            if (this.proxyUrl != null && !this.proxyUrl.isEmpty()) {
                this.getLog().warn((CharSequence)"Deprecated configuration detected, proxyUrl will be ignored; use the maven settings to configure the proxy instead");
            }
            if ((proxy = this.getMavenProxy()) != null) {
                Settings.setString((String)"proxy.server", (String)proxy.getHost());
                Settings.setString((String)"proxy.port", (String)Integer.toString(proxy.getPort()));
                String userName = proxy.getUsername();
                String password = proxy.getPassword();
                Settings.setStringIfNotNull((String)"proxy.username", (String)userName);
                Settings.setStringIfNotNull((String)"proxy.password", (String)password);
                Settings.setStringIfNotNull((String)"proxy.nonproxyhosts", (String)proxy.getNonProxyHosts());
            }
            String[] suppressions = this.determineSuppressions();
            Settings.setArrayIfNotEmpty((String)"suppression.file", (String[])suppressions);
            Settings.setStringIfNotEmpty((String)"connection.timeout", (String)this.connectionTimeout);
            Settings.setStringIfNotEmpty((String)"hints.file", (String)this.hintsFile);
            Settings.setBooleanIfNotNull((String)"analyzer.jar.enabled", (Boolean)this.jarAnalyzerEnabled);
            Settings.setBooleanIfNotNull((String)"analyzer.nuspec.enabled", (Boolean)this.nuspecAnalyzerEnabled);
            Settings.setBooleanIfNotNull((String)"analyzer.central.enabled", (Boolean)this.centralAnalyzerEnabled);
            Settings.setBooleanIfNotNull((String)"analyzer.nexus.enabled", (Boolean)this.nexusAnalyzerEnabled);
            Settings.setStringIfNotEmpty((String)"analyzer.nexus.url", (String)this.nexusUrl);
            Settings.setBooleanIfNotNull((String)"analyzer.nexus.proxy", (Boolean)this.nexusUsesProxy);
            Settings.setBooleanIfNotNull((String)"analyzer.assembly.enabled", (Boolean)this.assemblyAnalyzerEnabled);
            Settings.setBooleanIfNotNull((String)"analyzer.archive.enabled", (Boolean)this.archiveAnalyzerEnabled);
            Settings.setStringIfNotEmpty((String)"extensions.zip", (String)this.zipExtensions);
            Settings.setStringIfNotEmpty((String)"analyzer.assembly.mono.path", (String)this.pathToMono);
            Settings.setBooleanIfNotNull((String)"analyzer.python.distribution.enabled", (Boolean)this.pyDistributionAnalyzerEnabled);
            Settings.setBooleanIfNotNull((String)"analyzer.python.package.enabled", (Boolean)this.pyPackageAnalyzerEnabled);
            Settings.setBooleanIfNotNull((String)"analyzer.ruby.gemspec.enabled", (Boolean)this.rubygemsAnalyzerEnabled);
            Settings.setBooleanIfNotNull((String)"analyzer.openssl.enabled", (Boolean)this.opensslAnalyzerEnabled);
            Settings.setBooleanIfNotNull((String)"analyzer.cmake.enabled", (Boolean)this.cmakeAnalyzerEnabled);
            Settings.setBooleanIfNotNull((String)"analyzer.autoconf.enabled", (Boolean)this.autoconfAnalyzerEnabled);
            Settings.setBooleanIfNotNull((String)"analyzer.composer.lock.enabled", (Boolean)this.composerAnalyzerEnabled);
            Settings.setBooleanIfNotNull((String)"analyzer.node.package.enabled", (Boolean)this.nodeAnalyzerEnabled);
            Settings.setBooleanIfNotNull((String)"analyzer.nsp.package.enabled", (Boolean)this.nspAnalyzerEnabled);
            Settings.setBooleanIfNotNull((String)"analyzer.bundle.audit.enabled", (Boolean)this.bundleAuditAnalyzerEnabled);
            Settings.setStringIfNotNull((String)"analyzer.bundle.audit.path", (String)this.bundleAuditPath);
            Settings.setBooleanIfNotNull((String)"analyzer.cocoapods.enabled", (Boolean)this.cocoapodsAnalyzerEnabled);
            Settings.setBooleanIfNotNull((String)"analyzer.swift.package.manager.enabled", (Boolean)this.swiftPackageManagerAnalyzerEnabled);
            Settings.setStringIfNotEmpty((String)"data.driver_name", (String)this.databaseDriverName);
            Settings.setStringIfNotEmpty((String)"data.driver_path", (String)this.databaseDriverPath);
            Settings.setStringIfNotEmpty((String)"data.connection_string", (String)this.connectionString);
            if (this.databaseUser == null && this.databasePassword == null && this.serverId != null) {
                Server server = this.settingsXml.getServer(this.serverId);
                if (server != null) {
                    this.databaseUser = server.getUsername();
                    try {
                        if (this.securityDispatcher instanceof DefaultSecDispatcher) {
                            ((DefaultSecDispatcher)this.securityDispatcher).setConfigurationFile("~/.m2/settings-security.xml");
                        }
                        this.databasePassword = this.securityDispatcher.decrypt(server.getPassword());
                    }
                    catch (SecDispatcherException ex) {
                        if (ex.getCause() instanceof FileNotFoundException || ex.getCause() != null && ex.getCause().getCause() instanceof FileNotFoundException) {
                            String tmp = server.getPassword();
                            if (tmp.startsWith("{") && tmp.endsWith("}")) {
                                this.getLog().error((CharSequence)String.format("Unable to decrypt the server password for server id '%s' in settings.xml%n\tCause: %s", this.serverId, ex.getMessage()));
                            } else {
                                this.databasePassword = tmp;
                            }
                            break block27;
                        }
                        this.getLog().error((CharSequence)String.format("Unable to decrypt the server password for server id '%s' in settings.xml%n\tCause: %s", this.serverId, ex.getMessage()));
                    }
                } else {
                    this.getLog().error((CharSequence)String.format("Server '%s' not found in the settings.xml file", this.serverId));
                }
            }
        }
        Settings.setStringIfNotEmpty((String)"data.user", (String)this.databaseUser);
        Settings.setStringIfNotEmpty((String)"data.password", (String)this.databasePassword);
        Settings.setStringIfNotEmpty((String)"data.directory", (String)this.dataDirectory);
        Settings.setStringIfNotEmpty((String)"cve.url-1.2.modified", (String)this.cveUrl12Modified);
        Settings.setStringIfNotEmpty((String)"cve.url-2.0.modified", (String)this.cveUrl20Modified);
        Settings.setStringIfNotEmpty((String)"cve.url-1.2.base", (String)this.cveUrl12Base);
        Settings.setStringIfNotEmpty((String)"cve.url-2.0.base", (String)this.cveUrl20Base);
        Settings.setIntIfNotNull((String)"cve.check.validforhours", (Integer)this.cveValidForHours);
        this.artifactScopeExcluded = new ArtifactScopeExcluded(this.skipTestScope, this.skipProvidedScope, this.skipSystemScope, this.skipRuntimeScope);
        this.artifactTypeExcluded = new ArtifactTypeExcluded(this.skipArtifactType);
    }

    private String[] determineSuppressions() {
        String[] suppressions = this.suppressionFiles;
        if (this.suppressionFile != null) {
            if (suppressions == null) {
                suppressions = new String[]{this.suppressionFile};
            } else {
                suppressions = Arrays.copyOf(suppressions, suppressions.length + 1);
                suppressions[suppressions.length - 1] = this.suppressionFile;
            }
        }
        return suppressions;
    }

    private Proxy getMavenProxy() {
        List proxies;
        if (this.mavenSettings != null && (proxies = this.mavenSettings.getProxies()) != null && !proxies.isEmpty()) {
            if (this.mavenSettingsProxyId != null) {
                for (Proxy proxy : proxies) {
                    if (!this.mavenSettingsProxyId.equalsIgnoreCase(proxy.getId())) continue;
                    return proxy;
                }
            } else {
                if (proxies.size() == 1) {
                    return (Proxy)proxies.get(0);
                }
                this.getLog().warn((CharSequence)"Multiple proxy definitions exist in the Maven settings. In the dependency-check configuration set the mavenSettingsProxyId so that the correct proxy will be used.");
                throw new IllegalStateException("Ambiguous proxy definition");
            }
        }
        return null;
    }

    protected MavenProject getProject() {
        return this.project;
    }

    protected List<MavenProject> getReactorProjects() {
        return this.reactorProjects;
    }

    protected String getFormat() {
        return this.format;
    }

    protected Filter<String> getArtifactScopeExcluded() {
        return this.artifactScopeExcluded;
    }

    protected void checkForFailure(List<org.owasp.dependencycheck.dependency.Dependency> dependencies) throws MojoFailureException {
        StringBuilder ids = new StringBuilder();
        for (org.owasp.dependencycheck.dependency.Dependency d : dependencies) {
            boolean addName = true;
            for (Vulnerability v : d.getVulnerabilities()) {
                if (!this.failBuildOnAnyVulnerability && !(v.getCvssScore() >= this.failBuildOnCVSS)) continue;
                if (addName) {
                    addName = false;
                    ids.append(NEW_LINE).append(d.getFileName()).append(": ");
                    ids.append(v.getName());
                    continue;
                }
                ids.append(", ").append(v.getName());
            }
        }
        if (ids.length() > 0) {
            String msg = this.failBuildOnAnyVulnerability ? String.format("%n%nOne or more dependencies were identified with vulnerabilities: %n%s%n%nSee the dependency-check report for more details.%n%n", ids.toString()) : String.format("%n%nOne or more dependencies were identified with vulnerabilities that have a CVSS score greater than '%.1f': %n%s%n%nSee the dependency-check report for more details.%n%n", Float.valueOf(this.failBuildOnCVSS), ids.toString());
            throw new MojoFailureException(msg);
        }
    }

    protected void showSummary(MavenProject mp, List<org.owasp.dependencycheck.dependency.Dependency> dependencies) {
        if (this.showSummary) {
            StringBuilder summary = new StringBuilder();
            for (org.owasp.dependencycheck.dependency.Dependency d : dependencies) {
                boolean firstEntry = true;
                StringBuilder ids = new StringBuilder();
                for (Vulnerability v : d.getVulnerabilities()) {
                    if (firstEntry) {
                        firstEntry = false;
                    } else {
                        ids.append(", ");
                    }
                    ids.append(v.getName());
                }
                if (ids.length() <= 0) continue;
                summary.append(d.getFileName()).append(" (");
                firstEntry = true;
                for (Identifier id : d.getIdentifiers()) {
                    if (firstEntry) {
                        firstEntry = false;
                    } else {
                        summary.append(", ");
                    }
                    summary.append(id.getValue());
                }
                summary.append(") : ").append((CharSequence)ids).append(NEW_LINE);
            }
            if (summary.length() > 0) {
                String msg = String.format("%n%nOne or more dependencies were identified with known vulnerabilities in %s:%n%n%s%n%nSee the dependency-check report for more details.%n%n", mp.getName(), summary.toString());
                this.getLog().warn((CharSequence)msg);
            }
        }
    }

    protected String getDataFileContextKey() {
        return "dependency-check-path-" + this.dataFileName;
    }

    protected String getOutputDirectoryContextKey() {
        return "dependency-output-dir-" + this.dataFileName;
    }
}

