/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.maven;

import com.github.packageurl.MalformedPackageURLException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ExcludesArtifactFilter;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.License;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.reporting.MavenReport;
import org.apache.maven.reporting.MavenReportException;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Server;
import org.apache.maven.shared.artifact.filter.PatternExcludesArtifactFilter;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilder;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilderException;
import org.apache.maven.shared.dependency.graph.DependencyNode;
import org.apache.maven.shared.dependency.graph.filter.ArtifactDependencyNodeFilter;
import org.apache.maven.shared.dependency.graph.filter.DependencyNodeFilter;
import org.apache.maven.shared.dependency.graph.internal.DefaultDependencyNode;
import org.apache.maven.shared.dependency.graph.traversal.CollectingDependencyNodeVisitor;
import org.apache.maven.shared.dependency.graph.traversal.DependencyNodeVisitor;
import org.apache.maven.shared.dependency.graph.traversal.FilteringDependencyNodeVisitor;
import org.apache.maven.shared.model.fileset.FileSet;
import org.apache.maven.shared.model.fileset.util.FileSetManager;
import org.apache.maven.shared.transfer.artifact.ArtifactCoordinate;
import org.apache.maven.shared.transfer.artifact.DefaultArtifactCoordinate;
import org.apache.maven.shared.transfer.artifact.TransferUtils;
import org.apache.maven.shared.transfer.artifact.resolve.ArtifactResolver;
import org.apache.maven.shared.transfer.artifact.resolve.ArtifactResolverException;
import org.codehaus.doxia.sink.Sink;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.agent.DependencyCheckScanAgent;
import org.owasp.dependencycheck.analyzer.JarAnalyzer;
import org.owasp.dependencycheck.data.nexus.MavenArtifact;
import org.owasp.dependencycheck.data.nvdcve.DatabaseException;
import org.owasp.dependencycheck.dependency.Confidence;
import org.owasp.dependencycheck.dependency.EvidenceType;
import org.owasp.dependencycheck.dependency.Vulnerability;
import org.owasp.dependencycheck.dependency.naming.GenericIdentifier;
import org.owasp.dependencycheck.dependency.naming.Identifier;
import org.owasp.dependencycheck.dependency.naming.PurlIdentifier;
import org.owasp.dependencycheck.exception.DependencyNotFoundException;
import org.owasp.dependencycheck.exception.ExceptionCollection;
import org.owasp.dependencycheck.exception.ReportException;
import org.owasp.dependencycheck.maven.ArtifactScopeExcluded;
import org.owasp.dependencycheck.maven.ArtifactTypeExcluded;
import org.owasp.dependencycheck.maven.FilteringDependencyTransitiveNodeVisitor;
import org.owasp.dependencycheck.maven.Retirejs;
import org.owasp.dependencycheck.utils.Checksum;
import org.owasp.dependencycheck.utils.Filter;
import org.owasp.dependencycheck.utils.Settings;
import org.sonatype.plexus.components.sec.dispatcher.DefaultSecDispatcher;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcher;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcherException;

public abstract class BaseDependencyCheckMojo
extends AbstractMojo
implements MavenReport {
    private static final String PROPERTIES_FILE = "mojo.properties";
    private static final String NEW_LINE = System.getProperty("line.separator", "\n").intern();
    private boolean generatingSite = false;
    private Settings settings = null;
    @Parameter(property="failOnError", defaultValue="true", required=true)
    private boolean failOnError;
    @Parameter(property="project", required=true, readonly=true)
    private MavenProject project;
    @Parameter(readonly=true, required=true, property="reactorProjects")
    private List<MavenProject> reactorProjects;
    @Component
    private ArtifactResolver artifactResolver;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    private MavenSession session;
    @Component
    private DependencyGraphBuilder dependencyGraphBuilder;
    @Parameter(defaultValue="${project.build.directory}", required=true)
    private File outputDirectory;
    @Parameter(property="project.reporting.outputDirectory", readonly=true)
    private File reportOutputDirectory;
    @Parameter(property="failBuildOnCVSS", defaultValue="11", required=true)
    private float failBuildOnCVSS = 11.0f;
    @Parameter(property="failBuildOnAnyVulnerability", defaultValue="false", required=true)
    private boolean failBuildOnAnyVulnerability = false;
    @Parameter(property="autoUpdate")
    private Boolean autoUpdate;
    @Parameter(property="enableExperimental")
    private Boolean enableExperimental;
    @Parameter(property="enableRetired")
    private Boolean enableRetired;
    @Parameter(property="dependency-check.virtualSnapshotsFromReactor", defaultValue="true")
    private Boolean virtualSnapshotsFromReactor;
    @Parameter(property="format", defaultValue="HTML", required=true)
    private String format = "HTML";
    @Parameter(property="mavenSettings", defaultValue="${settings}", required=false)
    private org.apache.maven.settings.Settings mavenSettings;
    @Parameter(property="mavenSettingsProxyId", required=false)
    private String mavenSettingsProxyId;
    @Parameter(property="connectionTimeout", defaultValue="", required=false)
    private String connectionTimeout;
    @Parameter(property="versionCheckEnabled", defaultValue="true", required=false)
    private boolean versionCheckEnabled;
    @Parameter(property="suppressionFiles", required=false)
    private String[] suppressionFiles;
    @Parameter(property="suppressionFile", required=false)
    private String suppressionFile;
    @Parameter(property="hintsFile", defaultValue="", required=false)
    private String hintsFile;
    @Parameter(property="showSummary", defaultValue="true", required=false)
    private boolean showSummary = true;
    @Parameter(property="jarAnalyzerEnabled", required=false)
    private Boolean jarAnalyzerEnabled;
    @Parameter(property="archiveAnalyzerEnabled", required=false)
    private Boolean archiveAnalyzerEnabled;
    @Parameter(property="pyDistributionAnalyzerEnabled", required=false)
    private Boolean pyDistributionAnalyzerEnabled;
    @Parameter(property="pyPackageAnalyzerEnabled", required=false)
    private Boolean pyPackageAnalyzerEnabled;
    @Parameter(property="rubygemsAnalyzerEnabled", required=false)
    private Boolean rubygemsAnalyzerEnabled;
    @Parameter(property="opensslAnalyzerEnabled", required=false)
    private Boolean opensslAnalyzerEnabled;
    @Parameter(property="cmakeAnalyzerEnabled", required=false)
    private Boolean cmakeAnalyzerEnabled;
    @Parameter(property="autoconfAnalyzerEnabled", required=false)
    private Boolean autoconfAnalyzerEnabled;
    @Parameter(property="composerAnalyzerEnabled", required=false)
    private Boolean composerAnalyzerEnabled;
    @Parameter(property="nodeAnalyzerEnabled", required=false)
    private Boolean nodeAnalyzerEnabled;
    @Parameter(property="nodeAuditAnalyzerEnabled", required=false)
    private Boolean nodeAuditAnalyzerEnabled;
    @Parameter(property="retireJsAnalyzerEnabled", required=false)
    private Boolean retireJsAnalyzerEnabled;
    @Parameter(property="assemblyAnalyzerEnabled", required=false)
    private Boolean assemblyAnalyzerEnabled;
    @Parameter(property="nuspecAnalyzerEnabled", required=false)
    private Boolean nuspecAnalyzerEnabled;
    @Parameter(property="nugetconfAnalyzerEnabled", required=false)
    private Boolean nugetconfAnalyzerEnabled;
    @Parameter(property="centralAnalyzerEnabled", required=false)
    private Boolean centralAnalyzerEnabled;
    @Parameter(property="artifactoryAnalyzerEnabled")
    private Boolean artifactoryAnalyzerEnabled;
    @Parameter(property="artifactoryAnalyzerServerId", defaultValue="artifactory")
    private String artifactoryAnalyzerServerId;
    @Parameter(property="artifactoryAnalyzerUsername", defaultValue="artifactory")
    private String artifactoryAnalyzerUsername;
    @Parameter(property="artifactoryAnalyzerApiToken", defaultValue="artifactory")
    private String artifactoryAnalyzerApiToken;
    @Parameter(property="artifactoryAnalyzerBearerToken")
    private String artifactoryAnalyzerBearerToken;
    @Parameter(property="artifactoryAnalyzerUrl")
    private String artifactoryAnalyzerUrl;
    @Parameter(property="artifactoryAnalyzerUseProxy", defaultValue="artifactory")
    private Boolean artifactoryAnalyzerUseProxy;
    @Parameter(property="artifactoryAnalyzerParallelAnalysis", defaultValue="true")
    private Boolean artifactoryAnalyzerParallelAnalysis;
    @Parameter(property="nexusAnalyzerEnabled", required=false)
    private Boolean nexusAnalyzerEnabled;
    @Parameter(property="bundleAuditAnalyzerEnabled", required=false)
    private Boolean bundleAuditAnalyzerEnabled;
    @Parameter(property="bundleAuditPath", defaultValue="", required=false)
    private String bundleAuditPath;
    @Parameter(property="cocoapodsAnalyzerEnabled", required=false)
    private Boolean cocoapodsAnalyzerEnabled;
    @Parameter(property="swiftPackageManagerAnalyzerEnabled", required=false)
    private Boolean swiftPackageManagerAnalyzerEnabled;
    @Parameter(property="nexusUrl", required=false)
    private String nexusUrl;
    @Parameter(property="nexusServerId", required=false)
    private String nexusServerId;
    @Parameter(property="nexusUsesProxy", required=false)
    private Boolean nexusUsesProxy;
    @Parameter(property="connectionString", defaultValue="", required=false)
    private String connectionString;
    @Parameter(property="databaseDriverName", defaultValue="", required=false)
    private String databaseDriverName;
    @Parameter(property="databaseDriverPath", defaultValue="", required=false)
    private String databaseDriverPath;
    @Parameter(property="serverId", defaultValue="", required=false)
    private String serverId;
    @Parameter(defaultValue="${settings}", readonly=true, required=true)
    private org.apache.maven.settings.Settings settingsXml;
    @Component(role=SecDispatcher.class, hint="default")
    private SecDispatcher securityDispatcher;
    @Parameter(property="databaseUser", defaultValue="", required=false)
    private String databaseUser;
    @Parameter(property="databasePassword", defaultValue="", required=false)
    private String databasePassword;
    @Parameter(property="zipExtensions", required=false)
    private String zipExtensions;
    @Parameter(property="dependency-check.skip", defaultValue="false", required=false)
    private boolean skip = false;
    @Parameter(property="skipTestScope", defaultValue="true", required=false)
    private boolean skipTestScope = true;
    @Parameter(property="skipRuntimeScope", defaultValue="false", required=false)
    private boolean skipRuntimeScope = false;
    @Parameter(property="skipProvidedScope", defaultValue="false", required=false)
    private boolean skipProvidedScope = false;
    @Parameter(property="skipSystemScope", defaultValue="false", required=false)
    private boolean skipSystemScope = false;
    @Parameter(property="skipDependencyManagement", defaultValue="true", required=false)
    private boolean skipDependencyManagement = true;
    @Parameter(property="skipArtifactType", required=false)
    private String skipArtifactType;
    @Parameter(property="dataDirectory", defaultValue="", required=false)
    private String dataDirectory;
    @Parameter(property="cveUrlModified", defaultValue="", required=false)
    private String cveUrlModified;
    @Parameter(property="cveUrlBase", defaultValue="", required=false)
    private String cveUrlBase;
    @Parameter(property="cveValidForHours", defaultValue="", required=false)
    private Integer cveValidForHours;
    @Parameter(property="pathToCore", defaultValue="", required=false)
    private String pathToCore;
    @Parameter(property="retirejs", required=false)
    private Retirejs retirejs;
    @Parameter
    private List<String> excludes;
    private Filter<String> artifactScopeExcluded;
    private Filter<String> artifactTypeExcluded;
    @Parameter(property="scanSet", required=false)
    private FileSet[] scanSet;

    private static boolean artifactsMatch(Dependency d, Artifact a) {
        return BaseDependencyCheckMojo.isEqualOrNull(a.getArtifactId(), d.getArtifactId()) && BaseDependencyCheckMojo.isEqualOrNull(a.getGroupId(), d.getGroupId()) && BaseDependencyCheckMojo.isEqualOrNull(a.getVersion(), d.getVersion());
    }

    private static boolean isEqualOrNull(String left, String right) {
        return left != null && left.equals(right) || left == null && right == null;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.generatingSite = false;
        boolean shouldSkip = Boolean.parseBoolean(System.getProperty("dependency-check.skip", Boolean.toString(this.skip)));
        if (shouldSkip) {
            this.getLog().info((CharSequence)("Skipping " + this.getName(Locale.US)));
        } else {
            this.runCheck();
        }
    }

    @Deprecated
    public final void generate(Sink sink, Locale locale) throws MavenReportException {
        this.generate((org.apache.maven.doxia.sink.Sink)sink, locale);
    }

    protected boolean isGeneratingSite() {
        return this.generatingSite;
    }

    protected String getConnectionString() {
        return this.connectionString;
    }

    protected boolean isFailOnError() {
        return this.failOnError;
    }

    public void generate(org.apache.maven.doxia.sink.Sink sink, Locale locale) throws MavenReportException {
        boolean shouldSkip = Boolean.parseBoolean(System.getProperty("dependency-check.skip", Boolean.toString(this.skip)));
        if (shouldSkip) {
            this.getLog().info((CharSequence)("Skipping report generation " + this.getName(Locale.US)));
            return;
        }
        this.generatingSite = true;
        try {
            this.runCheck();
        }
        catch (MojoExecutionException ex) {
            throw new MavenReportException(ex.getMessage(), (Exception)((Object)ex));
        }
        catch (MojoFailureException ex) {
            this.getLog().warn((CharSequence)"Vulnerabilities were identifies that exceed the CVSS threshold for failing the build");
        }
    }

    protected File getCorrectOutputDirectory() throws MojoExecutionException {
        return this.getCorrectOutputDirectory(this.project);
    }

    protected File getCorrectOutputDirectory(MavenProject current) {
        File target = new File(current.getBuild().getDirectory());
        if (target.getParentFile() != null && "target".equals(target.getParentFile().getName())) {
            target = target.getParentFile();
        }
        return target;
    }

    protected ExceptionCollection scanArtifacts(MavenProject project, Engine engine) {
        return this.scanArtifacts(project, engine, false);
    }

    protected ExceptionCollection scanArtifacts(MavenProject project, Engine engine, boolean aggregate) {
        try {
            List<String> filterItems = Collections.singletonList(String.format("%s:%s", project.getGroupId(), project.getArtifactId()));
            ProjectBuildingRequest buildingRequest = this.newResolveArtifactProjectBuildingRequest(project);
            DependencyNode dn = this.dependencyGraphBuilder.buildDependencyGraph(buildingRequest, null, this.reactorProjects);
            CollectingDependencyNodeVisitor collectorVisitor = new CollectingDependencyNodeVisitor();
            FilteringDependencyTransitiveNodeVisitor transitiveFilterVisitor = new FilteringDependencyTransitiveNodeVisitor((DependencyNodeVisitor)collectorVisitor, (DependencyNodeFilter)new ArtifactDependencyNodeFilter((ArtifactFilter)new PatternExcludesArtifactFilter(this.getExcludes())));
            FilteringDependencyNodeVisitor artifactFilter = new FilteringDependencyNodeVisitor((DependencyNodeVisitor)transitiveFilterVisitor, (DependencyNodeFilter)new ArtifactDependencyNodeFilter((ArtifactFilter)new ExcludesArtifactFilter(filterItems)));
            dn.accept((DependencyNodeVisitor)artifactFilter);
            ArrayList<DependencyNode> nodes = new ArrayList<DependencyNode>(collectorVisitor.getNodes());
            return this.collectDependencies(engine, project, nodes, buildingRequest, aggregate);
        }
        catch (DependencyGraphBuilderException ex) {
            String msg = String.format("Unable to build dependency graph on project %s", project.getName());
            this.getLog().debug((CharSequence)msg, (Throwable)ex);
            return new ExceptionCollection((Throwable)ex);
        }
    }

    private DependencyNode toDependencyNode(ProjectBuildingRequest buildingRequest, DependencyNode parent, Dependency dependency) throws ArtifactResolverException {
        DefaultArtifactCoordinate coordinate = new DefaultArtifactCoordinate();
        coordinate.setGroupId(dependency.getGroupId());
        coordinate.setArtifactId(dependency.getArtifactId());
        coordinate.setVersion(dependency.getVersion());
        coordinate.setExtension(dependency.getType());
        coordinate.setClassifier(dependency.getClassifier());
        Artifact artifact = this.artifactResolver.resolveArtifact(buildingRequest, (ArtifactCoordinate)coordinate).getArtifact();
        artifact.setScope(dependency.getScope());
        DefaultDependencyNode node = new DefaultDependencyNode(parent, artifact, dependency.getVersion(), dependency.getScope(), null);
        return node;
    }

    private ExceptionCollection collectDependencyManagementDependencies(ProjectBuildingRequest buildingRequest, MavenProject project, List<DependencyNode> nodes, boolean aggregate) {
        if (this.skipDependencyManagement || project.getDependencyManagement() == null) {
            return null;
        }
        ExceptionCollection exCol = null;
        for (Dependency dependency : project.getDependencyManagement().getDependencies()) {
            try {
                nodes.add(this.toDependencyNode(buildingRequest, null, dependency));
            }
            catch (ArtifactResolverException ex) {
                this.getLog().debug((CharSequence)String.format("Aggregate : %s", aggregate));
                if (exCol == null) {
                    exCol = new ExceptionCollection();
                }
                exCol.addException((Throwable)ex);
            }
        }
        return exCol;
    }

    private ExceptionCollection collectMavenDependencies(Engine engine, MavenProject project, List<DependencyNode> nodes, ProjectBuildingRequest buildingRequest, boolean aggregate) {
        ExceptionCollection exCol = this.collectDependencyManagementDependencies(buildingRequest, project, nodes, aggregate);
        for (DependencyNode dependencyNode : nodes) {
            if (this.artifactScopeExcluded.passes((Object)dependencyNode.getArtifact().getScope()) || this.artifactTypeExcluded.passes((Object)dependencyNode.getArtifact().getType())) continue;
            boolean isResolved = false;
            File artifactFile = null;
            String artifactId = null;
            String groupId = null;
            String version = null;
            List availableVersions = null;
            if ("system".equals(dependencyNode.getArtifact().getScope())) {
                for (Dependency d : project.getDependencies()) {
                    Artifact a = dependencyNode.getArtifact();
                    if (d.getSystemPath() == null || !BaseDependencyCheckMojo.artifactsMatch(d, a)) continue;
                    artifactFile = new File(d.getSystemPath());
                    isResolved = artifactFile.isFile();
                    groupId = a.getGroupId();
                    artifactId = a.getArtifactId();
                    version = a.getVersion();
                    availableVersions = a.getAvailableVersions();
                    break;
                }
                if (!isResolved) {
                    this.getLog().error((CharSequence)("Unable to resolve system scoped dependency: " + dependencyNode.toNodeString()));
                    if (exCol == null) {
                        exCol = new ExceptionCollection();
                    }
                    exCol.addException((Throwable)new DependencyNotFoundException("Unable to resolve system scoped dependency: " + dependencyNode.toNodeString()));
                }
            } else {
                Artifact result;
                ArtifactCoordinate coordinate = TransferUtils.toArtifactCoordinate((Artifact)dependencyNode.getArtifact());
                try {
                    result = this.artifactResolver.resolveArtifact(buildingRequest, coordinate).getArtifact();
                }
                catch (ArtifactResolverException ex) {
                    this.getLog().debug((CharSequence)String.format("Aggregate : %s", aggregate));
                    boolean addException = true;
                    if (!aggregate || this.addReactorDependency(engine, dependencyNode.getArtifact())) {
                        addException = false;
                    }
                    if (!addException) continue;
                    if (exCol == null) {
                        exCol = new ExceptionCollection();
                    }
                    exCol.addException((Throwable)ex);
                    continue;
                }
                if (aggregate && this.virtualSnapshotsFromReactor.booleanValue() && dependencyNode.getArtifact().isSnapshot() && aggregate && this.addSnapshotReactorDependency(engine, dependencyNode.getArtifact())) continue;
                isResolved = result.isResolved();
                artifactFile = result.getFile();
                groupId = result.getGroupId();
                artifactId = result.getArtifactId();
                version = result.getVersion();
                availableVersions = result.getAvailableVersions();
            }
            if (isResolved && artifactFile != null) {
                String msg;
                List deps = engine.scan(artifactFile.getAbsoluteFile(), project.getName() + ":" + dependencyNode.getArtifact().getScope());
                if (deps != null) {
                    Dependency d;
                    d = null;
                    if (deps.size() == 1) {
                        d = (org.owasp.dependencycheck.dependency.Dependency)deps.get(0);
                    } else {
                        for (org.owasp.dependencycheck.dependency.Dependency possible : deps) {
                            if (!artifactFile.getAbsoluteFile().equals(possible.getActualFile())) continue;
                            d = possible;
                            break;
                        }
                    }
                    if (d != null) {
                        MavenArtifact ma = new MavenArtifact(groupId, artifactId, version);
                        d.addAsEvidence("pom", ma, Confidence.HIGHEST);
                        if (availableVersions != null) {
                            for (ArtifactVersion av : availableVersions) {
                                d.addAvailableVersion(av.toString());
                            }
                        }
                        this.getLog().debug((CharSequence)String.format("Adding project reference %s on dependency %s", project.getName(), d.getDisplayFileName()));
                        continue;
                    }
                    if (!this.getLog().isDebugEnabled()) continue;
                    String msg2 = String.format("More than 1 dependency was identified in first pass scan of '%s' in project %s", dependencyNode.getArtifact().getId(), project.getName());
                    this.getLog().debug((CharSequence)msg2);
                    continue;
                }
                if ("import".equals(dependencyNode.getArtifact().getScope())) {
                    msg = String.format("Skipping '%s:%s' in project %s as it uses an `import` scope", dependencyNode.getArtifact().getId(), dependencyNode.getArtifact().getScope(), project.getName());
                    this.getLog().debug((CharSequence)msg);
                    continue;
                }
                msg = String.format("No analyzer could be found for '%s:%s' in project %s", dependencyNode.getArtifact().getId(), dependencyNode.getArtifact().getScope(), project.getName());
                this.getLog().warn((CharSequence)msg);
                continue;
            }
            String msg = String.format("Unable to resolve '%s' in project %s", dependencyNode.getArtifact().getId(), project.getName());
            this.getLog().debug((CharSequence)msg);
            if (exCol != null) continue;
            exCol = new ExceptionCollection();
        }
        return exCol;
    }

    private ExceptionCollection collectDependencies(Engine engine, MavenProject project, List<DependencyNode> nodes, ProjectBuildingRequest buildingRequest, boolean aggregate) {
        FileSet[] projectScan;
        ExceptionCollection exCol = this.collectMavenDependencies(engine, project, nodes, buildingRequest, aggregate);
        if (this.scanSet == null || this.scanSet.length == 0) {
            FileSet resourcesSet = new FileSet();
            FileSet filtersSet = new FileSet();
            FileSet webappSet = new FileSet();
            try {
                resourcesSet.setDirectory(new File(project.getBasedir(), "src/main/resources").getCanonicalPath());
                filtersSet.setDirectory(new File(project.getBasedir(), "src/main/filters").getCanonicalPath());
                webappSet.setDirectory(new File(project.getBasedir(), "src/main/webapp").getCanonicalPath());
            }
            catch (IOException ex) {
                if (exCol == null) {
                    exCol = new ExceptionCollection();
                }
                exCol.addException((Throwable)ex);
            }
            projectScan = new FileSet[]{resourcesSet, filtersSet, webappSet};
        } else if (aggregate) {
            projectScan = new FileSet[this.scanSet.length];
            for (int x = 0; x < this.scanSet.length; ++x) {
                FileSet copyFrom = this.scanSet[x];
                FileSet fsCopy = new FileSet();
                File f = new File(copyFrom.getDirectory());
                if (f.isAbsolute()) {
                    fsCopy.setDirectory(copyFrom.getDirectory());
                } else {
                    try {
                        fsCopy.setDirectory(new File(project.getBasedir(), copyFrom.getDirectory()).getCanonicalPath());
                    }
                    catch (IOException ex) {
                        if (exCol == null) {
                            exCol = new ExceptionCollection();
                        }
                        exCol.addException((Throwable)ex);
                        fsCopy.setDirectory(copyFrom.getDirectory());
                    }
                }
                fsCopy.setDirectoryMode(copyFrom.getDirectoryMode());
                fsCopy.setExcludes(copyFrom.getExcludes());
                fsCopy.setFileMode(copyFrom.getFileMode());
                fsCopy.setFollowSymlinks(copyFrom.isFollowSymlinks());
                fsCopy.setIncludes(copyFrom.getIncludes());
                fsCopy.setLineEnding(copyFrom.getLineEnding());
                fsCopy.setMapper(copyFrom.getMapper());
                fsCopy.setModelEncoding(copyFrom.getModelEncoding());
                fsCopy.setOutputDirectory(copyFrom.getOutputDirectory());
                fsCopy.setUseDefaultExcludes(copyFrom.isUseDefaultExcludes());
                projectScan[x] = fsCopy;
            }
        } else {
            projectScan = this.scanSet;
        }
        FileSetManager fileSetManager = new FileSetManager();
        for (FileSet fileSet : projectScan) {
            String[] includedFiles;
            for (String include : includedFiles = fileSetManager.getIncludedFiles(fileSet)) {
                File includeFile = new File(fileSet.getDirectory(), include).getAbsoluteFile();
                if (!includeFile.exists()) continue;
                engine.scan(includeFile, project.getName());
            }
        }
        return exCol;
    }

    private boolean addReactorDependency(Engine engine, Artifact artifact) {
        return this.addVirtualDependencyFromReactor(engine, artifact, "Unable to resolve %s as it has not been built yet - creating a virtual dependency instead.");
    }

    private boolean addVirtualDependencyFromReactor(Engine engine, Artifact artifact, String infoLogTemplate) {
        this.getLog().debug((CharSequence)String.format("Checking the reactor projects (%d) for %s:%s:%s", this.reactorProjects.size(), artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion()));
        for (MavenProject prj : this.reactorProjects) {
            PurlIdentifier id;
            org.owasp.dependencycheck.dependency.Dependency d;
            this.getLog().debug((CharSequence)String.format("Comparing %s:%s:%s to %s:%s:%s", artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), prj.getGroupId(), prj.getArtifactId(), prj.getVersion()));
            if (!prj.getArtifactId().equals(artifact.getArtifactId()) || !prj.getGroupId().equals(artifact.getGroupId()) || !prj.getVersion().equals(artifact.getVersion())) continue;
            String displayName = String.format("%s:%s:%s", prj.getGroupId(), prj.getArtifactId(), prj.getVersion());
            this.getLog().info((CharSequence)String.format(infoLogTemplate, displayName));
            File pom = new File(prj.getBasedir(), "pom.xml");
            if (pom.isFile()) {
                this.getLog().debug((CharSequence)"Adding virtual dependency from pom.xml");
                d = new org.owasp.dependencycheck.dependency.Dependency(pom, true);
            } else {
                d = new org.owasp.dependencycheck.dependency.Dependency(true);
            }
            String key = String.format("%s:%s:%s", artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion());
            d.setSha1sum(Checksum.getSHA1Checksum((String)key));
            d.setSha256sum(Checksum.getSHA256Checksum((String)key));
            d.setMd5sum(Checksum.getMD5Checksum((String)key));
            d.setEcosystem("Java");
            d.setDisplayFileName(displayName);
            d.addEvidence(EvidenceType.PRODUCT, "project", "artifactid", prj.getArtifactId(), Confidence.HIGHEST);
            d.addEvidence(EvidenceType.VENDOR, "project", "artifactid", prj.getArtifactId(), Confidence.LOW);
            d.addEvidence(EvidenceType.VENDOR, "project", "groupid", prj.getGroupId(), Confidence.HIGHEST);
            d.addEvidence(EvidenceType.PRODUCT, "project", "groupid", prj.getGroupId(), Confidence.LOW);
            d.setEcosystem("Java");
            try {
                id = new PurlIdentifier("maven", artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), Confidence.HIGHEST);
            }
            catch (MalformedPackageURLException ex) {
                this.getLog().debug((CharSequence)("Unable to create PackageURL object:" + key));
                id = new GenericIdentifier("maven:" + key, Confidence.HIGHEST);
            }
            d.addSoftwareIdentifier((Identifier)id);
            d.setName(String.format("%s:%s", prj.getGroupId(), prj.getArtifactId()));
            d.setVersion(prj.getVersion());
            d.setPackagePath(displayName);
            if (prj.getDescription() != null) {
                JarAnalyzer.addDescription((org.owasp.dependencycheck.dependency.Dependency)d, (String)prj.getDescription(), (String)"project", (String)"description");
            }
            for (License l : prj.getLicenses()) {
                StringBuilder license = new StringBuilder();
                if (l.getName() != null) {
                    license.append(l.getName());
                }
                if (l.getUrl() != null) {
                    license.append(" ").append(l.getUrl());
                }
                if (d.getLicense() == null) {
                    d.setLicense(license.toString());
                    continue;
                }
                if (d.getLicense().contains(license)) continue;
                d.setLicense(String.format("%s%n%s", d.getLicense(), license.toString()));
            }
            engine.addDependency(d);
            return true;
        }
        return false;
    }

    private boolean addSnapshotReactorDependency(Engine engine, Artifact artifact) {
        if (!artifact.isSnapshot()) {
            return false;
        }
        return this.addVirtualDependencyFromReactor(engine, artifact, "Found snapshot reactor project in aggregate for %s - creating a virtual dependency as the snapshot found in the repository may contain outdated dependencies.");
    }

    public ProjectBuildingRequest newResolveArtifactProjectBuildingRequest(MavenProject project) {
        DefaultProjectBuildingRequest buildingRequest = new DefaultProjectBuildingRequest(this.session.getProjectBuildingRequest());
        buildingRequest.setRemoteRepositories(new ArrayList(project.getRemoteArtifactRepositories()));
        buildingRequest.setProject(project);
        return buildingRequest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runCheck() throws MojoExecutionException, MojoFailureException {
        block28: {
            try (Engine engine = this.initializeEngine();){
                ExceptionCollection exCol = this.scanDependencies(engine);
                try {
                    engine.analyzeDependencies();
                }
                catch (ExceptionCollection ex) {
                    exCol = this.handleAnalysisExceptions(exCol, ex);
                }
                if (exCol != null && exCol.isFatal()) break block28;
                File outputDir = this.getCorrectOutputDirectory(this.getProject());
                if (outputDir == null) {
                    outputDir = new File(this.getProject().getBuild().getDirectory());
                }
                try {
                    MavenProject p = this.getProject();
                    engine.writeReports(p.getName(), p.getGroupId(), p.getArtifactId(), p.getVersion(), outputDir, this.getFormat());
                }
                catch (ReportException ex) {
                    if (exCol == null) {
                        exCol = new ExceptionCollection((Throwable)ex);
                    } else {
                        exCol.addException((Throwable)ex);
                    }
                    if (this.isFailOnError()) {
                        throw new MojoExecutionException("One or more exceptions occurred during dependency-check analysis", (Exception)((Object)exCol));
                    }
                    this.getLog().debug((CharSequence)"Error writing the report", (Throwable)ex);
                }
                this.showSummary(this.getProject(), engine.getDependencies());
                this.checkForFailure(engine.getDependencies());
                if (exCol != null && this.isFailOnError()) {
                    throw new MojoExecutionException("One or more exceptions occurred during dependency-check analysis", (Exception)((Object)exCol));
                }
            }
            catch (DatabaseException ex) {
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)"Database connection error", (Throwable)ex);
                }
                String msg = "An exception occurred connecting to the local database. Please see the log file for more details.";
                if (this.isFailOnError()) {
                    throw new MojoExecutionException("An exception occurred connecting to the local database. Please see the log file for more details.", (Exception)((Object)ex));
                }
                this.getLog().error((CharSequence)"An exception occurred connecting to the local database. Please see the log file for more details.", (Throwable)ex);
            }
            finally {
                this.getSettings().cleanup();
            }
        }
    }

    private ExceptionCollection handleAnalysisExceptions(ExceptionCollection currentEx, ExceptionCollection newEx) throws MojoExecutionException {
        ExceptionCollection returnEx = currentEx;
        if (returnEx == null) {
            returnEx = newEx;
        } else {
            returnEx.getExceptions().addAll(newEx.getExceptions());
            if (newEx.isFatal()) {
                returnEx.setFatal(true);
            }
        }
        if (returnEx.isFatal()) {
            String msg = String.format("Fatal exception(s) analyzing %s", this.getProject().getName());
            if (this.isFailOnError()) {
                throw new MojoExecutionException(msg, (Exception)((Object)returnEx));
            }
            this.getLog().error((CharSequence)msg);
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((Throwable)returnEx);
            }
        } else {
            String msg = String.format("Exception(s) analyzing %s", this.getProject().getName());
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)msg, (Throwable)returnEx);
            }
        }
        return returnEx;
    }

    protected abstract ExceptionCollection scanDependencies(Engine var1) throws MojoExecutionException;

    public File getReportOutputDirectory() {
        return this.reportOutputDirectory;
    }

    public void setReportOutputDirectory(File directory) {
        this.reportOutputDirectory = directory;
    }

    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    public final boolean isExternalReport() {
        return true;
    }

    public String getOutputName() {
        if ("HTML".equalsIgnoreCase(this.format) || "ALL".equalsIgnoreCase(this.format)) {
            return "dependency-check-report";
        }
        if ("XML".equalsIgnoreCase(this.format)) {
            return "dependency-check-report.xml#";
        }
        if ("VULN".equalsIgnoreCase(this.format)) {
            return "dependency-check-vulnerability";
        }
        if ("JSON".equalsIgnoreCase(this.format)) {
            return "dependency-check-report.json";
        }
        if ("CSV".equalsIgnoreCase(this.format)) {
            return "dependency-check-report.csv";
        }
        this.getLog().warn((CharSequence)"Unknown report format used during site generation.");
        return "dependency-check-report";
    }

    public String getCategoryName() {
        return "Project Reports";
    }

    protected Engine initializeEngine() throws DatabaseException {
        this.populateSettings();
        return new Engine(this.settings);
    }

    protected void populateSettings() {
        block37: {
            Server server;
            this.settings = new Settings();
            InputStream mojoProperties = null;
            try {
                mojoProperties = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(PROPERTIES_FILE);
                this.settings.mergeProperties(mojoProperties);
            }
            catch (IOException ex) {
                this.getLog().warn((CharSequence)"Unable to load the dependency-check maven mojo.properties file.");
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)"", (Throwable)ex);
                }
            }
            finally {
                block36: {
                    if (mojoProperties != null) {
                        try {
                            mojoProperties.close();
                        }
                        catch (IOException ex) {
                            if (!this.getLog().isDebugEnabled()) break block36;
                            this.getLog().debug((CharSequence)"", (Throwable)ex);
                        }
                    }
                }
            }
            this.settings.setBooleanIfNotNull("autoupdate", this.autoUpdate);
            this.settings.setBooleanIfNotNull("analyzer.experimental.enabled", this.enableExperimental);
            this.settings.setBooleanIfNotNull("analyzer.retired.enabled", this.enableRetired);
            Proxy proxy = this.getMavenProxy();
            if (proxy != null) {
                this.settings.setString("proxy.server", proxy.getHost());
                this.settings.setString("proxy.port", Integer.toString(proxy.getPort()));
                String userName = proxy.getUsername();
                String password = proxy.getPassword();
                this.settings.setStringIfNotNull("proxy.username", userName);
                this.settings.setStringIfNotNull("proxy.password", password);
                this.settings.setStringIfNotNull("proxy.nonproxyhosts", proxy.getNonProxyHosts());
            }
            String[] suppressions = this.determineSuppressions();
            this.settings.setArrayIfNotEmpty("suppression.file", suppressions);
            this.settings.setBooleanIfNotNull("updater.versioncheck.enabled", Boolean.valueOf(this.versionCheckEnabled));
            this.settings.setStringIfNotEmpty("connection.timeout", this.connectionTimeout);
            this.settings.setStringIfNotEmpty("hints.file", this.hintsFile);
            this.settings.setBooleanIfNotNull("analyzer.jar.enabled", this.jarAnalyzerEnabled);
            this.settings.setBooleanIfNotNull("analyzer.nuspec.enabled", this.nuspecAnalyzerEnabled);
            this.settings.setBooleanIfNotNull("analyzer.nugetconf.enabled", this.nugetconfAnalyzerEnabled);
            this.settings.setBooleanIfNotNull("analyzer.central.enabled", this.centralAnalyzerEnabled);
            this.settings.setBooleanIfNotNull("analyzer.artifactory.enabled", this.artifactoryAnalyzerEnabled);
            this.settings.setBooleanIfNotNull("analyzer.nexus.enabled", this.nexusAnalyzerEnabled);
            this.settings.setBooleanIfNotNull("analyzer.assembly.enabled", this.assemblyAnalyzerEnabled);
            this.settings.setBooleanIfNotNull("analyzer.archive.enabled", this.archiveAnalyzerEnabled);
            this.settings.setStringIfNotEmpty("extensions.zip", this.zipExtensions);
            this.settings.setStringIfNotEmpty("analyzer.assembly.dotnet.path", this.pathToCore);
            this.settings.setStringIfNotEmpty("analyzer.nexus.url", this.nexusUrl);
            if (this.nexusServerId != null) {
                server = this.settingsXml.getServer(this.nexusServerId);
                if (server != null) {
                    String nexusUser = server.getUsername();
                    String nexusPassword = null;
                    try {
                        nexusPassword = this.decryptServerPassword(server);
                    }
                    catch (SecDispatcherException ex) {
                        if (ex.getCause() instanceof FileNotFoundException || ex.getCause() != null && ex.getCause().getCause() instanceof FileNotFoundException) {
                            String tmp = server.getPassword();
                            if (tmp.startsWith("{") && tmp.endsWith("}")) {
                                this.getLog().error((CharSequence)String.format("Unable to decrypt the server password for server id '%s' in settings.xml%n\tCause: %s", this.serverId, ex.getMessage()));
                            } else {
                                nexusPassword = tmp;
                            }
                        }
                        this.getLog().error((CharSequence)String.format("Unable to decrypt the server password for server id '%s' in settings.xml%n\tCause: %s", this.serverId, ex.getMessage()));
                    }
                    this.settings.setStringIfNotEmpty("analyzer.nexus.username", nexusUser);
                    this.settings.setStringIfNotEmpty("analyzer.nexus.password", nexusPassword);
                } else {
                    this.getLog().error((CharSequence)String.format("Server '%s' not found in the settings.xml file", this.serverId));
                }
            }
            this.settings.setBooleanIfNotNull("analyzer.nexus.proxy", this.nexusUsesProxy);
            this.settings.setStringIfNotNull("analyzer.artifactory.url", this.artifactoryAnalyzerUrl);
            this.settings.setBooleanIfNotNull("analyzer.artifactory.proxy", this.artifactoryAnalyzerUseProxy);
            this.settings.setBooleanIfNotNull("analyzer.artifactory.parallel.analysis", this.artifactoryAnalyzerParallelAnalysis);
            if (Boolean.TRUE.equals(this.artifactoryAnalyzerEnabled)) {
                if (this.artifactoryAnalyzerServerId != null) {
                    server = this.settingsXml.getServer(this.artifactoryAnalyzerServerId);
                    if (server != null) {
                        this.settings.setStringIfNotNull("analyzer.artifactory.api.username", server.getUsername());
                        this.settings.setStringIfNotNull("analyzer.artifactory.api.token", server.getPassword());
                    }
                } else {
                    this.settings.setStringIfNotNull("analyzer.artifactory.api.username", this.artifactoryAnalyzerUsername);
                    this.settings.setStringIfNotNull("analyzer.artifactory.api.token", this.artifactoryAnalyzerApiToken);
                }
                this.settings.setStringIfNotNull("analyzer.artifactory.bearer.token", this.artifactoryAnalyzerBearerToken);
            }
            this.settings.setBooleanIfNotNull("analyzer.python.distribution.enabled", this.pyDistributionAnalyzerEnabled);
            this.settings.setBooleanIfNotNull("analyzer.python.package.enabled", this.pyPackageAnalyzerEnabled);
            this.settings.setBooleanIfNotNull("analyzer.ruby.gemspec.enabled", this.rubygemsAnalyzerEnabled);
            this.settings.setBooleanIfNotNull("analyzer.openssl.enabled", this.opensslAnalyzerEnabled);
            this.settings.setBooleanIfNotNull("analyzer.cmake.enabled", this.cmakeAnalyzerEnabled);
            this.settings.setBooleanIfNotNull("analyzer.autoconf.enabled", this.autoconfAnalyzerEnabled);
            this.settings.setBooleanIfNotNull("analyzer.composer.lock.enabled", this.composerAnalyzerEnabled);
            this.settings.setBooleanIfNotNull("analyzer.node.package.enabled", this.nodeAnalyzerEnabled);
            this.settings.setBooleanIfNotNull("analyzer.node.audit.enabled", this.nodeAuditAnalyzerEnabled);
            this.settings.setBooleanIfNotNull("analyzer.retirejs.enabled", this.retireJsAnalyzerEnabled);
            this.settings.setBooleanIfNotNull("analyzer.bundle.audit.enabled", this.bundleAuditAnalyzerEnabled);
            this.settings.setStringIfNotNull("analyzer.bundle.audit.path", this.bundleAuditPath);
            this.settings.setBooleanIfNotNull("analyzer.cocoapods.enabled", this.cocoapodsAnalyzerEnabled);
            this.settings.setBooleanIfNotNull("analyzer.swift.package.manager.enabled", this.swiftPackageManagerAnalyzerEnabled);
            if (this.retirejs != null) {
                this.settings.setBooleanIfNotNull("analyzer.retirejs.filternonvulnerable", this.retirejs.getFilterNonVulnerable());
                this.settings.setArrayIfNotEmpty("analyzer.retirejs.filters", this.retirejs.getFilters());
            }
            this.settings.setStringIfNotEmpty("data.driver_name", this.databaseDriverName);
            this.settings.setStringIfNotEmpty("data.driver_path", this.databaseDriverPath);
            this.settings.setStringIfNotEmpty("data.connection_string", this.connectionString);
            if (this.databaseUser == null && this.databasePassword == null && this.serverId != null) {
                server = this.settingsXml.getServer(this.serverId);
                if (server != null) {
                    this.databaseUser = server.getUsername();
                    try {
                        this.databasePassword = this.decryptServerPassword(server);
                    }
                    catch (SecDispatcherException ex) {
                        if (ex.getCause() instanceof FileNotFoundException || ex.getCause() != null && ex.getCause().getCause() instanceof FileNotFoundException) {
                            String tmp = server.getPassword();
                            if (tmp.startsWith("{") && tmp.endsWith("}")) {
                                this.getLog().error((CharSequence)String.format("Unable to decrypt the server password for server id '%s' in settings.xml%n\tCause: %s", this.serverId, ex.getMessage()));
                            } else {
                                this.databasePassword = tmp;
                            }
                            break block37;
                        }
                        this.getLog().error((CharSequence)String.format("Unable to decrypt the server password for server id '%s' in settings.xml%n\tCause: %s", this.serverId, ex.getMessage()));
                    }
                } else {
                    this.getLog().error((CharSequence)String.format("Server '%s' not found in the settings.xml file", this.serverId));
                }
            }
        }
        this.settings.setStringIfNotEmpty("data.user", this.databaseUser);
        this.settings.setStringIfNotEmpty("data.password", this.databasePassword);
        this.settings.setStringIfNotEmpty("data.directory", this.dataDirectory);
        this.settings.setStringIfNotEmpty("cve.url.modified", this.cveUrlModified);
        this.settings.setStringIfNotEmpty("cve.url.base", this.cveUrlBase);
        this.settings.setIntIfNotNull("cve.check.validforhours", this.cveValidForHours);
        this.artifactScopeExcluded = new ArtifactScopeExcluded(this.skipTestScope, this.skipProvidedScope, this.skipSystemScope, this.skipRuntimeScope);
        this.artifactTypeExcluded = new ArtifactTypeExcluded(this.skipArtifactType);
    }

    private String decryptServerPassword(Server server) throws SecDispatcherException {
        if (this.securityDispatcher instanceof DefaultSecDispatcher) {
            ((DefaultSecDispatcher)this.securityDispatcher).setConfigurationFile("~/.m2/settings-security.xml");
        }
        return this.securityDispatcher.decrypt(server.getPassword());
    }

    private String[] determineSuppressions() {
        String[] suppressions = this.suppressionFiles;
        if (this.suppressionFile != null) {
            if (suppressions == null) {
                suppressions = new String[]{this.suppressionFile};
            } else {
                suppressions = Arrays.copyOf(suppressions, suppressions.length + 1);
                suppressions[suppressions.length - 1] = this.suppressionFile;
            }
        }
        return suppressions;
    }

    private Proxy getMavenProxy() {
        block4: {
            List proxies;
            if (this.mavenSettings == null || (proxies = this.mavenSettings.getProxies()) == null || proxies.isEmpty()) break block4;
            if (this.mavenSettingsProxyId != null) {
                for (Proxy proxy : proxies) {
                    if (!this.mavenSettingsProxyId.equalsIgnoreCase(proxy.getId())) continue;
                    return proxy;
                }
            } else {
                for (Proxy aProxy : proxies) {
                    if (!aProxy.isActive()) continue;
                    return aProxy;
                }
            }
        }
        return null;
    }

    protected MavenProject getProject() {
        return this.project;
    }

    protected List<MavenProject> getReactorProjects() {
        return this.reactorProjects;
    }

    protected String getFormat() {
        return this.format;
    }

    public List<String> getExcludes() {
        if (this.excludes == null) {
            this.excludes = new ArrayList<String>();
        }
        return this.excludes;
    }

    protected Filter<String> getArtifactScopeExcluded() {
        return this.artifactScopeExcluded;
    }

    protected Settings getSettings() {
        return this.settings;
    }

    protected void checkForFailure(org.owasp.dependencycheck.dependency.Dependency[] dependencies) throws MojoFailureException {
        StringBuilder ids = new StringBuilder();
        for (org.owasp.dependencycheck.dependency.Dependency d : dependencies) {
            boolean addName = true;
            for (Vulnerability v : d.getVulnerabilities()) {
                if (!(this.failBuildOnAnyVulnerability || v.getCvssV2() != null && v.getCvssV2().getScore() >= this.failBuildOnCVSS) && (v.getCvssV3() == null || !(v.getCvssV3().getBaseScore() >= this.failBuildOnCVSS))) continue;
                if (addName) {
                    addName = false;
                    ids.append(NEW_LINE).append(d.getFileName()).append(": ");
                    ids.append(v.getName());
                    continue;
                }
                ids.append(", ").append(v.getName());
            }
        }
        if (ids.length() > 0) {
            String msg = this.showSummary ? (this.failBuildOnAnyVulnerability ? String.format("%n%nOne or more dependencies were identified with vulnerabilities: %n%s%n%nSee the dependency-check report for more details.%n%n", ids.toString()) : String.format("%n%nOne or more dependencies were identified with vulnerabilities that have a CVSS score greater than or equal to '%.1f': %n%s%n%nSee the dependency-check report for more details.%n%n", Float.valueOf(this.failBuildOnCVSS), ids.toString())) : String.format("%n%nOne or more dependencies were identified with vulnerabilities.%n%nSee the dependency-check report for more details.%n%n", new Object[0]);
            throw new MojoFailureException(msg);
        }
    }

    protected void showSummary(MavenProject mp, org.owasp.dependencycheck.dependency.Dependency[] dependencies) {
        if (this.showSummary) {
            DependencyCheckScanAgent.showSummary((String)mp.getName(), (org.owasp.dependencycheck.dependency.Dependency[])dependencies);
        }
    }
}

