/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.maven;

import java.io.File;
import java.io.IOException;
import java.util.Locale;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.exception.ExceptionCollection;
import org.owasp.dependencycheck.maven.BaseDependencyCheckMojo;

@Mojo(name="purge", defaultPhase=LifecyclePhase.GENERATE_RESOURCES, requiresProject=false, threadSafe=true, requiresDependencyResolution=ResolutionScope.NONE, requiresOnline=true, aggregator=true)
public class PurgeMojo
extends BaseDependencyCheckMojo {
    public boolean canGenerateReport() {
        return false;
    }

    @Override
    protected void runCheck() throws MojoExecutionException, MojoFailureException {
        if (this.getConnectionString() != null && !this.getConnectionString().isEmpty()) {
            String msg = "Unable to purge the local NVD when using a non-default connection string";
            if (this.isFailOnError()) {
                throw new MojoFailureException("Unable to purge the local NVD when using a non-default connection string");
            }
            this.getLog().error((CharSequence)"Unable to purge the local NVD when using a non-default connection string");
        } else {
            this.populateSettings();
            try {
                File db = new File(this.getSettings().getDataDirectory(), this.getSettings().getString("data.file_name", "odc.mv.db"));
                if (db.exists()) {
                    if (db.delete()) {
                        this.getLog().info((CharSequence)"Database file purged; local copy of the NVD has been removed");
                    } else {
                        String msg = String.format("Unable to delete '%s'; please delete the file manually", db.getAbsolutePath());
                        if (this.isFailOnError()) {
                            throw new MojoFailureException(msg);
                        }
                        this.getLog().error((CharSequence)msg);
                    }
                } else {
                    String msg = String.format("Unable to purge database; the database file does not exist: %s", db.getAbsolutePath());
                    if (this.isFailOnError()) {
                        throw new MojoFailureException(msg);
                    }
                    this.getLog().error((CharSequence)msg);
                }
            }
            catch (IOException ex) {
                String msg = "Unable to delete the database";
                if (this.isFailOnError()) {
                    throw new MojoExecutionException("Unable to delete the database", (Exception)ex);
                }
                this.getLog().error((CharSequence)"Unable to delete the database");
            }
            this.getSettings().cleanup();
        }
    }

    public String getName(Locale locale) {
        return "dependency-check-purge";
    }

    public String getDescription(Locale locale) {
        return "Purges the local cache of the NVD dataT.";
    }

    @Override
    protected ExceptionCollection scanDependencies(Engine engine) throws MojoExecutionException {
        throw new UnsupportedOperationException("Operation not supported");
    }
}

