/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.maven;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.exception.ExceptionCollection;
import org.owasp.dependencycheck.maven.BaseDependencyCheckMojo;

@Mojo(name="aggregate", defaultPhase=LifecyclePhase.VERIFY, aggregator=true, threadSafe=true, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, requiresOnline=true)
public class AggregateMojo
extends BaseDependencyCheckMojo {
    @Parameter(property="name", defaultValue="dependency-check:aggregate", required=true)
    private String name = "dependency-check:aggregate";

    @Override
    protected ExceptionCollection scanDependencies(Engine engine) throws MojoExecutionException {
        ExceptionCollection exCol = this.scanArtifacts(this.getProject(), engine, true);
        for (MavenProject childProject : this.getDescendants(this.getProject())) {
            ExceptionCollection ex = this.scanArtifacts(childProject, engine, true);
            if (ex == null) continue;
            if (exCol == null) {
                exCol = ex;
            }
            exCol.getExceptions().addAll(ex.getExceptions());
            if (!ex.isFatal()) continue;
            exCol.setFatal(true);
            String msg = String.format("Fatal exception(s) analyzing %s", childProject.getName());
            if (this.isFailOnError()) {
                throw new MojoExecutionException(msg, (Exception)exCol);
            }
            this.getLog().error((CharSequence)msg);
            if (!this.getLog().isDebugEnabled()) continue;
            this.getLog().debug((Throwable)exCol);
        }
        return exCol;
    }

    protected Set<MavenProject> getDescendants(MavenProject project) {
        int size;
        if (project == null) {
            return Collections.emptySet();
        }
        HashSet<MavenProject> descendants = new HashSet<MavenProject>();
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)String.format("Collecting descendants of %s", project.getName()));
        }
        for (String m : project.getModules()) {
            for (MavenProject mod : this.getReactorProjects()) {
                try {
                    File mpp = new File(project.getBasedir(), m);
                    if ((mpp = mpp.getCanonicalFile()).compareTo(mod.getBasedir()) != 0 || !descendants.add(mod) || !this.getLog().isDebugEnabled()) continue;
                    this.getLog().debug((CharSequence)String.format("Descendant module %s added", mod.getName()));
                }
                catch (IOException ex) {
                    if (!this.getLog().isDebugEnabled()) continue;
                    this.getLog().debug((CharSequence)"Unable to determine module path", (Throwable)ex);
                }
            }
        }
        do {
            size = descendants.size();
            for (MavenProject p : this.getReactorProjects()) {
                if (project.equals((Object)p.getParent()) || descendants.contains(p.getParent())) {
                    if (descendants.add(p) && this.getLog().isDebugEnabled()) {
                        this.getLog().debug((CharSequence)String.format("Descendant %s added", p.getName()));
                    }
                    for (MavenProject modTest : this.getReactorProjects()) {
                        if (p.getModules() == null || !p.getModules().contains(modTest.getName()) || !descendants.add(modTest) || !this.getLog().isDebugEnabled()) continue;
                        this.getLog().debug((CharSequence)String.format("Descendant %s added", modTest.getName()));
                    }
                }
                HashSet<MavenProject> addedDescendants = new HashSet<MavenProject>();
                for (MavenProject dec : descendants) {
                    for (String mod : dec.getModules()) {
                        try {
                            File mpp = new File(dec.getBasedir(), mod);
                            if ((mpp = mpp.getCanonicalFile()).compareTo(p.getBasedir()) != 0) continue;
                            addedDescendants.add(p);
                        }
                        catch (IOException ex) {
                            if (!this.getLog().isDebugEnabled()) continue;
                            this.getLog().debug((CharSequence)"Unable to determine module path", (Throwable)ex);
                        }
                    }
                }
                for (MavenProject addedDescendant : addedDescendants) {
                    if (!descendants.add(addedDescendant) || !this.getLog().isDebugEnabled()) continue;
                    this.getLog().debug((CharSequence)String.format("Descendant module %s added", addedDescendant.getName()));
                }
            }
        } while (size != 0 && size != descendants.size());
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)String.format("%s has %d children", project, descendants.size()));
        }
        return descendants;
    }

    protected boolean isMultiModule(MavenProject mavenProject) {
        return "pom".equals(mavenProject.getPackaging());
    }

    public boolean canGenerateReport() {
        return true;
    }

    public String getName(Locale locale) {
        return this.name;
    }

    public String getDescription(Locale locale) {
        return "Generates an aggregate report of all child Maven projects providing details on any published vulnerabilities within project dependencies. This report is a best effort and may contain false positives and false negatives.";
    }
}

