/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.utils;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.owasp.dependencycheck.utils.DownloadFailedException;
import org.owasp.dependencycheck.utils.HttpResourceConnection;
import org.owasp.dependencycheck.utils.Settings;

public final class Downloader {
    private static final String UTF8 = StandardCharsets.UTF_8.name();
    private final Settings settings;

    public Downloader(Settings settings) {
        this.settings = settings;
    }

    public void fetchFile(URL url, File outputPath) throws DownloadFailedException {
        this.fetchFile(url, outputPath, true);
    }

    public void fetchFile(URL url, File outputPath, boolean useProxy) throws DownloadFailedException {
        try (HttpResourceConnection conn = new HttpResourceConnection(this.settings, useProxy);
             FileOutputStream out = new FileOutputStream(outputPath);){
            InputStream in = conn.fetch(url);
            IOUtils.copy((InputStream)in, (OutputStream)out);
        }
        catch (IOException ex) {
            String msg = String.format("Download failed, unable to copy '%s' to '%s'", url.toString(), outputPath.getAbsolutePath());
            throw new DownloadFailedException(msg, ex);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public String fetchContent(URL url, boolean useProxy) throws DownloadFailedException {
        try {
            Throwable throwable = null;
            try (HttpResourceConnection conn = new HttpResourceConnection(this.settings, useProxy);){
                String string;
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                Throwable throwable2 = null;
                try {
                    InputStream in = conn.fetch(url);
                    IOUtils.copy((InputStream)in, (OutputStream)out);
                    string = out.toString(UTF8);
                }
                catch (Throwable throwable3) {
                    try {
                        try {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            Downloader.$closeResource(throwable2, out);
                            throw throwable4;
                        }
                    }
                    catch (Throwable throwable5) {
                        throwable = throwable5;
                        throw throwable5;
                    }
                }
                Downloader.$closeResource(throwable2, out);
                return string;
            }
        }
        catch (IOException ex) {
            String msg = String.format("Download failed, unable to retrieve '%s'", url.toString());
            throw new DownloadFailedException(msg, ex);
        }
    }
}

