/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.fileio;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.owasp.fileio.codecs.Codec;
import org.owasp.fileio.codecs.HTMLEntityCodec;
import org.owasp.fileio.codecs.PercentCodec;
import org.owasp.fileio.util.Utils;

public class Encoder {
    private static volatile Encoder singletonInstance;
    public static final char[] CHAR_ALPHANUMERICS;
    public static final Set<Character> ALPHANUMERICS;
    private boolean restrictMultiple = true;
    private boolean restrictMixed = true;
    private List codecs = new ArrayList();
    private HTMLEntityCodec htmlCodec = new HTMLEntityCodec();
    private PercentCodec percentCodec = new PercentCodec();

    public boolean isRestrictMultiple() {
        return this.restrictMultiple;
    }

    public void setRestrictMultiple(boolean restrictMultiple) {
        this.restrictMultiple = restrictMultiple;
    }

    public boolean isRestrictMixed() {
        return this.restrictMixed;
    }

    public void setRestrictMixed(boolean restrictMixed) {
        this.restrictMixed = restrictMixed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Encoder getInstance() {
        if (singletonInstance != null) return singletonInstance;
        Class<Encoder> clazz = Encoder.class;
        synchronized (Encoder.class) {
            if (singletonInstance != null) return singletonInstance;
            singletonInstance = new Encoder();
            // ** MonitorExit[var0] (shouldn't be in output)
            return singletonInstance;
        }
    }

    public Encoder() {
        this.codecs.add(this.htmlCodec);
        this.codecs.add(this.percentCodec);
    }

    public Encoder(List<Codec> codecs) {
        this.codecs = codecs;
    }

    public String canonicalize(String input) {
        if (input == null) {
            return null;
        }
        return this.canonicalize(input, this.restrictMultiple, this.restrictMixed);
    }

    public String canonicalize(String input, boolean strict) {
        return this.canonicalize(input, strict, strict);
    }

    public String canonicalize(String input, boolean restrictMultiple, boolean restrictMixed) {
        if (input == null) {
            return null;
        }
        String working = input;
        Codec codecFound = null;
        int mixedCount = 1;
        int foundCount = 0;
        boolean clean = false;
        while (!clean) {
            clean = true;
            Iterator i = this.codecs.iterator();
            while (i.hasNext()) {
                String old = working;
                Codec codec = (Codec)i.next();
                if (old.equals(working = codec.decode(working))) continue;
                if (codecFound != null && codecFound != codec) {
                    ++mixedCount;
                }
                codecFound = codec;
                if (clean) {
                    ++foundCount;
                }
                clean = false;
            }
        }
        if (foundCount >= 2 && mixedCount > 1 ? !restrictMultiple && restrictMixed : (foundCount >= 2 ? restrictMultiple : mixedCount <= 1 || restrictMixed)) {
            // empty if block
        }
        return working;
    }

    static {
        CHAR_ALPHANUMERICS = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
        ALPHANUMERICS = Utils.arrayToSet(CHAR_ALPHANUMERICS);
    }
}

