/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.fileio.codecs;

import java.io.UnsupportedEncodingException;
import java.util.Set;
import org.owasp.fileio.Encoder;
import org.owasp.fileio.codecs.Codec;
import org.owasp.fileio.codecs.PushbackString;

public class PercentCodec
extends Codec {
    private static final Set<Character> UNENCODED_SET = Encoder.ALPHANUMERICS;

    private static byte[] toUtf8Bytes(String str) {
        try {
            return str.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("The Java spec requires UTF-8 support.", e);
        }
    }

    private static StringBuilder appendTwoUpperHex(StringBuilder sb, int b) {
        if (b < -128 || b > 127) {
            throw new IllegalArgumentException("b is not a byte (was " + b + ')');
        }
        if ((b &= 0xFF) < 16) {
            sb.append('0');
        }
        return sb.append(Integer.toHexString(b).toUpperCase());
    }

    @Override
    public String encodeCharacter(char[] immune, Character c) {
        String cStr = String.valueOf(c.charValue());
        if (UNENCODED_SET.contains(c)) {
            return cStr;
        }
        byte[] bytes = PercentCodec.toUtf8Bytes(cStr);
        StringBuilder sb = new StringBuilder(bytes.length * 3);
        for (byte b : bytes) {
            PercentCodec.appendTwoUpperHex(sb.append('%'), b);
        }
        return sb.toString();
    }

    @Override
    public Character decodeCharacter(PushbackString input) {
        int i;
        input.mark();
        Character first = input.next();
        if (first == null) {
            input.reset();
            return null;
        }
        if (first.charValue() != '%') {
            input.reset();
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (i = 0; i < 2; ++i) {
            Character c = input.nextHex();
            if (c == null) continue;
            sb.append(c);
        }
        if (sb.length() == 2) {
            try {
                i = Integer.parseInt(sb.toString(), 16);
                if (Character.isValidCodePoint(i)) {
                    return Character.valueOf((char)i);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        input.reset();
        return null;
    }
}

