/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.security.logging.filter;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.filter.AbstractMatcherFilter;
import ch.qos.logback.core.spi.FilterReply;
import java.util.ArrayList;
import java.util.List;
import org.owasp.security.logging.SecurityMarkers;
import org.slf4j.Marker;

public class ExcludeClassifiedMarkerFilter
extends AbstractMatcherFilter<ILoggingEvent> {
    public static final List<Marker> markersToMatch = new ArrayList<Marker>(4);

    public FilterReply decide(ILoggingEvent event) {
        if (!this.isStarted()) {
            return FilterReply.NEUTRAL;
        }
        Marker eventMarker = event.getMarker();
        if (eventMarker == null) {
            return FilterReply.NEUTRAL;
        }
        if (eventMarker.hasReferences()) {
            for (Marker marker : markersToMatch) {
                if (!eventMarker.contains(marker)) continue;
                return FilterReply.DENY;
            }
        } else if (markersToMatch.contains(eventMarker)) {
            return FilterReply.DENY;
        }
        return FilterReply.NEUTRAL;
    }

    static {
        markersToMatch.add(SecurityMarkers.RESTRICTED);
        markersToMatch.add(SecurityMarkers.CONFIDENTIAL);
        markersToMatch.add(SecurityMarkers.SECRET);
        markersToMatch.add(SecurityMarkers.TOP_SECRET);
    }
}

