/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.javalin;

import io.javalin.http.BadRequestResponse;
import io.javalin.http.ForbiddenResponse;
import io.javalin.http.HttpStatus;
import io.javalin.http.UnauthorizedResponse;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.exception.http.HttpAction;
import org.pac4j.core.exception.http.WithContentAction;
import org.pac4j.core.exception.http.WithLocationAction;
import org.pac4j.core.http.adapter.HttpActionAdapter;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.javalin.JavalinWebContext;

public class JavalinHttpActionAdapter
implements HttpActionAdapter {
    public static final JavalinHttpActionAdapter INSTANCE = new JavalinHttpActionAdapter();

    public Void adapt(HttpAction action, WebContext webContext) {
        CommonHelper.assertNotNull((String)"action", (Object)action);
        CommonHelper.assertNotNull((String)"context", (Object)webContext);
        if (!(webContext instanceof JavalinWebContext)) {
            throw new RuntimeException("not a JavalinWebContext, but " + webContext.getClass().getName());
        }
        JavalinWebContext context = (JavalinWebContext)webContext;
        int code = action.getCode();
        if (code == 401) {
            throw new UnauthorizedResponse();
        }
        if (code == 403) {
            throw new ForbiddenResponse();
        }
        if (code == 400) {
            throw new BadRequestResponse();
        }
        if (action instanceof WithContentAction) {
            context.getContext().status(code);
            String responseData = ((WithContentAction)action).getContent();
            context.getContext().result(responseData);
            return null;
        }
        if (action instanceof WithLocationAction) {
            String location = ((WithLocationAction)action).getLocation();
            context.getContext().redirect(location, HttpStatus.forStatus((int)code));
            return null;
        }
        context.getContext().status(code);
        return null;
    }
}

